/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.eccezione.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPFault;
import org.openspcoop.dao.eccezione.Dettaglio;
import org.openspcoop.dao.eccezione.DettaglioEccezione;
import org.openspcoop.dao.eccezione.Eccezione;
import org.openspcoop.dao.eccezione.driver.XMLUtilsException;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD() throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(XMLUtils.class.getResourceAsStream("/openspcoopDetail.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(DettaglioEccezione eccezione, StringBuffer motivoErroreValidazione) {
        int i;
        int size = motivoErroreValidazione.length();
        if (eccezione.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (eccezione.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("IdentificativoPorta non definito\n");
        }
        if (eccezione.getIdentificativoFunzione() == null) {
            motivoErroreValidazione.append("IdentificativoFunzione non definito\n");
        }
        if (eccezione.sizeEccezioniList() <= 0) {
            motivoErroreValidazione.append("Nessuna eccezione definita\n");
        } else {
            for (i = 0; i < eccezione.sizeEccezioniList(); ++i) {
                Eccezione ecc = eccezione.getEccezioni(i);
                if (ecc.getCodice() == null) {
                    motivoErroreValidazione.append("Eccezione.codice non definito\n");
                }
                if (ecc.getDescrizione() != null) continue;
                motivoErroreValidazione.append("Eccezione.codice non definito\n");
            }
        }
        if (eccezione.sizeDettagliList() > 0) {
            for (i = 0; i < eccezione.sizeDettagliList(); ++i) {
                Dettaglio detail = eccezione.getDettagli(i);
                if (detail == null) {
                    motivoErroreValidazione.append("Detail presente e non definito??\n");
                    continue;
                }
                if (detail.getTipo() == null) {
                    motivoErroreValidazione.append("Detail[" + i + "].tipo non definito\n");
                }
                if (detail.getBase() != null) continue;
                motivoErroreValidazione.append("Detail[" + i + "].tipo non definito\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DettaglioEccezione getDettaglioEccezione(byte[] m) throws XMLUtilsException {
        DettaglioEccezione dettaglioEccezione;
        ByteArrayInputStream bin = null;
        try {
            try {
                bin = new ByteArrayInputStream(m);
                dettaglioEccezione = XMLUtils.getDettaglioEccezione(bin);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (bin == null) throw throwable;
                bin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return dettaglioEccezione;
        }
        if (bin == null) return dettaglioEccezione;
        bin.close();
        return dettaglioEccezione;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DettaglioEccezione getDettaglioEccezione(File m) throws XMLUtilsException {
        DettaglioEccezione dettaglioEccezione;
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(m);
                dettaglioEccezione = XMLUtils.getDettaglioEccezione(fin);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (fin == null) throw throwable;
                fin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return dettaglioEccezione;
        }
        if (fin == null) return dettaglioEccezione;
        fin.close();
        return dettaglioEccezione;
    }

    public static DettaglioEccezione getDettaglioEccezione(String m) throws XMLUtilsException {
        return XMLUtils.getDettaglioEccezione(m.getBytes());
    }

    public static DettaglioEccezione getDettaglioEccezione(InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD();
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (DettaglioEccezione)org.openspcoop.dao.commons.XMLUtils.xmlToObj(binTrasformazione, DettaglioEccezione.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(out.getName(), XMLUtils.generateDettaglioEccezione_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(fileName, XMLUtils.generateDettaglioEccezione_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDettaglioEccezione(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDettaglioEccezione_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateDettaglioEccezione_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDettaglioEccezione_engine(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            org.openspcoop.dao.commons.XMLUtils.objToXml(bout, DettaglioEccezione.class, (Object)eccezione);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Message msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = (SOAPBody)msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = (SOAPFault)soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            MessageElement detailsFaultOriginale = faultOriginale.getChildElement(nameDetail);
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isDettaglioEccezione((Element)elem)) continue;
                        byte[] xml = org.openspcoop.utils.xml.XMLUtils.toByteArray((Element)elem);
                        DettaglioEccezione de = XMLUtils.getDettaglioEccezione(xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isDettaglioEccezione(byte[] doc) {
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioEccezione(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioEccezione(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioEccezione(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioEccezione(Element elemXML) {
        try {
            return "dettaglio-eccezione".equals(elemXML.getLocalName()) && "http://www.openspcoop.org/dao/eccezione".equals(elemXML.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String toString(DettaglioEccezione de) {
        StringBuffer bf = new StringBuffer();
        if (de != null) {
            int k;
            if (de.getOraRegistrazione() != null) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                bf.append("(" + dateformat.format(de.getOraRegistrazione()) + ") ");
            }
            if (de.getIdentificativoPorta() != null) {
                bf.append(de.getIdentificativoPorta());
                if (de.getIdentificativoFunzione() != null) {
                    bf.append(".");
                }
            }
            if (de.getIdentificativoFunzione() != null) {
                bf.append(de.getIdentificativoFunzione());
            }
            if (bf.length() > 0) {
                bf.append(" ");
            }
            bf.append("ha rilevato " + de.sizeEccezioniList() + " eccezione/i (dettagli:" + de.sizeDettagliList() + ")");
            for (k = 0; k < de.sizeEccezioniList(); ++k) {
                bf.append("\n- Eccezione [" + de.getEccezioni(k).getCodice() + "] " + de.getEccezioni(k).getDescrizione());
            }
            if (de.sizeDettagliList() > 0) {
                for (k = 0; k < de.sizeDettagliList(); ++k) {
                    bf.append("\n- Dettaglio [" + de.getDettagli(k).getTipo() + "] " + de.getDettagli(k).getBase());
                }
            }
        }
        return bf.toString();
    }
}

