/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.config.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.dao.config.Connettore;
import org.openspcoop.dao.config.ConnettoreProperty;
import org.openspcoop.dao.config.Credenziali;
import org.openspcoop.dao.config.InvocazionePorta;
import org.openspcoop.dao.config.InvocazionePortaGestioneErrore;
import org.openspcoop.dao.config.InvocazioneServizio;
import org.openspcoop.dao.config.Openspcoop;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.RispostaAsincrona;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.driver.DriverConfigurazioneDB;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneXML;
import org.openspcoop.dao.config.driver.IDPortaApplicativa;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.config.driver.IDriverConfigurazioneCRUD;
import org.openspcoop.dao.config.driver.IDriverConfigurazioneGet;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.utils.xml.ValidatoreXSD;

public class XMLDataConverter {
    private IDriverConfigurazioneCRUD gestoreCRUD = null;
    private Openspcoop sorgenteConfigurazione;
    private Logger log = null;
    private Logger logDriver = null;
    private String superUser = null;
    private boolean gestioneConfigurazione;
    private String tipoBEDestinazione;

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    private void XMLDataConverterSetup(Object sorgente, AccessoConfigurazionePdD destinazione, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.log = log == null ? Logger.getLogger((String)"ConfigurazioneXMLDataConverter") : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        if (destinazione == null) {
            throw new DriverConfigurazioneException("GestoreCRUD non definito");
        }
        this.tipoBEDestinazione = destinazione.getTipo();
        this.superUser = superUser;
        try {
            if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                int letti = 0;
                byte[] reads = new byte[65536];
                while ((letti = is.read(reads)) != -1) {
                    bout.write(reads, 0, letti);
                }
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        try {
            if ("db".equals(destinazione.getTipo())) {
                if (destinazione.getLocation() == null) {
                    throw new Exception("Location (DataSource) non definita");
                }
                if (destinazione.getContext() == null) {
                    throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties");
                }
                if (destinazione.getTipoDatabase() == null) {
                    throw new Exception("TipoDatabase (DataSource) non definita");
                }
                this.gestoreCRUD = new DriverConfigurazioneDB(destinazione.getLocation(), destinazione.getContext(), this.logDriver, destinazione.getTipoDatabase(), tabellaSoggettiCondivisaPddRegserv);
                if (!((DriverConfigurazioneDB)this.gestoreCRUD).create) {
                    throw new Exception("Configurazione DB non inizializzato");
                }
            } else {
                throw new Exception("Tipo di configurazione CRUD non gestita: " + destinazione.getTipo());
            }
            this.log.info((Object)"Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, Logger log, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser);
    }

    private void XMLDataConverterSetup(Object sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser) throws DriverConfigurazioneException {
        this.log = log == null ? Logger.getLogger((String)"ConfigurazioneXMLDataConverter [connection version]") : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        this.tipoBEDestinazione = "db";
        this.superUser = superUser;
        try {
            if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                int letti = 0;
                byte[] reads = new byte[65536];
                while ((letti = is.read(reads)) != -1) {
                    bout.write(reads, 0, letti);
                }
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        try {
            this.gestoreCRUD = new DriverConfigurazioneDB(connection, this.logDriver, tipoDatabase, tabellaSoggettiCondivisaPddRegserv);
            if (!((DriverConfigurazioneDB)this.gestoreCRUD).create) {
                throw new Exception("Configurazione DB non inizializzato");
            }
            this.log.info((Object)"Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSorgente(String sorgente) throws DriverConfigurazioneException {
        block33: {
            if (sorgente == null) {
                throw new DriverConfigurazioneException("Sorgente non definita");
            }
            ValidatoreXSD validatoreRegistro = null;
            try {
                validatoreRegistro = new ValidatoreXSD(DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione dello schema della Configurazione XML di OpenSPCoop: " + e.getMessage());
            }
            FileInputStream fXML = null;
            try {
                try {
                    if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                        validatoreRegistro.valida(sorgente);
                    } else {
                        fXML = new FileInputStream(sorgente);
                        validatoreRegistro.valida(fXML);
                    }
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD del Configurazione XML di OpenSPCoop: " + e.getMessage());
                }
                Object var6_5 = null;
                if (fXML == null) break block33;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (fXML == null) throw throwable;
                try {
                    fXML.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            fXML.close();
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Openspcoop.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            HttpURLConnection httpConn = null;
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                try {
                    URL url = new URL(sorgente);
                    URLConnection connection = url.openConnection();
                    httpConn = (HttpURLConnection)connection;
                    httpConn.setRequestMethod("GET");
                    httpConn.setDoOutput(true);
                    httpConn.setDoInput(true);
                    iStream = new InputStreamReader(httpConn.getInputStream());
                }
                catch (Exception e) {
                    try {
                        if (iStream != null) {
                            iStream.close();
                        }
                        if (httpConn == null) throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                        httpConn.disconnect();
                        throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                    }
                    catch (Exception ef) {
                        // empty catch block
                    }
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                }
            }
            try {
                iStream = new InputStreamReader(new FileInputStream(sorgente));
            }
            catch (FileNotFoundException e) {
                try {
                    if (iStream == null) throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (FILE) : \n\n" + e.getMessage());
                    iStream.close();
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (FILE) : \n\n" + e.getMessage());
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteConfigurazione = (Openspcoop)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn == null) throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
                    httpConn.disconnect();
                    throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn == null) return;
                httpConn.disconnect();
                return;
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    private void createSorgente(byte[] sorgente) throws DriverConfigurazioneException {
        if (sorgente == null) {
            throw new DriverConfigurazioneException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione dello schema della Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            validatoreRegistro.valida(new ByteArrayInputStream(sorgente));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD del Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Openspcoop.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            try {
                iStream = new InputStreamReader(new ByteArrayInputStream(sorgente));
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStreamReader della Configurazione : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteConfigurazione = (Openspcoop)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    public void convertXML(boolean reset, boolean aggiornamentoSoggetti) throws DriverConfigurazioneException {
        IDSoggetto idSoggetto;
        SoggettoSpcoop soggetto;
        int i;
        if (reset) {
            try {
                this.log.info((Object)("Configurazione, reset in corso (Reset configurazione:" + this.gestioneConfigurazione + ")..."));
                this.gestoreCRUD.reset(this.gestioneConfigurazione);
                this.log.info((Object)"Configurazione, reset effettuato.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Reset del Configurazione non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                soggetto.setSuperUser(this.superUser);
                if ("db".equals(this.tipoBEDestinazione) && soggetto.getIdentificativoPorta() == null) {
                    soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
                }
                IDSoggetto idSoggetto2 = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                if (!reset && this.gestoreCRUD.existsSoggetto(idSoggetto2)) {
                    if (!aggiornamentoSoggetti) continue;
                    this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso..."));
                    this.gestoreCRUD.updateSoggetto(soggetto);
                    this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato."));
                    continue;
                }
                this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso..."));
                this.gestoreCRUD.createSoggetto(soggetto);
                this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML dei soggetti: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo servizioApplicativo = soggetto.getServizioApplicativo(j);
                    this.addServizioApplicativo(servizioApplicativo, soggetto, null, reset);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML dei servizi applicativi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                    PortaDelegata pd = soggetto.getPortaDelegata(j);
                    String nomePD = pd.getNome();
                    if (pd.getLocation() != null) {
                        nomePD = pd.getLocation();
                    }
                    nomePD = soggetto.getTipo() + soggetto.getNome() + "_" + nomePD;
                    for (int k = 0; k < pd.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPD = pd.getServizioApplicativo(k);
                        if (saPD.getInvocazionePorta() == null && saPD.getInvocazioneServizio() == null && saPD.getRispostaAsincrona() == null) continue;
                        saPD.setNome(nomePD + "_" + saPD.getNome());
                        this.addServizioApplicativo(saPD, soggetto, "Definizione Interna alla PortaDelegata", reset);
                    }
                    pd.setTipoSoggettoProprietario(soggetto.getTipo());
                    pd.setNomeSoggettoProprietario(soggetto.getNome());
                    if (pd.getWsSecurity() != null && (pd.getWsSecurity().sizeRequestFlowList() > 0 || pd.getWsSecurity().sizeResponseFlowList() > 0)) {
                        pd.setStatoWSSecurity("abilitato");
                    }
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setSoggettoFruitore(idSoggetto);
                    idPD.setLocationPD(pd.getNome());
                    if (pd.getLocation() != null) {
                        idPD.setLocationPD(pd.getLocation());
                    }
                    if (!reset && this.gestoreCRUD.existsPortaDelegata(idPD)) {
                        this.log.info((Object)("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso..."));
                        this.gestoreCRUD.updatePortaDelegata(pd);
                        this.log.info((Object)("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato."));
                        continue;
                    }
                    this.log.info((Object)("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso..."));
                    this.gestoreCRUD.createPortaDelegata(pd);
                    this.log.info((Object)("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato."));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML delle porte delegate: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    String nomePA = pa.getNome();
                    nomePA = soggetto.getTipo() + soggetto.getNome() + "_" + nomePA;
                    for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPA = pa.getServizioApplicativo(k);
                        if (saPA.getInvocazionePorta() == null && saPA.getInvocazioneServizio() == null && saPA.getRispostaAsincrona() == null) continue;
                        saPA.setNome(nomePA + "_" + saPA.getNome());
                        this.addServizioApplicativo(saPA, soggetto, "Definizione Interna alla PortaApplicativa", reset);
                    }
                    pa.setTipoSoggettoProprietario(soggetto.getTipo());
                    pa.setNomeSoggettoProprietario(soggetto.getNome());
                    if (pa.getWsSecurity() != null && (pa.getWsSecurity().sizeRequestFlowList() > 0 || pa.getWsSecurity().sizeResponseFlowList() > 0)) {
                        pa.setStatoWSSecurity("abilitato");
                    }
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    String azione = null;
                    if (pa.getAzione() != null) {
                        azione = pa.getAzione().getNome();
                    }
                    idPA.setIDServizio(new IDServizio(idSoggetto, pa.getServizio().getTipo(), pa.getServizio().getNome(), azione));
                    if (!reset && this.gestoreCRUD.existsPortaApplicativa(idPA, true)) {
                        this.log.info((Object)("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso..."));
                        this.gestoreCRUD.updatePortaApplicativa(pa);
                        this.log.info((Object)("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato."));
                        continue;
                    }
                    this.log.info((Object)("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso..."));
                    this.gestoreCRUD.createPortaApplicativa(pa);
                    this.log.info((Object)("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato."));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML delle porte applicative: " + e.getMessage(), e);
        }
        if (this.gestioneConfigurazione) {
            try {
                this.log.info((Object)"Routing Table, creazione/aggiornamento in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getRoutingTable() != null) {
                    if (reset) {
                        this.gestoreCRUD.createRoutingTable(this.sorgenteConfigurazione.getConfigurazione().getRoutingTable());
                        this.log.info((Object)"Routing Table, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateRoutingTable(this.sorgenteConfigurazione.getConfigurazione().getRoutingTable());
                        this.log.info((Object)"Routing Table, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML della routing table: " + e.getMessage(), e);
            }
            try {
                this.log.info((Object)"Accesso registro, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro() != null) {
                    if (reset) {
                        this.gestoreCRUD.createAccessoRegistro(this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro());
                        this.log.info((Object)"Accesso registro, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateAccessoRegistro(this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro());
                        this.log.info((Object)"Accesso registro, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di accesso al registro: " + e.getMessage(), e);
            }
            try {
                this.log.info((Object)"GestioneErrore, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createGestioneErroreComponenteCooperazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione());
                        this.log.info((Object)"GestioneErrore, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateGestioneErroreComponenteCooperazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione());
                        this.log.info((Object)"GestioneErrore, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di gestione dell'errore del connettore per il componente di cooperazione: " + e.getMessage(), e);
            }
            try {
                this.log.info((Object)"GestioneErrore, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createGestioneErroreComponenteIntegrazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione());
                        this.log.info((Object)"GestioneErrore, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateGestioneErroreComponenteIntegrazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione());
                        this.log.info((Object)"GestioneErrore, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di gestione dell'errore del connettore per il componente di integrazione: " + e.getMessage(), e);
            }
            try {
                this.log.info((Object)"Configurazione, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createConfigurazione(this.sorgenteConfigurazione.getConfigurazione());
                        this.log.info((Object)"Configurazione, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateConfigurazione(this.sorgenteConfigurazione.getConfigurazione());
                        this.log.info((Object)"Configurazione, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML della Configurazione: " + e.getMessage(), e);
            }
        }
    }

    public void delete(boolean deleteSoggetti) throws DriverConfigurazioneException {
        IDSoggetto idSoggetto;
        int j;
        SoggettoSpcoop soggetto;
        int i;
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                for (j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                    PortaDelegata pd = soggetto.getPortaDelegata(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setSoggettoFruitore(idSoggetto);
                    idPD.setLocationPD(pd.getNome());
                    if (pd.getLocation() != null) {
                        idPD.setLocationPD(pd.getLocation());
                    }
                    this.log.info((Object)("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsPortaDelegata(idPD)) {
                        this.gestoreCRUD.deletePortaDelegata(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getPortaDelegata(idPD));
                    }
                    this.log.info((Object)("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminata."));
                    String nomePD = pd.getNome();
                    if (pd.getLocation() != null) {
                        nomePD = pd.getLocation();
                    }
                    nomePD = soggetto.getTipo() + soggetto.getNome() + "_" + nomePD;
                    for (int k = 0; k < pd.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPD = pd.getServizioApplicativo(k);
                        if (saPD.getInvocazionePorta() == null && saPD.getInvocazioneServizio() == null && saPD.getRispostaAsincrona() == null) continue;
                        saPD.setNome(nomePD + "_" + saPD.getNome());
                        this.log.info((Object)("Servizio Applicativo [" + saPD.getNome() + "] [Definizione Interna alla PortaDelegata] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso..."));
                        if (this.gestoreCRUD.existsServizioApplicativo(idSoggetto, saPD.getNome())) {
                            this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSoggetto, saPD.getNome()));
                        }
                        this.log.info((Object)("Servizio Applicativo [" + saPD.getNome() + "] [Definizione Interna alla PortaDelegata] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato."));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante l'eliminazione delle porte delegate: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                for (j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    String azione = null;
                    if (pa.getAzione() != null) {
                        azione = pa.getAzione().getNome();
                    }
                    idPA.setIDServizio(new IDServizio(idSoggetto, pa.getServizio().getTipo(), pa.getServizio().getNome(), azione));
                    this.log.info((Object)("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsPortaApplicativa(idPA, true)) {
                        this.gestoreCRUD.deletePortaApplicativa(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getPortaApplicativa(idPA));
                    }
                    this.log.info((Object)("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminata."));
                    String nomePA = pa.getNome();
                    nomePA = soggetto.getTipo() + soggetto.getNome() + "_" + nomePA;
                    for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPA = pa.getServizioApplicativo(k);
                        if (saPA.getInvocazionePorta() == null && saPA.getInvocazioneServizio() == null && saPA.getRispostaAsincrona() == null) continue;
                        saPA.setNome(nomePA + "_" + saPA.getNome());
                        this.log.info((Object)("Servizio Applicativo [" + saPA.getNome() + "] [Definizione Interna alla PortaApplicativa] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso..."));
                        if (this.gestoreCRUD.existsServizioApplicativo(idSoggetto, saPA.getNome())) {
                            this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSoggetto, saPA.getNome()));
                        }
                        this.log.info((Object)("Servizio Applicativo [" + saPA.getNome() + "] [Definizione Interna alla PortaApplicativa] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato."));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante l'eliminazione delle porte applicative: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                for (j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo servizioApplicativo = soggetto.getServizioApplicativo(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsServizioApplicativo(idSoggetto, servizioApplicativo.getNome())) {
                        this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSoggetto, servizioApplicativo.getNome()));
                    }
                    this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato."));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante l'eliminazione dei servizi applicativi: " + e.getMessage(), e);
        }
        if (deleteSoggetti) {
            try {
                for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoSpcoopList(); ++i) {
                    soggetto = this.sorgenteConfigurazione.getSoggettoSpcoop(i);
                    IDSoggetto idSoggetto2 = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsSoggetto(idSoggetto2)) {
                        this.gestoreCRUD.deleteSoggetto(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto2));
                    }
                    this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato."));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante l'eliminazione dei soggetti: " + e.getMessage(), e);
            }
        }
    }

    private void gestioneDefaultConnettoreHTTP(Connettore connettore) {
        if (connettore.getProperties() != null) {
            ConnettoreProperty cp;
            if (!connettore.getProperties().containsKey("trustStoreType")) {
                cp = new ConnettoreProperty();
                cp.setNome("trustStoreType");
                cp.setValore("jks");
                connettore.addProperty(cp);
            }
            if (!connettore.getProperties().containsKey("trustManagementAlgorithm")) {
                cp = new ConnettoreProperty();
                cp.setNome("trustManagementAlgorithm");
                cp.setValore(TrustManagerFactory.getDefaultAlgorithm());
                connettore.addProperty(cp);
            }
            if (connettore.getProperties().containsKey("keyStoreLocation")) {
                if (!connettore.getProperties().containsKey("keyStoreType")) {
                    cp = new ConnettoreProperty();
                    cp.setNome("keyStoreType");
                    cp.setValore("jks");
                    connettore.addProperty(cp);
                }
                if (!connettore.getProperties().containsKey("keyManagementAlgorithm")) {
                    cp = new ConnettoreProperty();
                    cp.setNome("keyManagementAlgorithm");
                    cp.setValore(KeyManagerFactory.getDefaultAlgorithm());
                    connettore.addProperty(cp);
                }
            }
        }
    }

    private void addServizioApplicativo(ServizioApplicativo servizioApplicativo, SoggettoSpcoop soggettoProprietario, String posizione, boolean reset) throws Exception {
        Credenziali credenziali;
        servizioApplicativo.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
        servizioApplicativo.setNomeSoggettoProprietario(soggettoProprietario.getNome());
        String pos = "";
        if (posizione != null) {
            pos = "[" + posizione + "]";
        }
        if (servizioApplicativo.getInvocazionePorta() == null) {
            InvocazionePorta saInv = new InvocazionePorta();
            Credenziali credenziali2 = new Credenziali();
            credenziali2.setTipo("none");
            saInv.addCredenziali(credenziali2);
            InvocazionePortaGestioneErrore ge = new InvocazionePortaGestioneErrore();
            ge.setFault("soap");
            saInv.setGestioneErrore(ge);
            servizioApplicativo.setInvocazionePorta(saInv);
        } else {
            if (servizioApplicativo.getInvocazionePorta().getGestioneErrore() == null) {
                InvocazionePortaGestioneErrore ge = new InvocazionePortaGestioneErrore();
                ge.setFault("soap");
                servizioApplicativo.getInvocazionePorta().setGestioneErrore(ge);
            } else if (servizioApplicativo.getInvocazionePorta().getGestioneErrore().getFault() == null) {
                servizioApplicativo.getInvocazionePorta().getGestioneErrore().setFault("soap");
            }
            if (servizioApplicativo.getInvocazionePorta().sizeCredenzialiList() == 0) {
                credenziali = new Credenziali();
                credenziali.setTipo("none");
                servizioApplicativo.getInvocazionePorta().addCredenziali(credenziali);
            }
        }
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null) {
            if (servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() == null) {
                for (int con = 0; con < soggettoProprietario.sizeConnettoreList(); ++con) {
                    if (!soggettoProprietario.getConnettore(con).getNome().equals(servizioApplicativo.getInvocazioneServizio().getConnettore().getNome())) continue;
                    servizioApplicativo.getInvocazioneServizio().setConnettore(soggettoProprietario.getConnettore(con));
                    break;
                }
                this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore inv servizio di tipo, dopo ricerca [" + servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() + "]"));
            } else {
                this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore inv servizio di tipo [" + servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() + "]"));
            }
            if ("db".equals(this.tipoBEDestinazione)) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    this.gestioneDefaultConnettoreHTTP(servizioApplicativo.getInvocazioneServizio().getConnettore());
                }
            }
        } else if (servizioApplicativo.getInvocazioneServizio() == null) {
            credenziali = new Credenziali();
            credenziali.setTipo("none");
            InvocazioneServizio invServizio = new InvocazioneServizio();
            invServizio.setAutenticazione("none");
            invServizio.setCredenziali(credenziali);
            invServizio.setGetMessage("disabilitato");
            servizioApplicativo.setInvocazioneServizio(invServizio);
        }
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getGetMessage() == null) {
            servizioApplicativo.getInvocazioneServizio().setGetMessage("disabilitato");
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null) {
            if (servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() == null) {
                for (int con = 0; con < soggettoProprietario.sizeConnettoreList(); ++con) {
                    if (!soggettoProprietario.getConnettore(con).getNome().equals(servizioApplicativo.getRispostaAsincrona().getConnettore().getNome())) continue;
                    servizioApplicativo.getRispostaAsincrona().setConnettore(soggettoProprietario.getConnettore(con));
                    break;
                }
                this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore risposta asincrona di tipo, dopo ricerca [" + servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() + "]"));
            } else {
                this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore risposta asincrona di tipo [" + servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() + "]"));
            }
            if ("db".equals(this.tipoBEDestinazione)) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    this.gestioneDefaultConnettoreHTTP(servizioApplicativo.getRispostaAsincrona().getConnettore());
                }
            }
        } else if (servizioApplicativo.getRispostaAsincrona() == null) {
            Credenziali credenziali3 = new Credenziali();
            credenziali3.setTipo("none");
            RispostaAsincrona rispostaAsinc = new RispostaAsincrona();
            rispostaAsinc.setAutenticazione("none");
            rispostaAsinc.setCredenziali(credenziali3);
            rispostaAsinc.setGetMessage("disabilitato");
            servizioApplicativo.setRispostaAsincrona(rispostaAsinc);
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getGetMessage() == null) {
            servizioApplicativo.getRispostaAsincrona().setGetMessage("disabilitato");
        }
        if ("db".equals(this.tipoBEDestinazione)) {
            if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    this.gestioneDefaultConnettoreHTTP(servizioApplicativo.getInvocazioneServizio().getConnettore());
                }
            }
            if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    this.gestioneDefaultConnettoreHTTP(servizioApplicativo.getRispostaAsincrona().getConnettore());
                }
            }
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggettoProprietario.getTipo(), soggettoProprietario.getNome());
        if (!reset && this.gestoreCRUD.existsServizioApplicativo(idSoggetto, servizioApplicativo.getNome())) {
            this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " aggiornamento in corso..."));
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setSoggettoFruitore(new IDSoggetto(soggettoProprietario.getTipo(), soggettoProprietario.getNome()));
            ServizioApplicativo old = ((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idPD, servizioApplicativo.getNome());
            if (servizioApplicativo.getInvocazioneServizio() != null) {
                if (servizioApplicativo.getInvocazioneServizio().getConnettore() == null) {
                    if (old.getInvocazioneServizio() != null) {
                        servizioApplicativo.getInvocazioneServizio().setConnettore(old.getInvocazioneServizio().getConnettore());
                    }
                } else if (old.getInvocazioneServizio() != null && old.getInvocazioneServizio().getConnettore() != null) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setId(old.getInvocazioneServizio().getConnettore().getId());
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(old.getInvocazioneServizio().getConnettore().getNome());
                }
            }
            if (servizioApplicativo.getRispostaAsincrona() != null) {
                if (servizioApplicativo.getRispostaAsincrona().getConnettore() == null) {
                    if (old.getRispostaAsincrona() != null) {
                        servizioApplicativo.getRispostaAsincrona().setConnettore(old.getRispostaAsincrona().getConnettore());
                    }
                } else if (old.getRispostaAsincrona() != null && old.getRispostaAsincrona().getConnettore() != null) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setId(old.getRispostaAsincrona().getConnettore().getId());
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(old.getRispostaAsincrona().getConnettore().getNome());
                }
            }
            this.gestoreCRUD.updateServizioApplicativo(servizioApplicativo);
            this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " aggiornato."));
        } else {
            this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " creazione in corso..."));
            this.gestoreCRUD.createServizioApplicativo(servizioApplicativo);
            this.log.info((Object)("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " creato."));
        }
    }
}

