/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.config.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.AccessoRegistroCache;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.dao.config.Attachments;
import org.openspcoop.dao.config.Configurazione;
import org.openspcoop.dao.config.Connettore;
import org.openspcoop.dao.config.ConnettoreProperty;
import org.openspcoop.dao.config.CorrelazioneApplicativa;
import org.openspcoop.dao.config.CorrelazioneApplicativaElemento;
import org.openspcoop.dao.config.Credenziali;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.GestioneErroreCodiceTrasporto;
import org.openspcoop.dao.config.GestioneErroreSoapFault;
import org.openspcoop.dao.config.IndirizzoTelematico;
import org.openspcoop.dao.config.InoltroBusteNonRiscontrate;
import org.openspcoop.dao.config.IntegrationManager;
import org.openspcoop.dao.config.InvocazionePorta;
import org.openspcoop.dao.config.InvocazionePortaGestioneErrore;
import org.openspcoop.dao.config.InvocazioneServizio;
import org.openspcoop.dao.config.MessaggiDiagnostici;
import org.openspcoop.dao.config.Openspcoop;
import org.openspcoop.dao.config.OpenspcoopAppender;
import org.openspcoop.dao.config.OpenspcoopAppenderProperty;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaApplicativaAzione;
import org.openspcoop.dao.config.PortaApplicativaServizio;
import org.openspcoop.dao.config.PortaApplicativaSoggettoVirtuale;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.PortaDelegataAzione;
import org.openspcoop.dao.config.PortaDelegataServizio;
import org.openspcoop.dao.config.PortaDelegataSoggettoSpcoopErogatore;
import org.openspcoop.dao.config.RispostaAsincrona;
import org.openspcoop.dao.config.RisposteSpcoop;
import org.openspcoop.dao.config.Route;
import org.openspcoop.dao.config.RouteGateway;
import org.openspcoop.dao.config.RouteRegistro;
import org.openspcoop.dao.config.RoutingTable;
import org.openspcoop.dao.config.RoutingTableDestinazione;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SetSpcoopProperty;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.Tracciamento;
import org.openspcoop.dao.config.ValidazioneBusteEgov;
import org.openspcoop.dao.config.ValidazioneContenutiApplicativi;
import org.openspcoop.dao.config.WsSecurity;
import org.openspcoop.dao.config.WsSecurityRequestFlowParameter;
import org.openspcoop.dao.config.WsSecurityResponseFlowParameter;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.regexp.RegularExpressionEngine;

public class ValidazioneSemantica {
    private Openspcoop configurazione = null;
    private List<String> errori = new ArrayList<String>();
    private Logger log = null;
    private boolean validazioneConfigurazione = false;
    private List<String> tipoConnettori = new ArrayList<String>();
    private List<String> tipoSoggetti = new ArrayList<String>();
    private List<String> tipoServizi = new ArrayList<String>();
    private List<String> tipoMsgDiagnosticiAppender = new ArrayList<String>();
    private List<String> tipoTracciamentoAppender = new ArrayList<String>();
    private List<String> tipoAutenticazione = new ArrayList<String>();
    private List<String> tipoAutorizzazione = new ArrayList<String>();
    private List<String> tipoAutorizzazioneContenuto = new ArrayList<String>();
    private List<String> tipoAutorizzazioneContenutoSPCoop = new ArrayList<String>();
    private List<String> tipoIntegrazionePD = new ArrayList<String>();
    private List<String> tipoIntegrazionePA = new ArrayList<String>();

    private String getTipoConnettori() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoConnettori.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoConnettori.get(i));
        }
        return bf.toString();
    }

    private String getTipoSoggetti() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoSoggetti.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoSoggetti.get(i));
        }
        return bf.toString();
    }

    private String getTipoServizi() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoServizi.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServizi.get(i));
        }
        return bf.toString();
    }

    private String getTipoMsgDiagnosticiAppender() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoMsgDiagnosticiAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoMsgDiagnosticiAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoTracciamentoAppender() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoTracciamentoAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoTracciamentoAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutenticazione() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutenticazione.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutenticazione.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazione() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazione.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazione.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazioneContenuto() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazioneContenuto.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazioneContenuto.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazioneContenutoSPCoop() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazioneContenutoSPCoop.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazioneContenutoSPCoop.get(i));
        }
        return bf.toString();
    }

    private String getTipoIntegrazionePD() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoIntegrazionePD.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoIntegrazionePD.get(i));
        }
        return bf.toString();
    }

    private String getTipoIntegrazionePA() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoIntegrazionePA.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoIntegrazionePA.get(i));
        }
        return bf.toString();
    }

    public ValidazioneSemantica(Openspcoop configurazione, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazione, String[] tipoAutorizzazione, String[] tipoAutorizzazioneContenuto, String[] tipoAutorizzazioneContenutoSPCoop, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA, boolean validazioneConfigurazione, Logger log) throws DriverConfigurazioneException {
        int i;
        this.configurazione = configurazione;
        this.log = log;
        this.validazioneConfigurazione = validazioneConfigurazione;
        if (tipoConnettori != null && tipoConnettori.length > 0) {
            for (i = 0; i < tipoConnettori.length; ++i) {
                this.tipoConnettori.add(tipoConnettori[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di connettori ammissibili non definiti");
        }
        if (tipoSoggetti != null && tipoSoggetti.length > 0) {
            for (i = 0; i < tipoSoggetti.length; ++i) {
                this.tipoSoggetti.add(tipoSoggetti[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di soggetti ammissibili non definiti");
        }
        if (tipoServizi != null && tipoServizi.length > 0) {
            for (i = 0; i < tipoServizi.length; ++i) {
                this.tipoServizi.add(tipoServizi[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di servizi ammissibili non definiti");
        }
        if (tipoMsgDiagnosticiAppender != null && tipoMsgDiagnosticiAppender.length > 0) {
            for (i = 0; i < tipoMsgDiagnosticiAppender.length; ++i) {
                this.tipoMsgDiagnosticiAppender.add(tipoMsgDiagnosticiAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per i msg diagnostici non definiti");
        }
        if (tipoTracciamentoAppender != null && tipoTracciamentoAppender.length > 0) {
            for (i = 0; i < tipoTracciamentoAppender.length; ++i) {
                this.tipoTracciamentoAppender.add(tipoTracciamentoAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per le traccie non definiti");
        }
        if (tipoAutenticazione != null && tipoAutenticazione.length > 0) {
            for (i = 0; i < tipoAutenticazione.length; ++i) {
                this.tipoAutenticazione.add(tipoAutenticazione[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autenticazione ammissibili non definiti");
        }
        if (tipoAutorizzazione != null && tipoAutorizzazione.length > 0) {
            for (i = 0; i < tipoAutorizzazione.length; ++i) {
                this.tipoAutorizzazione.add(tipoAutorizzazione[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione ammissibili non definiti");
        }
        if (tipoAutorizzazioneContenutoSPCoop != null && tipoAutorizzazioneContenutoSPCoop.length > 0) {
            for (i = 0; i < tipoAutorizzazioneContenutoSPCoop.length; ++i) {
                this.tipoAutorizzazioneContenutoSPCoop.add(tipoAutorizzazioneContenutoSPCoop[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione contenuto spcoop ammissibili non definiti");
        }
        if (tipoAutorizzazioneContenuto != null && tipoAutorizzazioneContenuto.length > 0) {
            for (i = 0; i < tipoAutorizzazioneContenuto.length; ++i) {
                this.tipoAutorizzazioneContenuto.add(tipoAutorizzazioneContenuto[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione contenuto ammissibili non definiti");
        }
        if (tipoIntegrazionePD != null && tipoIntegrazionePD.length > 0) {
            for (i = 0; i < tipoIntegrazionePD.length; ++i) {
                this.tipoIntegrazionePD.add(tipoIntegrazionePD[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di integrazione lato PortaDelegata ammissibili non definiti");
        }
        if (tipoIntegrazionePA != null && tipoIntegrazionePA.length > 0) {
            for (i = 0; i < tipoIntegrazionePA.length; ++i) {
                this.tipoIntegrazionePA.add(tipoIntegrazionePA[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di integrazione lato PortaApplicativa ammissibili non definiti");
        }
    }

    public ValidazioneSemantica(Openspcoop configurazione, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazione, String[] tipoAutorizzazione, String[] tipoAutorizzazioneContenuto, String[] tipoAutorizzazioneContenutoSPCoop, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA, boolean validazioneConfigurazione) throws DriverConfigurazioneException {
        this(configurazione, tipoConnettori, tipoSoggetti, tipoServizi, tipoMsgDiagnosticiAppender, tipoTracciamentoAppender, tipoAutenticazione, tipoAutorizzazione, tipoAutorizzazioneContenuto, tipoAutorizzazioneContenutoSPCoop, tipoIntegrazionePD, tipoIntegrazionePA, validazioneConfigurazione, null);
    }

    private void printMsg(String msg) {
        if (this.log == null) {
            this.printMsg(msg);
        } else {
            this.log.debug((Object)msg);
        }
    }

    public void validazioneSemantica(boolean showIDOggettiAnalizzati) throws DriverConfigurazioneException {
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Soggetti(" + this.configurazione.sizeSoggettoSpcoopList() + ")-----------------------------------------------------");
        }
        for (int i = 0; i < this.configurazione.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop sogg = this.configurazione.getSoggettoSpcoop(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Soggetto SPCoop: " + sogg.getTipo() + "/" + sogg.getNome());
            }
            this.validaSoggettoSpcoop(sogg, showIDOggettiAnalizzati);
        }
        if (this.validazioneConfigurazione) {
            if (showIDOggettiAnalizzati) {
                this.printMsg("\n\n------------------------------------Configurazione-----------------------------------------------------");
            }
            this.validaConfigurazione(this.configurazione.getConfigurazione());
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n-----------------------------------------------------------------------------------------");
        }
        if (!this.errori.isEmpty()) {
            StringBuffer stringB = new StringBuffer().append("\n");
            Iterator<String> itE = this.errori.iterator();
            while (itE.hasNext()) {
                stringB.append(itE.next()).append("\n");
            }
            throw new DriverConfigurazioneException(stringB.toString());
        }
    }

    private void validaSoggettoSpcoop(SoggettoSpcoop sogg, boolean showIDOggettiAnalizzati) throws DriverConfigurazioneException {
        int j;
        if (sogg.getNome() == null) {
            this.errori.add("Esiste un soggetto spcoop senza nome");
            return;
        }
        if (sogg.getTipo() == null) {
            this.errori.add("Esiste un soggetto spcoop senza tipo");
            return;
        }
        for (j = 0; j < sogg.sizePortaDelegataList(); ++j) {
            PortaDelegata pd = sogg.getPortaDelegata(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tPorta Delegata: " + pd.getNome());
            }
            this.validaPortaDelegata(pd, sogg);
        }
        for (j = 0; j < sogg.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = sogg.getPortaApplicativa(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tPortaApplicativa: " + pa.getNome());
            }
            this.validaPortaApplicativa(pa, sogg);
        }
        for (j = 0; j < sogg.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = sogg.getServizioApplicativo(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tServizioApplicativo: " + sa.getNome());
            }
            this.validaServizioApplicativo(sa, sogg);
        }
        for (j = 0; j < sogg.sizeConnettoreList(); ++j) {
            Connettore connettore = sogg.getConnettore(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tConnettore definito nella root del soggetto: " + connettore.getNome());
            }
            this.validaConnettore(connettore, null, sogg);
        }
        if (!this.tipoSoggetti.contains(sogg.getTipo())) {
            this.errori.add("Il tipo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch(sogg.getNome(), "^[0-9A-Za-z]+$")) {
                this.errori.add("Il nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo caratteri e cifre");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + ": " + e.getMessage(), e);
        }
        int numS = 0;
        for (int j2 = 0; j2 < this.configurazione.sizeSoggettoSpcoopList(); ++j2) {
            SoggettoSpcoop tmpSogg = this.configurazione.getSoggettoSpcoop(j2);
            if (!sogg.getNome().equals(tmpSogg.getNome()) || !sogg.getTipo().equals(tmpSogg.getTipo())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto con nome " + sogg.getNome() + " e tipo " + sogg.getTipo());
        }
        if (sogg.getRouter()) {
            int numR = 0;
            for (int j3 = 0; j3 < this.configurazione.sizeSoggettoSpcoopList(); ++j3) {
                SoggettoSpcoop tmpS = this.configurazione.getSoggettoSpcoop(j3);
                if (!tmpS.getRouter()) continue;
                ++numR;
            }
            if (numR > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto abilitato alla funzione di Router");
            }
        }
        try {
            if (sogg.getPdUrlPrefixRewriter() != null && !RegularExpressionEngine.isMatch(sogg.getPdUrlPrefixRewriter(), "[A-Za-z]+:\\/\\/(.*)")) {
                this.errori.add("La funzione PdUrlPrefixRewriter contiene un valore errato che non rispetta l'espressione [A-Za-z]+:\\/\\/(.*)");
            }
            if (sogg.getPaUrlPrefixRewriter() != null && !RegularExpressionEngine.isMatch(sogg.getPaUrlPrefixRewriter(), "[A-Za-z]+:\\/\\/(.*)")) {
                this.errori.add("La funzione PaUrlPrefixRewriter contiene un valore errato che non rispetta l'espressione [A-Za-z]+:\\/\\/(.*)");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e);
        }
    }

    private void validaPortaDelegata(PortaDelegata pd, SoggettoSpcoop sogg) throws DriverConfigurazioneException {
        String stateless;
        String gestMan;
        String scartaBody;
        String allegaBody;
        String integrazione;
        String ricAsiAsim;
        String ricAsiSim;
        ValidazioneContenutiApplicativi vca;
        String identificazione;
        if (pd.getNome() == null) {
            this.errori.add("Il soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] posside una porta delegata che non contiene la definizione del nome");
            return;
        }
        String idPortaDelegata = sogg.getTipo() + "/" + sogg.getNome() + "_" + pd.getNome();
        if (pd.getSoggettoSpcoopErogatore() == null) {
            this.errori.add("La porta delegata " + idPortaDelegata + " non contiene la definizione del soggetto spcoop erogatore");
        } else {
            PortaDelegataSoggettoSpcoopErogatore pdsse = pd.getSoggettoSpcoopErogatore();
            if (pdsse.getTipo() == null) {
                this.errori.add("Il soggetto spcoop erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del tipo.");
            } else if (!this.tipoSoggetti.contains(pdsse.getTipo())) {
                this.errori.add("Il tipo del soggetto spcoop erogatore della porta delegata " + idPortaDelegata + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
            }
            identificazione = pdsse.getIdentificazione();
            if (!(identificazione == null || identificazione.equals("static") || identificazione.equals("urlBased") || identificazione.equals("contentBased") || identificazione.equals("inputBased"))) {
                this.errori.add("La modalita d'identificazione del soggetto spcoop erogatore della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + "static" + "," + "urlBased" + "," + "contentBased" + " o " + "inputBased");
            }
            if (identificazione == null) {
                identificazione = "static";
            }
            if ("static".equals(identificazione)) {
                if (pdsse.getNome() == null) {
                    this.errori.add("Il soggetto spcoop erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + identificazione);
                }
            } else if (("urlBased".equals(identificazione) || "contentBased".equals(identificazione)) && pdsse.getPattern() == null) {
                this.errori.add("Il soggetto spcoop erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + identificazione);
            }
        }
        if (pd.getServizio() == null) {
            this.errori.add("La porta delegata " + idPortaDelegata + " non contiene la definizione del servizio spcoop");
        } else {
            PortaDelegataServizio pds = pd.getServizio();
            if (pds.getTipo() == null) {
                this.errori.add("Il servizio spcoop della porta delegata " + idPortaDelegata + " non contiene la definizione del tipo.");
            } else if (!this.tipoServizi.contains(pds.getTipo())) {
                this.errori.add("Il tipo del servizio spcoop della porta delegata " + idPortaDelegata + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoServizi() + ")");
            }
            identificazione = pds.getIdentificazione();
            if (!(identificazione == null || identificazione.equals("static") || identificazione.equals("urlBased") || identificazione.equals("contentBased") || identificazione.equals("inputBased"))) {
                this.errori.add("La modalita d'identificazione del servizio spcoop della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + "static" + "," + "urlBased" + "," + "contentBased" + " o " + "inputBased");
            }
            if (identificazione == null) {
                identificazione = "static";
            }
            if ("static".equals(identificazione)) {
                if (pds.getNome() == null) {
                    this.errori.add("Il servizio spcoop della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + identificazione);
                }
            } else if (("urlBased".equals(identificazione) || "contentBased".equals(identificazione)) && pds.getPattern() == null) {
                this.errori.add("Il servizio spcoop della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + identificazione);
            }
        }
        if (pd.getAzione() != null) {
            PortaDelegataAzione pda = pd.getAzione();
            identificazione = pda.getIdentificazione();
            if (!(identificazione == null || identificazione.equals("static") || identificazione.equals("urlBased") || identificazione.equals("contentBased") || identificazione.equals("inputBased") || identificazione.equals("soapActionBased"))) {
                this.errori.add("La modalita d'identificazione dell'azione spcoop della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + "static" + ", " + "urlBased" + ", " + "contentBased" + ", " + "inputBased" + " o " + "soapActionBased");
            }
            if (identificazione == null) {
                identificazione = "static";
            }
            if ("static".equals(identificazione)) {
                if (pda.getNome() == null) {
                    this.errori.add("L'azione spcoop della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + identificazione);
                }
            } else if (("urlBased".equals(identificazione) || "contentBased".equals(identificazione)) && pda.getPattern() == null) {
                this.errori.add("L'azione spcoop della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + identificazione);
            }
        }
        String autenticazione = "ssl";
        if (pd.getAutenticazione() != null) {
            autenticazione = pd.getAutenticazione();
            if (!this.tipoAutenticazione.contains(pd.getAutenticazione())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autenticazione non valido; tipi conosciuti: " + this.getTipoAutenticazione());
            }
        }
        String autorizzazione = "openspcoop";
        if (pd.getAutorizzazione() != null) {
            autorizzazione = pd.getAutorizzazione();
            if (!this.tipoAutorizzazione.contains(pd.getAutorizzazione())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione non valido; tipi conosciuti: " + this.getTipoAutorizzazione());
            }
        }
        if (!"none".equals(autorizzazione) && "none".equals(autenticazione)) {
            this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione ma non un processo di autenticazione: non e' possibile effettuare autorizzazione senza prima autenticare i servizi applicativi");
        }
        if ("openspcoop".equals(autorizzazione) && pd.sizeServizioApplicativoList() == 0) {
            this.errori.add("La porta delegata " + idPortaDelegata + " deve avere almeno un servizio applicativo associato poiche' lo richiede il tipo di autorizzazione " + "openspcoop");
        }
        if (pd.getAutorizzazioneContenuto() != null && !this.tipoAutorizzazioneContenuto.contains(pd.getAutorizzazioneContenuto())) {
            this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione contenuto non valido; tipi conosciuti: " + this.getTipoAutorizzazioneContenuto());
        }
        for (int i = 0; i < pd.sizeServizioApplicativoList(); ++i) {
            int k;
            boolean trovato;
            ServizioApplicativo sa = pd.getServizioApplicativo(i);
            if (sa.getNome() == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un servizio applicativo per cui non e' stato definito il nome");
            } else if (sa.getInvocazionePorta() == null && sa.getInvocazioneServizio() == null && sa.getRispostaAsincrona() == null) {
                if (!this.existsServizioApplicativo(sa.getNome(), sogg)) {
                    this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un riferimento ad un servizio applicativo [" + sa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                } else {
                    sa = this.getServizioApplicativo(sa.getNome(), sogg);
                }
            } else {
                this.validaServizioApplicativo(sa, sogg);
            }
            if ("none".equals(autenticazione)) continue;
            if (sa.getInvocazionePorta() == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione dell'elemento invocazione porta");
                continue;
            }
            if (sa.getInvocazionePorta().sizeCredenzialiList() <= 0) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso");
                continue;
            }
            if ("basic".equals(autenticazione)) {
                trovato = false;
                for (k = 0; k < sa.getInvocazionePorta().sizeCredenzialiList(); ++k) {
                    if (!"basic".equals(sa.getInvocazionePorta().getCredenziali(k).getTipo())) continue;
                    trovato = true;
                    break;
                }
                if (trovato) continue;
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso di tipo " + "basic");
                continue;
            }
            if (!"ssl".equals(autenticazione)) continue;
            trovato = false;
            for (k = 0; k < sa.getInvocazionePorta().sizeCredenzialiList(); ++k) {
                if (!"ssl".equals(sa.getInvocazionePorta().getCredenziali(k).getTipo())) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso di tipo " + "ssl");
        }
        WsSecurity ws = pd.getWsSecurity();
        if (ws != null) {
            this.validaWSSecurity(ws, "PortaDelegata_" + idPortaDelegata);
        }
        if ((vca = pd.getValidazioneContenutiApplicativi()) != null) {
            this.validazioneValidazioneContenutiApplicativi(vca, "PortaDelegata_" + idPortaDelegata);
        }
        String idRisorsa = "Porta delegata " + idPortaDelegata;
        this.validaCorrelazioneApplicativa(idRisorsa, pd.getCorrelazioneApplicativa(), true);
        String idPorta = null;
        idPorta = pd.getLocation() != null ? pd.getLocation() : pd.getNome();
        int numPD = 0;
        Vector<String> pdTrovate = new Vector<String>();
        for (int j = 0; j < this.configurazione.sizeSoggettoSpcoopList(); ++j) {
            SoggettoSpcoop s = this.configurazione.getSoggettoSpcoop(j);
            for (int k = 0; k < s.sizePortaDelegataList(); ++k) {
                PortaDelegata tmpPd = s.getPortaDelegata(k);
                String tmpIdPorta = null;
                tmpIdPorta = tmpPd.getLocation() != null ? tmpPd.getLocation() : tmpPd.getNome();
                if (!idPorta.equals(tmpIdPorta)) continue;
                ++numPD;
                pdTrovate.add(s.getTipo() + "/" + s.getNome() + "_" + tmpPd.getNome());
            }
        }
        if (numPD > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta delegata invocabile tramite identificativo " + idPorta + ". Invece l'identificativo invoca le seguenti porte delegate: " + pdTrovate.toArray(new String[1]));
        }
        if ((ricAsiSim = pd.getRicevutaAsincronaSimmetrica()) != null && !ricAsiSim.equals("abilitato") && !ricAsiSim.equals("disabilitato")) {
            this.errori.add("La ricevuta asincrona simmetrica della porta delegata " + idPortaDelegata + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((ricAsiAsim = pd.getRicevutaAsincronaAsimmetrica()) != null && !ricAsiAsim.equals("abilitato") && !ricAsiAsim.equals("disabilitato")) {
            this.errori.add("La ricevuta asincrona asimmetrica della porta delegata " + idPortaDelegata + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((integrazione = pd.getIntegrazione()) != null) {
            String[] tipiIntegrazione = integrazione.split(",");
            if (tipiIntegrazione == null || tipiIntegrazione.length <= 0) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un valore nel campo 'integrazione' non valido: " + integrazione);
            }
            for (int p = 0; p < tipiIntegrazione.length; ++p) {
                String tipoI = tipiIntegrazione[p].trim();
                if (this.tipoIntegrazionePD.contains(tipoI)) continue;
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un tipo di integrazione [" + tipoI + "] non valido: valori utilizzabili sono: " + this.getTipoIntegrazionePD());
            }
        }
        if ((allegaBody = pd.getAllegaBody()) != null && !allegaBody.equals("abilitato") && !allegaBody.equals("disabilitato")) {
            this.errori.add("La funzionalita' di allega-boxy della porta delegata " + idPortaDelegata + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((scartaBody = pd.getScartaBody()) != null && !scartaBody.equals("abilitato") && !scartaBody.equals("disabilitato")) {
            this.errori.add("La funzionalita' di scarta-boxy della porta delegata " + idPortaDelegata + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((gestMan = pd.getGestioneManifest()) != null && !gestMan.equals("abilitato") && !gestMan.equals("disabilitato")) {
            this.errori.add("La funzionalita' di gestioneManifest della porta delegata " + idPortaDelegata + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((stateless = pd.getStateless()) != null && !stateless.equals("abilitato") && !stateless.equals("disabilitato")) {
            this.errori.add("La funzionalita' 'stateless' della porta delegata " + idPortaDelegata + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
    }

    private void validaPortaApplicativa(PortaApplicativa pa, SoggettoSpcoop sogg) throws DriverConfigurazioneException {
        String stateless;
        String gestMan;
        String scartaBody;
        String allegaBody;
        String integrazione;
        String ricAsiAsim;
        String ricAsiSim;
        ValidazioneContenutiApplicativi vca;
        PortaApplicativaAzione azione;
        if (pa.getNome() == null) {
            this.errori.add("Il soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] posside una porta applicativa che non contiene la definizione del nome");
            return;
        }
        String idPortaApplicativa = sogg.getTipo() + "/" + sogg.getNome() + "_" + pa.getNome();
        boolean checkIDPA = true;
        if (pa.getSoggettoVirtuale() != null) {
            PortaApplicativaSoggettoVirtuale sv = pa.getSoggettoVirtuale();
            if (sv.getTipo() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui non e' stato definito il tipo");
                checkIDPA = false;
            } else if (!this.tipoSoggetti.contains(sv.getTipo())) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui e' stato definito un tipo non valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
            }
            if (sv.getNome() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui non e' stato definito il nome");
                checkIDPA = false;
            }
        }
        if (pa.getServizio() != null) {
            PortaApplicativaServizio serv = pa.getServizio();
            if (serv.getTipo() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio spcoop erogato per cui non e' stato definito il tipo");
                checkIDPA = false;
            } else if (!this.tipoServizi.contains(serv.getTipo())) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio spcoop erogato per cui e' stato definito un tipo non valido (Tipi utilizzabili: " + this.getTipoServizi() + ")");
            }
            if (serv.getNome() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio spcoop erogato per cui non e' stato definito il nome");
                checkIDPA = false;
            }
        } else {
            this.errori.add("La porta applicativa [" + idPortaApplicativa + "] non possiede la definizione del servizio spcoop erogato");
        }
        if (pa.getAzione() != null && (azione = pa.getAzione()).getNome() == null) {
            this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un azione spcoop erogata per cui non e' stato definito il nome");
            checkIDPA = false;
        }
        if (pa.sizeServizioApplicativoList() < 1) {
            this.errori.add("Alla porta applicativa [" + idPortaApplicativa + "] non sono stati associati servizi applicativi");
        } else {
            for (int i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
                ServizioApplicativo sa = pa.getServizioApplicativo(i);
                if (sa.getNome() == null) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo per cui non e' stato definito il nome");
                } else if (sa.getInvocazionePorta() == null && sa.getInvocazioneServizio() == null && sa.getRispostaAsincrona() == null) {
                    if (!this.existsServizioApplicativo(sa.getNome(), sogg)) {
                        this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un riferimento ad un servizio applicativo [" + sa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                    } else {
                        sa = this.getServizioApplicativo(sa.getNome(), sogg);
                    }
                } else {
                    this.validaServizioApplicativo(sa, sogg);
                }
                if (sa.getInvocazioneServizio() == null) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo [" + sa.getNome() + "] per cui non e' stato definito l'elemento invocazione servizio");
                    continue;
                }
                boolean connettore = false;
                boolean get = false;
                if (sa.getInvocazioneServizio().getConnettore() != null && !"disabilitato".equals(sa.getInvocazioneServizio().getConnettore().getTipo())) {
                    connettore = true;
                }
                if (sa.getInvocazioneServizio().getGetMessage() != null && "abilitato".equals(sa.getInvocazioneServizio().getGetMessage())) {
                    get = true;
                }
                if (connettore || get) continue;
                this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo [" + sa.getNome() + "] per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
        }
        if (pa.getAutorizzazioneContenuto() != null && !this.tipoAutorizzazioneContenutoSPCoop.contains(pa.getAutorizzazioneContenuto())) {
            this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autorizzazione contenuto non valido; tipi conosciuti: " + this.getTipoAutorizzazioneContenutoSPCoop());
        }
        for (int j = 0; j < pa.sizeSetSpcoopPropertyList(); ++j) {
            SetSpcoopProperty ssp = pa.getSetSpcoopProperty(j);
            this.validaSpcoopProperty(ssp, idPortaApplicativa);
        }
        WsSecurity ws = pa.getWsSecurity();
        if (ws != null) {
            this.validaWSSecurity(ws, "PortaApplicativa_" + idPortaApplicativa);
        }
        if ((vca = pa.getValidazioneContenutiApplicativi()) != null) {
            this.validazioneValidazioneContenutiApplicativi(vca, "PortaApplicativa_" + idPortaApplicativa);
        }
        String idRisorsa = "Porta applicativa " + idPortaApplicativa;
        this.validaCorrelazioneApplicativa(idRisorsa, pa.getCorrelazioneApplicativa(), false);
        int numPA = 0;
        for (int j = 0; j < sogg.sizePortaApplicativaList(); ++j) {
            PortaApplicativa tmpPa = sogg.getPortaApplicativa(j);
            if (!pa.getNome().equals(tmpPa.getNome())) continue;
            ++numPA;
        }
        if (numPA > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " con nome " + pa.getNome());
        }
        String idPortaA = null;
        if (!checkIDPA) {
            idPortaA = pa.getSoggettoVirtuale() != null ? pa.getSoggettoVirtuale().getTipo() + "/" + pa.getSoggettoVirtuale().getNome() : sogg.getTipo() + "/" + sogg.getNome();
            idPortaA = idPortaA + "_" + pa.getServizio().getTipo() + "/" + pa.getServizio().getNome();
            if (pa.getAzione() != null) {
                idPortaA = idPortaA + "_" + pa.getAzione().getNome();
            }
            int cont = 0;
            for (int i = 0; i < sogg.sizePortaApplicativaList(); ++i) {
                PortaApplicativa tmp = sogg.getPortaApplicativa(i);
                String idTMPPA = null;
                if (tmp.getSoggettoVirtuale() != null) {
                    if (tmp.getSoggettoVirtuale().getTipo() == null || tmp.getSoggettoVirtuale().getNome() == null) continue;
                    idTMPPA = tmp.getSoggettoVirtuale().getTipo() + "/" + tmp.getSoggettoVirtuale().getNome();
                } else {
                    idTMPPA = sogg.getTipo() + "/" + sogg.getNome();
                }
                if (tmp.getServizio() == null || tmp.getServizio().getTipo() == null || tmp.getServizio().getNome() == null) continue;
                idTMPPA = idTMPPA + "_" + tmp.getServizio().getTipo() + "/" + tmp.getServizio().getNome();
                if (tmp.getAzione() != null) {
                    if (tmp.getAzione().getNome() == null) continue;
                    idTMPPA = idTMPPA + "_" + pa.getAzione().getNome();
                }
                if (!idPortaA.equals(idTMPPA)) continue;
                ++cont;
            }
            if (cont > 1) {
                if (pa.getSoggettoVirtuale() != null) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa (con soggetto virtuale) che mappa il servizio: " + idPortaA);
                } else {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa che mappa il servizio: " + idPortaA);
                }
            }
        }
        if ((ricAsiSim = pa.getRicevutaAsincronaSimmetrica()) != null && !ricAsiSim.equals("abilitato") && !ricAsiSim.equals("disabilitato")) {
            this.errori.add("La ricevuta asincrona simmetrica della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((ricAsiAsim = pa.getRicevutaAsincronaAsimmetrica()) != null && !ricAsiAsim.equals("abilitato") && !ricAsiAsim.equals("disabilitato")) {
            this.errori.add("La ricevuta asincrona asimmetrica della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((integrazione = pa.getIntegrazione()) != null) {
            String[] tipiIntegrazione = integrazione.split(",");
            if (tipiIntegrazione == null || tipiIntegrazione.length <= 0) {
                this.errori.add("La porta applicativa " + idPortaApplicativa + " possiede un valore nel campo 'integrazione' non valido: " + integrazione);
            }
            for (int p = 0; p < tipiIntegrazione.length; ++p) {
                String tipoI = tipiIntegrazione[p].trim();
                if (this.tipoIntegrazionePA.contains(tipoI)) continue;
                this.errori.add("La porta applicativa " + idPortaApplicativa + " possiede un tipo di integrazione [" + tipoI + "] non valido: valori utilizzabili sono: " + this.getTipoIntegrazionePA());
            }
        }
        if ((allegaBody = pa.getAllegaBody()) != null && !allegaBody.equals("abilitato") && !allegaBody.equals("disabilitato")) {
            this.errori.add("La funzionalita' di allega-boxy della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((scartaBody = pa.getScartaBody()) != null && !scartaBody.equals("abilitato") && !scartaBody.equals("disabilitato")) {
            this.errori.add("La funzionalita' di scarta-boxy della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((gestMan = pa.getGestioneManifest()) != null && !gestMan.equals("abilitato") && !gestMan.equals("disabilitato")) {
            this.errori.add("La funzionalita' di gestioneManifest della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
        if ((stateless = pa.getStateless()) != null && !stateless.equals("abilitato") && !stateless.equals("disabilitato")) {
            this.errori.add("La funzionalita' 'stateless' della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
        }
    }

    private void validaServizioApplicativo(ServizioApplicativo sa, SoggettoSpcoop sogg) throws DriverConfigurazioneException {
        String rispRif;
        String invRif;
        String getMsg;
        boolean get;
        boolean connettore;
        GestioneErrore ge;
        Connettore conn;
        String auth;
        Credenziali c;
        if (sa.getNome() == null) {
            this.errori.add("Esiste un ServizioApplicativo del soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] per cui non e' stato definito il nome");
            return;
        }
        String idServizioApplicativo = sogg.getTipo() + "/" + sogg.getNome() + "_" + sa.getNome();
        if (sa.getInvocazionePorta() == null && sa.getRispostaAsincrona() == null && sa.getInvocazioneServizio() == null) {
            this.errori.add("Il ServizioApplicativo [" + idServizioApplicativo + "] non contiene ne la definizione dell'elemento invocazione porta, ne la definizione della risposta asincrona, ne la definizione dell'elemento invocazione servizio");
            return;
        }
        InvocazionePorta ip = sa.getInvocazionePorta();
        if (ip != null) {
            InvocazionePortaGestioneErrore ipge;
            if (ip.sizeCredenzialiList() < 1) {
                this.errori.add("Il ServizioApplicativo [" + idServizioApplicativo + "] non contiene credenziali di accesso, nonostante abbia definito l'elemento invocazione porta");
            }
            for (int j = 0; j < ip.sizeCredenzialiList(); ++j) {
                c = ip.getCredenziali(j);
                this.validaCredenziale(c, "servizio applicativo [" + idServizioApplicativo + "] (invocazione porta)", true);
            }
            String invRif2 = ip.getInvioPerRiferimento();
            if (invRif2 != null && !invRif2.equals("abilitato") && !invRif2.equals("disabilitato")) {
                this.errori.add("L'invio per riferimento dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
            if ((ipge = ip.getGestioneErrore()) != null) {
                String genFault;
                String fault = ipge.getFault();
                if (fault != null && !fault.equals("soap") && !fault.equals("xml")) {
                    this.errori.add("Il fault della gestione errore dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + "soap" + " o " + "xml");
                }
                if ((genFault = ipge.getGenericFaultCode()) != null && !genFault.equals("abilitato") && !genFault.equals("disabilitato")) {
                    this.errori.add("Il generic-fault-code della gestione errore dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
                }
            }
        }
        if (sa.getInvocazioneServizio() != null) {
            InvocazioneServizio is = sa.getInvocazioneServizio();
            c = is.getCredenziali();
            if (c != null) {
                this.validaCredenziale(c, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)", false);
            }
            if ((auth = is.getAutenticazione()) != null && !auth.equals("basic") && !auth.equals("none")) {
                this.errori.add("L'autenticazione dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere uno dei seguenti valori: " + "basic" + " o " + "none");
            }
            if ("basic".equals(auth)) {
                if (c == null) {
                    this.errori.add("L'autenticazione basic dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali");
                }
                if (!"basic".equals(c.getTipo())) {
                    this.errori.add("L'autenticazione basic dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali di tipo " + "basic");
                }
            }
            if ((conn = is.getConnettore()) != null) {
                this.validaConnettore(conn, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)", sogg);
            }
            if ((ge = is.getGestioneErrore()) != null) {
                this.validaGestioneErrore(ge, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)");
            }
            connettore = false;
            get = false;
            if (is.getConnettore() != null && !"disabilitato".equals(is.getConnettore().getTipo())) {
                connettore = true;
            }
            if (is.getGetMessage() != null && "abilitato".equals(is.getGetMessage())) {
                get = true;
            }
            if (!connettore && !get) {
                this.errori.add("Il servizio Applicativo " + idServizioApplicativo + " possiede un elemento invocazione servizio per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
            if ((getMsg = is.getGetMessage()) != null && !getMsg.equals("abilitato") && !getMsg.equals("disabilitato")) {
                this.errori.add("Il get-message dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
            if ((invRif = is.getInvioPerRiferimento()) != null && !invRif.equals("abilitato") && !invRif.equals("disabilitato")) {
                this.errori.add("La funzionalita' di invio per riferimento dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
            if ((rispRif = is.getRispostaPerRiferimento()) != null && !rispRif.equals("abilitato") && !rispRif.equals("disabilitato")) {
                this.errori.add("La funzionalita' di risposta per riferimento dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
        }
        if (sa.getRispostaAsincrona() != null) {
            RispostaAsincrona ra = sa.getRispostaAsincrona();
            c = ra.getCredenziali();
            if (c != null) {
                this.validaCredenziale(c, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)", false);
            }
            if ((auth = ra.getAutenticazione()) != null && !auth.equals("basic") && !auth.equals("none")) {
                this.errori.add("L'autenticazione della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere uno dei seguenti valori: " + "basic" + " o " + "none");
            }
            if ("basic".equals(auth)) {
                if (c == null) {
                    this.errori.add("L'autenticazione basic della risposta asincrona del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali");
                }
                if (!"basic".equals(c.getTipo())) {
                    this.errori.add("L'autenticazione basic della risposta asincrona del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali di tipo " + "basic");
                }
            }
            if ((conn = ra.getConnettore()) != null) {
                this.validaConnettore(conn, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)", sogg);
            }
            if ((ge = ra.getGestioneErrore()) != null) {
                this.validaGestioneErrore(ge, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)");
            }
            connettore = false;
            get = false;
            if (ra.getConnettore() != null && !"disabilitato".equals(ra.getConnettore().getTipo())) {
                connettore = true;
            }
            if (ra.getGetMessage() != null && "abilitato".equals(ra.getGetMessage())) {
                get = true;
            }
            if (!connettore && !get) {
                this.errori.add("Il servizio Applicativo " + idServizioApplicativo + " possiede un elemento risposta asincrona per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
            if ((getMsg = ra.getGetMessage()) != null && !getMsg.equals("abilitato") && !getMsg.equals("disabilitato")) {
                this.errori.add("Il get-message della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
            if ((invRif = ra.getInvioPerRiferimento()) != null && !invRif.equals("abilitato") && !invRif.equals("disabilitato")) {
                this.errori.add("La funzionalita' di invio per riferimento della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
            if ((rispRif = ra.getRispostaPerRiferimento()) != null && !rispRif.equals("abilitato") && !rispRif.equals("disabilitato")) {
                this.errori.add("La funzionalita' di risposta per riferimento della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + "abilitato" + " o " + "disabilitato");
            }
        }
        int numSA = 0;
        for (int j = 0; j < sogg.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo tmpSA = sogg.getServizioApplicativo(j);
            if (!sa.getNome().equals(tmpSA.getNome())) continue;
            ++numSA;
        }
        if (numSA > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un servizio applicativo con nome " + sa.getNome() + " associato al soggetto " + sogg.getTipo() + "/" + sogg.getNome());
        }
    }

    private void validaConnettore(Connettore conn, String identificativoElementoInternoSoggetto, SoggettoSpcoop soggetto) throws DriverConfigurazioneException {
        block117: {
            int j;
            String nomeConn = conn.getNome();
            String tipoConn = conn.getTipo();
            String idSoggetto = soggetto.getTipo() + "/" + soggetto.getNome();
            if (nomeConn == null) {
                if (identificativoElementoInternoSoggetto == null) {
                    this.errori.add("Esiste un connettore nella radice del soggetto[" + idSoggetto + "] per cui non \u00e8 definito il nome");
                } else {
                    this.errori.add("Esiste un connettore del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") per cui non \u00e8 definito il nome");
                }
                return;
            }
            if (identificativoElementoInternoSoggetto == null) {
                int numC = 0;
                for (j = 0; j < soggetto.sizeConnettoreList(); ++j) {
                    Connettore tmpC = soggetto.getConnettore(j);
                    if (!nomeConn.equals(tmpC.getNome())) continue;
                    ++numC;
                }
                if (numC > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un connettore con nome " + nomeConn + " definito come elemento radice del soggetto[" + idSoggetto + "]");
                }
            } else {
                if (tipoConn == null) {
                    conn = null;
                    for (int j2 = 0; j2 < soggetto.sizeConnettoreList(); ++j2) {
                        Connettore connettore = soggetto.getConnettore(j2);
                        if (!nomeConn.equals(connettore.getNome())) continue;
                        conn = connettore;
                        break;
                    }
                }
                if (conn == null) {
                    this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") non corrisponde a nessuno dei connettori registrati");
                } else {
                    tipoConn = conn.getTipo();
                }
            }
            if (!this.tipoConnettori.contains(tipoConn)) {
                if (identificativoElementoInternoSoggetto == null) {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                } else {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                }
            } else {
                ConnettoreProperty[] cpArray = conn.getPropertyList();
                if (cpArray != null) {
                    for (j = 0; j < cpArray.length; ++j) {
                        ConnettoreProperty cp = cpArray[j];
                        if (cp.getNome() == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            }
                            return;
                        }
                        if (cp.getValore() != null) continue;
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        }
                        return;
                    }
                }
                if (tipoConn.equals(TipiConnettore.HTTP.getNome())) {
                    String urlConn = null;
                    for (int j3 = 0; j3 < cpArray.length; ++j3) {
                        ConnettoreProperty cp = cpArray[j3];
                        if (!cp.getNome().equals("location")) continue;
                        urlConn = cp.getValore();
                        break;
                    }
                    if (urlConn == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            Utilities.validateUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                                break block117;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.JMS.getNome())) {
                    String jmsNome = null;
                    String jmsTipo = null;
                    String jmsConnFact = null;
                    String jmsSendAs = null;
                    for (int j4 = 0; j4 < cpArray.length; ++j4) {
                        ConnettoreProperty cp = cpArray[j4];
                        if (cp.getNome().equals("location")) {
                            jmsNome = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("tipo")) {
                            jmsTipo = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("connection-factory")) {
                            jmsConnFact = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("send-as")) continue;
                        jmsSendAs = cp.getValore();
                    }
                    if (jmsNome == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        }
                    }
                    if (jmsTipo == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        }
                    } else if (!jmsTipo.equals("queue") && !jmsTipo.equals("topic")) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        }
                    }
                    if (jmsConnFact == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha una connection factory definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha una connection factory definita");
                        }
                    }
                    if (jmsSendAs == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        }
                    } else if (!jmsSendAs.equals("TextMessage") && !jmsSendAs.equals("BytesMessage")) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.HTTPS.getNome())) {
                    String urlConn = null;
                    String trustStoreLocation = null;
                    String trustStorePassword = null;
                    String keyStoreLocation = null;
                    String keyStorePassword = null;
                    String keyPassword = null;
                    String hostNameVerifier = null;
                    for (int j5 = 0; j5 < cpArray.length; ++j5) {
                        ConnettoreProperty cp = cpArray[j5];
                        if (cp.getNome().equals("location")) {
                            urlConn = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStoreLocation")) {
                            trustStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStorePassword")) {
                            trustStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStoreLocation")) {
                            keyStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStorePassword")) {
                            keyStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyPassword")) {
                            keyPassword = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("hostnameVerifier")) continue;
                        hostNameVerifier = cp.getValore();
                    }
                    if (urlConn == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            Utilities.validateUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                    if (trustStoreLocation != null) {
                        File f = new File(trustStoreLocation);
                        if (!f.exists()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (trustStorePassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            }
                        }
                    }
                    if (keyStoreLocation != null) {
                        File f = new File(keyStoreLocation);
                        if (!f.exists()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (keyStorePassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            }
                        } else if (keyPassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            }
                        }
                    }
                    if (hostNameVerifier != null) {
                        try {
                            Boolean.parseBoolean(hostNameVerifier);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                                break block117;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.DISABILITATO.getNome()) && cpArray != null) {
                    if (identificativoElementoInternoSoggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    }
                }
            }
        }
    }

    private void validaCorrelazioneApplicativa(String identificativoRisorsa, CorrelazioneApplicativa ca, boolean portaDelegata) throws DriverConfigurazioneException {
        if (ca != null) {
            CorrelazioneApplicativaElemento cae;
            int j;
            if (ca.getScadenza() != null) {
                try {
                    Long.parseLong(ca.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza della correlazione applicativa inserita nella " + identificativoRisorsa + " dev'essere un numero intero");
                }
            }
            if (ca.sizeElementoList() < 1) {
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa senza elementi?");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                cae = ca.getElemento(j);
                if (cae.getNome() != null || j == ca.sizeElementoList() - 1) continue;
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa (" + (j + 1) + ") con un elemento '*' (match qualsiasi contenuto) definito non come ultima regola di correlazione");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                String riusoIDEgov;
                String identificazioneFallita;
                String identificazione;
                cae = ca.getElemento(j);
                int numE = 0;
                for (int k = 0; k < ca.sizeElementoList(); ++k) {
                    CorrelazioneApplicativaElemento tmpCae = ca.getElemento(k);
                    if (cae.getNome() == null) {
                        if (tmpCae.getNome() != null) continue;
                        ++numE;
                        continue;
                    }
                    if (!cae.getNome().equals(tmpCae.getNome())) continue;
                    ++numE;
                }
                if (numE > 1) {
                    String nome = "*";
                    if (cae.getNome() != null) {
                        nome = cae.getNome();
                    }
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento di correlazione applicativa con nome " + nome + " (" + identificativoRisorsa + ")");
                }
                if (!((identificazione = cae.getIdentificazione()) == null || identificazione.equals("disabilitato") || identificazione.equals("urlBased") || identificazione.equals("contentBased") || identificazione.equals("inputBased"))) {
                    this.errori.add("La modalita d'identificazione della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + "disabilitato" + "," + "urlBased" + "," + "contentBased" + " o " + "inputBased");
                }
                if (identificazione == null) {
                    identificazione = "contentBased";
                }
                if (("urlBased".equals(identificazione) || "contentBased".equals(identificazione)) && cae.getPattern() == null) {
                    this.errori.add("La correlazione applicativa (" + (j + 1) + ") della " + identificativoRisorsa + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + identificazione);
                }
                if ((identificazioneFallita = cae.getIdentificazioneFallita()) != null && !identificazioneFallita.equals("blocca") && !identificazioneFallita.equals("accetta")) {
                    this.errori.add("Il comportamento in caso di identificazione fallita della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + "blocca" + " o " + "accetta");
                }
                if ((riusoIDEgov = cae.getRiusoIdEgov()) != null && !riusoIDEgov.equals("abilitato") && !riusoIDEgov.equals("disabilitato")) {
                    this.errori.add("Il comportamento per il riuso dell'id egov della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + "abilitato" + " o " + "disabilitato");
                }
                if (portaDelegata) continue;
                if (identificazione.equals("urlBased") || identificazione.equals("inputBased")) {
                    this.errori.add("La modalita d'identificazione della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + "disabilitato" + " o " + "contentBased");
                }
                if (riusoIDEgov == null) continue;
                this.errori.add("La proprieta' 'riuso-id-egov', utilizzata dalla correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + ",  non e' utilizzabile in un contesto di PortaApplicativa");
            }
        }
    }

    private void validaConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        String[] v;
        IntegrationManager im;
        String connessione;
        RisposteSpcoop rs;
        String gestione;
        Attachments attachments;
        String utilizzo;
        IndirizzoTelematico it;
        ValidazioneBusteEgov vbe;
        AccessoRegistro ar = null;
        if (configurazione.getAccessoRegistro() == null) {
            this.errori.add("Non \u00e8 stato configurato un accesso ad un registro dei servizi");
        } else {
            ar = configurazione.getAccessoRegistro();
            if (ar.sizeRegistroList() <= 0) {
                this.errori.add("Non \u00e8 stato configurato un accesso ad un registro dei servizi");
                ar = null;
            } else {
                for (int j = 0; j < ar.sizeRegistroList(); ++j) {
                    AccessoRegistroRegistro arr = ar.getRegistro(j);
                    String nomeArr = arr.getNome();
                    if (nomeArr == null) {
                        this.errori.add("E' presente la configurazione di accesso ad un registro dei servizi anonimo; deve obbligatoriamente essere associato un nome ad un registro dei servizi");
                    } else {
                        int numAR = 0;
                        for (int k = 0; k < ar.sizeRegistroList(); ++k) {
                            AccessoRegistroRegistro tmpArr = ar.getRegistro(k);
                            if (!nomeArr.equals(tmpArr.getNome())) continue;
                            ++numAR;
                        }
                        if (numAR > 1) {
                            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un registro dei servizi con nome " + nomeArr);
                        }
                    }
                    String tipo = arr.getTipo();
                    if (!(tipo == null || tipo.equals("xml") || tipo.equals("uddi") || tipo.equals("web") || tipo.equals("db") || tipo.equals("ws"))) {
                        this.errori.add("Il tipo del registro " + nomeArr + " non \u00e8 valido; deve assumere uno dei seguenti tipi: " + "xml" + "," + "uddi" + "," + "web" + "," + "db" + "," + "ws");
                    }
                    if (arr.getLocation() == null) {
                        this.errori.add("Per la configurazione di accesso al registro dei servizi [" + nomeArr + "] non \u00e8 stata fornita la location");
                    }
                    if (arr.getPassword() == null || arr.getUser() != null) continue;
                    this.errori.add("Per la configurazione di accesso al registro dei servizi [" + nomeArr + "] non \u00e8 stata fornito un username, ma \u00e8 stato specificata una password?");
                }
                AccessoRegistroCache arc = ar.getCache();
                if (arc != null) {
                    String algoritmo;
                    if (arc.getDimensione() != null) {
                        try {
                            Integer.parseInt(arc.getDimensione());
                        }
                        catch (Exception e) {
                            this.errori.add("Il valore associato alla dimensione della cache, anteposta ai registri dei servizi, dev'essere un numero intero");
                        }
                    }
                    if ((algoritmo = arc.getAlgoritmo()) != null && !algoritmo.equals("lru") && !algoritmo.equals("mru")) {
                        this.errori.add("L'algoritmo dell'accesso alla cache, anteposta ai registri dei servizi, dev'essere lru o mru");
                    }
                    if (arc.getItemIdleTime() != null) {
                        try {
                            Long.parseLong(arc.getItemIdleTime());
                        }
                        catch (Exception e) {
                            this.errori.add("Il valore associato all'item-idle-time, anteposta ai registri dei servizi, dev'essere un numero intero");
                        }
                    }
                    if (arc.getItemLifeSecond() != null) {
                        try {
                            Long.parseLong(arc.getItemLifeSecond());
                        }
                        catch (Exception e) {
                            this.errori.add("Il valore associato all'item-life-seconds, anteposta ai registri dei servizi, dev'essere un numero intero");
                        }
                    }
                }
            }
        }
        RoutingTable rt = configurazione.getRoutingTable();
        if (rt != null) {
            if (rt.sizeDefaultList() == 0) {
                this.errori.add("(RoutingTable abilitata) Non \u00e8 stata definita una rotta di default");
            } else {
                for (int i = 0; i < rt.sizeDefaultList(); ++i) {
                    Route r = rt.getDefault(i);
                    this.validaRotta(r, "[RottaDefault]", ar);
                    if (r.getRegistro() != null) {
                        int numRR = 0;
                        for (int h = 0; h < rt.sizeDefaultList(); ++h) {
                            Route tmpR = rt.getDefault(h);
                            if (tmpR.getRegistro() == null) continue;
                            RouteRegistro tmpRR = tmpR.getRegistro();
                            if (r.getRegistro().getNome() == null) {
                                if (tmpRR.getNome() != null) continue;
                                ++numRR;
                                continue;
                            }
                            if (!r.getRegistro().getNome().equals(tmpRR.getNome())) continue;
                            ++numRR;
                        }
                        if (numRR > 1) {
                            String nome = "TuttiRegistri";
                            if (r.getRegistro().getNome() != null) {
                                nome = r.getRegistro().getNome();
                            }
                            this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta di default, che utilizzi il registro " + nome);
                        }
                    }
                    if (r.getGateway() == null || r.getGateway().getTipo() == null || r.getGateway().getNome() == null) continue;
                    RouteGateway rg = r.getGateway();
                    String idRG = rg.getTipo() + "/" + rg.getNome();
                    int numRG = 0;
                    for (int h = 0; h < rt.sizeDefaultList(); ++h) {
                        RouteGateway tmpRG;
                        String tmpIdRG;
                        Route tmpR = rt.getDefault(h);
                        if (tmpR.getGateway() == null || tmpR.getGateway().getTipo() == null || tmpR.getGateway().getNome() == null || !idRG.equals(tmpIdRG = (tmpRG = tmpR.getGateway()).getTipo() + "/" + tmpRG.getNome())) continue;
                        ++numRG;
                    }
                    if (numRG <= true) continue;
                    this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta di default di tipo gateway con identificativo soggetto " + idRG);
                }
            }
            for (int j = 0; j < rt.sizeDestinazioneList(); ++j) {
                int k;
                RoutingTableDestinazione rtd = rt.getDestinazione(j);
                if (rtd.getTipo() == null) {
                    this.errori.add("(RoutingTable abilitata) E' stata definita una rotta di destinazone statica, senza aver specificato il tipo");
                    continue;
                }
                if (rtd.getNome() == null) {
                    this.errori.add("(RoutingTable abilitata) E' stata definita una rotta di destinazone statica, senza aver specificato il nome");
                    continue;
                }
                String idDest = rtd.getTipo() + "/" + rtd.getNome();
                int numD = 0;
                for (k = 0; k < rt.sizeDestinazioneList(); ++k) {
                    RoutingTableDestinazione tmpRtd = rt.getDestinazione(k);
                    String tmpIdDest = tmpRtd.getTipo() + "/" + tmpRtd.getNome();
                    if (!idDest.equals(tmpIdDest)) continue;
                    ++numD;
                }
                if (numD > 1) {
                    this.errori.add("(RoutingTable abilitata)  Non pu\u00f2 esistere pi\u00f9 di una rotta di destinazione statico con identificativo soggetto" + idDest);
                }
                for (k = 0; k < rtd.sizeRouteList(); ++k) {
                    Route r = rtd.getRoute(k);
                    this.validaRotta(r, "[RottaDestinazioneStatica(" + idDest + ")]", ar);
                    if (r.getRegistro() != null) {
                        int numRR = 0;
                        for (int h = 0; h < rtd.sizeRouteList(); ++h) {
                            Route tmpR = rtd.getRoute(h);
                            if (tmpR.getRegistro() == null) continue;
                            RouteRegistro tmpRR = tmpR.getRegistro();
                            if (r.getRegistro().getNome() == null) {
                                if (tmpRR.getNome() != null) continue;
                                ++numRR;
                                continue;
                            }
                            if (!r.getRegistro().getNome().equals(tmpRR.getNome())) continue;
                            ++numRR;
                        }
                        if (numRR > 1) {
                            String nome = "TuttiRegistri";
                            if (r.getRegistro().getNome() != null) {
                                nome = r.getRegistro().getNome();
                            }
                            this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta per la destinazione statica [" + idDest + "], che utilizzi il registro " + nome);
                        }
                    }
                    if (r.getGateway() == null || r.getGateway().getTipo() == null || r.getGateway().getNome() == null) continue;
                    RouteGateway rg = r.getGateway();
                    String idRG = rg.getTipo() + "/" + rg.getNome();
                    int numRG = 0;
                    for (int h = 0; h < rtd.sizeRouteList(); ++h) {
                        RouteGateway tmpRG;
                        String tmpIdRG;
                        Route tmpR = rtd.getRoute(h);
                        if (tmpR.getGateway() == null || tmpR.getGateway().getTipo() == null || tmpR.getGateway().getNome() == null || !idRG.equals(tmpIdRG = (tmpRG = tmpR.getGateway()).getTipo() + "/" + tmpRG.getNome())) continue;
                        ++numRG;
                    }
                    if (numRG <= true) continue;
                    this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta per la destinazione statica [" + idDest + "] di tipo gateway con identificativo soggetto " + idRG);
                }
            }
        }
        if ((vbe = configurazione.getValidazioneBusteEgov()) != null) {
            String manifest;
            String profColl;
            String controllo;
            String statoBuste = vbe.getStato();
            if (!(statoBuste == null || statoBuste.equals("abilitato") || statoBuste.equals("disabilitato") || statoBuste.equals("warningOnly"))) {
                this.errori.add("Lo stato della validazione buste egov deve possedere uno dei seguenti valori: abilitato, disabilitato o warningOnly");
            }
            if ((controllo = vbe.getControllo()) != null && !controllo.equals("normale") && !controllo.equals("rigido")) {
                this.errori.add("Il controllo della validazione buste egov deve possedere uno dei seguenti valori: normale o rigido");
            }
            if ((profColl = vbe.getProfiloCollaborazione()) != null && !profColl.equals("abilitato") && !profColl.equals("disabilitato")) {
                this.errori.add("Il profilo di collaborazione della validazione buste egov deve possedere i valori abilitato o disabilitato");
            }
            if ((manifest = vbe.getManifestAttachments()) != null && !manifest.equals("abilitato") && !manifest.equals("disabilitato")) {
                this.errori.add("Il manifest-attachments della validazione buste egov deve possedere i valori abilitato o disabilitato");
            }
        }
        if (configurazione.getValidazioneContenutiApplicativi() != null) {
            this.validazioneValidazioneContenutiApplicativi(configurazione.getValidazioneContenutiApplicativi(), "ConfigurazioneGeneralePdD");
        }
        if ((it = configurazione.getIndirizzoTelematico()) != null && (utilizzo = it.getUtilizzo()) != null && !utilizzo.equals("abilitato") && !utilizzo.equals("disabilitato")) {
            this.errori.add("L'utilizzo dell'indirizzo telematico nella configurazione generale della PdD deve assumere i valori: abilitato o disabilitato");
        }
        if ((attachments = configurazione.getAttachments()) != null && (gestione = attachments.getGestioneManifest()) != null && !gestione.equals("abilitato") && !gestione.equals("disabilitato")) {
            this.errori.add("La gestione dei manifest degli attachments nella configurazione generale della PdD deve assumere i valori: abilitato o disabilitato");
        }
        if ((rs = configurazione.getRisposteSpcoop()) != null && (connessione = rs.getConnessione()) != null && !connessione.equals("new") && !connessione.equals("reply")) {
            this.errori.add("La connessione delle risposte spcoop nella configurazione generale della PdD deve assumere i valori:reply o new");
        }
        if (configurazione.getInoltroBusteNonRiscontrate() == null) {
            this.errori.add("Definizione della cadenza delle buste non riscontrate non presente nella configurazione generale della PdD");
        } else {
            InoltroBusteNonRiscontrate inoltro = configurazione.getInoltroBusteNonRiscontrate();
            if (inoltro.getCadenza() == null) {
                this.errori.add("Definizione della cadenza delle buste non riscontrate non presente nella configurazione generale della PdD");
            } else {
                try {
                    Long.parseLong(inoltro.getCadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla cadenza delle buste non riscontrate, presente nella configurazione generale della PdD, dev'essere un numero intero");
                }
            }
        }
        MessaggiDiagnostici md = configurazione.getMessaggiDiagnostici();
        if (md != null) {
            String openspcoop;
            for (int j = 0; j < md.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = md.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender dei msg diagnostici per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoMsgDiagnosticiAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender dei msg diagnostici per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoMsgDiagnosticiAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    OpenspcoopAppenderProperty oap = oa.getProperty(k);
                    if (oap.getNome() == null) continue;
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] dei msg diagnostici per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        OpenspcoopAppenderProperty tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] dei msg diagnostici");
                }
            }
            String spcoop = md.getSpcoop();
            if (!(spcoop == null || spcoop.equals("off") || spcoop.equals("fatalOpenspcoop") || spcoop.equals("errorSpcoop") || spcoop.equals("errorOpenspcoop") || spcoop.equals("infoSpcoop") || spcoop.equals("infoOpenspcoop") || spcoop.equals("debugLow") || spcoop.equals("debugMedium") || spcoop.equals("debugHigh") || spcoop.equals("all"))) {
                this.errori.add("L'opzione 'spcoop' della configurazione dei messaggi diagnostici nella configurazione generale della PdD deve assumere uno dei seguenti valori: off, fatalOpenspcoop, errorSpcoop, errorOpenspcoop, infoSpcoop, infoOpenspcoop, debugLow, debugMedium, debugHigh o all");
            }
            if (!((openspcoop = md.getOpenspcoop()) == null || spcoop.equals("off") || spcoop.equals("fatalOpenspcoop") || spcoop.equals("errorSpcoop") || spcoop.equals("errorOpenspcoop") || spcoop.equals("infoSpcoop") || spcoop.equals("infoOpenspcoop") || spcoop.equals("debugLow") || spcoop.equals("debugMedium") || spcoop.equals("debugHigh") || spcoop.equals("all"))) {
                this.errori.add("L'opzione 'openspcoop' della configurazione dei messaggi diagnostici nella configurazione generale della PdD deve assumere uno dei seguenti valori: off, fatalOpenspcoop, errorSpcoop, errorOpenspcoop, infoSpcoop, infoOpenspcoop, debugLow, debugMedium, debugHigh o all");
            }
        } else {
            this.errori.add("Non e' stata definita la configurazione dei messaggi diagnostici nella configurazione generale della PdD");
        }
        Tracciamento t = configurazione.getTracciamento();
        if (t != null) {
            String dump;
            for (int j = 0; j < t.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = t.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender delle tracce per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoTracciamentoAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender delle tracce per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoTracciamentoAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    OpenspcoopAppenderProperty oap = oa.getProperty(k);
                    if (oap.getNome() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] delle tracce per cui esiste una proprieta' senza un nome?");
                        continue;
                    }
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] delle tracce per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        OpenspcoopAppenderProperty tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] delle tracce");
                }
            }
            String busteEgov = t.getBusteEgov();
            if (busteEgov != null && !busteEgov.equals("abilitato") && !busteEgov.equals("disabilitato")) {
                this.errori.add("Il valore 'buste-egov' della configurazione per il tracciamento delle buste egov deve assumere i valori abilitato o disabilitato");
            }
            if ((dump = t.getDump()) != null && !dump.equals("abilitato") && !dump.equals("disabilitato")) {
                this.errori.add("Il valore 'dump' della configurazione per il tracciamento delle buste egov deve assumere i valori abilitato o disabilitato");
            }
        }
        if (configurazione.getGestioneErrore() != null) {
            if (configurazione.getGestioneErrore().getComponenteCooperazione() != null) {
                this.validaGestioneErrore(configurazione.getGestioneErrore().getComponenteCooperazione(), "ConfigurazioneGenerale-GestioneErroreComponenteCooperazione");
            }
            if (configurazione.getGestioneErrore().getComponenteIntegrazione() != null) {
                this.validaGestioneErrore(configurazione.getGestioneErrore().getComponenteIntegrazione(), "ConfigurazioneGenerale-GestioneErroreComponenteIntegrazione");
            }
        }
        if ((im = configurazione.getIntegrationManager()) != null && im.getAutenticazione() != null && (v = im.getAutenticazione().split(",")) != null && v.length > 0) {
            for (int l = 0; l < v.length; ++l) {
                if (this.tipoAutenticazione.contains(v[l].trim())) continue;
                this.errori.add("Processo di autenticazione[" + v[l].trim() + "] associato al servizio di IntegrationManager non conosciuto, valori ammessi: " + this.getTipoAutenticazione());
            }
        }
    }

    private void validaRotta(Route route, String tipo, AccessoRegistro ar) throws DriverConfigurazioneException {
        if (route.getGateway() == null && route.getRegistro() == null) {
            this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato ne un Gateway ne un Registro");
        } else if (route.getGateway() != null && route.getRegistro() != null) {
            this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " che possiede sia un Gateway che un Registro (Solo un tipo deve essere selezionato)");
        } else if (route.getGateway() != null) {
            if (route.getGateway().getNome() == null) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato il nome del soggetto Gateway");
            }
            if (route.getGateway().getTipo() == null) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato il tipo del soggetto Gateway");
            }
        } else if (route.getRegistro().getNome() != null && ar != null) {
            boolean trovato = false;
            for (int i = 0; i < ar.sizeRegistroList(); ++i) {
                if (!ar.getRegistro(i).getNome().equals(route.getRegistro().getNome())) continue;
                trovato = true;
                break;
            }
            if (!trovato) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " per cui \u00e8 stata specificato un registro [" + route.getRegistro().getNome() + "] non esistente neella configurazione");
            }
        }
    }

    private void validaWSSecurity(WsSecurity ws, String idOggetto) throws DriverConfigurazioneException {
        Cloneable tmpWsrfp;
        int k;
        int numRF;
        Cloneable wsrfp;
        int j;
        for (j = 0; j < ws.sizeRequestFlowList(); ++j) {
            wsrfp = ws.getRequestFlow(j);
            if (((WsSecurityRequestFlowParameter)wsrfp).getNome() == null) {
                this.errori.add("(" + idOggetto + " WSSecurity) Nella request-flow esiste una proprieta' per cui non e' stato definito il nome");
            }
            if (((WsSecurityRequestFlowParameter)wsrfp).getValore() == null) {
                this.errori.add("(" + idOggetto + " WSSecurity) Nella request-flow esiste una proprieta' per cui non e' stato definito il valore");
            }
            numRF = 0;
            for (k = 0; k < ws.sizeRequestFlowList(); ++k) {
                tmpWsrfp = ws.getRequestFlow(k);
                if (!((WsSecurityRequestFlowParameter)wsrfp).getNome().equals(((WsSecurityRequestFlowParameter)tmpWsrfp).getNome())) continue;
                ++numRF;
            }
            if (numRF <= true) continue;
            this.errori.add("(" + idOggetto + " WSSecurity) Nella request-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + ((WsSecurityRequestFlowParameter)wsrfp).getNome());
        }
        for (j = 0; j < ws.sizeResponseFlowList(); ++j) {
            wsrfp = ws.getResponseFlow(j);
            if (((WsSecurityResponseFlowParameter)wsrfp).getNome() == null) {
                this.errori.add("(" + idOggetto + " WSSecurity) Nella response-flow esiste una proprieta' per cui non e' stato definito il nome");
            }
            if (((WsSecurityResponseFlowParameter)wsrfp).getValore() == null) {
                this.errori.add("(" + idOggetto + " WSSecurity) Nella response-flow esiste una proprieta' per cui non e' stato definito il valore");
            }
            numRF = 0;
            for (k = 0; k < ws.sizeResponseFlowList(); ++k) {
                tmpWsrfp = ws.getResponseFlow(k);
                if (!((WsSecurityResponseFlowParameter)wsrfp).getNome().equals(((WsSecurityResponseFlowParameter)tmpWsrfp).getNome())) continue;
                ++numRF;
            }
            if (numRF <= true) continue;
            this.errori.add("(" + idOggetto + " WSSecurity) Nella response-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + ((WsSecurityResponseFlowParameter)wsrfp).getNome());
        }
    }

    private void validazioneValidazioneContenutiApplicativi(ValidazioneContenutiApplicativi vca, String tipo) throws DriverConfigurazioneException {
        String tipoV;
        String stato = vca.getStato();
        if (!(stato == null || stato.equals("abilitato") || stato.equals("disabilitato") || stato.equals("warningOnly"))) {
            this.errori.add("Lo stato della validazione contenuti applicativi (" + tipo + ") deve possedere uno dei seguenti valori: " + "abilitato" + ", " + "disabilitato" + " o " + "warningOnly");
        }
        if (!((tipoV = vca.getTipo()) == null || tipoV.equals("openspcoop") || tipoV.equals("wsdl") || tipoV.equals("xsd"))) {
            this.errori.add("Il tipo di validazione contenuti applicativi da attuare (" + tipo + ") deve possedere uno dei seguenti valori: " + "xsd" + ", " + "wsdl" + " o " + "openspcoop");
        }
    }

    private void validaSpcoopProperty(SetSpcoopProperty ssp, String oggetto) throws DriverConfigurazioneException {
        String valore;
        if (ssp.getNome() == null) {
            this.errori.add("Esiste una SPCoopProperty della porta applicativa " + oggetto + " che non contiene la definizione del nome");
        }
        if (ssp.getValore() == null) {
            this.errori.add("Esiste una SPCoopProperty della porta applicativa " + oggetto + " che non contiene la definizione del valore");
        }
        if (!((valore = ssp.getValore()) == null || valore.equals("mittente") || valore.equals("tipoMittente") || valore.equals("destinatario") || valore.equals("tipoDestinatario") || valore.equals("servizio") || valore.equals("tipoServizio") || valore.equals("azione") || valore.equals("idegov"))) {
            this.errori.add("Il valore della SpcoopProperty " + ssp.getNome() + " della porta applicativa " + oggetto + " dev'essere mittente, tipoMittente, destinatario, tipoDestinatario, servizio, tipoServizio, azione o idegov");
        }
    }

    private void validaCredenziale(Credenziali c, String oggetto, boolean invocazionePorta) throws DriverConfigurazioneException {
        if (invocazionePorta) {
            String tipo = "ssl";
            if (c.getTipo() != null) {
                tipo = c.getTipo();
            }
            if (!tipo.equals("basic") && !tipo.equals("ssl")) {
                this.errori.add("Il tipo delle credenziali del " + oggetto + " deve possedere i valori: " + "basic" + " o " + "ssl");
            }
            if (c.getTipo().equals("basic") && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
                this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
            }
            if (c.getTipo().equals("ssl")) {
                if (c.getSubject() == null || c.getSubject().equals("")) {
                    this.errori.add("Le credenziali di tipo ssl del " + oggetto + " devono avere subject valorizzato");
                } else {
                    try {
                        Utilities.validaSubject(c.getSubject());
                    }
                    catch (Exception e) {
                        this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un subject non valido: " + e.getMessage());
                    }
                }
            }
        } else if (!"basic".equals(c.getTipo())) {
            this.errori.add("Le uniche credenziali utilizzabili per " + oggetto + " devono avere tipo basic");
        } else if (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals("")) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
    }

    private void validaGestioneErrore(GestioneErrore ge, String tipo) throws DriverConfigurazioneException {
        int j;
        for (j = 0; j < ge.sizeCodiceTrasportoList(); ++j) {
            String comportamento;
            GestioneErroreCodiceTrasporto gect = ge.getCodiceTrasporto(j);
            if (gect.getValoreMinimo() == null || gect.getValoreMassimo() == null) {
                this.errori.add("Gli elementi codice-trasporto devono possedere almeno un valore minimo o un valore massimo");
            }
            if (gect.getValoreMinimo() != null && gect.getValoreMinimo().longValue() < 0L) {
                this.errori.add("Il valore minimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero >= 0 (Attualemente:" + gect.getValoreMinimo().longValue() + ")");
            }
            if (gect.getValoreMassimo() != null && gect.getValoreMassimo().longValue() <= 0L) {
                this.errori.add("Il valore massimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero > 0 (Attualemente:" + gect.getValoreMassimo().longValue() + ")");
            }
            if (gect.getValoreMassimo() != null && gect.getValoreMinimo().longValue() >= 0L && gect.getValoreMinimo() != null && gect.getValoreMassimo().longValue() > 0L && gect.getValoreMassimo().longValue() < gect.getValoreMinimo().longValue()) {
                this.errori.add("Il valore massimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero maggiore del valore associate al valore minimo (Attualemente max:" + gect.getValoreMassimo().longValue() + " min:" + gect.getValoreMinimo().longValue() + ")");
            }
            if ((comportamento = gect.getComportamento()) == null) {
                this.errori.add("Non e' stato definito il comportamento di adottato per la gestione errore (" + tipo + ") per un codice-trasporto");
            } else if (!comportamento.equals("accetta") && !comportamento.equals("rispedisci")) {
                this.errori.add("Il comportamento associato alla gestione errore (" + tipo + "-CodiceTrasporto) deve assumere uno dei seguenti valori: " + "accetta" + " o " + "rispedisci");
            }
            if (gect.getCadenzaRispedizione() == null) continue;
            try {
                Long.parseLong(gect.getCadenzaRispedizione());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione associato alla gestione errore (" + tipo + ") per un codice-trasporto, dev'essere un numero intero");
            }
        }
        for (j = 0; j < ge.sizeSoapFaultList(); ++j) {
            String comportamento;
            GestioneErroreSoapFault gesf = ge.getSoapFault(j);
            String identificativo = "";
            identificativo = gesf.getFaultActor() == null ? "NULL-" : gesf.getFaultActor() + "-";
            identificativo = gesf.getFaultCode() == null ? identificativo + "NULL-" : identificativo + "" + gesf.getFaultCode() + "-";
            identificativo = gesf.getFaultString() == null ? identificativo + "NULL" : identificativo + "" + gesf.getFaultString();
            int numSF = 0;
            for (int k = 0; k < ge.sizeSoapFaultList(); ++k) {
                GestioneErroreSoapFault tmpGesf = ge.getSoapFault(k);
                String tmpId = "";
                tmpId = tmpGesf.getFaultActor() == null ? "NULL-" : tmpGesf.getFaultActor() + "-";
                tmpId = tmpGesf.getFaultCode() == null ? tmpId + "NULL-" : tmpId + "" + tmpGesf.getFaultCode() + "-";
                tmpId = tmpGesf.getFaultString() == null ? tmpId + "NULL" : tmpId + "" + tmpGesf.getFaultString();
                if (!identificativo.equals(tmpId)) continue;
                ++numSF;
            }
            if (numSF > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento soap-fault con identificativo " + identificativo + " associato alla gestione errore (" + tipo + ")");
            }
            if ((comportamento = gesf.getComportamento()) == null) {
                this.errori.add("Non e' stato definito il comportamento di adottato per la gestione errore (" + tipo + ") per un soap-fault");
            } else if (!comportamento.equals("accetta") && !comportamento.equals("rispedisci")) {
                this.errori.add("Il comportamento associato alla gestione errore (" + tipo + "-SoapFault) deve assumere uno dei seguenti valori: " + "accetta" + " o " + "rispedisci");
            }
            if (gesf.getCadenzaRispedizione() == null) continue;
            try {
                Long.parseLong(gesf.getCadenzaRispedizione());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione associato alla gestione errore (" + tipo + ") per un soap-fault, dev'essere un numero intero");
            }
        }
        String comportamento = ge.getComportamento();
        if (comportamento == null) {
            this.errori.add("Non e' stato definito il comportamento di default adottato per la gestione errore (" + tipo + ")");
        } else if (!comportamento.equals("accetta") && !comportamento.equals("rispedisci")) {
            this.errori.add("Il comportamento di default associato alla gestione errore (" + tipo + ") deve assumere uno dei seguenti valori: " + "accetta" + " o " + "rispedisci");
        }
        if (ge.getCadenzaRispedizione() != null) {
            try {
                Long.parseLong(ge.getCadenzaRispedizione());
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione di default associato alla gestione errore (" + tipo + "), dev'essere un numero intero");
            }
        }
    }

    private boolean existsServizioApplicativo(String nome, SoggettoSpcoop soggetto) {
        return this.getServizioApplicativo(nome, soggetto) != null;
    }

    private ServizioApplicativo getServizioApplicativo(String nome, SoggettoSpcoop soggetto) {
        for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggetto.getServizioApplicativo(j);
            if (!nome.equals(sa.getNome())) continue;
            return sa;
        }
        return null;
    }
}

