/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.config.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.dao.config.driver.XMLDataConverter;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.Utilities;

public class TestXMLDataConverter {
    private static Boolean resetEffettuata = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        boolean condivisioneDBRegservPddValue;
        String tipoDatabase;
        String driver;
        String password;
        String username;
        String connection;
        boolean connectionDB;
        String superUser;
        AccessoConfigurazionePdD acCRUD;
        Logger log;
        block28: {
            if (args.length < 7) {
                String errorMsg = "ERROR, Usage:  java TestXMLDataConverter sorgenteXML tipoConfigurazioneCRUD proprietaConfigurazioneCRUD reset isGestioneConfigurazione tipoConversione gestioneSoggetti [Logger]";
                System.err.println(errorMsg);
                throw new Exception(errorMsg);
            }
            try {
                if (args.length == 8) {
                    PropertyConfigurator.configure((String)args[7]);
                } else {
                    PropertyConfigurator.configure((URL)TestXMLDataConverter.class.getResource("/tracer.log4j.properties"));
                }
            }
            catch (Exception e) {
                String errorMsg = "Errore durante il caricamento del file di log args7[" + args[7] + "] : " + e.getMessage();
                System.err.println(errorMsg);
                throw new Exception(errorMsg);
            }
            log = Logger.getLogger((String)"gestoreDatiConfigurazione");
            Properties reader = new Properties();
            try {
                reader.load(new FileInputStream(args[2]));
            }
            catch (IOException e) {
                String errorMsg = "Errore durante il caricamento del file di properties [" + args[2] + "] : " + e.getMessage();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
            acCRUD = new AccessoConfigurazionePdD();
            superUser = null;
            connectionDB = false;
            connection = null;
            username = null;
            password = null;
            driver = null;
            tipoDatabase = null;
            condivisioneDBRegservPddValue = false;
            try {
                acCRUD.setTipo(args[1]);
                superUser = reader.getProperty("openspcoop.superuser");
                if (superUser != null) {
                    superUser.trim();
                }
                if (!"db".equals(args[1])) break block28;
                tipoDatabase = reader.getProperty("openspcoop.configurazione.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String condivisioneDBRegservPdd = reader.getProperty("openspcoop.configurazione.db.condivisioneDBRegserv");
                try {
                    condivisioneDBRegservPddValue = Boolean.parseBoolean(condivisioneDBRegservPdd.trim());
                }
                catch (Exception e) {
                    throw new Exception("Non e' stato definita o e' definita non correttamente la proprieta' [openspcoop.configurazione.db.condivisioneDBRegserv]: " + e.getMessage());
                }
                String dataSource = reader.getProperty("openspcoop.configurazione.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties("openspcoop.configurazione.db.context.", reader);
                    acCRUD.setLocation(dataSource);
                    acCRUD.setContext(context);
                    acCRUD.setTipoDatabase(tipoDatabase);
                    break block28;
                }
                connectionDB = true;
                connection = reader.getProperty("openspcoop.configurazione.db.url");
                if (connection == null) {
                    throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                driver = reader.getProperty("openspcoop.configurazione.db.driver");
                if (driver == null) {
                    throw new Exception("Connessione diretta: non e' stato definito il Driver");
                }
                driver = driver.trim();
                username = reader.getProperty("openspcoop.configurazione.db.user");
                password = reader.getProperty("openspcoop.configurazione.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
            }
            catch (Exception e) {
                String errorMsg = "Errore durante la lettura del file di properties [" + args[2] + "] : " + e.getMessage();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
        }
        Connection connectionSQL = null;
        try {
            try {
                File fSorgente = new File(args[0]);
                if (connectionDB) {
                    Loader.getInstance().newInstance(driver);
                    connectionSQL = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                }
                TestXMLDataConverter.letturaSorgenti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, acCRUD, args, condivisioneDBRegservPddValue, superUser);
            }
            catch (Exception e) {
                String errorMsg = "Errore durante la conversione XML dei dati: " + e.getMessage();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
            Object var16_24 = null;
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            try {
                if (connectionSQL == null) throw throwable;
                connectionSQL.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (connectionSQL == null) return;
        connectionSQL.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reset(boolean b) {
        if (b) {
            Boolean bl = resetEffettuata;
            synchronized (bl) {
                if (!resetEffettuata.booleanValue()) {
                    resetEffettuata = true;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static void letturaSorgenti(File fSorgente, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, AccessoConfigurazionePdD acCRUD, String[] args, boolean condivisioneDBRegservPddValue, String superUser) throws Exception {
        if (fSorgente.isFile()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Sorgente XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            if (fSorgente.getName().endsWith(".xml")) {
                TestXMLDataConverter.converti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, acCRUD, args, condivisioneDBRegservPddValue, superUser);
            } else {
                log.debug((Object)("File [" + fSorgente.getAbsolutePath() + "] ignorato. Non possiede l'estensione .xml"));
            }
        } else if (fSorgente.isDirectory()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Directory contenente gli XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            File[] f = fSorgente.listFiles();
            if (f == null || f.length <= 0) {
                throw new Exception("Directory [" + fSorgente.getAbsolutePath() + "] non contiene XML");
            }
            for (int i = 0; i < f.length; ++i) {
                TestXMLDataConverter.letturaSorgenti(f[i], connectionDB, connectionSQL, tipoDatabase, log, acCRUD, args, condivisioneDBRegservPddValue, superUser);
            }
        }
    }

    private static void converti(File f, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, AccessoConfigurazionePdD acCRUD, String[] args, boolean condivisioneDBRegservPddValue, String superUser) throws Exception {
        XMLDataConverter dataConverter = null;
        Logger logDriver = null;
        dataConverter = connectionDB ? new XMLDataConverter(f, connectionSQL, tipoDatabase, log, logDriver, Boolean.parseBoolean(args[4]), condivisioneDBRegservPddValue, superUser) : new XMLDataConverter(f, acCRUD, log, logDriver, Boolean.parseBoolean(args[4]), condivisioneDBRegservPddValue, superUser);
        if ("insertUpdate".equals(args[5].trim())) {
            log.info((Object)"Inizio conversione...");
            dataConverter.convertXML(TestXMLDataConverter.reset(Boolean.parseBoolean(args[3])), Boolean.parseBoolean(args[6]));
            log.info((Object)"Conversione terminata.");
        } else if ("delete".equals(args[5].trim())) {
            log.info((Object)"Inizio conversione...");
            dataConverter.delete(Boolean.parseBoolean(args[6]));
            log.info((Object)"Conversione terminata.");
        } else {
            throw new Exception("Valore opzione 'tipoConversioneConfigurazione' non gestito (valori possibili insertUpdate/delete): " + args[5]);
        }
    }
}

