/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.config.driver;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.config.Openspcoop;
import org.openspcoop.dao.config.driver.DriverConfigurazioneDB;
import org.openspcoop.dao.config.driver.DriverConfigurazioneXML;
import org.openspcoop.dao.config.driver.ValidazioneSemantica;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.Utilities;

public class TestValidazioneSemantica {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        Openspcoop configurazione;
        Logger log;
        block27: {
            block29: {
                Connection connectionDB;
                Properties reader;
                block28: {
                    if (args.length < 3) {
                        String errorMsg = "ERROR, Usage:  java TestValidazioneSemantica tipoConfigurazione proprietaConfigurazione validazioneConfigurazione";
                        System.err.println(errorMsg);
                        throw new Exception(errorMsg);
                    }
                    try {
                        if (args.length == 4) {
                            PropertyConfigurator.configure((String)args[3]);
                        } else {
                            PropertyConfigurator.configure((URL)TestValidazioneSemantica.class.getResource("/tracer.log4j.properties"));
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Errore durante il caricamento del file di log args3[" + args[2] + "] : " + e.getMessage();
                        System.err.println(errorMsg);
                        throw new Exception(errorMsg);
                    }
                    log = Logger.getLogger((String)"validatoreDatiConfigurazione");
                    reader = new Properties();
                    try {
                        reader.load(new FileInputStream(args[1]));
                    }
                    catch (IOException e) {
                        String errorMsg = "Errore durante il caricamento del file di properties [" + args[1] + "] : " + e.getMessage();
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new Exception(errorMsg, e);
                    }
                    configurazione = null;
                    connectionDB = null;
                    if (!"xml".equals(args[0])) break block28;
                    String path = reader.getProperty("openspcoop.configurazione.xml");
                    if (path == null) {
                        throw new Exception("Non e' stato definito il path dove localizzare la configurazione xml");
                    }
                    path = path.trim();
                    DriverConfigurazioneXML driver = new DriverConfigurazioneXML(path, log);
                    if (!driver.create) {
                        throw new Exception("ConfigurazionePdD XML non inizializzata");
                    }
                    log.info((Object)"Inizializzata Configurazione PdD XML");
                    configurazione = driver.getImmagineCompletaConfigurazionePdD();
                    break block27;
                }
                if (!"db".equals(args[0])) break block29;
                String tipoDatabase = reader.getProperty("openspcoop.configurazione.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String dataSource = reader.getProperty("openspcoop.configurazione.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties("openspcoop.configurazione.db.context.", reader);
                    DriverConfigurazioneDB driver = new DriverConfigurazioneDB(dataSource, context, log, tipoDatabase);
                    if (!driver.create) {
                        throw new Exception("Configurazione DB non inizializzata");
                    }
                    log.info((Object)"Inizializzata Configurazione DB");
                    configurazione = driver.getImmagineCompletaConfigurazionePdD();
                } else {
                    String connection = reader.getProperty("openspcoop.configurazione.db.url");
                    if (connection == null) {
                        throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                    }
                    connection = connection.trim();
                    String driverJDBC = reader.getProperty("openspcoop.configurazione.db.driver");
                    if (driverJDBC == null) {
                        throw new Exception("Connessione diretta: non e' stato definito il Driver");
                    }
                    driverJDBC = driverJDBC.trim();
                    String username = reader.getProperty("openspcoop.configurazione.db.user");
                    String password = reader.getProperty("openspcoop.configurazione.db.password");
                    if (username != null) {
                        username = username.trim();
                    }
                    if (password != null) {
                        password = password.trim();
                    }
                    Loader.getInstance().newInstance(driverJDBC);
                    connectionDB = username != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                    DriverConfigurazioneDB driver = new DriverConfigurazioneDB(connectionDB, log, tipoDatabase);
                    if (!driver.create) {
                        throw new Exception("Configurazione DB non inizializzata");
                    }
                    log.info((Object)"Inizializzata Configurazione DB");
                    configurazione = driver.getImmagineCompletaConfigurazionePdD();
                    Object var13_18 = null;
                    try {
                        if (connectionDB != null) {
                            connectionDB.close();
                        }
                        break block27;
                    }
                    catch (Exception e) {}
                }
                break block27;
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    try {
                        if (connectionDB != null) {
                            connectionDB.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            throw new Exception("Tipo di configurazione [" + args[0] + "] non gestita");
        }
        try {
            String[] tipoConnettori = new String[]{"http", "jms", "saaj", "null", "nullEcho", "disabilitato"};
            String[] tipoSoggetti = new String[]{"SPC", "TEST", "AOO"};
            String[] tipoServizi = new String[]{"SPC", "TEST", "URL", "WSDL", "LDAP", "UDDI", "ebXMLRegistry"};
            String[] tipoMsgDiagnostici = new String[]{"dbDiagnosticoAppender"};
            String[] tipoTracce = new String[]{"dbTracciamentoAppender"};
            String[] tipoAutenticazione = new String[]{"none", "basic", "ssl"};
            String[] tipoAutorizzazione = new String[]{"none", "openspcoop"};
            String[] tipoAutorizzazioneContenuto = new String[]{"none"};
            String[] tipoAutorizzazioneContenutoSPCoop = new String[]{"none"};
            String[] tipoIntegrazione = new String[]{"trasporto", "urlBased", "soap"};
            ValidazioneSemantica validatore = new ValidazioneSemantica(configurazione, tipoConnettori, tipoSoggetti, tipoServizi, tipoMsgDiagnostici, tipoTracce, tipoAutenticazione, tipoAutorizzazione, tipoAutorizzazioneContenuto, tipoAutorizzazioneContenutoSPCoop, tipoIntegrazione, tipoIntegrazione, Boolean.parseBoolean(args[2]), log);
            validatore.validazioneSemantica(true);
        }
        catch (Exception e) {
            log.error((Object)("Errore: " + e.getMessage()));
            throw e;
        }
    }
}

