/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.config.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.Configurazione;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.Openspcoop;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.RoutingTable;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.driver.BeanUtilities;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaApplicativa;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.config.driver.IDServizioApplicativo;
import org.openspcoop.dao.config.driver.IDriverConfigurazioneGet;
import org.openspcoop.dao.config.driver.ValidazioneSemantica;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.xml.ValidatoreXSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverConfigurazioneXML
extends BeanUtilities
implements IDriverConfigurazioneGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private IUnmarshallingContext uctx;
    private String configuration_path;
    private Openspcoop openspcoop;
    private ValidatoreXSD validatoreConfigurazione = null;
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;
    private boolean validazioneSemanticaDuranteModificaXML = false;
    private String[] tipiConnettori = null;
    private String[] tipiSoggetti = null;
    private String[] tipiServizi = null;
    private String[] tipoMsgDiagnosticiAppender = null;
    private String[] tipoTracciamentoAppender = null;
    private String[] tipoAutenticazione = null;
    private String[] tipoAutorizzazione = null;
    private String[] tipoAutorizzazioneContenuto = null;
    private String[] tipoAutorizzazioneContenutoSPCoop = null;
    private String[] tipoIntegrazionePD = null;
    private String[] tipoIntegrazionePA = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsingXMLConfigurazione() throws DriverConfigurazioneException {
        block33: {
            FileInputStream fXML = null;
            try {
                try {
                    if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
                        this.validatoreConfigurazione.valida(this.configuration_path);
                    } else {
                        fXML = new FileInputStream(this.configuration_path);
                        this.validatoreConfigurazione.valida(fXML);
                    }
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD della configurazione XML di OpenSPCoop: " + e.getMessage());
                }
                Object var4_2 = null;
                if (fXML == null) break block33;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (fXML == null) throw throwable;
                try {
                    fXML.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            fXML.close();
        }
        InputStreamReader iStream = null;
        HttpURLConnection httpConn = null;
        if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
            try {
                URL url = new URL(this.configuration_path);
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                httpConn.setRequestMethod("GET");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                iStream = new InputStreamReader(httpConn.getInputStream());
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn == null) throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (HTTP) : \n\n" + e.getMessage());
                    httpConn.disconnect();
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (HTTP) : \n\n" + e.getMessage());
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (HTTP) : \n\n" + e.getMessage());
            }
            this.lastModified = DateManager.getTimeMillis();
        } else {
            try {
                iStream = new InputStreamReader(new FileInputStream(this.configuration_path));
            }
            catch (FileNotFoundException e) {
                try {
                    if (iStream == null) throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (FILE) : \n\n" + e.getMessage());
                    iStream.close();
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (FILE) : \n\n" + e.getMessage());
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.lastModified = new File(this.configuration_path).lastModified();
            }
            catch (Exception e) {
                try {
                    if (iStream == null) throw new DriverConfigurazioneException("Riscontrato errore durante la lettura del file dove e' allocato la configurazione: " + e.getMessage());
                    iStream.close();
                    throw new DriverConfigurazioneException("Riscontrato errore durante la lettura del file dove e' allocato la configurazione: " + e.getMessage());
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la lettura del file dove e' allocato la configurazione: " + e.getMessage());
            }
        }
        try {
            this.openspcoop = (Openspcoop)this.uctx.unmarshalDocument((Reader)iStream, null);
        }
        catch (JiBXException e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn == null) throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione  : \n\n" + e.getMessage());
                httpConn.disconnect();
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione  : \n\n" + e.getMessage());
            }
            catch (Exception ef) {
                // empty catch block
            }
            throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione  : \n\n" + e.getMessage());
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
            if (httpConn == null) return;
            httpConn.disconnect();
            return;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream  : \n\n" + e.getMessage());
        }
    }

    public DriverConfigurazioneXML(String path, Logger alog) {
        this.log = alog == null ? Logger.getLogger((String)"Configurazione XML") : alog;
        if (path == null) {
            this.log.error((Object)"DriverConfigurazione: Riscontrato errore durante la creazione: url/path is null");
            this.create = false;
            return;
        }
        this.configuration_path = path;
        try {
            this.validatoreConfigurazione = new ValidatoreXSD(DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            this.log.info((Object)("Riscontrato errore durante l'inizializzazione dello schema della configurazione di OpenSPCoop: " + e.getMessage()));
            return;
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Openspcoop.class);
            this.uctx = bfact.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            this.log.error((Object)("DriverConfigurazione: Riscontrato errore durante la creazione del contesto di unmarshall  : \n\n" + e.getMessage()));
            this.create = false;
            return;
        }
        try {
            this.parsingXMLConfigurazione();
        }
        catch (Exception e) {
            this.log.error((Object)("DriverConfigurazione: " + e.getMessage()));
            this.create = false;
            return;
        }
        this.create = true;
    }

    private void forzaRefreshConfigurazioneXML() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML(true);
    }

    public void refreshConfigurazioneXML() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML(false);
    }

    private synchronized void refreshConfigurazioneXML(boolean refreshForzato) throws DriverConfigurazioneException {
        File fTest = null;
        boolean refresh = refreshForzato;
        if (!refreshForzato) {
            if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
                long now = DateManager.getTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.configuration_path);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXMLConfigurazione();
            }
            catch (Exception e) {
                this.log.error((Object)("DriverConfigurazione refreshError: " + e.getMessage()));
                throw new DriverConfigurazioneException("DriverConfigurazione refreshError: " + e.getMessage());
            }
            if (!this.configuration_path.startsWith("http://") && !this.configuration_path.startsWith("file://")) {
                this.log.warn((Object)"Reloaded configuration context.");
            }
            if (this.validazioneSemanticaDuranteModificaXML) {
                ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(this.openspcoop, this.tipiConnettori, this.tipiSoggetti, this.tipiServizi, this.tipoMsgDiagnosticiAppender, this.tipoTracciamentoAppender, this.tipoAutenticazione, this.tipoAutorizzazione, this.tipoAutorizzazioneContenuto, this.tipoAutorizzazioneContenutoSPCoop, this.tipoIntegrazionePD, this.tipoIntegrazionePA, true, this.log);
                try {
                    validazioneSemantica.validazioneSemantica(false);
                }
                catch (Exception e) {
                    this.log.error((Object)("DriverConfigurazione refreshError(ValidazioneSemantica): " + e.getMessage()));
                    throw new DriverConfigurazioneException("DriverConfigurazione refreshError(ValidazioneSemantica): " + e.getMessage());
                }
            }
        }
        if (this.openspcoop == null) {
            this.log.error((Object)"DriverConfigurazione refreshError: istanza della configurazione is null dopo il refresh");
            throw new DriverConfigurazioneException("DriverConfigurazione refreshError: istanza della configurazione is null dopo il refresh");
        }
    }

    public void abilitazioneValidazioneSemanticaDuranteModificaXML(String[] tipiConnettori, String[] tipiSoggetti, String[] tipiServizi, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazione, String[] tipoAutorizzazione, String[] tipoAutorizzazioneContenuto, String[] tipoAutorizzazioneContenutoSPCoop, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA) {
        this.validazioneSemanticaDuranteModificaXML = true;
        this.tipiConnettori = tipiConnettori;
        this.tipiSoggetti = tipiSoggetti;
        this.tipiServizi = tipiServizi;
        this.tipoMsgDiagnosticiAppender = tipoMsgDiagnosticiAppender;
        this.tipoTracciamentoAppender = tipoTracciamentoAppender;
        this.tipoAutenticazione = tipoAutenticazione;
        this.tipoAutorizzazione = tipoAutorizzazione;
        this.tipoAutorizzazioneContenuto = tipoAutorizzazioneContenuto;
        this.tipoAutorizzazioneContenutoSPCoop = tipoAutorizzazioneContenutoSPCoop;
        this.tipoIntegrazionePD = tipoIntegrazionePD;
        this.tipoIntegrazionePA = tipoIntegrazionePA;
    }

    @Override
    public SoggettoSpcoop getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametri Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop soggetto = this.openspcoop.getSoggettoSpcoop(i);
            if (!aSoggetto.getNome().equals(soggetto.getNome()) || !aSoggetto.getTipo().equals(soggetto.getTipo())) continue;
            return soggetto;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto " + aSoggetto.toString() + " non Esistente");
    }

    @Override
    public SoggettoSpcoop getSoggetto(String location) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (location == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametro Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop soggetto = this.openspcoop.getSoggettoSpcoop(i);
            for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                PortaDelegata pd = soggetto.getPortaDelegata(j);
                if (!(pd.getLocation() != null ? pd.getLocation().equals(location) : location.equals(pd.getNome()))) continue;
                return soggetto;
            }
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto che possiede la porta delegata [" + location + "] non esistente");
    }

    @Override
    public SoggettoSpcoop getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            if (!this.openspcoop.getSoggettoSpcoop(i).getRouter()) continue;
            return this.openspcoop.getSoggettoSpcoop(i);
        }
        throw new DriverConfigurazioneNotFound("[getRouter] Router non esistente");
    }

    @Override
    public HashSet<String> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        HashSet<String> lista = new HashSet<String>();
        try {
            for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop soggetto = this.openspcoop.getSoggettoSpcoop(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    String soggettoVirtuale;
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    if (pa.getSoggettoVirtuale() == null || pa.getSoggettoVirtuale().getTipo() == null || pa.getSoggettoVirtuale().getNome() == null || lista.contains(soggettoVirtuale = pa.getSoggettoVirtuale().getTipo() + pa.getSoggettoVirtuale().getNome())) continue;
                    this.log.info((Object)("aggiunto Soggetto " + soggettoVirtuale + " alla lista dei Soggetti Virtuali"));
                    lista.add(soggettoVirtuale);
                }
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[getSoggettiVirtuali] Inizializzazione lista dei soggetti virtuali non riuscita: " + e.getMessage());
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Soggetti virtuali non esistenti");
        }
        return lista;
    }

    @Override
    public HashSet<IDServizio> getServizi_SoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        HashSet<IDServizio> lista = new HashSet<IDServizio>();
        HashSet<String> unique = new HashSet<String>();
        try {
            for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop soggetto = this.openspcoop.getSoggettoSpcoop(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    if (pa.getSoggettoVirtuale() == null || pa.getSoggettoVirtuale().getTipo() == null || pa.getSoggettoVirtuale().getNome() == null) continue;
                    IDServizio s = new IDServizio();
                    s.setSoggettoErogatore(new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome()));
                    s.setTipoServizio(pa.getServizio().getTipo());
                    s.setServizio(pa.getServizio().getNome());
                    if (unique.contains(s.toString())) continue;
                    lista.add(s);
                    unique.add(s.toString());
                }
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[getServizi_SoggettiVirtuali] Inizializzazione lista servizi dei soggetti virtuali non riuscita: " + e.getMessage());
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getServizi_SoggettiVirtuali] Servizi erogati da Soggetti virtuali non esistenti");
        }
        return lista;
    }

    @Override
    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Parametro idPD Non Validi");
        }
        IDSoggetto aSoggetto = idPD.getSoggettoFruitore();
        String location = idPD.getLocationPD();
        if (location == null || aSoggetto == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Parametri non Validi");
        }
        SoggettoSpcoop soggetto = null;
        try {
            soggetto = this.getSoggetto(aSoggetto);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Soggetto fruitore [" + aSoggetto.getTipo() + "/" + aSoggetto.getNome() + "] non esistente");
        }
        for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
            PortaDelegata pd = soggetto.getPortaDelegata(j);
            if (!(pd.getLocation() != null ? pd.getLocation().equals(location) : location.equals(pd.getNome()))) continue;
            return pd;
        }
        throw new DriverConfigurazioneNotFound("[getPortaDelegata] PortaDelegata [" + location + "] non esistente");
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, false, null);
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, ricercaPuntuale, null);
    }

    @Override
    public PortaApplicativa getPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, false, soggettoVirtuale);
    }

    @Override
    public PortaApplicativa getPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa_engine(idPA, ricercaPuntuale, soggettoVirtuale);
    }

    private PortaApplicativa getPortaApplicativa_engine(IDPortaApplicativa idPA, boolean ricercaPuntuale, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idPA Non Validi");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idPA non Validi (IDServizio is null)");
        }
        IDSoggetto soggettoErogatore = idPA.getIDServizio().getSoggettoErogatore();
        if (soggettoErogatore == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri Non Validi (Soggetto Erogatore is null)");
        }
        IDServizio service = idPA.getIDServizio();
        if (service == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri Non Validi (Servizio is null)");
        }
        String servizio = service.getServizio();
        String tipoServizio = service.getTipoServizio();
        String azione = service.getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Servizio) Non Validi");
        }
        SoggettoSpcoop soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoErogatore);
        }
        catch (DriverConfigurazioneNotFound dn) {
            throw new DriverConfigurazioneNotFound("[getPortaApplicativa] " + dn.getMessage(), dn);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Soggetto erogatore [" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "] non esistente");
        }
        if (soggettoVirtuale != null && (soggettoVirtuale.getTipo() == null || soggettoVirtuale.getNome() == null)) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Soggetto Virtuale) non validi");
        }
        PortaApplicativa paSenzaAzione = null;
        for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = soggetto.getPortaApplicativa(j);
            boolean paMatchaCriteriDiRicerca = false;
            if (soggettoVirtuale == null) {
                paMatchaCriteriDiRicerca = servizio.equals(pa.getServizio().getNome()) && tipoServizio.equals(pa.getServizio().getTipo());
            } else {
                boolean bl = paMatchaCriteriDiRicerca = servizio.equals(pa.getServizio().getNome()) && tipoServizio.equals(pa.getServizio().getTipo()) && pa.getSoggettoVirtuale() != null && soggettoVirtuale.getTipo().equals(pa.getSoggettoVirtuale().getTipo()) && soggettoVirtuale.getNome().equals(pa.getSoggettoVirtuale().getNome());
            }
            if (!paMatchaCriteriDiRicerca) continue;
            if (azione == null) {
                if (pa.getAzione() != null) continue;
                return pa;
            }
            if (pa.getAzione() == null) {
                paSenzaAzione = pa;
                continue;
            }
            if (!azione.equals(pa.getAzione().getNome())) continue;
            return pa;
        }
        if (paSenzaAzione != null && !ricercaPuntuale) {
            return paSenzaAzione;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PortaApplicativa non esistente");
    }

    @Override
    public PortaApplicativa getPortaApplicativa(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nomePorta == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]  Nome Porta is null");
        }
        if (soggettoProprietario == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]  SoggettoProprietario is null");
        }
        if (soggettoProprietario.getTipo() == null || soggettoProprietario.getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]  dati del SoggettoProprietario null");
        }
        SoggettoSpcoop soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoProprietario);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Soggetto proprietario [" + soggettoProprietario.toString() + "] non esistente");
        }
        for (int i = 0; i < soggetto.sizePortaApplicativaList(); ++i) {
            if (!nomePorta.equals(soggetto.getPortaApplicativa(i).getNome())) continue;
            return soggetto.getPortaApplicativa(i);
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PortaApplicativa non esistente");
    }

    @Override
    public Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idPA Non Valido");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idServizio Non Valido");
        }
        if (idPA.getIDServizio().getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro Soggetto Erogatore Non Valido");
        }
        this.refreshConfigurazioneXML();
        Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = new Hashtable<IDSoggetto, PortaApplicativa>();
        IDSoggetto soggettoVirtuale = idPA.getIDServizio().getSoggettoErogatore();
        String servizio = idPA.getIDServizio().getServizio();
        String tipoServizio = idPA.getIDServizio().getTipoServizio();
        String azione = idPA.getIDServizio().getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametri (Servizio) Non Validi");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop aSoggetto = this.openspcoop.getSoggettoSpcoop(i);
            PortaApplicativa paSenzaAzione = null;
            for (int j = 0; j < aSoggetto.sizePortaApplicativaList(); ++j) {
                int k;
                PortaApplicativa pa = aSoggetto.getPortaApplicativa(j);
                if (pa.getSoggettoVirtuale() == null || !pa.getSoggettoVirtuale().getTipo().equals(soggettoVirtuale.getTipo()) || !pa.getSoggettoVirtuale().getNome().equals(soggettoVirtuale.getNome()) || !servizio.equals(pa.getServizio().getNome()) || !tipoServizio.equals(pa.getServizio().getTipo())) continue;
                if (azione == null) {
                    if (pa.getAzione() != null) continue;
                    for (k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), pa);
                    }
                } else {
                    if (pa.getAzione() == null) {
                        paSenzaAzione = pa;
                        continue;
                    }
                    if (!azione.equals(pa.getAzione().getNome())) continue;
                    for (k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), pa);
                        paSenzaAzione = null;
                    }
                }
                break;
            }
            if (paSenzaAzione == null) continue;
            paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), paSenzaAzione);
        }
        if (paConSoggetti.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getPortaApplicativa_SoggettiVirtuali] Porte applicative di soggetti virtuali non esistenti.");
        }
        return paConSoggetti;
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDPortaDelegata idPD, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDSoggetto soggetto = idPD.getSoggettoFruitore();
        if (servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaDelegata)] Parametro servizioApplicativo Non Valido");
        }
        PortaDelegata pd = this.getPortaDelegata(idPD);
        if (pd != null) {
            for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = pd.getServizioApplicativo(j);
                if (!servizioApplicativo.equals(sa.getNome())) continue;
                if (sa.getInvocazionePorta() == null) break;
                return sa;
            }
        }
        if (soggetto != null) {
            SoggettoSpcoop soggettoSPCoop = null;
            try {
                soggettoSPCoop = this.getSoggetto(soggetto);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (soggettoSPCoop == null) {
                throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaDelegata)] Soggetto fruitore non esistente");
            }
            for (int j = 0; j < soggettoSPCoop.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSPCoop.getServizioApplicativo(j);
                if (!servizioApplicativo.equals(sa.getNome())) continue;
                return sa;
            }
        } else {
            for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop soggettoSearch = this.openspcoop.getSoggettoSpcoop(i);
                for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                    if (!servizioApplicativo.equals(sa.getNome())) continue;
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo(RichiestaDelegata)] Servizio Applicativo non esistente");
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDPortaApplicativa idPA, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDSoggetto soggetto = idPA.getIDServizio().getSoggettoErogatore();
        if (soggetto == null || servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaApplicativa)] Parametri Non Validi");
        }
        PortaApplicativa pa = this.getPortaApplicativa(idPA);
        if (pa != null) {
            for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = pa.getServizioApplicativo(j);
                if (!servizioApplicativo.equals(sa.getNome())) continue;
                if (sa.getInvocazioneServizio() == null) break;
                return sa;
            }
        }
        SoggettoSpcoop soggettoSPCoop = null;
        try {
            soggettoSPCoop = this.getSoggetto(soggetto);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (soggettoSPCoop == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo(RichiestaApplicativa)] Soggetto Erogatore non esistente");
        }
        for (int j = 0; j < soggettoSPCoop.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggettoSPCoop.getServizioApplicativo(j);
            if (!servizioApplicativo.equals(sa.getNome())) continue;
            return sa;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo(RichiestaApplicativa)] Servizio applicativo non esistente");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(IDPortaDelegata idPD, String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        block14: {
            block13: {
                int z;
                ServizioApplicativo sa;
                if (idPD != null && idPD.getSoggettoFruitore() != null & idPD.getLocationPD() != null) {
                    PortaDelegata pd = null;
                    try {
                        pd = this.getPortaDelegata(idPD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (pd != null) {
                        for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                            sa = pd.getServizioApplicativo(j);
                            if (sa.getInvocazionePorta() == null) continue;
                            for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                                if (!"basic".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                                return sa;
                            }
                        }
                    }
                }
                if (idPD == null || idPD.getSoggettoFruitore() == null) break block13;
                SoggettoSpcoop soggetto = null;
                try {
                    soggetto = this.getSoggetto(idPD.getSoggettoFruitore());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (soggetto == null) break block14;
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    sa = soggetto.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (!"basic".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                        return sa;
                    }
                }
                break block14;
            }
            for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop soggettoSearch = this.openspcoop.getSoggettoSpcoop(i);
                for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (!"basic".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                        return sa;
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali basic non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop soggettoSearch = this.openspcoop.getSoggettoSpcoop(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (!"basic".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !aPassword.equals(sa.getInvocazionePorta().getCredenziali(z).getPassword())) continue;
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali basic non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(IDPortaDelegata idPD, String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        block32: {
            block31: {
                int z;
                ServizioApplicativo sa;
                if (idPD != null && idPD.getSoggettoFruitore() != null & idPD.getLocationPD() != null) {
                    PortaDelegata pd = null;
                    try {
                        pd = this.getPortaDelegata(idPD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (pd != null) {
                        for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                            sa = pd.getServizioApplicativo(j);
                            if (sa.getInvocazionePorta() == null) continue;
                            for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                                if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                                    try {
                                        if (Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) {
                                            return sa;
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new DriverConfigurazioneException(e.getMessage(), e);
                                    }
                                }
                                if (!"ssl".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                                try {
                                    if (!Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) continue;
                                    return sa;
                                }
                                catch (Exception e) {
                                    throw new DriverConfigurazioneException(e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
                if (idPD == null || idPD.getSoggettoFruitore() == null) break block31;
                SoggettoSpcoop soggetto = null;
                try {
                    soggetto = this.getSoggetto(idPD.getSoggettoFruitore());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (soggetto == null) break block32;
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    sa = soggetto.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                            try {
                                if (Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) {
                                    return sa;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverConfigurazioneException(e.getMessage(), e);
                            }
                        }
                        if (!"ssl".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                        try {
                            if (!Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) continue;
                            return sa;
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                }
                break block32;
            }
            for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop soggettoSearch = this.openspcoop.getSoggettoSpcoop(i);
                for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                    if (sa.getInvocazionePorta() == null) continue;
                    for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                        if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                            try {
                                if (Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) {
                                    return sa;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverConfigurazioneException(e.getMessage(), e);
                            }
                        }
                        if (!"ssl".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                        try {
                            if (!Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) continue;
                            return sa;
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticato(String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop soggettoSearch = this.openspcoop.getSoggettoSpcoop(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                        try {
                            if (Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) {
                                return sa;
                            }
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                    if (!"ssl".equalsIgnoreCase(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                    try {
                        if (!Utilities.sslVerify(sa.getInvocazionePorta().getCredenziali(z).getSubject(), aSubject)) continue;
                        return sa;
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idServizioApplicativo == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo non definito");
        }
        if (idServizioApplicativo.getIdSoggettoProprietario() == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo.idSoggettoProprietario non definito");
        }
        if (idServizioApplicativo.getNome() == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo.nome non definito");
        }
        SoggettoSpcoop soggettoProprietario = this.getSoggetto(idServizioApplicativo.getIdSoggettoProprietario());
        for (int j = 0; j < soggettoProprietario.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggettoProprietario.getServizioApplicativo(j);
            if (!idServizioApplicativo.getNome().equals(sa.getNome())) continue;
            return sa;
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        for (int i = 0; i < this.openspcoop.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop soggettoSearch = this.openspcoop.getSoggettoSpcoop(i);
            if (!idSoggetto.getTipo().equals(soggettoSearch.getTipo()) || !idSoggetto.getNome().equals(soggettoSearch.getNome())) continue;
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (!sa.getNome().equals(nomeServizioApplicativo)) continue;
                return sa;
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public RoutingTable getRoutingTable() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        RoutingTable r = null;
        if (this.openspcoop.getConfigurazione().getRoutingTable() == null) {
            r = new RoutingTable();
            r.setAbilitata(false);
        } else {
            r = this.openspcoop.getConfigurazione().getRoutingTable();
            r.setAbilitata(true);
        }
        return r;
    }

    @Override
    public AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoRegistro() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoRegistro] Informazioni di accesso al RegistroServizi non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoRegistro();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Informazioni per la gestione dell'errore non trovate");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteCooperazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Informazioni per la gestione dell'errore per il componente di cooperazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteCooperazione();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Informazioni per la gestione dell'errore non trovate");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteIntegrazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Informazioni per la gestione dell'errore per il componente di cooperazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteIntegrazione();
    }

    @Override
    public Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        return this.openspcoop.getConfigurazione();
    }

    @Override
    public void isAlive() throws DriverException {
        if (!this.create) {
            throw new DriverException("Driver non inizializzato");
        }
        try {
            this.forzaRefreshConfigurazioneXML();
        }
        catch (Exception e) {
            throw new DriverException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }

    @Override
    public Openspcoop getImmagineCompletaConfigurazionePdD() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        return this.openspcoop;
    }
}

