/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.commons;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.ProprietariDocumento;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;
import org.openspcoop.utils.sql.TipiDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtils {
    public static String estraiTipoDatabaseFromLocation(String location) throws DriverException {
        if (location == null) {
            throw new DriverException("Location del db is null");
        }
        if (location.indexOf("@") == -1) {
            throw new DriverException("Tipo di database non indicato nella location, sintassi corretta e' tipoDatabase@datasource");
        }
        String tipoDatabase = location.split("@")[0].trim();
        if (!(TipiDatabase.MYSQL.equals(tipoDatabase) || TipiDatabase.POSTGRESQL.equals(tipoDatabase) || TipiDatabase.ORACLE.equals(tipoDatabase))) {
            throw new DriverException("Tipo di database indicato nella location [" + tipoDatabase + "] non supportato");
        }
        return tipoDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdPortaDominio(String nome, Connection con, String tipoDB) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idPdD = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, nome);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idPdD = rs.getLong("id");
                }
                l = idPdD;
                Object var12_11 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB) throws DriverException {
        return DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB, "soggetti");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB, String tabellaSoggetti) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable(tabellaSoggetti);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, tipoSoggetto);
                stm.setString(2, nomeSoggetto);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSoggetto = rs.getLong("id");
                }
                l = idSoggetto;
                Object var14_13 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdConnettore(String nomeConnettore, Connection con, String tipoDB) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_connettore = ?");
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, nomeConnettore);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idConnettore = rs.getLong("id");
                }
                l = idConnettore;
                Object var12_11 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB) throws DriverException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws DriverException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, tipoDB, tabellaSoggetti);
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, boolean testServizioNonCorrelato, String tipoDB) throws DriverException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, testServizioNonCorrelato, tipoDB, "soggetti");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, boolean testServizioNonCorrelato, String tipoDB, String tabellaSoggetti) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                sqlQueryObject.addWhereCondition("nome_servizio = ?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                if (testServizioNonCorrelato) {
                    query = query + " AND servizio_correlato=?";
                }
                stm = con.prepareStatement(query);
                stm.setString(1, tipoServizio);
                stm.setString(2, nomeServizio);
                stm.setLong(3, idSoggetto);
                if (testServizioNonCorrelato) {
                    stm.setString(4, "disabilitato");
                }
                if ((rs = stm.executeQuery()).next()) {
                    idServizio = rs.getLong("id");
                }
                l = idServizio;
                Object var19_17 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws DriverException {
        return DBUtils.getIdServizioApplicativo(nomeServizioApplicativo, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idServizioApplicativo = -1L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idSoggetto);
                stm.setString(2, nomeServizioApplicativo);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idServizioApplicativo = rs.getLong("id");
                }
                l = idServizioApplicativo;
                Object var17_15 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws DriverException {
        return DBUtils.getIdPortaApplicativa(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idPortaApplicativa = -1L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("nome_porta = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idSoggetto);
                stm.setString(2, nomePorta);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idPortaApplicativa = rs.getLong("id");
                }
                l = idPortaApplicativa;
                Object var17_15 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static long getIdPortaDelegata(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws DriverException {
        return DBUtils.getIdPortaDelegata(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdPortaDelegata(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idPortaDelegata = -1L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("nome_porta = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idSoggetto);
                stm.setString(2, nomePorta);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idPortaDelegata = rs.getLong("id");
                }
                l = idPortaDelegata;
                Object var17_15 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }

    public static long getIdAccordo(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB) throws DriverException {
        return DBUtils.getIdAccordo(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB, "soggetti");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdAccordo(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idAccordo = -1L;
        try {
            try {
                long idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setLong(1, idServizio);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idAccordo = rs.getLong("id_accordo");
                }
                l = idAccordo;
                Object var18_16 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdPortType(Long idAccordo, String nomePortType, Connection con) throws DriverException {
        long l;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        long id = -1L;
        try {
            try {
                String selectQuery = "SELECT id FROM port_type WHERE id_accordo = ? AND nome=?";
                selectStmt = con.prepareStatement(selectQuery);
                selectStmt.setLong(1, idAccordo);
                selectStmt.setString(2, nomePortType);
                selectRS = selectStmt.executeQuery();
                if (selectRS.next()) {
                    id = selectRS.getLong("id");
                }
                selectRS.close();
                selectStmt.close();
                l = id;
                Object var11_9 = null;
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt == null) throw throwable;
                selectStmt.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return l;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt == null) return l;
        selectStmt.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdAccordoServizio(IDAccordo idAccordo, Connection con, String tipoDB) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.addWhereCondition("id_referente = ?");
                if (IDAccordo.versioneNonDefinita(idAccordo.getVersione())) {
                    sqlQueryObject.addWhereCondition(false, "versione = ?", "versione is null");
                } else {
                    sqlQueryObject.addWhereCondition("versione = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, idAccordo.getNome());
                long idSoggettoReferente = 0L;
                if (idAccordo.getSoggettoReferente() != null && (idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB)) <= 0L) {
                    throw new DriverException("[getIdAccordoServizio] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
                }
                stm.setLong(2, idSoggettoReferente);
                String vers = "";
                if (idAccordo.getVersione() != null) {
                    vers = idAccordo.getVersione();
                }
                stm.setString(3, vers);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idAccordoLong = rs.getLong("id");
                }
                l = idAccordoLong;
                Object var15_13 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdAccordoCooperazione(IDAccordoCooperazione idAccordo, Connection con, String tipoDB) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome = ?");
                if (IDAccordo.versioneNonDefinita(idAccordo.getVersione())) {
                    sqlQueryObject.addWhereCondition(false, "versione = ?", "versione is null");
                } else {
                    sqlQueryObject.addWhereCondition("versione = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, idAccordo.getNome());
                String vers = "";
                if (idAccordo.getVersione() != null) {
                    vers = idAccordo.getVersione();
                }
                stm.setString(2, vers);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idAccordoLong = rs.getLong("id");
                }
                l = idAccordoLong;
                Object var13_12 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdAccordoServizioParteSpecifica(IDAccordo idAccordo, Connection con, String tipoDB) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("aps_nome = ?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("aps_versione = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, idAccordo.getNome());
                long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB);
                if (idSoggettoReferente <= 0L) {
                    throw new DriverException("[getIdAccordoServizio] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
                }
                stm.setLong(2, idSoggettoReferente);
                stm.setString(3, idAccordo.getVersione());
                rs = stm.executeQuery();
                if (rs.next()) {
                    idAccordoLong = rs.getLong("id");
                }
                l = idAccordoLong;
                Object var14_12 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConnettoreProperty[] getPropertiesConnettore(String nome_connettore, Connection con, String tipoDB) throws DriverException {
        ConnettoreProperty[] connettorePropertyArray;
        Statement stmt = null;
        ResultSet risultato = null;
        String path = null;
        Properties prop = new Properties();
        ConnettoreProperty[] res = null;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("connettori_properties");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_connettore = ?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nome_connettore);
                risultato = stmt.executeQuery();
                if (risultato.next()) {
                    path = risultato.getString("path");
                }
                if (path == null) throw new DriverException("getPropertiesConnettore : nessun path impostato per il connettore : " + nome_connettore);
                if (path.equals("")) {
                    throw new DriverException("getPropertiesConnettore : nessun path impostato per il connettore : " + nome_connettore);
                }
                InputStream ins = DBUtils.class.getResourceAsStream(path);
                prop.load(ins);
                ArrayList<ConnettoreProperty> collection = DBUtils.fromPropertiesToCollection(prop);
                connettorePropertyArray = res = collection.toArray(new ConnettoreProperty[collection.size()]);
                Object var14_15 = null;
            }
            catch (FileNotFoundException fe) {
                throw new DriverException("Impossibile aprire il file :" + path + " Errore: " + fe.getMessage(), fe);
            }
            catch (Exception e) {
                throw new DriverException("Errore durante la lettura delle properties dal file [" + path + "]: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return connettorePropertyArray;
        }
        if (risultato != null) {
            risultato.close();
        }
        if (stmt == null) return connettorePropertyArray;
        stmt.close();
        return connettorePropertyArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static org.openspcoop.dao.config.ConnettoreProperty[] getPropertiesConnettoreConfig(String nome_connettore, Connection con, String tipoDB) throws DriverException {
        org.openspcoop.dao.config.ConnettoreProperty[] connettorePropertyArray;
        Statement stmt = null;
        ResultSet risultato = null;
        String path = null;
        Properties prop = new Properties();
        org.openspcoop.dao.config.ConnettoreProperty[] res = null;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("connettori_properties");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_connettore = ?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nome_connettore);
                risultato = stmt.executeQuery();
                if (risultato.next()) {
                    path = risultato.getString("path");
                }
                if (path == null) throw new DriverException("getPropertiesConnettore : nessun path impostato per il connettore : " + nome_connettore);
                if (path.equals("")) {
                    throw new DriverException("getPropertiesConnettore : nessun path impostato per il connettore : " + nome_connettore);
                }
                InputStream ins = DBUtils.class.getResourceAsStream(path);
                prop.load(ins);
                ArrayList<org.openspcoop.dao.config.ConnettoreProperty> collection = DBUtils.fromPropertiesToCollectionConfig(prop);
                connettorePropertyArray = res = collection.toArray(new org.openspcoop.dao.config.ConnettoreProperty[collection.size()]);
                Object var14_15 = null;
            }
            catch (FileNotFoundException fe) {
                throw new DriverException("Impossibile aprire il file :" + path + " Errore: " + fe.getMessage(), fe);
            }
            catch (Exception e) {
                throw new DriverException("Errore durante la lettura delle properties dal file [" + path + "]: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return connettorePropertyArray;
        }
        if (risultato != null) {
            risultato.close();
        }
        if (stmt == null) return connettorePropertyArray;
        stmt.close();
        return connettorePropertyArray;
    }

    private static ArrayList<ConnettoreProperty> fromPropertiesToCollection(Properties props) {
        ArrayList<ConnettoreProperty> lista = new ArrayList<ConnettoreProperty>();
        ConnettoreProperty tmp = null;
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)props.get(key);
            tmp = new ConnettoreProperty();
            tmp.setNome(key);
            tmp.setValore(value);
            lista.add(tmp);
        }
        return lista;
    }

    private static ArrayList<org.openspcoop.dao.config.ConnettoreProperty> fromPropertiesToCollectionConfig(Properties props) {
        ArrayList<org.openspcoop.dao.config.ConnettoreProperty> lista = new ArrayList<org.openspcoop.dao.config.ConnettoreProperty>();
        org.openspcoop.dao.config.ConnettoreProperty tmp = null;
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)props.get(key);
            tmp = new org.openspcoop.dao.config.ConnettoreProperty();
            tmp.setNome(key);
            tmp.setValore(value);
            lista.add(tmp);
        }
        return lista;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdDocumento(String nome, String tipo, String ruolo, long idProprietario, Connection con, String tipoDB, ProprietariDocumento tipoProprietario) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idDoc = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.addWhereCondition("tipo = ?");
                sqlQueryObject.addWhereCondition("ruolo = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idProprietario);
                stm.setString(2, nome);
                stm.setString(3, tipo);
                stm.setString(4, ruolo);
                stm.setString(5, tipoProprietario.toString());
                rs = stm.executeQuery();
                if (rs.next()) {
                    idDoc = rs.getLong("id");
                }
                rs.close();
                stm.close();
                l = idDoc;
                Object var17_15 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }
}

