/*
 * Decompiled with CFR 0.152.
 */
package it.gov.spcoop.sica.wscp.driver;

import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import it.gov.spcoop.sica.wscp.OperationListType;
import it.gov.spcoop.sica.wscp.OperationType;
import it.gov.spcoop.sica.wscp.ProfiloCollaborazioneEGOV;
import it.gov.spcoop.sica.wscp.driver.TipiProfiliCollaborazione;
import it.gov.spcoop.sica.wscp.driver.XMLUtilsException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.wsdl.DefinitionWrapper;
import org.openspcoop.dao.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD() throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(XMLUtils.class.getResourceAsStream("/SpecificaSemiformaleEGov_ClientSICA.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(ProfiloCollaborazioneEGOV egov, StringBuffer motivoErroreValidazione) {
        OperationListType operations;
        int size = motivoErroreValidazione.length();
        if (egov.getVersioneEGOV() == null) {
            motivoErroreValidazione.append("VersioneEGov non definita\n");
        }
        if (egov.getRiferimentoDefinizioneInterfaccia() == null) {
            motivoErroreValidazione.append("RifInterfaccia non definita\n");
        }
        if ((operations = egov.getListaCollaborazioni()) == null) {
            motivoErroreValidazione.append("OperationListType non presente\n");
        } else {
            if (operations.sizeCollaborazioneList() <= 0) {
                motivoErroreValidazione.append("OperationListType vuota\n");
            }
            for (int i = 0; i < operations.sizeCollaborazioneList(); ++i) {
                OperationType op = operations.getCollaborazione(i);
                if (op.getServizio() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza il servizio\n");
                }
                if (op.getOperazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza l'operation\n");
                }
                if (op.getProfiloDiCollaborazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza un profilo di collaborazione\n");
                }
                if (TipiProfiliCollaborazione.EGOV_IT_MessaggioSingoloOneWay.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.EGOV_IT_ServizioSincrono.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) continue;
                motivoErroreValidazione.append("OperationList[" + i + "] con un profilo di collaborazione non conosciuto (" + op.getProfiloDiCollaborazione() + ")\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProfiloCollaborazioneEGOV getDichiarazioneEGov(byte[] m, boolean acceptChildUnqualified) throws XMLUtilsException {
        ProfiloCollaborazioneEGOV profiloCollaborazioneEGOV;
        ByteArrayInputStream bin = null;
        try {
            try {
                bin = new ByteArrayInputStream(m);
                profiloCollaborazioneEGOV = XMLUtils.getDichiarazioneEGov(bin, acceptChildUnqualified);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (bin == null) throw throwable;
                bin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return profiloCollaborazioneEGOV;
        }
        if (bin == null) return profiloCollaborazioneEGOV;
        bin.close();
        return profiloCollaborazioneEGOV;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProfiloCollaborazioneEGOV getDichiarazioneEGov(File m, boolean acceptChildUnqualified) throws XMLUtilsException {
        ProfiloCollaborazioneEGOV profiloCollaborazioneEGOV;
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(m);
                profiloCollaborazioneEGOV = XMLUtils.getDichiarazioneEGov(fin, acceptChildUnqualified);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fin == null) throw throwable;
                fin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return profiloCollaborazioneEGOV;
        }
        if (fin == null) return profiloCollaborazioneEGOV;
        fin.close();
        return profiloCollaborazioneEGOV;
    }

    public static ProfiloCollaborazioneEGOV getDichiarazioneEGov(String m, boolean acceptChildUnqualified) throws XMLUtilsException {
        return XMLUtils.getDichiarazioneEGov(m.getBytes(), acceptChildUnqualified);
    }

    public static ProfiloCollaborazioneEGOV getDichiarazioneEGov(InputStream m, boolean acceptChildUnqualified) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            if (acceptChildUnqualified) {
                xml = XMLUtils.unescapeXMLForClientSICA(xml);
            }
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD();
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (ProfiloCollaborazioneEGOV)org.openspcoop.dao.commons.XMLUtils.xmlToObj(binTrasformazione, ProfiloCollaborazioneEGOV.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] unescapeXMLForClientSICA(byte[] xml) throws Exception {
        Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(xml);
        Element elemXML = docXML.getDocumentElement();
        String prefixRootElement = elemXML.getPrefix();
        String prefixChildElementEgovVersione = null;
        for (int i = 0; i < elemXML.getChildNodes().getLength(); ++i) {
            Node child = elemXML.getChildNodes().item(i);
            if (!"versioneEGOV".equals(child.getLocalName())) continue;
            prefixChildElementEgovVersione = child.getPrefix();
        }
        if (prefixRootElement != null && prefixChildElementEgovVersione == null) {
            String xmlS = new String(xml);
            xmlS = xmlS.replace("<" + prefixRootElement + ":" + "profiloCollaborazioneEGOV", "<profiloCollaborazioneEGOV");
            xmlS = xmlS.replace("xmlns:" + prefixRootElement, "xmlns");
            xmlS = xmlS.replace("</" + prefixRootElement + ":" + "profiloCollaborazioneEGOV", "</profiloCollaborazioneEGOV");
            xml = xmlS.getBytes();
        }
        return xml;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateDichiarazioneEGov(ProfiloCollaborazioneEGOV manifest, File out, boolean buildChildUnqualified) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(out);
                byte[] xml = XMLUtils.generateDichiarazioneEGov_engine(manifest, buildChildUnqualified);
                fout.write(xml);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_6 = null;
            if (fout == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fout == null) throw throwable;
            try {
                fout.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        fout.close();
        return;
    }

    public static void generateDichiarazioneEGov(ProfiloCollaborazioneEGOV manifest, String fileName, boolean buildChildUnqualified) throws XMLUtilsException {
        XMLUtils.generateDichiarazioneEGov(manifest, new File(fileName), buildChildUnqualified);
    }

    public static byte[] generateDichiarazioneEGov(ProfiloCollaborazioneEGOV manifest, boolean buildChildUnqualified) throws XMLUtilsException {
        try {
            return XMLUtils.generateDichiarazioneEGov_engine(manifest, buildChildUnqualified);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(ProfiloCollaborazioneEGOV manifest, OutputStream out, boolean buildChildUnqualified) throws XMLUtilsException {
        try {
            byte[] xml = XMLUtils.generateDichiarazioneEGov_engine(manifest, buildChildUnqualified);
            out.write(xml);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDichiarazioneEGov_engine(ProfiloCollaborazioneEGOV manifest, boolean buildChildUnqualified) throws Exception {
        StringBuffer risultatoValidazione = new StringBuffer();
        if (!XMLUtils.validate(manifest, risultatoValidazione)) {
            throw new Exception(risultatoValidazione.toString());
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        org.openspcoop.dao.commons.XMLUtils.objToXml(bout, ProfiloCollaborazioneEGOV.class, (Object)manifest);
        byte[] xml = bout.toByteArray();
        if (buildChildUnqualified) {
            xml = XMLUtils.escapeXMLForClientSICA(xml);
        }
        return xml;
    }

    private static byte[] escapeXMLForClientSICA(byte[] xml) throws Exception {
        String xmlS = new String(xml);
        xmlS = xmlS.replace("<profiloCollaborazioneEGOV", "<wscp:profiloCollaborazioneEGOV");
        xmlS = xmlS.replace("xmlns", "xmlns:wscp");
        xmlS = xmlS.replace("</profiloCollaborazioneEGOV", "</wscp:profiloCollaborazioneEGOV");
        return xmlS.getBytes();
    }

    public static boolean isProfiloCollaborazioneEGOV(byte[] doc) {
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return "profiloCollaborazioneEGOV".equals(elemXML.getLocalName()) && "http://spcoop.gov.it/sica/wscp".equals(elemXML.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String readNomeSPCoop(String QName2, Hashtable<String, String> mapPrefixNamespaces) throws XMLUtilsException {
        if (QName2 == null) {
            return null;
        }
        if (QName2.contains(":")) {
            String[] split = QName2.split(":");
            if (split.length != 2) {
                throw new XMLUtilsException("QName [" + QName2 + "] non valido");
            }
            String prefix = split[0].trim();
            String nomeSPCoop = split[1].trim();
            if (mapPrefixNamespaces.containsKey(prefix)) {
                return nomeSPCoop;
            }
            throw new XMLUtilsException("QName [" + QName2 + "] non valido, prefix [" + prefix + "] non associato a nessun namespace");
        }
        return QName2;
    }

    public static void mapProfiloCollaborazioneEGOVIntoAS(byte[] doc, AccordoServizio as, boolean acceptChildUnqualified) throws XMLUtilsException {
        ProfiloCollaborazioneEGOV egov = null;
        try {
            egov = XMLUtils.getDichiarazioneEGov(doc, acceptChildUnqualified);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Documento con informazione egov non leggibile: " + e.getMessage(), e);
        }
        Hashtable<String, String> mapPrefixNamespaces = new Hashtable<String, String>();
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            NamedNodeMap map = elemXML.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node o = map.item(i);
                if (!(o instanceof Attr)) continue;
                Attr attr = (Attr)o;
                String prefix = "";
                if (attr.getPrefix() != null) {
                    prefix = attr.getLocalName();
                }
                mapPrefixNamespaces.put(prefix, attr.getValue());
            }
        }
        catch (Exception e) {
            throw new XMLUtilsException("Documento XML con informazione egov non leggibile: " + e.getMessage(), e);
        }
        Hashtable<String, PortType> servizi = new Hashtable<String, PortType>();
        OperationListType list = egov.getListaCollaborazioni();
        for (int h = 0; h < list.sizeCollaborazioneList(); ++h) {
            OperationType operationType = list.getCollaborazione(h);
            String nomeAzione = XMLUtils.readNomeSPCoop(operationType.getOperazione(), mapPrefixNamespaces);
            String nomeServizio = XMLUtils.readNomeSPCoop(operationType.getServizio(), mapPrefixNamespaces);
            String nomeAzioneCorrelata = XMLUtils.readNomeSPCoop(operationType.getOperazioneCorrelata(), mapPrefixNamespaces);
            String nomeServizioCorrelato = XMLUtils.readNomeSPCoop(operationType.getServizioCorrelato(), mapPrefixNamespaces);
            String profiloCollaborazione = operationType.getProfiloDiCollaborazione();
            PortType pt = null;
            if (servizi.containsKey(nomeServizio)) {
                pt = (PortType)servizi.remove(nomeServizio);
            } else {
                pt = new PortType();
                pt.setProfiloPT("ridefinito");
                if (TipiProfiliCollaborazione.EGOV_IT_MessaggioSingoloOneWay.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("oneway");
                } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioSincrono.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("sincrono");
                } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("asincronoSimmetrico");
                } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("asincronoAsimmetrico");
                } else {
                    throw new XMLUtilsException("Profilo di collaborazione non valido [" + profiloCollaborazione + "]");
                }
                pt.setNome(nomeServizio);
            }
            Operation azione = new Operation();
            azione.setNome(nomeAzione);
            azione.setProfAzione("ridefinito");
            if (TipiProfiliCollaborazione.EGOV_IT_MessaggioSingoloOneWay.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("oneway");
            } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioSincrono.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("sincrono");
            } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("asincronoSimmetrico");
            } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("asincronoAsimmetrico");
            } else {
                throw new XMLUtilsException("Profilo di collaborazione non valido [" + profiloCollaborazione + "]");
            }
            pt.addAzione(azione);
            servizi.put(nomeServizio, pt);
            if (!TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.toString().equals(profiloCollaborazione) && !TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.toString().equals(profiloCollaborazione) || nomeAzioneCorrelata == null) continue;
            String servizio = nomeServizioCorrelato;
            if (servizio == null) {
                servizio = nomeServizio;
            }
            PortType ptCorrelato = null;
            if (servizi.containsKey(servizio)) {
                ptCorrelato = (PortType)servizi.remove(servizio);
            } else {
                ptCorrelato = new PortType();
                ptCorrelato.setProfiloPT("ridefinito");
                if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                    ptCorrelato.setProfiloCollaborazione("asincronoSimmetrico");
                } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                    ptCorrelato.setProfiloCollaborazione("asincronoAsimmetrico");
                }
                ptCorrelato.setNome(servizio);
            }
            Operation azioneCorrelata = new Operation();
            azioneCorrelata.setNome(nomeAzioneCorrelata);
            azioneCorrelata.setProfAzione("ridefinito");
            if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                azioneCorrelata.setProfiloCollaborazione("asincronoSimmetrico");
            } else if (TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                azioneCorrelata.setProfiloCollaborazione("asincronoAsimmetrico");
            }
            if (nomeServizio != null) {
                azioneCorrelata.setCorrelataServizio(nomeServizio);
            }
            azioneCorrelata.setCorrelata(nomeAzione);
            ptCorrelato.addAzione(azioneCorrelata);
            servizi.put(servizio, ptCorrelato);
        }
        Enumeration keys = servizi.keys();
        while (keys.hasMoreElements()) {
            String pt = (String)keys.nextElement();
            as.addPortType((PortType)servizi.get(pt));
        }
    }

    public static DocumentoSemiformale generaDocumentoSemiformale(AccordoServizio as, AccordoServizioParteComune accServParteComuneSICA, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        DocumentoSemiformale docSemiformalePerManifest = XMLUtils.generaDocumentoSemiformalePerManifesto();
        Documento docSICA = XMLUtils.generaDocumentoSemiformale(as, nomiSPCoopQualified, gestioneChildUnquilified);
        accServParteComuneSICA.addSpecificaSemiformale(docSICA);
        return docSemiformalePerManifest;
    }

    public static DocumentoSemiformale generaDocumentoSemiformale(AccordoServizio as, AccordoServizioComposto accServCompostoSICA, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        DocumentoSemiformale docSemiformalePerManifest = XMLUtils.generaDocumentoSemiformalePerManifesto();
        Documento docSICA = XMLUtils.generaDocumentoSemiformale(as, nomiSPCoopQualified, gestioneChildUnquilified);
        accServCompostoSICA.addSpecificaSemiformale(docSICA);
        return docSemiformalePerManifest;
    }

    private static DocumentoSemiformale generaDocumentoSemiformalePerManifesto() throws XMLUtilsException {
        DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
        docSemiformale.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSemiformale.setBase("ProfiloDiCollaborazione.wscp");
        return docSemiformale;
    }

    private static Documento generaDocumentoSemiformale(AccordoServizio as, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        Documento docSICA = new Documento();
        docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSICA.setNome("ProfiloDiCollaborazione.wscp");
        try {
            byte[] dichiarazioneEGov = XMLUtils.generaDocumentoEGov(as, nomiSPCoopQualified, gestioneChildUnquilified);
            docSICA.setContenuto(dichiarazioneEGov);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
        }
        return docSICA;
    }

    public static String generaGenericoDocumento(AccordoServizio as, AccordoServizioParteComune accServParteComuneSICA, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        String genericoDocumentoPerManifest = XMLUtils.generaGenericoDocumentoPerManifesto();
        Documento docSICA = XMLUtils.generaGenericoDocumento(as, nomiSPCoopQualified, gestioneChildUnquilified);
        accServParteComuneSICA.addAllegato(docSICA);
        return genericoDocumentoPerManifest;
    }

    public static String generaGenericoDocumento(AccordoServizio as, AccordoServizioComposto accServCompostoSICA, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        String genericoDocumentoPerManifest = XMLUtils.generaGenericoDocumentoPerManifesto();
        Documento docSICA = XMLUtils.generaGenericoDocumento(as, nomiSPCoopQualified, gestioneChildUnquilified);
        accServCompostoSICA.addAllegato(docSICA);
        return genericoDocumentoPerManifest;
    }

    private static String generaGenericoDocumentoPerManifesto() throws XMLUtilsException {
        return "ProfiloDiCollaborazione.wscp";
    }

    private static Documento generaGenericoDocumento(AccordoServizio as, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        Documento docSICA = new Documento();
        docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSICA.setNome("ProfiloDiCollaborazione.wscp");
        try {
            byte[] dichiarazioneEGov = XMLUtils.generaDocumentoEGov(as, nomiSPCoopQualified, gestioneChildUnquilified);
            docSICA.setContenuto(dichiarazioneEGov);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
        }
        return docSICA;
    }

    private static byte[] generaDocumentoEGov(AccordoServizio as, boolean nomiSPCoopQualified, boolean gestioneChildUnquilified) throws XMLUtilsException {
        String prefissoNomiSPCoop = "";
        String namespaceQualified = null;
        if (nomiSPCoopQualified) {
            try {
                byte[] wsdlConcettuale = as.getByteWsdlConcettuale();
                if (wsdlConcettuale != null) {
                    RegistroOpenSPCoopUtilities wsdlUtility = new RegistroOpenSPCoopUtilities(null);
                    wsdlConcettuale = wsdlUtility.eliminaImportASParteComune(wsdlConcettuale);
                    DefinitionWrapper wsdl = new DefinitionWrapper(wsdlConcettuale);
                    String targetNamespace = wsdl.getTargetNamespace();
                    String prefix = null;
                    if (targetNamespace != null && (prefix = wsdl.getPrefix(targetNamespace)) == null) {
                        prefix = "tnsService";
                    }
                    if (targetNamespace != null) {
                        prefissoNomiSPCoop = prefix + ":";
                        namespaceQualified = "xmlns:" + prefix + "=\"" + targetNamespace + "\"";
                    }
                }
            }
            catch (Exception e) {
                System.out.println("errore durante la lettura del target namespace del wsdl: " + e.getMessage());
            }
        }
        byte[] dichiarazioneEGov = XMLUtils.generateDichiarazioneEGov(XMLUtils.generaProfiloCollaborazioneEGOV(as, prefissoNomiSPCoop), gestioneChildUnquilified);
        if (nomiSPCoopQualified && namespaceQualified != null) {
            dichiarazioneEGov = new String(dichiarazioneEGov).replaceFirst("profiloCollaborazioneEGOV", "profiloCollaborazioneEGOV " + namespaceQualified).getBytes();
        }
        return dichiarazioneEGov;
    }

    private static ProfiloCollaborazioneEGOV generaProfiloCollaborazioneEGOV(AccordoServizio as, String prefissoNomiSPCoop) throws XMLUtilsException {
        if (as.sizePortTypeList() > 0) {
            ProfiloCollaborazioneEGOV egov = new ProfiloCollaborazioneEGOV();
            egov.setVersioneEGOV("e-govV1.1");
            egov.setRiferimentoDefinizioneInterfaccia(as.getNome());
            OperationListType operations = new OperationListType();
            Vector<OperationType> operationsSICA_asincrone_nonAncoraInserite = new Vector<OperationType>();
            for (int i = 0; i < as.sizePortTypeList(); ++i) {
                PortType pt = as.getPortType(i);
                String nomeServizio = prefissoNomiSPCoop + pt.getNome();
                for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                    OperationType opSICA;
                    String nomeServizioCorrelato;
                    Operation op = pt.getAzione(j);
                    String nomeAzione = prefissoNomiSPCoop + op.getNome();
                    String nomeAzioneCorrelata = op.getCorrelata();
                    if (nomeAzioneCorrelata != null) {
                        nomeAzioneCorrelata = prefissoNomiSPCoop + nomeAzioneCorrelata;
                    }
                    if ((nomeServizioCorrelato = op.getCorrelataServizio()) != null) {
                        nomeServizioCorrelato = prefissoNomiSPCoop + nomeServizioCorrelato;
                    }
                    String profilo = null;
                    profilo = "ridefinito".equals(op.getProfAzione()) ? op.getProfiloCollaborazione() : pt.getProfiloCollaborazione();
                    if ("asincronoAsimmetrico".equals(profilo) || "asincronoSimmetrico".equals(profilo)) {
                        if (nomeAzioneCorrelata == null) {
                            opSICA = new OperationType();
                            opSICA.setOperazione(nomeAzione);
                            if ("asincronoAsimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.name());
                            } else if ("asincronoSimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.name());
                            }
                            opSICA.setServizio(nomeServizio);
                            operationsSICA_asincrone_nonAncoraInserite.add(opSICA);
                            continue;
                        }
                        opSICA = new OperationType();
                        opSICA.setOperazione(nomeAzioneCorrelata);
                        opSICA.setOperazioneCorrelata(nomeAzione);
                        if ("asincronoAsimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.name());
                        } else if ("asincronoSimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.name());
                        }
                        if (nomeServizioCorrelato != null) {
                            opSICA.setServizio(nomeServizioCorrelato);
                        } else {
                            opSICA.setServizio(nomeServizio);
                        }
                        opSICA.setServizioCorrelato(nomeServizio);
                        operations.addCollaborazione(opSICA);
                        continue;
                    }
                    opSICA = new OperationType();
                    opSICA.setOperazione(nomeAzione);
                    if ("oneway".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.EGOV_IT_MessaggioSingoloOneWay.name());
                    } else if ("sincrono".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.EGOV_IT_ServizioSincrono.name());
                    }
                    opSICA.setServizio(nomeServizio);
                    operations.addCollaborazione(opSICA);
                }
            }
            while (operationsSICA_asincrone_nonAncoraInserite.size() > 0) {
                OperationType opSICA = (OperationType)operationsSICA_asincrone_nonAncoraInserite.remove(0);
                boolean find = false;
                for (int i = 0; i < operations.sizeCollaborazioneList(); ++i) {
                    if (!opSICA.getServizio().equals(operations.getCollaborazione(i).getServizio()) || !opSICA.getOperazione().equals(operations.getCollaborazione(i).getOperazione())) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                operations.addCollaborazione(opSICA);
            }
            egov.setListaCollaborazioni(operations);
            return egov;
        }
        throw new XMLUtilsException("PortTypes non definiti per l'accordo di servizio");
    }
}

