/*
 * Decompiled with CFR 0.152.
 */
package it.gov.spcoop.sica.dao.driver;

import it.gov.spcoop.sica.dao.AccordoCooperazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.firma.Firma;
import it.gov.spcoop.sica.manifest.AccordoServizio;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.SpecificaConversazione;
import it.gov.spcoop.sica.manifest.SpecificaInterfaccia;
import it.gov.spcoop.sica.manifest.SpecificaPortiAccesso;
import it.gov.spcoop.sica.manifest.driver.XMLUtilsException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.FileDataSource;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopContext;

public class XMLUtils {
    private SICAtoOpenSPCoopContext sicaToOpenSPCoopContext = null;

    public XMLUtils(SICAtoOpenSPCoopContext sContext) {
        this.sicaToOpenSPCoopContext = sContext;
    }

    private String getRootDir(String entry) throws XMLUtilsException {
        try {
            String rootDir = null;
            String dir = entry;
            int indexOf = dir.indexOf(File.separatorChar);
            if (indexOf <= 0) {
                throw new XMLUtilsException("Errore durante la comprensione della directory radice presente all'interno dello zip (" + indexOf + ")");
            }
            if ((dir = dir.substring(0, indexOf)) == null || "".equals(dir)) {
                throw new XMLUtilsException("Errore durante la comprensione della directory radice presente all'interno dello zip (" + dir + ")");
            }
            rootDir = dir + File.separatorChar;
            return rootDir;
        }
        catch (XMLUtilsException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new XMLUtilsException("Errore durante la comprensione della directory radice presente all'interno dello zip: " + e.getMessage(), e);
        }
    }

    private String getBaseName(String file) throws XMLUtilsException {
        try {
            return new File(file).getName();
        }
        catch (Exception e) {
            throw new XMLUtilsException("Errore durante la comprensione del base name per il file [" + file + "]: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteComune getAccordoServizioParteComune(byte[] zip) throws XMLUtilsException {
        AccordoServizioParteComune accordoServizioParteComune;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "apc");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoServizioParteComune = this.getAccordoServizioParteComune(tmp);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteComune;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoServizioParteComune;
        tmp.delete();
        return accordoServizioParteComune;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(String fileName) throws XMLUtilsException {
        return this.getAccordoServizioParteComune(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteComune getAccordoServizioParteComune(File zip) throws XMLUtilsException {
        AccordoServizioParteComune accordoServizioParteComune;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoServizioParteComune = this.getAccordoServizioParteComune(zipFile);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteComune;
        }
        if (zipFile == null) return accordoServizioParteComune;
        zipFile.close();
        return accordoServizioParteComune;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteComune getAccordoServizioParteComune(InputStream m) throws XMLUtilsException {
        AccordoServizioParteComune accordoServizioParteComune;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoServizioParteComune = this.getAccordoServizioParteComune(bout.toByteArray());
                Object var7_7 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteComune;
        }
        if (bout == null) return accordoServizioParteComune;
        bout.close();
        return accordoServizioParteComune;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(ZipFile zip) throws XMLUtilsException {
        try {
            AccordoServizioParteComune archivio = new AccordoServizioParteComune();
            String rootDir = null;
            it.gov.spcoop.sica.manifest.AccordoServizioParteComune parteComune = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if (!(rootDir + "manifesto.xml").equals(entry.getName())) continue;
                InputStream inputStream = zip.getInputStream(entry);
                AccordoServizio manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAS(inputStream);
                parteComune = manifesto.getParteComune();
                if (parteComune == null) {
                    throw new Exception("Manifest Parte Comune non presente");
                }
                inputStream.close();
                archivio.setManifesto(manifesto);
            }
            String interfacciaConcettuale = "InterfacciaConcettuale.wsdl";
            String interfaccialogicoErogatore = "InterfacciaLogicaErogatore.wsdl";
            String interfaccialogicoFruitore = "InterfacciaLogicaFruitore.wsdl";
            String conversazioneConcettuale = "ConversazioneConcettuale.wsbl";
            String conversazionelogicoErogatore = "ConversazioneLogicaLatoErogatore.wsbl";
            String conversazionelogicoFruitore = "ConversazioneLogicaLatoFruitore.wsbl";
            if (parteComune.getSpecificaInterfaccia() != null) {
                SpecificaInterfaccia interfaccia = parteComune.getSpecificaInterfaccia();
                if (interfaccia.getInterfacciaConcettuale() != null) {
                    interfacciaConcettuale = this.getBaseName(interfaccia.getInterfacciaConcettuale().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoErogatore() != null) {
                    interfaccialogicoErogatore = this.getBaseName(interfaccia.getInterfacciaLogicaLatoErogatore().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoFruitore() != null) {
                    interfaccialogicoFruitore = this.getBaseName(interfaccia.getInterfacciaLogicaLatoFruitore().getBase());
                }
            }
            if (parteComune.getSpecificaConversazione() != null) {
                SpecificaConversazione conversazione = parteComune.getSpecificaConversazione();
                if (conversazione.getConversazioneConcettuale() != null) {
                    conversazioneConcettuale = this.getBaseName(conversazione.getConversazioneConcettuale().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoErogatore() != null) {
                    conversazionelogicoErogatore = this.getBaseName(conversazione.getConversazioneLogicaLatoErogatore().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoFruitore() != null) {
                    conversazionelogicoFruitore = this.getBaseName(conversazione.getConversazioneLogicaLatoFruitore().getBase());
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                String dir;
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ((rootDir + ".project").equals(entry.getName())) continue;
                if ((rootDir + "firma.xml").equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entry.getName())) continue;
                if (entry.getName().startsWith(rootDir + "specificaConversazione")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaConversazione" + File.separatorChar;
                    if ((dir + conversazioneConcettuale).equals(entry.getName())) {
                        archivio.setConversazioneConcettuale(d);
                        continue;
                    }
                    if ((dir + conversazionelogicoErogatore).equals(entry.getName())) {
                        archivio.setConversazioneLogicaErogatore(d);
                        continue;
                    }
                    if (!(dir + conversazionelogicoFruitore).equals(entry.getName())) continue;
                    archivio.setConversazioneLogicaFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "specificaInterfaccia")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaInterfaccia" + File.separatorChar;
                    if ((dir + interfacciaConcettuale).equals(entry.getName())) {
                        archivio.setInterfacciaConcettuale(d);
                        continue;
                    }
                    if ((dir + interfaccialogicoErogatore).equals(entry.getName())) {
                        archivio.setInterfacciaLogicaLatoErogatore(d);
                        continue;
                    }
                    if (!(dir + interfaccialogicoFruitore).equals(entry.getName())) continue;
                    archivio.setInterfacciaLogicaLatoFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                        it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                        continue;
                    }
                    if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                    it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
                    continue;
                }
                if (!entry.getName().startsWith(rootDir + "specificaSemiformale")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
                if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                    it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                    continue;
                }
                if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    String fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                this.generateAccordoServizioParteComune(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                this.generateAccordoServizioParteComune(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public byte[] generateAccordoServizioParteComune(AccordoServizioParteComune manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoServizioParteComune(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            try {
                zipOut = new ZipOutputStream(out);
                String rootDir = "";
                rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
                if (generaSICAClientProjectFile) {
                    String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_" + "apc";
                    String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop (www.openspcoop.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                    zipOut.putNextEntry(new ZipEntry(rootDir + ".project"));
                    zipOut.write(projectContenuto.getBytes());
                }
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry(rootDir + "firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAS(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
                zipOut.putNextEntry(new ZipEntry(rootDir + "manifesto.xml"));
                zipOut.write(manifestoBytes);
                boolean specificaInterfaccia = false;
                if (manifesto.getInterfacciaConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaConcettuale.wsdl"));
                    zipOut.write(manifesto.getInterfacciaConcettuale().getContenuto());
                    specificaInterfaccia = true;
                }
                if (manifesto.getInterfacciaLogicaLatoErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoErogatore().getContenuto());
                    specificaInterfaccia = true;
                }
                if (manifesto.getInterfacciaLogicaLatoFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoFruitore().getContenuto());
                    specificaInterfaccia = true;
                }
                if (!specificaInterfaccia) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar));
                }
                boolean specificaConversazione = false;
                if (manifesto.getConversazioneConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneConcettuale.wsbl"));
                    zipOut.write(manifesto.getConversazioneConcettuale().getContenuto());
                    specificaConversazione = true;
                }
                if (manifesto.getConversazioneLogicaErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoErogatore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaErogatore().getContenuto());
                    specificaConversazione = true;
                }
                if (manifesto.getConversazioneLogicaFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoFruitore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaFruitore().getContenuto());
                    specificaConversazione = true;
                }
                if (!specificaConversazione) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar));
                }
                boolean allegati = manifesto.sizeAllegati() > 0;
                for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                if (!allegati) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar));
                }
                boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    Documento doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheSemiformali) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar));
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(byte[] zip) throws XMLUtilsException {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "aps");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoServizioParteSpecifica = this.getAccordoServizioParteSpecifica(tmp);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteSpecifica;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoServizioParteSpecifica;
        tmp.delete();
        return accordoServizioParteSpecifica;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(String fileName) throws XMLUtilsException {
        return this.getAccordoServizioParteSpecifica(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(File zip) throws XMLUtilsException {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoServizioParteSpecifica = this.getAccordoServizioParteSpecifica(zipFile);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteSpecifica;
        }
        if (zipFile == null) return accordoServizioParteSpecifica;
        zipFile.close();
        return accordoServizioParteSpecifica;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(InputStream m) throws XMLUtilsException {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoServizioParteSpecifica = this.getAccordoServizioParteSpecifica(bout.toByteArray());
                Object var7_7 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteSpecifica;
        }
        if (bout == null) return accordoServizioParteSpecifica;
        bout.close();
        return accordoServizioParteSpecifica;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(ZipFile zip) throws XMLUtilsException {
        try {
            String fileName;
            AccordoServizioParteSpecifica archivio = new AccordoServizioParteSpecifica();
            String rootDir = null;
            it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if (!(rootDir + "manifesto.xml").equals(entry.getName())) continue;
                InputStream inputStream = zip.getInputStream(entry);
                AccordoServizio manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAS(inputStream);
                parteSpecifica = manifesto.getParteSpecifica();
                if (parteSpecifica == null) {
                    throw new Exception("Manifest Parte Specifica non presente");
                }
                inputStream.close();
                archivio.setManifesto(manifesto);
            }
            String interfacciaPortiAccessoErogatore = "PortiAccessoErogatore.wsdl";
            String interfacciaPortiAccessoFruitore = "PortiAccessoFruitore.wsdl";
            if (parteSpecifica.getSpecificaPortiAccesso() != null) {
                SpecificaPortiAccesso portiAccesso = parteSpecifica.getSpecificaPortiAccesso();
                if (portiAccesso.getPortiAccessoErogatore() != null) {
                    interfacciaPortiAccessoErogatore = this.getBaseName(portiAccesso.getPortiAccessoErogatore().getBase());
                }
                if (portiAccesso.getPortiAccessoFruitore() != null) {
                    interfacciaPortiAccessoFruitore = this.getBaseName(portiAccesso.getPortiAccessoFruitore().getBase());
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ((rootDir + ".project").equals(entry.getName())) continue;
                if ((rootDir + "firma.xml").equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entry.getName())) continue;
                if (entry.getName().startsWith(rootDir + "specificaPortiAccesso")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    String dir = rootDir + "specificaPortiAccesso" + File.separatorChar;
                    if ((dir + interfacciaPortiAccessoErogatore).equals(entry.getName())) {
                        archivio.setPortiAccessoErogatore(d);
                        continue;
                    }
                    if (!(dir + interfacciaPortiAccessoFruitore).equals(entry.getName())) continue;
                    archivio.setPortiAccessoFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "specificaSemiformale")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addSpecificaSemiformale(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "specificaLivelliServizio")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addSpecificaLivelloServizio(d);
                    continue;
                }
                if (!entry.getName().startsWith(rootDir + "specificaSicurezza")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSicurezza(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio() != null) {
                for (int i = 0; i < archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().sizeDocumentoLivelloServizioList(); ++i) {
                    fileName = archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().getDocumentoLivelloServizio(i).getBase();
                    String tipo = archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().getDocumentoLivelloServizio(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheLivelliServizio(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaLivelloServizio(j).getNome())) continue;
                        archivio.getSpecificaLivelloServizio(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza() != null) {
                for (int i = 0; i < archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().sizeDocumentoSicurezzaList(); ++i) {
                    fileName = archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().getDocumentoSicurezza(i).getBase();
                    String tipo = archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().getDocumentoSicurezza(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSicurezza(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSicurezza(j).getNome())) continue;
                        archivio.getSpecificaSicurezza(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                this.generateAccordoServizioParteSpecifica(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                this.generateAccordoServizioParteSpecifica(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public byte[] generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoServizioParteSpecifica(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            try {
                zipOut = new ZipOutputStream(out);
                String rootDir = "";
                rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
                if (generaSICAClientProjectFile) {
                    String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_" + "aps";
                    String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop (www.openspcoop.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                    zipOut.putNextEntry(new ZipEntry(rootDir + ".project"));
                    zipOut.write(projectContenuto.getBytes());
                }
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry(rootDir + "firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAS(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
                zipOut.putNextEntry(new ZipEntry(rootDir + "manifesto.xml"));
                zipOut.write(manifestoBytes);
                boolean specificaPortiAccesso = false;
                if (manifesto.getPortiAccessoErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaPortiAccesso" + File.separatorChar + "PortiAccessoErogatore.wsdl"));
                    zipOut.write(manifesto.getPortiAccessoErogatore().getContenuto());
                    specificaPortiAccesso = true;
                }
                if (manifesto.getPortiAccessoFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaPortiAccesso" + File.separatorChar + "PortiAccessoFruitore.wsdl"));
                    zipOut.write(manifesto.getPortiAccessoFruitore().getContenuto());
                    specificaPortiAccesso = true;
                }
                if (!specificaPortiAccesso) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaPortiAccesso" + File.separatorChar));
                }
                boolean allegati = manifesto.sizeAllegati() > 0;
                for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                if (!allegati) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar));
                }
                boolean specificheLivelliServizio = manifesto.sizeSpecificheLivelliServizio() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheLivelliServizio(); ++i) {
                    Documento doc = manifesto.getSpecificaLivelloServizio(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaLivelliServizio" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheLivelliServizio) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaLivelliServizio" + File.separatorChar));
                }
                boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    Documento doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheSemiformali) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar));
                }
                boolean specificheSicurezza = manifesto.sizeSpecificheSicurezza() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheSicurezza(); ++i) {
                    Documento doc = manifesto.getSpecificaSicurezza(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSicurezza" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheSicurezza) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSicurezza" + File.separatorChar));
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var17_21 = null;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoCooperazione getAccordoCooperazione(byte[] zip) throws XMLUtilsException {
        AccordoCooperazione accordoCooperazione;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "adc");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoCooperazione = this.getAccordoCooperazione(tmp);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoCooperazione;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoCooperazione;
        tmp.delete();
        return accordoCooperazione;
    }

    public AccordoCooperazione getAccordoCooperazione(String fileName) throws XMLUtilsException {
        return this.getAccordoCooperazione(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoCooperazione getAccordoCooperazione(File zip) throws XMLUtilsException {
        AccordoCooperazione accordoCooperazione;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoCooperazione = this.getAccordoCooperazione(zipFile);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoCooperazione;
        }
        if (zipFile == null) return accordoCooperazione;
        zipFile.close();
        return accordoCooperazione;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoCooperazione getAccordoCooperazione(InputStream m) throws XMLUtilsException {
        AccordoCooperazione accordoCooperazione;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoCooperazione = this.getAccordoCooperazione(bout.toByteArray());
                Object var7_7 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoCooperazione;
        }
        if (bout == null) return accordoCooperazione;
        bout.close();
        return accordoCooperazione;
    }

    public AccordoCooperazione getAccordoCooperazione(ZipFile zip) throws XMLUtilsException {
        try {
            AccordoCooperazione archivio = new AccordoCooperazione();
            String rootDir = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ((rootDir + ".project").equals(entry.getName())) continue;
                if ((rootDir + "firma.xml").equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entry.getName())) {
                    inputStream = zip.getInputStream(entry);
                    it.gov.spcoop.sica.manifest.AccordoCooperazione manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAC(inputStream);
                    inputStream.close();
                    archivio.setManifesto(manifesto);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (!entry.getName().startsWith(rootDir + "specificaSemiformale")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    String fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoCooperazione(AccordoCooperazione manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                this.generateAccordoCooperazione(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoCooperazione(AccordoCooperazione manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                this.generateAccordoCooperazione(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public byte[] generateAccordoCooperazione(AccordoCooperazione manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoCooperazione(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoCooperazione(AccordoCooperazione manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            try {
                zipOut = new ZipOutputStream(out);
                String rootDir = "";
                rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
                if (generaSICAClientProjectFile) {
                    String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_" + "adc";
                    String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop (www.openspcoop.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                    zipOut.putNextEntry(new ZipEntry(rootDir + ".project"));
                    zipOut.write(projectContenuto.getBytes());
                }
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry(rootDir + "firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAC(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
                zipOut.putNextEntry(new ZipEntry(rootDir + "manifesto.xml"));
                zipOut.write(manifestoBytes);
                boolean allegati = manifesto.sizeAllegati() > 0;
                for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                if (!allegati) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar));
                }
                boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    Documento doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheSemiformali) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar));
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioComposto getAccordoServizioComposto(byte[] zip) throws XMLUtilsException {
        AccordoServizioComposto accordoServizioComposto;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "asc");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoServizioComposto = this.getAccordoServizioComposto(tmp);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioComposto;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoServizioComposto;
        tmp.delete();
        return accordoServizioComposto;
    }

    public AccordoServizioComposto getAccordoServizioComposto(String fileName) throws XMLUtilsException {
        return this.getAccordoServizioComposto(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioComposto getAccordoServizioComposto(File zip) throws XMLUtilsException {
        AccordoServizioComposto accordoServizioComposto;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoServizioComposto = this.getAccordoServizioComposto(zipFile);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioComposto;
        }
        if (zipFile == null) return accordoServizioComposto;
        zipFile.close();
        return accordoServizioComposto;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioComposto getAccordoServizioComposto(InputStream m) throws XMLUtilsException {
        AccordoServizioComposto accordoServizioComposto;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoServizioComposto = this.getAccordoServizioComposto(bout.toByteArray());
                Object var7_7 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioComposto;
        }
        if (bout == null) return accordoServizioComposto;
        bout.close();
        return accordoServizioComposto;
    }

    public AccordoServizioComposto getAccordoServizioComposto(ZipFile zip) throws XMLUtilsException {
        try {
            String fileName;
            AccordoServizioComposto archivio = new AccordoServizioComposto();
            String rootDir = null;
            ServizioComposto manifesto = null;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if (!(rootDir + "manifesto.xml").equals(entry.getName())) continue;
                InputStream inputStream = zip.getInputStream(entry);
                manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoSC(inputStream);
                inputStream.close();
                archivio.setManifesto(manifesto);
            }
            String interfacciaConcettuale = "InterfacciaConcettuale.wsdl";
            String interfaccialogicoErogatore = "InterfacciaLogicaErogatore.wsdl";
            String interfaccialogicoFruitore = "InterfacciaLogicaFruitore.wsdl";
            String conversazioneConcettuale = "ConversazioneConcettuale.wsbl";
            String conversazionelogicoErogatore = "ConversazioneLogicaLatoErogatore.wsbl";
            String conversazionelogicoFruitore = "ConversazioneLogicaLatoFruitore.wsbl";
            if (manifesto.getSpecificaInterfaccia() != null) {
                SpecificaInterfaccia interfaccia = manifesto.getSpecificaInterfaccia();
                if (interfaccia.getInterfacciaConcettuale() != null) {
                    interfacciaConcettuale = this.getBaseName(interfaccia.getInterfacciaConcettuale().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoErogatore() != null) {
                    interfaccialogicoErogatore = this.getBaseName(interfaccia.getInterfacciaLogicaLatoErogatore().getBase());
                }
                if (interfaccia.getInterfacciaLogicaLatoFruitore() != null) {
                    interfaccialogicoFruitore = this.getBaseName(interfaccia.getInterfacciaLogicaLatoFruitore().getBase());
                }
            }
            if (manifesto.getSpecificaConversazione() != null) {
                SpecificaConversazione conversazione = manifesto.getSpecificaConversazione();
                if (conversazione.getConversazioneConcettuale() != null) {
                    conversazioneConcettuale = this.getBaseName(conversazione.getConversazioneConcettuale().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoErogatore() != null) {
                    conversazionelogicoErogatore = this.getBaseName(conversazione.getConversazioneLogicaLatoErogatore().getBase());
                }
                if (conversazione.getConversazioneLogicaLatoFruitore() != null) {
                    conversazionelogicoFruitore = this.getBaseName(conversazione.getConversazioneLogicaLatoFruitore().getBase());
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                String dir;
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (rootDir == null) {
                    rootDir = this.getRootDir(entry.getName());
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ((rootDir + ".project").equals(entry.getName())) continue;
                if ((rootDir + "firma.xml").equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ((rootDir + "manifesto.xml").equals(entry.getName())) continue;
                if (entry.getName().startsWith(rootDir + "specificaConversazione")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaConversazione" + File.separatorChar;
                    if ((dir + conversazioneConcettuale).equals(entry.getName())) {
                        archivio.setConversazioneConcettuale(d);
                        continue;
                    }
                    if ((dir + conversazionelogicoErogatore).equals(entry.getName())) {
                        archivio.setConversazioneLogicaErogatore(d);
                        continue;
                    }
                    if (!(dir + conversazionelogicoFruitore).equals(entry.getName())) continue;
                    archivio.setConversazioneLogicaFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "specificaInterfaccia")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = rootDir + "specificaInterfaccia" + File.separatorChar;
                    if ((dir + interfacciaConcettuale).equals(entry.getName())) {
                        archivio.setInterfacciaConcettuale(d);
                        continue;
                    }
                    if ((dir + interfaccialogicoErogatore).equals(entry.getName())) {
                        archivio.setInterfacciaLogicaLatoErogatore(d);
                        continue;
                    }
                    if (!(dir + interfaccialogicoFruitore).equals(entry.getName())) continue;
                    archivio.setInterfacciaLogicaLatoFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "specificaCoordinamento")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addSpecificaCoordinamento(d);
                    continue;
                }
                if (entry.getName().startsWith(rootDir + "allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                        it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                        continue;
                    }
                    if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                    it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
                    continue;
                }
                if (!entry.getName().startsWith(rootDir + "specificaSemiformale")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
                if (it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) {
                    it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpDisabled_childUnqualified());
                    continue;
                }
                if (!it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(d.getContenuto())) continue;
                it.gov.spcoop.sica.wscp.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto(), this.sicaToOpenSPCoopContext.isInformazioniEGov_wscpEnabled_childUnqualified());
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            if (archivio.getManifesto().getSpecificaSemiformale() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaSemiformale().getDocumentoSemiformale(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                        archivio.getSpecificaSemiformale(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getSpecificaCoordinamento() != null) {
                for (int i = 0; i < archivio.getManifesto().getSpecificaCoordinamento().sizeDocumentoCoordinamentoList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaCoordinamento().getDocumentoCoordinamento(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaCoordinamento().getDocumentoCoordinamento(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheCoordinamento(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaCoordinamento(j).getNome())) continue;
                        archivio.getSpecificaCoordinamento(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioComposto(AccordoServizioComposto manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                this.generateAccordoServizioComposto(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioComposto(AccordoServizioComposto manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                this.generateAccordoServizioComposto(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public byte[] generateAccordoServizioComposto(AccordoServizioComposto manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generateAccordoServizioComposto(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateAccordoServizioComposto(AccordoServizioComposto manifesto, OutputStream out) throws XMLUtilsException {
        boolean generaSICAClientProjectFile = this.sicaToOpenSPCoopContext.isSICAClient_generaProject();
        boolean includiInfoRegistroGenerale = this.sicaToOpenSPCoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean lunghezzaNomeAccordoLimitata = this.sicaToOpenSPCoopContext.isSICAClient_nomeAccordo_32CaratteriMax();
        ZipOutputStream zipOut = null;
        try {
            try {
                zipOut = new ZipOutputStream(out);
                String rootDir = "";
                rootDir = manifesto.getManifesto().getNome() + File.separatorChar;
                if (generaSICAClientProjectFile) {
                    String nomeProgettoEclipse = manifesto.getManifesto().getNome() + "_" + "asc";
                    String projectContenuto = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n        <name>@NOME@</name>\n        <comment>Package generato tramite OpenSPCoop (www.openspcoop.org)</comment>\n        <projects>\n        </projects>\n        <buildSpec>\n                <buildCommand>\n                        <name>com.ibm.rst.sica.workbench.agreementValidator</name>\n                        <arguments>\n                        </arguments>\n                </buildCommand>\n        </buildSpec>\n        <natures>\n                <nature>com.ibm.rst.sica.workbench.natures.commonPart</nature>\n                <nature>com.ibm.rst.sica.workbench.natures.agreementProject</nature>\n        </natures>\n</projectDescription>".replace("@NOME@", nomeProgettoEclipse);
                    zipOut.putNextEntry(new ZipEntry(rootDir + ".project"));
                    zipOut.write(projectContenuto.getBytes());
                }
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry(rootDir + "firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoSC(manifesto.getManifesto(), includiInfoRegistroGenerale, lunghezzaNomeAccordoLimitata);
                zipOut.putNextEntry(new ZipEntry(rootDir + "manifesto.xml"));
                zipOut.write(manifestoBytes);
                boolean specificaInterfaccia = false;
                if (manifesto.getInterfacciaConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaConcettuale.wsdl"));
                    zipOut.write(manifesto.getInterfacciaConcettuale().getContenuto());
                    specificaInterfaccia = true;
                }
                if (manifesto.getInterfacciaLogicaLatoErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoErogatore().getContenuto());
                    specificaInterfaccia = true;
                }
                if (manifesto.getInterfacciaLogicaLatoFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoFruitore().getContenuto());
                    specificaInterfaccia = true;
                }
                if (!specificaInterfaccia) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaInterfaccia" + File.separatorChar));
                }
                boolean specificaConversazioni = false;
                if (manifesto.getConversazioneConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneConcettuale.wsbl"));
                    zipOut.write(manifesto.getConversazioneConcettuale().getContenuto());
                    specificaConversazioni = true;
                }
                if (manifesto.getConversazioneLogicaErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoErogatore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaErogatore().getContenuto());
                    specificaConversazioni = true;
                }
                if (manifesto.getConversazioneLogicaFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoFruitore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaFruitore().getContenuto());
                    specificaConversazioni = true;
                }
                if (!specificaConversazioni) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaConversazione" + File.separatorChar));
                }
                boolean specificheCoordinameno = manifesto.sizeSpecificheCoordinamento() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheCoordinamento(); ++i) {
                    Documento doc = manifesto.getSpecificaCoordinamento(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaCoordinamento" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheCoordinameno) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaCoordinamento" + File.separatorChar));
                }
                boolean allegati = manifesto.sizeAllegati() > 0;
                for (int i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                if (!allegati) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "allegati" + File.separatorChar));
                }
                boolean specificheSemiformali = manifesto.sizeSpecificheSemiformali() > 0;
                for (int i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    Documento doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                if (!specificheSemiformali) {
                    zipOut.putNextEntry(new ZipEntry(rootDir + "specificaSemiformale" + File.separatorChar));
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var17_20 = null;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }
}

