/*
 * Decompiled with CFR 0.152.
 */
package it.gov.spcoop.sica.dao.driver;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationType;
import it.cnipa.collprofiles.driver.TipiProfiliCollaborazione;
import it.gov.spcoop.sica.dao.AccordoCooperazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.dao.driver.XMLUtils;
import it.gov.spcoop.sica.manifest.AccordoServizio;
import it.gov.spcoop.sica.manifest.DocumentoConversazione;
import it.gov.spcoop.sica.manifest.DocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.DocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.DocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.DocumentoSicurezza;
import it.gov.spcoop.sica.manifest.ElencoAllegati;
import it.gov.spcoop.sica.manifest.ElencoPartecipanti;
import it.gov.spcoop.sica.manifest.ElencoServiziComponenti;
import it.gov.spcoop.sica.manifest.ElencoServiziComposti;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.SpecificaConversazione;
import it.gov.spcoop.sica.manifest.SpecificaCoordinamento;
import it.gov.spcoop.sica.manifest.SpecificaInterfaccia;
import it.gov.spcoop.sica.manifest.SpecificaLivelliServizio;
import it.gov.spcoop.sica.manifest.SpecificaPortiAccesso;
import it.gov.spcoop.sica.manifest.SpecificaSemiformale;
import it.gov.spcoop.sica.manifest.SpecificaSicurezza;
import it.gov.spcoop.sica.manifest.driver.TipiAdesione;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoConversazione;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSicurezza;
import it.gov.spcoop.sica.wscp.OperationListType;
import it.gov.spcoop.sica.wscp.ProfiloCollaborazioneEGOV;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.WSDL2Java;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziXML;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopContext;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopUtilities;
import org.openspcoop.dao.registry.wsdl.DefinitionWrapper;
import org.openspcoop.dao.registry.wsdl.WSDLUtilities;
import org.openspcoop.utils.FileSystemUtilities;
import org.openspcoop.utils.io.ZipUtilities;
import org.openspcoop.utils.xml.XSDUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientTest {
    public static final String wsdlImplementativo = "<wsdl:definitions targetNamespace=\"http://openspcoop.org/Example/service\" \nxmlns:apachesoap=\"http://xml.apache.org/xml-soap\" xmlns:service=\"http://openspcoop.org/Example/service\"\n xmlns:types=\"http://openspcoop.org/Example/types\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" >\n   \n\t<!-- Example KEYWORD -->  \n\t\n\t\t<wsdl:import namespace=\"http://openspcoop.org/Example/service\" location=\"logicoKEYWORD.wsdl\" />\n  \t\t <wsdl:binding name=\"ExampleSoapBinding\" type=\"service:Example\">\n\t\t\t<wsdlsoap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>\n\t\t\t<wsdl:operation name=\"movOneWayRequest\">\n\t\t\t\t<wsdlsoap:operation soapAction=\"Example\"/>\n\t\t\t\t<wsdl:input name=\"movOneWayRequest\">\n\t\t\t\t\t\t<wsdlsoap:body use=\"literal\"/>\n\t\t\t\t</wsdl:input>\n\t\t\t</wsdl:operation>\n\t\t</wsdl:binding>\n\n\t\t<wsdl:service name=\"ExampleService\">\n\t\t\t<wsdl:port binding=\"service:ExampleSoapBinding\" name=\"Example\">\n\t\t\t\t<wsdlsoap:address location=\"http://localhost:8080/exampleKEYWORD/service\"/>\n\t\t\t</wsdl:port>\n\t\t</wsdl:service>\n</wsdl:definitions>";

    public static SICAtoOpenSPCoopContext getContextSICAToOpenSPCoop(boolean invertiOpzioni, boolean invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione, boolean sicaClientCompatibility) throws Exception {
        SICAtoOpenSPCoopContext context = new SICAtoOpenSPCoopContext();
        if (invertiOpzioni) {
            context.setSICAClient_generaProject(!context.isSICAClient_generaProject());
            if (invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione) {
                context.setSICAClient_includiInfoRegistroGenerale(!context.isSICAClient_includiInfoRegistroGenerale());
            }
            context.setInformazioniEGov_specificaSemiformale(!context.isInformazioniEGov_specificaSemiformale());
            context.setInformazioniEGov_wscp(!context.isInformazioniEGov_wscp());
            context.setInformazioniEGov_wscpDisabled_namespaceCnipa(!context.isInformazioniEGov_wscpDisabled_namespaceCnipa());
            context.setInformazioniEGov_wscpDisabled_childUnqualified(!context.isInformazioniEGov_wscpDisabled_childUnqualified());
            context.setInformazioniEGov_wscpEnabled_childUnqualified(!context.isInformazioniEGov_wscpEnabled_childUnqualified());
            context.setInformazioniEGov_nomiSPCoop_qualified(!context.isInformazioniEGov_nomiSPCoop_qualified());
            context.setWSDL_XSD_prettyDocuments(!context.isWSDL_XSD_prettyDocuments());
            if (invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione) {
                context.setWSDL_XSD_allineaImportInclude(!context.isWSDL_XSD_allineaImportInclude());
                context.setWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune(!context.isWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune());
            }
            context.setWSDL_XSD_accordiParteSpecifica_gestioneParteComune(!context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune());
            context.setWSDL_XSD_accordiParteSpecifica_wsdlEmpty(!context.isWSDL_XSD_accordiParteSpecifica_wsdlEmpty());
            context.setWSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune(!context.isWSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune());
        }
        context.setSICAClientCompatibility(sicaClientCompatibility);
        return context;
    }

    public static void main(String[] args) {
        try {
            IDServizio[] idServiziComponenti;
            IDAccordo[] idAccordiServiziComposti;
            ServizioSpcoop asRitrasformatopenSPCoop;
            AccordoServizioParteSpecifica tmpRitrasformato;
            AccordoServizioParteSpecifica tmp;
            SoggettoSpcoop soggettoErogatore;
            org.openspcoop.dao.registry.AccordoServizio asParteComuneDaIncludere;
            String dirFiles;
            String nomeServizio;
            ServizioSpcoop s;
            IDServizio[] idServizio;
            IDAccordo[] idAccordi;
            Cloneable dichiarazioneEGov;
            Cloneable dichiarazioneEGov2;
            if (args.length < 1) {
                System.out.println("Error, java use:");
                System.out.println("\t java -classpath CLASSPATH it.gov.spcoop.sica.dao.driver.ClientTest \"example/registroServizi/registroServiziXML\" [0/1/2/SICA]");
                return;
            }
            boolean invertiOpzioni = false;
            boolean invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione = false;
            boolean sicaClientCompatibility = false;
            if (args != null && args.length > 1) {
                if ("0".equals(args[1].trim())) {
                    invertiOpzioni = false;
                } else if ("1".equals(args[1].trim())) {
                    invertiOpzioni = true;
                    invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione = true;
                } else if ("2".equals(args[1].trim())) {
                    invertiOpzioni = true;
                    invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione = false;
                } else if ("SICA".equalsIgnoreCase(args[1].trim())) {
                    sicaClientCompatibility = true;
                } else {
                    throw new Exception("Proprieta' [" + args[1].trim() + "] non gestita. (Forse volevi usare la proprieta' '0/1/2'?) ");
                }
            }
            SICAtoOpenSPCoopContext context = ClientTest.getContextSICAToOpenSPCoop(invertiOpzioni, invertireOpzioniCheCausanoFallimentoPerValidazioneETrasformazione, sicaClientCompatibility);
            String dir = args[0].trim();
            File dirRegistroServizi = new File(dir);
            if (!dirRegistroServizi.exists()) {
                throw new Exception("Directory [" + dirRegistroServizi.getAbsolutePath() + "] non esistente");
            }
            if (!dirRegistroServizi.canRead()) {
                throw new Exception("Directory [" + dirRegistroServizi.getAbsolutePath() + "] non accessibile");
            }
            Properties loggerProperties = new Properties();
            loggerProperties.load(ClientTest.class.getResourceAsStream("/logger.log4j.properties"));
            PropertyConfigurator.configure((Properties)loggerProperties);
            Logger log = Logger.getLogger((String)"openspcoop.core");
            XMLUtils xmlSICAUtilities = new XMLUtils(context);
            System.out.println("********* TEST PER FUNZIONAMENTO DRIVER **************** \n\n");
            AccordoServizioParteComune asPC = new AccordoServizioParteComune();
            AccordoServizio manAsPC = ClientTest.getManifestoAS_ParteComune(context.isInformazioniEGov_specificaSemiformale(), context.isInformazioniEGov_wscp());
            asPC.setManifesto(manAsPC);
            Documento dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            Documento dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            asPC.addAllegato(dAllegato1);
            asPC.addAllegato(dAllegato2);
            Documento dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            Documento dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            asPC.addSpecificaSemiformale(dSS1);
            asPC.addSpecificaSemiformale(dSS2);
            Documento conversazioneConcettuale = new Documento("ConversazioneConcettuale.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>concettuale</wsbl>".getBytes());
            asPC.setConversazioneConcettuale(conversazioneConcettuale);
            Documento conversazioneLogicaErogatore = new Documento("ConversazioneLogicaLatoErogatore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>erogatore</wsbl>".getBytes());
            asPC.setConversazioneLogicaErogatore(conversazioneLogicaErogatore);
            Documento conversazioneLogicaFruitore = new Documento("ConversazioneLogicaLatoFruitore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>fruitore</wsbl>".getBytes());
            asPC.setConversazioneLogicaFruitore(conversazioneLogicaFruitore);
            Documento interfacciaConcettuale = new Documento("InterfacciaConcettuale.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>concettuale</wsdl>".getBytes());
            asPC.setInterfacciaConcettuale(interfacciaConcettuale);
            Documento interfacciaLogicaErogatore = new Documento("InterfacciaLogicaErogatore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>erogatore</wsdl>".getBytes());
            asPC.setInterfacciaLogicaLatoErogatore(interfacciaLogicaErogatore);
            Documento interfacciaLogicaFruitore = new Documento("InterfacciaLogicaFruitore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>fruitore</wsdl>".getBytes());
            asPC.setInterfacciaLogicaLatoFruitore(interfacciaLogicaFruitore);
            byte[] egovBytes = null;
            String nomeFileInfoEGov = null;
            if (context.isInformazioniEGov_wscp()) {
                dichiarazioneEGov2 = ClientTest.getDichiarazioneEGovFormatoClientSICA(manAsPC.getNome());
                egovBytes = it.gov.spcoop.sica.wscp.driver.XMLUtils.generateDichiarazioneEGov(dichiarazioneEGov2, context.isInformazioniEGov_wscpEnabled_childUnqualified());
                nomeFileInfoEGov = "ProfiloDiCollaborazione.wscp";
            } else {
                dichiarazioneEGov2 = ClientTest.getDichiarazioneEGov(manAsPC.getNome());
                egovBytes = it.cnipa.collprofiles.driver.XMLUtils.generateDichiarazioneEGov((EgovDecllElement)dichiarazioneEGov2, context.isInformazioniEGov_wscpDisabled_namespaceCnipa());
                nomeFileInfoEGov = "ProfiloDiCollaborazione.xml";
            }
            Documento docModalitaEsplicitaCNIPA = new Documento(nomeFileInfoEGov, TipiDocumentoSemiformale.XML.toString(), egovBytes);
            if (context.isInformazioniEGov_specificaSemiformale()) {
                asPC.addSpecificaSemiformale(docModalitaEsplicitaCNIPA);
            } else {
                asPC.addAllegato(docModalitaEsplicitaCNIPA);
            }
            Documento dAllegatoDEFINITORIO = new Documento("InterfacciaDefinitoria.xsd", "XSD", "<xsd>DEFINITORIO</xsd>".getBytes());
            asPC.addAllegato(dAllegatoDEFINITORIO);
            String fileName = "package.apc";
            xmlSICAUtilities.generateAccordoServizioParteComune(asPC, fileName);
            AccordoServizioParteComune asParteComune = xmlSICAUtilities.getAccordoServizioParteComune(fileName);
            org.openspcoop.dao.registry.AccordoServizio asParteComuneOpenSPCoop = SICAtoOpenSPCoopUtilities.accordoServizioParteComune_sicaToOpenspcoop(asParteComune, context);
            ClientTest.printAccordoServizio(log, asParteComuneOpenSPCoop, false, false);
            AccordoServizioParteSpecifica asPS = new AccordoServizioParteSpecifica();
            AccordoServizio manAsPS = ClientTest.getManifestoAS_ParteSpecifica();
            asPS.setManifesto(manAsPS);
            dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            asPS.addAllegato(dAllegato1);
            asPS.addAllegato(dAllegato2);
            dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            asPS.addSpecificaSemiformale(dSS1);
            asPS.addSpecificaSemiformale(dSS2);
            Documento portiAccessoErogatore = new Documento("PortiAccessoErogatore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), wsdlImplementativo.replaceAll("KEYWORD", "EROGATORE").getBytes());
            asPS.setPortiAccessoErogatore(portiAccessoErogatore);
            Documento portiAccessoFruitore = new Documento("PortiAccessoFruitore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), wsdlImplementativo.replaceAll("KEYWORD", "FRUITORE").getBytes());
            asPS.setPortiAccessoFruitore(portiAccessoFruitore);
            Documento servizioMinimo = new Documento("LivelloServizioMinimo.wsla", TipiDocumentoLivelloServizio.WSLA.toString(), "<sla>minimo</sla>".getBytes());
            asPS.addSpecificaLivelloServizio(servizioMinimo);
            Documento servizioMax = new Documento("LivelloServizioOttimale.wsla", TipiDocumentoLivelloServizio.WSLA.toString(), "<sla>max</sla>".getBytes());
            asPS.addSpecificaLivelloServizio(servizioMax);
            Documento sicurezza1 = new Documento("SicurezzaDelCanale.wspolicy", TipiDocumentoSicurezza.WSPOLICY.toString(), "<sec>wss</sec>".getBytes());
            asPS.addSpecificaSicurezza(sicurezza1);
            Documento sicurezza2 = new Documento("LineeGuida.doc", TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString(), "LINEE GUIDA".getBytes());
            asPS.addSpecificaSicurezza(sicurezza2);
            fileName = "package.aps";
            xmlSICAUtilities.generateAccordoServizioParteSpecifica(asPS, fileName);
            AccordoServizioParteSpecifica asParteSpecifica = xmlSICAUtilities.getAccordoServizioParteSpecifica(fileName);
            ServizioSpcoop asParteSpecificaOpenSPCoop = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_sicaToOpenspcoop(asParteSpecifica, context);
            ClientTest.printAccordoServizioParteSpecifica(log, asParteSpecificaOpenSPCoop, false);
            fileName = "package2.aps";
            asPS.getManifesto().setNome(asPS.getManifesto().getNome() + "2");
            xmlSICAUtilities.generateAccordoServizioParteSpecifica(asPS, fileName);
            AccordoCooperazione ac = new AccordoCooperazione();
            ac.setManifesto(ClientTest.getManifestoAC());
            dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            ac.addAllegato(dAllegato1);
            ac.addAllegato(dAllegato2);
            dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            ac.addSpecificaSemiformale(dSS1);
            ac.addSpecificaSemiformale(dSS2);
            fileName = "package.adc";
            xmlSICAUtilities.generateAccordoCooperazione(ac, fileName);
            AccordoCooperazione acSICA = xmlSICAUtilities.getAccordoCooperazione(fileName);
            org.openspcoop.dao.registry.AccordoCooperazione acOpenSPCoop = SICAtoOpenSPCoopUtilities.accordoCooperazione_sicaToOpenspcoop(acSICA, context);
            ClientTest.printAccordoCooperazione(acOpenSPCoop);
            AccordoServizioComposto aSC = new AccordoServizioComposto();
            ServizioComposto manASC = ClientTest.getManifestoASComposto(context.isInformazioniEGov_specificaSemiformale(), context.isInformazioniEGov_wscp());
            aSC.setManifesto(manASC);
            dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            aSC.addAllegato(dAllegato1);
            aSC.addAllegato(dAllegato2);
            dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            aSC.addSpecificaSemiformale(dSS1);
            aSC.addSpecificaSemiformale(dSS2);
            conversazioneConcettuale = new Documento("ConversazioneConcettuale.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>concettuale</wsbl>".getBytes());
            aSC.setConversazioneConcettuale(conversazioneConcettuale);
            conversazioneLogicaErogatore = new Documento("ConversazioneLogicaLatoErogatore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>erogatore</wsbl>".getBytes());
            aSC.setConversazioneLogicaErogatore(conversazioneLogicaErogatore);
            conversazioneLogicaFruitore = new Documento("ConversazioneLogicaLatoFruitore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>fruitore</wsbl>".getBytes());
            aSC.setConversazioneLogicaFruitore(conversazioneLogicaFruitore);
            interfacciaConcettuale = new Documento("InterfacciaConcettuale.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>concettuale</wsdl>".getBytes());
            aSC.setInterfacciaConcettuale(interfacciaConcettuale);
            interfacciaLogicaErogatore = new Documento("InterfacciaLogicaErogatore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>erogatore</wsdl>".getBytes());
            aSC.setInterfacciaLogicaLatoErogatore(interfacciaLogicaErogatore);
            interfacciaLogicaFruitore = new Documento("InterfacciaLogicaFruitore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>fruitore</wsdl>".getBytes());
            aSC.setInterfacciaLogicaLatoFruitore(interfacciaLogicaFruitore);
            Documento specificaCoordinamento = new Documento("Generica Orchestrazione.bpel", TipiDocumentoCoordinamento.BPEL.toString(), "<bpel>coordinamento</bpel>".getBytes());
            aSC.addSpecificaCoordinamento(specificaCoordinamento);
            Documento specificaCoordinamento2 = new Documento("Generica Orchestrazione.wscdl", TipiDocumentoCoordinamento.WSCDL.toString(), "<wscdl>coordinamento</wscdl>".getBytes());
            aSC.addSpecificaCoordinamento(specificaCoordinamento2);
            byte[] egovBytesServizioComposto = null;
            String nomeFileInfoEGovServizioComposto = null;
            if (context.isInformazioniEGov_wscp()) {
                dichiarazioneEGov = ClientTest.getDichiarazioneEGovFormatoClientSICA(manAsPC.getNome());
                egovBytesServizioComposto = it.gov.spcoop.sica.wscp.driver.XMLUtils.generateDichiarazioneEGov(dichiarazioneEGov, context.isInformazioniEGov_wscpEnabled_childUnqualified());
                nomeFileInfoEGovServizioComposto = "ProfiloDiCollaborazione.wscp";
            } else {
                dichiarazioneEGov = ClientTest.getDichiarazioneEGov(manAsPC.getNome());
                egovBytesServizioComposto = it.cnipa.collprofiles.driver.XMLUtils.generateDichiarazioneEGov((EgovDecllElement)dichiarazioneEGov, context.isInformazioniEGov_wscpDisabled_namespaceCnipa());
                nomeFileInfoEGovServizioComposto = "ProfiloDiCollaborazione.xml";
            }
            Documento docModalitaEsplicitaCNIPAServizioComposto = new Documento(nomeFileInfoEGovServizioComposto, TipiDocumentoSemiformale.XML.toString(), egovBytesServizioComposto);
            if (context.isInformazioniEGov_specificaSemiformale()) {
                aSC.addSpecificaSemiformale(docModalitaEsplicitaCNIPAServizioComposto);
            } else {
                aSC.addAllegato(docModalitaEsplicitaCNIPAServizioComposto);
            }
            dAllegatoDEFINITORIO = new Documento("InterfacciaDefinitoria.xsd", "XSD", "<xsd>DEFINITORIO</xsd>".getBytes());
            aSC.addAllegato(dAllegatoDEFINITORIO);
            fileName = "package.asc";
            xmlSICAUtilities.generateAccordoServizioComposto(aSC, fileName);
            AccordoServizioComposto asComposto = xmlSICAUtilities.getAccordoServizioComposto(fileName);
            context.addMappingServizioSPCoopToUriAPS(new IDServizio("SPC", "SoggettoEsempio", "SPC", "ASParteSpecifica"), IDAccordo.getIDAccordoFromValues("ASParteSpecifica", new IDSoggetto("SPC", "SoggettoEsempio"), "2"));
            context.addMappingServizioSPCoopToUriAPS(new IDServizio("SPC", "SoggettoEsempio", "SPC", "ASParteSpecifica2"), IDAccordo.getIDAccordoFromValues("ASParteSpecifica2", new IDSoggetto("SPC", "SoggettoEsempio"), "2"));
            org.openspcoop.dao.registry.AccordoServizio asCompostoOpenSPCoop = SICAtoOpenSPCoopUtilities.accordoServizioComposto_sicaToOpenspcoop(asComposto, context);
            ClientTest.printAccordoServizio(log, asCompostoOpenSPCoop, false, true);
            System.out.println("\n\n\n********* SCENARIO REALE AS PARTE COMUNE E SPECIFICA **************** \n\n");
            DriverRegistroServiziXML driverRegistroServiziASParteComuneESpecificaXML = new DriverRegistroServiziXML(dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiServizio" + File.separatorChar + "registroServizi.xml", null);
            if (!driverRegistroServiziASParteComuneESpecificaXML.create) {
                throw new Exception("RegistroServiziXML non istanziato");
            }
            String DIR_ESEMPI_AS = "ESEMPI_PACKAGE_AS";
            File fDIR_ESEMPI_AS = new File(DIR_ESEMPI_AS);
            if (!fDIR_ESEMPI_AS.exists()) {
                if (!fDIR_ESEMPI_AS.mkdir()) {
                    throw new Exception("Creazione directory " + fDIR_ESEMPI_AS.getAbsolutePath() + " non riuscita");
                }
            } else {
                FileSystemUtilities.deleteDir(fDIR_ESEMPI_AS.getAbsolutePath());
                if (!fDIR_ESEMPI_AS.mkdir()) {
                    throw new Exception("Creazione directory " + fDIR_ESEMPI_AS.getAbsolutePath() + " non riuscita");
                }
            }
            if ((idAccordi = driverRegistroServiziASParteComuneESpecificaXML.getAllIdAccordiServizio(null)) != null) {
                for (int i = 0; i < idAccordi.length; ++i) {
                    org.openspcoop.dao.registry.AccordoServizio as = driverRegistroServiziASParteComuneESpecificaXML.getAccordoServizio(idAccordi[i]);
                    String nomeFile = IDAccordo.getUriFromIDAccordo(idAccordi[i]).replace(":", "_") + "." + "apc";
                    nomeFile = nomeFile.replace("/", "");
                    nomeFile = DIR_ESEMPI_AS + File.separatorChar + nomeFile;
                    String dirFiles2 = dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiServizio" + File.separatorChar;
                    boolean servizioComposto = false;
                    ClientTest.normalizzaPackageCNIPA(as, dirFiles2, servizioComposto);
                    AccordoServizioParteComune tmp2 = SICAtoOpenSPCoopUtilities.accordoServizioParteComune_openspcoopToSica(as, context);
                    if (tmp2 == null) {
                        throw new Exception("AccordoServizioParteComune [" + idAccordi[i] + "] non generato in formato CNIPA?");
                    }
                    xmlSICAUtilities.generateAccordoServizioParteComune(tmp2, nomeFile);
                    if (context.isWSDL_XSD_allineaImportInclude()) {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Accordo di Servizio [" + IDAccordo.getUriFromAccordo(as) + "] verifica WSDL");
                        ClientTest.verificaAccordoServizio(nomeFile, as);
                        System.out.println("------------------------------------------------------------------------------------------------");
                    } else {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Accordo di Servizio [" + IDAccordo.getUriFromAccordo(as) + "] verifica WSDL non attuata poiche' non vi e' abilitata l'opzione 'WSDL_XSD.allineaImportInclude'");
                        System.out.println("------------------------------------------------------------------------------------------------");
                    }
                    if (context.isSICAClient_includiInfoRegistroGenerale()) {
                        AccordoServizioParteComune tmpRitrasformato2 = xmlSICAUtilities.getAccordoServizioParteComune(nomeFile);
                        org.openspcoop.dao.registry.AccordoServizio asRitrasformatopenSPCoop2 = SICAtoOpenSPCoopUtilities.accordoServizioParteComune_sicaToOpenspcoop(tmpRitrasformato2, context);
                        ClientTest.printAccordoServizio(log, asRitrasformatopenSPCoop2, true, false);
                        continue;
                    }
                    System.out.println("------------------------------------------------------------------------------------------------");
                    System.out.println("Accordo di Servizio [" + IDAccordo.getUriFromAccordo(as) + "] non ritrasformato in oggetto openspcoop, poiche' mancano le informazioni del registro SICA Generale (es. Soggetto Referente)");
                    System.out.println("------------------------------------------------------------------------------------------------");
                }
            }
            if ((idServizio = driverRegistroServiziASParteComuneESpecificaXML.getAllIdServizi(null)) != null) {
                for (int i = 0; i < idServizio.length; ++i) {
                    s = driverRegistroServiziASParteComuneESpecificaXML.getServizio(idServizio[i]);
                    nomeServizio = s.getTipoSoggettoErogatore() + s.getNomeSoggettoErogatore() + "_" + s.getTipo() + s.getNome();
                    String nomeFile = nomeServizio + "." + "aps";
                    nomeFile = nomeFile.replace("/", "");
                    nomeFile = DIR_ESEMPI_AS + File.separatorChar + nomeFile;
                    dirFiles = dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiServizio" + File.separatorChar;
                    boolean implementazioneServizioComposto = false;
                    asParteComuneDaIncludere = null;
                    if (context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune() && (asParteComuneDaIncludere = driverRegistroServiziASParteComuneESpecificaXML.getAccordoServizio(IDAccordo.getIDAccordoFromUri(s.getAccordoServizio()))) == null) {
                        throw new Exception("Accordo di servizio parte comune [" + s.getAccordoServizio() + "] per il Servizio SPCoop [" + nomeServizio + "] non trovata sul Registro dei Servizi");
                    }
                    soggettoErogatore = driverRegistroServiziASParteComuneESpecificaXML.getSoggettoRegistro(new IDSoggetto(s.getTipoSoggettoErogatore(), s.getNomeSoggettoErogatore()));
                    if (soggettoErogatore == null) {
                        throw new Exception("Soggetto erogatore [" + s.getTipoSoggettoErogatore() + "/" + s.getNomeSoggettoErogatore() + "] per il Servizio SPCoop [" + nomeServizio + "] non trovato sul Registro dei Servizi");
                    }
                    ClientTest.normalizzaPackageCNIPA(s, dirFiles, soggettoErogatore.getConnettore());
                    tmp = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_openspcoopToSica(s, implementazioneServizioComposto, asParteComuneDaIncludere, context);
                    if (tmp == null) {
                        throw new Exception("AccordoServizioParteSpecifica [" + idAccordi[i] + "] non generato in formato CNIPA?");
                    }
                    xmlSICAUtilities.generateAccordoServizioParteSpecifica(tmp, nomeFile);
                    if (context.isWSDL_XSD_allineaImportInclude() && (!context.isWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune() || context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune())) {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Servizio SPCoop [" + nomeServizio + "] verifica WSDL");
                        ClientTest.verificaAccordoServizioParteSpecifica(nomeFile, s, context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune(), DIR_ESEMPI_AS, false);
                        System.out.println("------------------------------------------------------------------------------------------------");
                    } else {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        if (!context.isWSDL_XSD_allineaImportInclude()) {
                            System.out.println("Servizio SPCoop [" + nomeServizio + "] verifica WSDL non attuata poiche' non vi e' abilitata l'opzione 'WSDL_XSD.allineaImportInclude'");
                        } else {
                            System.out.println("Servizio SPCoop [" + nomeServizio + "] verifica WSDL non attuata poiche'  vi e' sia abilitata l'opzione 'WSDL_XSD.accordiParteSpecifica.openspcoopToSica.eliminazioneImportParteComune' che disabilitata l'opzione 'WSDL_XSD.accordiParteSpecifica.gestioneParteComune'");
                        }
                        System.out.println("------------------------------------------------------------------------------------------------");
                    }
                    if (context.isSICAClient_includiInfoRegistroGenerale()) {
                        tmpRitrasformato = xmlSICAUtilities.getAccordoServizioParteSpecifica(nomeFile);
                        asRitrasformatopenSPCoop = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_sicaToOpenspcoop(tmpRitrasformato, context);
                        ClientTest.printAccordoServizioParteSpecifica(log, asRitrasformatopenSPCoop, true);
                        continue;
                    }
                    System.out.println("------------------------------------------------------------------------------------------------");
                    System.out.println("Servizio SPCoop [" + nomeServizio + "] non ritrasformato in oggetto openspcoop, poiche' mancano le informazioni del registro SICA Generale (es. Soggetto Referente)");
                    System.out.println("------------------------------------------------------------------------------------------------");
                }
            }
            if ((idServizio = driverRegistroServiziASParteComuneESpecificaXML.getAllIdServiziCorrelati(null)) != null) {
                for (int i = 0; i < idServizio.length; ++i) {
                    s = driverRegistroServiziASParteComuneESpecificaXML.getServizioCorrelato(idServizio[i]);
                    nomeServizio = s.getTipoSoggettoErogatore() + s.getNomeSoggettoErogatore() + "_" + s.getTipo() + s.getNome();
                    String nomeFile = nomeServizio + "." + "aps";
                    nomeFile = nomeFile.replace("/", "");
                    nomeFile = DIR_ESEMPI_AS + File.separatorChar + nomeFile;
                    dirFiles = dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiServizio" + File.separatorChar;
                    boolean implementazioneServizioComposto = false;
                    asParteComuneDaIncludere = null;
                    if (context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune() && (asParteComuneDaIncludere = driverRegistroServiziASParteComuneESpecificaXML.getAccordoServizio(IDAccordo.getIDAccordoFromUri(s.getAccordoServizio()))) == null) {
                        throw new Exception("Accordo di servizio parte comune [" + s.getAccordoServizio() + "] per il Servizio SPCoop [" + nomeServizio + "] non trovata sul Registro dei Servizi");
                    }
                    soggettoErogatore = driverRegistroServiziASParteComuneESpecificaXML.getSoggettoRegistro(new IDSoggetto(s.getTipoSoggettoErogatore(), s.getNomeSoggettoErogatore()));
                    if (soggettoErogatore == null) {
                        throw new Exception("Soggetto erogatore [" + s.getTipoSoggettoErogatore() + "/" + s.getNomeSoggettoErogatore() + "] per il Servizio SPCoop [" + nomeServizio + "] non trovato sul Registro dei Servizi");
                    }
                    ClientTest.normalizzaPackageCNIPA(s, dirFiles, soggettoErogatore.getConnettore());
                    tmp = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_openspcoopToSica(s, implementazioneServizioComposto, asParteComuneDaIncludere, context);
                    if (tmp == null) {
                        throw new Exception("AccordoServizioParteSpecifica [" + idAccordi[i] + "] non generato in formato CNIPA?");
                    }
                    xmlSICAUtilities.generateAccordoServizioParteSpecifica(tmp, nomeFile);
                    if (context.isWSDL_XSD_allineaImportInclude() && (!context.isWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune() || context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune())) {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Servizio SPCoop Correlato [" + nomeServizio + "] verifica WSDL");
                        ClientTest.verificaAccordoServizioParteSpecifica(nomeFile, s, context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune(), DIR_ESEMPI_AS, false);
                        System.out.println("------------------------------------------------------------------------------------------------");
                    } else {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        if (!context.isWSDL_XSD_allineaImportInclude()) {
                            System.out.println("Servizio SPCoop Correlato [" + nomeServizio + "] verifica WSDL non attuata poiche' non vi e' abilitata l'opzione 'WSDL_XSD.allineaImportInclude'");
                        } else {
                            System.out.println("Servizio SPCoop Correlato [" + nomeServizio + "] verifica WSDL non attuata poiche'  vi e' sia abilitata l'opzione 'WSDL_XSD.accordiParteSpecifica.openspcoopToSica.eliminazioneImportParteComune' che disabilitata l'opzione 'WSDL_XSD.accordiParteSpecifica.gestioneParteComune'");
                        }
                        System.out.println("------------------------------------------------------------------------------------------------");
                    }
                    if (context.isSICAClient_includiInfoRegistroGenerale()) {
                        tmpRitrasformato = xmlSICAUtilities.getAccordoServizioParteSpecifica(nomeFile);
                        asRitrasformatopenSPCoop = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_sicaToOpenspcoop(tmpRitrasformato, context);
                        ClientTest.printAccordoServizioParteSpecifica(log, asRitrasformatopenSPCoop, true);
                        continue;
                    }
                    System.out.println("------------------------------------------------------------------------------------------------");
                    System.out.println("Servizio SPCoop Correlato [" + nomeServizio + "] non ritrasformato in oggetto openspcoop, poiche' mancano le informazioni del registro SICA Generale (es. Soggetto Referente)");
                    System.out.println("------------------------------------------------------------------------------------------------");
                }
            }
            System.out.println("\n\n\n********* SCENARIO REALE AS SERVIZI COMPOSTI E ACCORDI DI COOPERAZIONE **************** \n\n");
            DriverRegistroServiziXML driverRegistroServiziASCompostiEACooperazioneXML = new DriverRegistroServiziXML(dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiCooperazione" + File.separatorChar + "registroServizi.xml", null);
            if (!driverRegistroServiziASCompostiEACooperazioneXML.create) {
                throw new Exception("RegistroServiziXML non istanziato");
            }
            String DIR_ESEMPI_AC = "ESEMPI_PACKAGE_AC";
            File fDIR_ESEMPI_AC = new File(DIR_ESEMPI_AC);
            if (!fDIR_ESEMPI_AC.exists()) {
                if (!fDIR_ESEMPI_AC.mkdir()) {
                    throw new Exception("Creazione directory " + fDIR_ESEMPI_AC.getAbsolutePath() + " non riuscita");
                }
            } else {
                FileSystemUtilities.deleteDir(fDIR_ESEMPI_AC.getAbsolutePath());
                if (!fDIR_ESEMPI_AC.mkdir()) {
                    throw new Exception("Creazione directory " + fDIR_ESEMPI_AC.getAbsolutePath() + " non riuscita");
                }
            }
            String nomeFileTMP = "SPCMinisteroReferente_EsempioASParteComune_1.apc";
            String nomeFileAS = DIR_ESEMPI_AS + File.separatorChar + nomeFileTMP;
            String nomeFileAC = DIR_ESEMPI_AC + File.separatorChar + nomeFileTMP;
            FileSystemUtilities.copy(nomeFileAS, nomeFileAC);
            IDAccordoCooperazione[] idAccordiCooperazione = driverRegistroServiziASCompostiEACooperazioneXML.getAllIdAccordiCooperazione(null);
            if (idAccordiCooperazione != null) {
                for (int i = 0; i < idAccordiCooperazione.length; ++i) {
                    org.openspcoop.dao.registry.AccordoCooperazione acoop = driverRegistroServiziASCompostiEACooperazioneXML.getAccordoCooperazione(idAccordiCooperazione[i]);
                    String nomeFile = IDAccordoCooperazione.getUriFromIDAccordo(idAccordiCooperazione[i]).replace(":", "_") + "." + "adc";
                    nomeFile = nomeFile.replace("/", "");
                    nomeFile = DIR_ESEMPI_AC + File.separatorChar + nomeFile;
                    String dirFiles3 = dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiCooperazione" + File.separatorChar;
                    ClientTest.normalizzaPackageCNIPA(acoop, dirFiles3);
                    AccordoCooperazione tmp3 = SICAtoOpenSPCoopUtilities.accordoCooperazione_openspcoopToSica(acoop, context);
                    if (tmp3 == null) {
                        throw new Exception("AccordoCooperazione [" + idAccordiCooperazione[i] + "] non generato in formato CNIPA?");
                    }
                    xmlSICAUtilities.generateAccordoCooperazione(tmp3, nomeFile);
                    if (context.isSICAClient_includiInfoRegistroGenerale()) {
                        AccordoCooperazione tmpRitrasformato3 = xmlSICAUtilities.getAccordoCooperazione(nomeFile);
                        org.openspcoop.dao.registry.AccordoCooperazione acRitrasformatopenSPCoop = SICAtoOpenSPCoopUtilities.accordoCooperazione_sicaToOpenspcoop(tmpRitrasformato3, context);
                        ClientTest.printAccordoCooperazione(acRitrasformatopenSPCoop);
                        continue;
                    }
                    System.out.println("------------------------------------------------------------------------------------------------");
                    System.out.println("Accordo di Cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(acoop) + "] non ritrasformato in oggetto openspcoop, poiche' mancano le informazioni del registro SICA Generale (es. Soggetto Referente)");
                    System.out.println("------------------------------------------------------------------------------------------------");
                }
            }
            if ((idAccordiServiziComposti = driverRegistroServiziASCompostiEACooperazioneXML.getAllIdAccordiServizio(null)) != null) {
                for (int i = 0; i < idAccordiServiziComposti.length; ++i) {
                    org.openspcoop.dao.registry.AccordoServizio as = driverRegistroServiziASCompostiEACooperazioneXML.getAccordoServizio(idAccordiServiziComposti[i]);
                    if (as.getServizioComposto() == null) {
                        throw new Exception("Accordo di servizio Composto [" + idAccordiServiziComposti[i].toString() + "] non e' un accordo di servizio composto");
                    }
                    String nomeFile = IDAccordo.getUriFromIDAccordo(idAccordiServiziComposti[i]).replace(":", "_") + "." + "asc";
                    nomeFile = nomeFile.replace("/", "");
                    nomeFile = DIR_ESEMPI_AC + File.separatorChar + nomeFile;
                    String dirFiles4 = dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiCooperazione" + File.separatorChar;
                    boolean servizioComposto = true;
                    if (as.getServizioComposto() != null) {
                        for (int j = 0; j < as.getServizioComposto().sizeServizioComponenteList(); ++j) {
                            AccordoServizioServizioCompostoServizioComponente sc = as.getServizioComposto().getServizioComponente(j);
                            IDServizio idServizioComponente = new IDServizio(sc.getTipoSoggetto(), sc.getNomeSoggetto(), sc.getTipo(), sc.getNome());
                            ServizioSpcoop servComponente = driverRegistroServiziASCompostiEACooperazioneXML.getServizio(idServizioComponente);
                            IDAccordo idAccordoParteSpecifica = IDAccordo.getIDAccordoFromValues(servComponente.getAccordoParteSpecifica().getNome(), idServizioComponente.getSoggettoErogatore(), servComponente.getAccordoParteSpecifica().getVersione());
                            context.addMappingServizioSPCoopToUriAPS(idServizioComponente, idAccordoParteSpecifica);
                        }
                    }
                    ClientTest.normalizzaPackageCNIPA(as, dirFiles4, servizioComposto);
                    AccordoServizioComposto tmp4 = SICAtoOpenSPCoopUtilities.accordoServizioComposto_openspcoopToSica(as, context);
                    if (tmp4 == null) {
                        throw new Exception("AccordoServizioComposto [" + idAccordiServiziComposti[i] + "] non generato in formato CNIPA?");
                    }
                    xmlSICAUtilities.generateAccordoServizioComposto(tmp4, nomeFile);
                    if (context.isWSDL_XSD_allineaImportInclude()) {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Accordo di Servizio Composto  [" + IDAccordo.getUriFromAccordo(as) + "] verifica WSDL");
                        ClientTest.verificaAccordoServizio(nomeFile, as);
                        System.out.println("------------------------------------------------------------------------------------------------");
                    } else {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Accordo di Servizio Composto [" + IDAccordo.getUriFromAccordo(as) + "] verifica WSDL non attuata poiche' non vi e' abilitata l'opzione 'WSDL_XSD.allineaImportInclude'");
                        System.out.println("------------------------------------------------------------------------------------------------");
                    }
                    if (context.isSICAClient_includiInfoRegistroGenerale()) {
                        AccordoServizioComposto tmpRitrasformato4 = xmlSICAUtilities.getAccordoServizioComposto(nomeFile);
                        org.openspcoop.dao.registry.AccordoServizio asRitrasformatopenSPCoop3 = SICAtoOpenSPCoopUtilities.accordoServizioComposto_sicaToOpenspcoop(tmpRitrasformato4, context);
                        ClientTest.printAccordoServizio(log, asRitrasformatopenSPCoop3, true, true);
                        continue;
                    }
                    System.out.println("------------------------------------------------------------------------------------------------");
                    System.out.println("Accordo di Servizio [" + IDAccordo.getUriFromAccordo(as) + "] non ritrasformato in oggetto openspcoop, poiche' mancano le informazioni del registro SICA Generale (es. Soggetto Referente)");
                    System.out.println("------------------------------------------------------------------------------------------------");
                }
            }
            if ((idServiziComponenti = driverRegistroServiziASCompostiEACooperazioneXML.getAllIdServizi(null)) != null) {
                for (int i = 0; i < idServiziComponenti.length; ++i) {
                    ServizioSpcoop s2 = driverRegistroServiziASCompostiEACooperazioneXML.getServizio(idServiziComponenti[i]);
                    String nomeServizio2 = s2.getTipoSoggettoErogatore() + s2.getNomeSoggettoErogatore() + "_" + s2.getTipo() + s2.getNome();
                    String nomeFile = nomeServizio2 + "." + "aps";
                    nomeFile = nomeFile.replace("/", "");
                    nomeFile = DIR_ESEMPI_AC + File.separatorChar + nomeFile;
                    String dirFiles5 = dirRegistroServizi.getAbsolutePath() + File.separatorChar + "accordiCooperazione" + File.separatorChar;
                    boolean implementazioneServizioComposto = "EsempioServizioComposto".equals(s2.getNome());
                    org.openspcoop.dao.registry.AccordoServizio asParteComuneDaIncludere2 = null;
                    if (context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune() && (asParteComuneDaIncludere2 = "EsempioServizioComposto".equals(s2.getNome()) ? driverRegistroServiziASCompostiEACooperazioneXML.getAccordoServizio(IDAccordo.getIDAccordoFromUri(s2.getAccordoServizio())) : driverRegistroServiziASParteComuneESpecificaXML.getAccordoServizio(IDAccordo.getIDAccordoFromUri(s2.getAccordoServizio()))) == null) {
                        throw new Exception("Accordo di servizio parte comune [" + s2.getAccordoServizio() + "] per il Servizio SPCoop [" + nomeServizio2 + "] non trovata sul Registro dei Servizi");
                    }
                    SoggettoSpcoop soggettoErogatore2 = driverRegistroServiziASCompostiEACooperazioneXML.getSoggettoRegistro(new IDSoggetto(s2.getTipoSoggettoErogatore(), s2.getNomeSoggettoErogatore()));
                    if (soggettoErogatore2 == null) {
                        throw new Exception("Soggetto erogatore [" + s2.getTipoSoggettoErogatore() + "/" + s2.getNomeSoggettoErogatore() + "] per il Servizio SPCoop [" + nomeServizio2 + "] non trovato sul Registro dei Servizi");
                    }
                    ClientTest.normalizzaPackageCNIPA(s2, dirFiles5, soggettoErogatore2.getConnettore());
                    AccordoServizioParteSpecifica tmp5 = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_openspcoopToSica(s2, implementazioneServizioComposto, asParteComuneDaIncludere2, context);
                    if (tmp5 == null) {
                        throw new Exception("AccordoServizioParteSpecifica [" + idAccordi[i] + "] non generato in formato CNIPA?");
                    }
                    xmlSICAUtilities.generateAccordoServizioParteSpecifica(tmp5, nomeFile);
                    if (context.isWSDL_XSD_allineaImportInclude() && (!context.isWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune() || context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune())) {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        System.out.println("Servizio SPCoop [" + nomeServizio2 + "] verifica WSDL");
                        ClientTest.verificaAccordoServizioParteSpecifica(nomeFile, s2, context.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune(), DIR_ESEMPI_AC, implementazioneServizioComposto);
                        System.out.println("------------------------------------------------------------------------------------------------");
                    } else {
                        System.out.println("------------------------------------------------------------------------------------------------");
                        if (!context.isWSDL_XSD_allineaImportInclude()) {
                            System.out.println("Servizio SPCoop [" + nomeServizio2 + "] verifica WSDL non attuata poiche' non vi e' abilitata l'opzione 'WSDL_XSD.allineaImportInclude'");
                        } else {
                            System.out.println("Servizio SPCoop [" + nomeServizio2 + "] verifica WSDL non attuata poiche'  vi e' sia abilitata l'opzione 'WSDL_XSD.accordiParteSpecifica.openspcoopToSica.eliminazioneImportParteComune' che disabilitata l'opzione 'WSDL_XSD.accordiParteSpecifica.gestioneParteComune'");
                        }
                        System.out.println("------------------------------------------------------------------------------------------------");
                    }
                    if (context.isSICAClient_includiInfoRegistroGenerale()) {
                        AccordoServizioParteSpecifica tmpRitrasformato5 = xmlSICAUtilities.getAccordoServizioParteSpecifica(nomeFile);
                        ServizioSpcoop asRitrasformatopenSPCoop4 = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_sicaToOpenspcoop(tmpRitrasformato5, context);
                        ClientTest.printAccordoServizioParteSpecifica(log, asRitrasformatopenSPCoop4, true);
                        continue;
                    }
                    System.out.println("------------------------------------------------------------------------------------------------");
                    System.out.println("Servizio SPCoop [" + nomeServizio2 + "] non ritrasformato in oggetto openspcoop, poiche' mancano le informazioni del registro SICA Generale (es. Soggetto Referente)");
                    System.out.println("------------------------------------------------------------------------------------------------");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private static void printImportFromWSDL(Logger log, byte[] doc) throws Exception {
        if (org.openspcoop.utils.xml.XMLUtils.isDocument(doc)) {
            Document d = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            List<Node> imports = WSDLUtilities.readImports(d);
            for (int i = 0; i < imports.size(); ++i) {
                Node n = imports.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = WSDLUtilities.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String location = null;
                try {
                    location = WSDLUtilities.getImportLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("\t\t  Import namespace=\"" + namespaceImport + "\" location=\"" + location + "\"");
            }
        }
    }

    private static void printImportIntoTypesFromWSDL(Logger log, byte[] doc) throws Exception {
        if (org.openspcoop.utils.xml.XMLUtils.isDocument(doc)) {
            Document d = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            List<Node> imports = WSDLUtilities.readImportsSchemaIntoTypes(d);
            for (int i = 0; i < imports.size(); ++i) {
                Node n = imports.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = XSDUtils.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String location = null;
                try {
                    location = XSDUtils.getImportSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("\t\t  Import (types.schema) namespace=\"" + namespaceImport + "\" schemaLocation=\"" + location + "\"");
            }
        }
    }

    private static void printIncludeIntoTypesFromWSDL(Logger log, byte[] doc) throws Exception {
        if (org.openspcoop.utils.xml.XMLUtils.isDocument(doc)) {
            Document d = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            List<Node> include = WSDLUtilities.readIncludesSchemaIntoTypes(d);
            for (int i = 0; i < include.size(); ++i) {
                Node n = include.get(i);
                String location = null;
                try {
                    location = XSDUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("\t\t  Include (types.schema) schemaLocation=\"" + location + "\"");
            }
        }
    }

    private static void printImportFromXSD(Logger log, byte[] doc) throws Exception {
        if (org.openspcoop.utils.xml.XMLUtils.isDocument(doc)) {
            Document d = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            List<Node> imports = XSDUtils.readImports(d);
            for (int i = 0; i < imports.size(); ++i) {
                Node n = imports.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = XSDUtils.getImportNamespace(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String location = null;
                try {
                    location = XSDUtils.getImportSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("\t\t  Import namespace=\"" + namespaceImport + "\" schemaLocation=\"" + location + "\"");
            }
        }
    }

    private static void printIncludeFromXSD(Logger log, byte[] doc) throws Exception {
        if (org.openspcoop.utils.xml.XMLUtils.isDocument(doc)) {
            Document d = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            List<Node> includes = XSDUtils.readIncludes(d);
            for (int i = 0; i < includes.size(); ++i) {
                Node n = includes.get(i);
                String location = null;
                try {
                    location = XSDUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("\t\t  Include schemaLocation=\"" + location + "\"");
            }
        }
    }

    private static void printElementIntoWSDL(Logger log, byte[] doc) throws Exception {
        Map<?, ?> services;
        Map<?, ?> bindings;
        Map<?, ?> porttypes;
        Document d = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
        WSDLUtilities.removeTypes(d);
        WSDLUtilities.removeImports(d);
        DefinitionWrapper wsdl = new DefinitionWrapper(d);
        Map<?, ?> messages = wsdl.getMessages();
        if (messages != null && messages.size() > 0) {
            for (QName key : messages.keySet()) {
                Message msg = (Message)messages.get(key);
                System.out.println("\t\t  Message=" + msg.getQName().toString());
            }
        }
        if ((porttypes = wsdl.getAllPortTypes()) != null && porttypes.size() > 0) {
            for (QName key : porttypes.keySet()) {
                PortType pt = (PortType)porttypes.get(key);
                System.out.println("\t\t  PortType=" + pt.getQName().toString() + " (" + pt.getOperations().size() + " operations)");
                for (int i = 0; i < pt.getOperations().size(); ++i) {
                    javax.wsdl.Operation op = (javax.wsdl.Operation)pt.getOperations().get(i);
                    String tipo = "InputOutput";
                    if (op.getOutput() == null) {
                        tipo = "InputOnly";
                    }
                    System.out.println("\t\t  \t\t  Operation=" + op.getName() + " (" + tipo + ")");
                }
            }
        }
        if ((bindings = wsdl.getAllBindings()) != null && bindings.size() > 0) {
            for (QName key : bindings.keySet()) {
                Binding binding = (Binding)bindings.get(key);
                System.out.println("\t\t  Binding=" + binding.getQName().toString());
            }
        }
        if ((services = wsdl.getAllServices()) != null && services.size() > 0) {
            for (QName key : services.keySet()) {
                Service service = (Service)services.get(key);
                System.out.println("\t\t  Service=" + service.getQName().toString());
            }
        }
    }

    private static void printAccordoServizio(Logger log, org.openspcoop.dao.registry.AccordoServizio asParteComuneOpenSPCoop, boolean readWSDL_XSD, boolean servizioComposto) throws Exception {
        org.openspcoop.dao.registry.Documento doc;
        int i;
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("Accordo di Servizio [" + IDAccordo.getUriFromAccordo(asParteComuneOpenSPCoop) + "] gestito correttamente");
        if (asParteComuneOpenSPCoop.getByteWsdlDefinitorio() != null) {
            System.out.println("- WSDL Definitorio");
            if (readWSDL_XSD) {
                ClientTest.printImportFromXSD(log, asParteComuneOpenSPCoop.getByteWsdlDefinitorio());
                ClientTest.printIncludeFromXSD(log, asParteComuneOpenSPCoop.getByteWsdlDefinitorio());
            }
        }
        System.out.println("- Allegati: " + asParteComuneOpenSPCoop.sizeAllegatoList());
        for (i = 0; i < asParteComuneOpenSPCoop.sizeAllegatoList(); ++i) {
            doc = asParteComuneOpenSPCoop.getAllegato(i);
            System.out.println("\t- (" + doc.getTipo() + ") " + doc.getFile());
            if (!readWSDL_XSD) continue;
            ClientTest.printImportFromXSD(log, doc.getByteContenuto());
            ClientTest.printIncludeFromXSD(log, doc.getByteContenuto());
        }
        System.out.println("- SpecificheSemiformali: " + asParteComuneOpenSPCoop.sizeSpecificaSemiformaleList());
        for (i = 0; i < asParteComuneOpenSPCoop.sizeSpecificaSemiformaleList(); ++i) {
            doc = asParteComuneOpenSPCoop.getSpecificaSemiformale(i);
            System.out.println("\t- (" + doc.getTipo() + ") " + doc.getFile());
            if (!readWSDL_XSD) continue;
            ClientTest.printImportFromXSD(log, doc.getByteContenuto());
            ClientTest.printIncludeFromXSD(log, doc.getByteContenuto());
        }
        if (servizioComposto) {
            int i2;
            AccordoServizioServizioComposto asComposto = asParteComuneOpenSPCoop.getServizioComposto();
            System.out.println("- SpecificheCoordinamento: " + asComposto.sizeSpecificaCoordinamentoList());
            for (i2 = 0; i2 < asComposto.sizeSpecificaCoordinamentoList(); ++i2) {
                org.openspcoop.dao.registry.Documento doc2 = asComposto.getSpecificaCoordinamento(i2);
                System.out.println("\t- (" + doc2.getTipo() + ") " + doc2.getFile());
            }
            System.out.println("- ServiziComponenti: " + asComposto.sizeServizioComponenteList());
            for (i2 = 0; i2 < asComposto.sizeServizioComponenteList(); ++i2) {
                AccordoServizioServizioCompostoServizioComponente sComponente = asComposto.getServizioComponente(i2);
                String s = "\t- " + sComponente.getTipoSoggetto() + "/" + sComponente.getNomeSoggetto() + "_" + sComponente.getTipo() + "/" + sComponente.getNome();
                if (sComponente.getAzione() != null) {
                    s = s + "_" + sComponente.getAzione();
                }
                System.out.println(s);
            }
        }
        if (asParteComuneOpenSPCoop.getByteWsdlConcettuale() != null) {
            System.out.println("- WSDL Concettuale");
            if (readWSDL_XSD) {
                ClientTest.printImportFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlConcettuale());
                ClientTest.printImportIntoTypesFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlConcettuale());
                ClientTest.printIncludeIntoTypesFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlConcettuale());
                ClientTest.printElementIntoWSDL(log, asParteComuneOpenSPCoop.getByteWsdlConcettuale());
            }
        }
        if (asParteComuneOpenSPCoop.getByteWsdlLogicoErogatore() != null) {
            System.out.println("- WSDL Logico Erogatore");
            if (readWSDL_XSD) {
                ClientTest.printImportFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoErogatore());
                ClientTest.printImportIntoTypesFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoErogatore());
                ClientTest.printIncludeIntoTypesFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoErogatore());
                ClientTest.printElementIntoWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoErogatore());
            }
        }
        if (asParteComuneOpenSPCoop.getByteWsdlLogicoFruitore() != null) {
            System.out.println("- WSDL Logico Fruitore");
            if (readWSDL_XSD) {
                ClientTest.printImportFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoFruitore());
                ClientTest.printImportIntoTypesFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoFruitore());
                ClientTest.printIncludeIntoTypesFromWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoFruitore());
                ClientTest.printElementIntoWSDL(log, asParteComuneOpenSPCoop.getByteWsdlLogicoFruitore());
            }
        }
        System.out.println("- PortTypes: " + asParteComuneOpenSPCoop.sizePortTypeList());
        for (int i3 = 0; i3 < asParteComuneOpenSPCoop.sizePortTypeList(); ++i3) {
            org.openspcoop.dao.registry.PortType pt = asParteComuneOpenSPCoop.getPortType(i3);
            System.out.println("\tPortType[" + i3 + "]=" + pt.getNome() + " (sizeAzioni:" + pt.sizeAzioneList() + ") (ProfiloCollaborazione:" + pt.getProfiloCollaborazione() + ")");
            for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                Operation op = pt.getAzione(j);
                if (op.getCorrelata() != null || op.getCorrelataServizio() != null) {
                    System.out.println("\t\tOperation[" + j + "]=" + op.getNome() + " (ProfiloCollaborazione:" + op.getProfiloCollaborazione() + ") (servizioCorrelato:" + op.getCorrelataServizio() + ") (correlata:" + op.getCorrelata() + ")");
                    continue;
                }
                System.out.println("\t\tOperation[" + j + "]=" + op.getNome() + " (ProfiloCollaborazione:" + op.getProfiloCollaborazione() + ")");
            }
        }
        System.out.println("------------------------------------------------------------------------------------------------");
    }

    private static void printAccordoServizioParteSpecifica(Logger log, ServizioSpcoop asParteSpecificaOpenSPCoop, boolean readWSDL) throws Exception {
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("Servizio SPCoop (correlato:" + asParteSpecificaOpenSPCoop.getServizioCorrelato() + ") [" + asParteSpecificaOpenSPCoop.getTipo() + "/" + asParteSpecificaOpenSPCoop.getNome() + "] (erogatore:" + asParteSpecificaOpenSPCoop.getTipoSoggettoErogatore() + "/" + asParteSpecificaOpenSPCoop.getNomeSoggettoErogatore() + ") gestito correttamente");
        System.out.println("- Allegati: " + asParteSpecificaOpenSPCoop.sizeAllegatoList());
        System.out.println("- SpecificheSemiformali: " + asParteSpecificaOpenSPCoop.sizeSpecificaSemiformaleList());
        System.out.println("- SpecificheLivelliServizio: " + asParteSpecificaOpenSPCoop.sizeSpecificaLivelloServizioList());
        System.out.println("- SpecificheSicurezza: " + asParteSpecificaOpenSPCoop.sizeSpecificaSicurezzaList());
        System.out.println("- Connettore servizio: " + asParteSpecificaOpenSPCoop.getConnettore().getProperty(0).getValore());
        if (asParteSpecificaOpenSPCoop.getByteWsdlImplementativoErogatore() != null) {
            System.out.println("- WSDL Implementativo Erogatore");
            if (readWSDL) {
                ClientTest.printImportFromWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoErogatore());
                ClientTest.printImportIntoTypesFromWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoErogatore());
                ClientTest.printIncludeIntoTypesFromWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoErogatore());
                ClientTest.printElementIntoWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoErogatore());
            }
        }
        if (asParteSpecificaOpenSPCoop.getByteWsdlImplementativoFruitore() != null) {
            System.out.println("- WSDL Implementativo Fruitore");
            if (readWSDL) {
                ClientTest.printImportFromWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoFruitore());
                ClientTest.printImportIntoTypesFromWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoFruitore());
                ClientTest.printIncludeIntoTypesFromWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoFruitore());
                ClientTest.printElementIntoWSDL(log, asParteSpecificaOpenSPCoop.getByteWsdlImplementativoFruitore());
            }
        }
        System.out.println("------------------------------------------------------------------------------------------------");
    }

    private static void printAccordoCooperazione(org.openspcoop.dao.registry.AccordoCooperazione acOpenSPCoop) throws Exception {
        int i;
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("Accordo di Cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(acOpenSPCoop) + "] gestito correttamente");
        System.out.println("- Allegati: " + acOpenSPCoop.sizeAllegatoList());
        System.out.println("- SpecificheSemiformali: " + acOpenSPCoop.sizeSpecificaSemiformaleList());
        System.out.println("- Partecipanti: " + acOpenSPCoop.sizeElencoPartecipantiList());
        for (i = 0; i < acOpenSPCoop.sizeElencoPartecipantiList(); ++i) {
            System.out.println("\t\t  - " + acOpenSPCoop.getElencoPartecipanti(i).getTipo() + "/" + acOpenSPCoop.getElencoPartecipanti(i).getNome());
        }
        System.out.println("- URIServiziComposti: " + acOpenSPCoop.sizeUriServiziCompostiList());
        for (i = 0; i < acOpenSPCoop.sizeUriServiziCompostiList(); ++i) {
            System.out.println("\t\t  - " + acOpenSPCoop.getUriServiziComposti(i));
        }
        System.out.println("------------------------------------------------------------------------------------------------");
    }

    private static void normalizzaPackageCNIPA(org.openspcoop.dao.registry.AccordoServizio as, String dirFiles, boolean servizioComposto) throws Exception {
        File f;
        byte[] contenuto;
        String path;
        org.openspcoop.dao.registry.Documento doc;
        int i;
        byte[] contenuto2;
        String path2;
        as.setOraRegistrazione(new Date());
        if (as.getWsdlDefinitorio() != null) {
            path2 = dirFiles + as.getWsdlDefinitorio();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsdlDefinitorio(contenuto2);
        }
        if (as.getWsdlConcettuale() != null) {
            path2 = dirFiles + as.getWsdlConcettuale();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsdlConcettuale(contenuto2);
        }
        if (as.getWsdlLogicoErogatore() != null) {
            path2 = dirFiles + as.getWsdlLogicoErogatore();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsdlLogicoErogatore(contenuto2);
        }
        if (as.getWsdlLogicoFruitore() != null) {
            path2 = dirFiles + as.getWsdlLogicoFruitore();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsdlLogicoFruitore(contenuto2);
        }
        if (as.getWsblConcettuale() != null) {
            path2 = dirFiles + as.getWsblConcettuale();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsblConcettuale(contenuto2);
        }
        if (as.getWsblLogicoErogatore() != null) {
            path2 = dirFiles + as.getWsblLogicoErogatore();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsblLogicoErogatore(contenuto2);
        }
        if (as.getWsblLogicoFruitore() != null) {
            path2 = dirFiles + as.getWsblLogicoFruitore();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            as.setByteWsblLogicoFruitore(contenuto2);
        }
        for (i = 0; i < as.sizeAllegatoList(); ++i) {
            doc = as.getAllegato(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
        for (i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
            doc = as.getSpecificaSemiformale(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
        if (servizioComposto) {
            if (as.getServizioComposto() == null) {
                throw new Exception("ServizioComposto non e' presente");
            }
            for (int j = 0; j < as.getServizioComposto().sizeSpecificaCoordinamentoList(); ++j) {
                doc = as.getServizioComposto().getSpecificaCoordinamento(j);
                path = dirFiles + doc.getFile();
                contenuto = FileSystemUtilities.readBytesFromFile(path);
                doc.setByteContenuto(contenuto);
                f = new File(path);
                doc.setFile(f.getName());
            }
        }
    }

    private static void normalizzaPackageCNIPA(ServizioSpcoop servizio, String dirFiles, Connettore connettoreSoggetto) throws Exception {
        File f;
        byte[] contenuto;
        String path;
        org.openspcoop.dao.registry.Documento doc;
        int i;
        byte[] contenuto2;
        String path2;
        servizio.setOraRegistrazione(new Date());
        servizio.setTipoAdesione(TipiAdesione.AUTOMATICA.toString());
        String url = connettoreSoggetto.getProperty(0).getValore();
        Connettore con = new Connettore();
        con.setTipo("http");
        con.setNome("Connettore per servizio " + servizio.toString());
        ConnettoreProperty cp = new ConnettoreProperty();
        cp.setNome("location");
        cp.setValore(url + "/TEST_" + servizio.getTipo() + servizio.getNome());
        con.addProperty(cp);
        servizio.setConnettore(con);
        if (servizio.getWsdlImplementativoErogatore() != null) {
            path2 = dirFiles + servizio.getWsdlImplementativoErogatore();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            servizio.setByteWsdlImplementativoErogatore(contenuto2);
        }
        if (servizio.getWsdlImplementativoFruitore() != null) {
            path2 = dirFiles + servizio.getWsdlImplementativoFruitore();
            contenuto2 = FileSystemUtilities.readBytesFromFile(path2);
            servizio.setByteWsdlImplementativoFruitore(contenuto2);
        }
        for (i = 0; i < servizio.sizeAllegatoList(); ++i) {
            doc = servizio.getAllegato(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
        for (i = 0; i < servizio.sizeSpecificaSemiformaleList(); ++i) {
            doc = servizio.getSpecificaSemiformale(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
        for (i = 0; i < servizio.sizeSpecificaLivelloServizioList(); ++i) {
            doc = servizio.getSpecificaLivelloServizio(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
        for (i = 0; i < servizio.sizeSpecificaSicurezzaList(); ++i) {
            doc = servizio.getSpecificaSicurezza(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
    }

    private static void normalizzaPackageCNIPA(org.openspcoop.dao.registry.AccordoCooperazione ac, String dirFiles) throws Exception {
        File f;
        byte[] contenuto;
        String path;
        org.openspcoop.dao.registry.Documento doc;
        int i;
        ac.setOraRegistrazione(new Date());
        for (i = 0; i < ac.sizeAllegatoList(); ++i) {
            doc = ac.getAllegato(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
        for (i = 0; i < ac.sizeSpecificaSemiformaleList(); ++i) {
            doc = ac.getSpecificaSemiformale(i);
            path = dirFiles + doc.getFile();
            contenuto = FileSystemUtilities.readBytesFromFile(path);
            doc.setByteContenuto(contenuto);
            f = new File(path);
            doc.setFile(f.getName());
        }
    }

    private static void verificaAccordoServizio(String nomeFile, org.openspcoop.dao.registry.AccordoServizio as) throws Exception {
        File f = new File(nomeFile);
        if (!f.exists()) {
            throw new Exception("Accordo [" + nomeFile + "] non esistente");
        }
        if (!f.canRead()) {
            throw new Exception("Accordo [" + nomeFile + "] non leggibile");
        }
        String dir = "DIR_CONCETTUALE_" + nomeFile.replace("/", "");
        FileSystemUtilities.deleteDir(dir);
        ZipUtilities.unzipFile(nomeFile, dir);
        System.out.println("InterfacciaConcettuale.wsdl in corso di verifica (sintassi/import/include) ...");
        if (as.getServizioComposto() == null) {
            ClientTest.verificaAccordoServizioParteComune(dir, as.getNome(), "InterfacciaConcettuale.wsdl", true, true);
        } else {
            ClientTest.verificaAccordoServizioComposto(dir, as.getNome(), "InterfacciaConcettuale.wsdl");
        }
        System.out.println("InterfacciaConcettuale.wsdl correttamente formato");
        FileSystemUtilities.deleteDir(dir);
        dir = "DIR_LOGICA_EROGATORE_" + nomeFile.replace("/", "");
        FileSystemUtilities.deleteDir(dir);
        ZipUtilities.unzipFile(nomeFile, dir);
        System.out.println("InterfacciaLogicaErogatore.wsdl in corso di verifica (sintassi/import/include) ...");
        if (as.getServizioComposto() == null) {
            ClientTest.verificaAccordoServizioParteComune(dir, as.getNome(), "InterfacciaLogicaErogatore.wsdl", true, false);
        } else {
            ClientTest.verificaAccordoServizioComposto(dir, as.getNome(), "InterfacciaLogicaErogatore.wsdl");
        }
        System.out.println("InterfacciaLogicaErogatore.wsdl correttamente formato");
        FileSystemUtilities.deleteDir(dir);
        if (as.getServizioComposto() == null) {
            dir = "DIR_LOGICA_FRUITORE_" + nomeFile.replace("/", "");
            FileSystemUtilities.deleteDir(dir);
            ZipUtilities.unzipFile(nomeFile, dir);
            System.out.println("InterfacciaLogicaFruitore.wsdl in corso di verifica (sintassi/import/include) ...");
            ClientTest.verificaAccordoServizioParteComune(dir, as.getNome(), "InterfacciaLogicaFruitore.wsdl", false, true);
            System.out.println("InterfacciaLogicaFruitore.wsdl correttamente formato");
            FileSystemUtilities.deleteDir(dir);
        }
    }

    private static void verificaAccordoServizioParteComune(String dirName, String nomeAccordoServizioParteComune, String fileWSDL, boolean logicoErogatore, boolean logicoFruitore) throws Exception {
        WSDL2JAVA wsdl2java = new WSDL2JAVA();
        String[] args = new String[5];
        args[0] = "-S";
        args[1] = "true";
        args[2] = "-o";
        args[3] = "STUB_SKELETON_" + dirName;
        String dirWSDL = dirName + File.separatorChar + nomeAccordoServizioParteComune + File.separatorChar + "specificaInterfaccia" + File.separatorChar;
        FileSystemUtilities.deleteDir(args[3]);
        args[4] = dirWSDL + fileWSDL;
        wsdl2java.run(args);
        if (wsdl2java.getError() != null) {
            throw wsdl2java.getError();
        }
        String baseDir = args[3] + File.separatorChar + "org" + File.separatorChar + "openspcoop" + File.separatorChar + "www" + File.separatorChar + "example" + File.separatorChar;
        ClientTest.isFileExists(baseDir + "deploy.wsdd");
        ClientTest.isFileExists(baseDir + "Esito.java");
        ClientTest.isFileExists(baseDir + "PresaInCarico.java");
        ClientTest.isFileExists(baseDir + "IdentificativoRichiestaAsincrona.java");
        ClientTest.isFileExists(baseDir + "RichiestaStatoRegistrazioneRequest.java");
        ClientTest.isFileExists(baseDir + "RichiestaStatoRegistrazioneResponse.java");
        ClientTest.isFileExists(baseDir + "undeploy.wsdd");
        if (logicoErogatore) {
            ClientTest.isFileExists(baseDir + "AggiornamentoRequest.java");
            ClientTest.isFileExists(baseDir + "AggiornamentoResponse.java");
            ClientTest.isFileExists(baseDir + "Dati.java");
            ClientTest.isFileExists(baseDir + "EsempioAllegatoInclude1.java");
            ClientTest.isFileExists(baseDir + "EsempioAllegatoInclude2.java");
            ClientTest.isFileExists(baseDir + "EsempioSpecificaSemiformaleInclude1.java");
            ClientTest.isFileExists(baseDir + "EsempioSpecificaSemiformaleInclude2.java");
            ClientTest.isFileExists(baseDir + "NotificaRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaAggiornamentoRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaAggiornamentoResponse.java");
            ClientTest.isFileExists(baseDir + "RichiestaRegistrazioneRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaRegistrazioneResponse.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "_import" + File.separatorChar + "EsempioAllegatoImport1.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "_import" + File.separatorChar + "EsempioAllegatoImport2.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "_import" + File.separatorChar + "allegato" + File.separatorChar + "interno" + File.separatorChar + "EsempioAllegatoInterno.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "import2" + File.separatorChar + "AltroOggettoImportato.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "importwsdl" + File.separatorChar + "AllegatoImportatoDirettamenteInWSDL.java");
            ClientTest.isFileExists(baseDir + "specificasemiformale" + File.separatorChar + "_import" + File.separatorChar + "EsempioSpecificaSemiformaleImport1.java");
            ClientTest.isFileExists(baseDir + "specificasemiformale" + File.separatorChar + "_import" + File.separatorChar + "EsempioSpecificaSemiformaleImport2.java");
            ClientTest.isFileExists(baseDir + "specificasemiformale" + File.separatorChar + "_import" + File.separatorChar + "specificasemiformale" + File.separatorChar + "interno" + File.separatorChar + "EsempioSpecificaSemiformaleInterno.java");
        }
        if (logicoFruitore) {
            ClientTest.isFileExists(baseDir + "EsitoAggiornamentoRequest.java");
            ClientTest.isFileExists(baseDir + "EsitoAggiornamentoResponse.java");
        }
        FileSystemUtilities.deleteDir(args[3]);
    }

    private static void verificaAccordoServizioComposto(String dirName, String nomeAccordoServizioParteComune, String fileWSDL) throws Exception {
        WSDL2JAVA wsdl2java = new WSDL2JAVA();
        String[] args = new String[5];
        args[0] = "-S";
        args[1] = "true";
        args[2] = "-o";
        args[3] = "STUB_SKELETON_" + dirName;
        String dirWSDL = dirName + File.separatorChar + nomeAccordoServizioParteComune + File.separatorChar + "specificaInterfaccia" + File.separatorChar;
        FileSystemUtilities.deleteDir(args[3]);
        args[4] = dirWSDL + fileWSDL;
        wsdl2java.run(args);
        if (wsdl2java.getError() != null) {
            throw wsdl2java.getError();
        }
        String baseDir = args[3] + File.separatorChar + "org" + File.separatorChar + "openspcoop" + File.separatorChar + "www" + File.separatorChar + "example" + File.separatorChar;
        ClientTest.isFileExists(baseDir + "deploy.wsdd");
        ClientTest.isFileExists(baseDir + "Esito.java");
        ClientTest.isFileExists(baseDir + "Dati.java");
        ClientTest.isFileExists(baseDir + "ServizioCompostoRequest.java");
        ClientTest.isFileExists(baseDir + "ServizioCompostoResponse.java");
        ClientTest.isFileExists(baseDir + "undeploy.wsdd");
        FileSystemUtilities.deleteDir(args[3]);
    }

    private static void verificaAccordoServizioParteSpecifica(String nomeFile, ServizioSpcoop serv, boolean parteSpecificaContieneParteComune, String DIR_ESEMPI_AS, boolean implementazioneServizioComposto) throws Exception {
        File f = new File(nomeFile);
        if (!f.exists()) {
            throw new Exception("Accordo [" + nomeFile + "] non esistente");
        }
        if (!f.canRead()) {
            throw new Exception("Accordo [" + nomeFile + "] non leggibile");
        }
        String dir = null;
        dir = serv.getServizioCorrelato() ? "DIR_IMPL_FRUITORE_" + nomeFile.replace("/", "") : "DIR_IMPL_EROGATORE_" + nomeFile.replace("/", "");
        FileSystemUtilities.deleteDir(dir);
        if (!parteSpecificaContieneParteComune) {
            String fPC = serv.getAccordoServizio().replace(":", "_") + ".";
            fPC = implementazioneServizioComposto ? fPC + "asc" : fPC + "apc";
            fPC = fPC.replace("/", "");
            fPC = DIR_ESEMPI_AS + File.separatorChar + fPC;
            File parteComune = new File(fPC);
            if (!parteComune.exists()) {
                throw new Exception("Accordo Parte Comune [" + parteComune.getAbsolutePath() + "] non esistente");
            }
            if (!parteComune.canRead()) {
                throw new Exception("Accordo Parte Comune [" + parteComune.getAbsolutePath() + "] non leggibile");
            }
            ZipUtilities.unzipFile(parteComune.getAbsolutePath(), dir);
        }
        ZipUtilities.unzipFile(nomeFile, dir);
        if (serv.getServizioCorrelato()) {
            System.out.println("PortiAccessoFruitore.wsdl in corso di verifica (sintassi/import/include) ...");
            if (implementazioneServizioComposto) {
                ClientTest.verificaAccordoServizioCompostoParteSpecifica(dir, serv.getAccordoParteSpecifica().getNome(), serv.getNome(), "PortiAccessoFruitore.wsdl");
            } else {
                ClientTest.verificaAccordoServizioParteSpecifica(dir, serv.getAccordoParteSpecifica().getNome(), serv.getNome(), "PortiAccessoFruitore.wsdl");
            }
            System.out.println("PortiAccessoFruitore.wsdl correttamente formato");
        } else {
            System.out.println("PortiAccessoErogatore.wsdl in corso di verifica (sintassi/import/include) ...");
            if (implementazioneServizioComposto) {
                ClientTest.verificaAccordoServizioCompostoParteSpecifica(dir, serv.getAccordoParteSpecifica().getNome(), serv.getNome(), "PortiAccessoErogatore.wsdl");
            } else {
                ClientTest.verificaAccordoServizioParteSpecifica(dir, serv.getAccordoParteSpecifica().getNome(), serv.getNome(), "PortiAccessoErogatore.wsdl");
            }
            System.out.println("PortiAccessoErogatore.wsdl correttamente formato");
        }
        FileSystemUtilities.deleteDir(dir);
    }

    private static void verificaAccordoServizioParteSpecifica(String dirName, String nomeAccordoServizioParteSpecifica, String nomeServizioSPCoop, String fileWSDL) throws Exception {
        WSDL2JAVA wsdl2java = new WSDL2JAVA();
        String[] args = new String[5];
        args[0] = "-S";
        args[1] = "true";
        args[2] = "-o";
        args[3] = "STUB_SKELETON_" + dirName;
        String dirWSDL = dirName + File.separatorChar + nomeAccordoServizioParteSpecifica + File.separatorChar + "specificaPortiAccesso" + File.separatorChar;
        FileSystemUtilities.deleteDir(args[3]);
        args[4] = dirWSDL + fileWSDL;
        wsdl2java.run(args);
        if (wsdl2java.getError() != null) {
            throw wsdl2java.getError();
        }
        String baseDir = args[3] + File.separatorChar + "org" + File.separatorChar + "openspcoop" + File.separatorChar + "www" + File.separatorChar + "example" + File.separatorChar;
        ClientTest.isFileExists(baseDir + "deploy.wsdd");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "BindingImpl.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "BindingSkeleton.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "BindingStub.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + ".java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "Service.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "ServiceLocator.java");
        ClientTest.isFileExists(baseDir + "undeploy.wsdd");
        if ("Oneway".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "Dati.java");
            ClientTest.isFileExists(baseDir + "EsempioAllegatoInclude1.java");
            ClientTest.isFileExists(baseDir + "EsempioAllegatoInclude2.java");
            ClientTest.isFileExists(baseDir + "EsempioSpecificaSemiformaleInclude1.java");
            ClientTest.isFileExists(baseDir + "EsempioSpecificaSemiformaleInclude2.java");
            ClientTest.isFileExists(baseDir + "NotificaRequest.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "_import" + File.separatorChar + "EsempioAllegatoImport1.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "_import" + File.separatorChar + "EsempioAllegatoImport2.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "_import" + File.separatorChar + "allegato" + File.separatorChar + "interno" + File.separatorChar + "EsempioAllegatoInterno.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "import2" + File.separatorChar + "AltroOggettoImportato.java");
            ClientTest.isFileExists(baseDir + "allegato" + File.separatorChar + "importwsdl" + File.separatorChar + "AllegatoImportatoDirettamenteInWSDL.java");
            ClientTest.isFileExists(baseDir + "specificasemiformale" + File.separatorChar + "_import" + File.separatorChar + "EsempioSpecificaSemiformaleImport1.java");
            ClientTest.isFileExists(baseDir + "specificasemiformale" + File.separatorChar + "_import" + File.separatorChar + "EsempioSpecificaSemiformaleImport2.java");
            ClientTest.isFileExists(baseDir + "specificasemiformale" + File.separatorChar + "_import" + File.separatorChar + "specificasemiformale" + File.separatorChar + "interno" + File.separatorChar + "EsempioSpecificaSemiformaleInterno.java");
        } else if ("Sincrono".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "AggiornamentoRequest.java");
            ClientTest.isFileExists(baseDir + "AggiornamentoResponse.java");
            ClientTest.isFileExists(baseDir + "Dati.java");
            ClientTest.isFileExists(baseDir + "Esito.java");
        } else if ("AsincronoSimmetricoRichiesta".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "RichiestaAggiornamentoRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaAggiornamentoResponse.java");
            ClientTest.isFileExists(baseDir + "Dati.java");
            ClientTest.isFileExists(baseDir + "PresaInCarico.java");
        } else if ("AsincronoSimmetricoRisposta".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "EsitoAggiornamentoRequest.java");
            ClientTest.isFileExists(baseDir + "EsitoAggiornamentoResponse.java");
            ClientTest.isFileExists(baseDir + "Esito.java");
            ClientTest.isFileExists(baseDir + "PresaInCarico.java");
        } else if ("AsincronoAsimmetrico".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "RichiestaRegistrazioneRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaRegistrazioneResponse.java");
            ClientTest.isFileExists(baseDir + "RichiestaStatoRegistrazioneRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaStatoRegistrazioneResponse.java");
            ClientTest.isFileExists(baseDir + "Dati.java");
            ClientTest.isFileExists(baseDir + "Esito.java");
            ClientTest.isFileExists(baseDir + "IdentificativoRichiestaAsincrona.java");
            ClientTest.isFileExists(baseDir + "PresaInCarico.java");
        } else if ("AsincronoAsimmetricoRichiesta".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "RichiestaRegistrazioneRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaRegistrazioneResponse.java");
            ClientTest.isFileExists(baseDir + "Dati.java");
            ClientTest.isFileExists(baseDir + "PresaInCarico.java");
        } else if ("AsincronoAsimmetricoRisposta".equals(nomeServizioSPCoop)) {
            ClientTest.isFileExists(baseDir + "RichiestaStatoRegistrazioneRequest.java");
            ClientTest.isFileExists(baseDir + "RichiestaStatoRegistrazioneResponse.java");
            ClientTest.isFileExists(baseDir + "Esito.java");
            ClientTest.isFileExists(baseDir + "IdentificativoRichiestaAsincrona.java");
        } else {
            throw new Exception("Servizio [" + nomeServizioSPCoop + "] non gestito ?");
        }
        FileSystemUtilities.deleteDir(args[3]);
    }

    private static void verificaAccordoServizioCompostoParteSpecifica(String dirName, String nomeAccordoServizioParteSpecifica, String nomeServizioSPCoop, String fileWSDL) throws Exception {
        WSDL2JAVA wsdl2java = new WSDL2JAVA();
        String[] args = new String[5];
        args[0] = "-S";
        args[1] = "true";
        args[2] = "-o";
        args[3] = "STUB_SKELETON_" + dirName;
        String dirWSDL = dirName + File.separatorChar + nomeAccordoServizioParteSpecifica + File.separatorChar + "specificaPortiAccesso" + File.separatorChar;
        FileSystemUtilities.deleteDir(args[3]);
        args[4] = dirWSDL + fileWSDL;
        wsdl2java.run(args);
        if (wsdl2java.getError() != null) {
            throw wsdl2java.getError();
        }
        String baseDir = args[3] + File.separatorChar + "org" + File.separatorChar + "openspcoop" + File.separatorChar + "www" + File.separatorChar + "example" + File.separatorChar;
        ClientTest.isFileExists(baseDir + "deploy.wsdd");
        ClientTest.isFileExists(baseDir + "Dati.java");
        ClientTest.isFileExists(baseDir + "Esito.java");
        ClientTest.isFileExists(baseDir + "ServizioCompostoRequest.java");
        ClientTest.isFileExists(baseDir + "ServizioCompostoResponse.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "BindingImpl.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "BindingSkeleton.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "BindingStub.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + ".java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "Service.java");
        ClientTest.isFileExists(baseDir + nomeServizioSPCoop + "ServiceLocator.java");
        ClientTest.isFileExists(baseDir + "undeploy.wsdd");
        FileSystemUtilities.deleteDir(args[3]);
    }

    private static AccordoServizio getManifestoAS_ParteComune(boolean generaInfoEGovComeSpecificaSemiformale, boolean generaInfoEGovFormatoClientSICA) throws Exception {
        AccordoServizio manifest = new AccordoServizio();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("ASParteComune");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        it.gov.spcoop.sica.manifest.AccordoServizioParteComune parteComune = new it.gov.spcoop.sica.manifest.AccordoServizioParteComune();
        parteComune.setPubblicatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", true));
        SpecificaConversazione conversazione = new SpecificaConversazione();
        DocumentoConversazione doc = new DocumentoConversazione();
        doc.setTipo("WSBL");
        doc.setBase("ConversazioneConcettuale.wsbl");
        conversazione.setConversazioneConcettuale(doc);
        DocumentoConversazione docErogatore = new DocumentoConversazione();
        docErogatore.setTipo("WSBL");
        docErogatore.setBase("ConversazioneLogicaLatoErogatore.wsbl");
        conversazione.setConversazioneLogicaLatoErogatore(docErogatore);
        DocumentoConversazione docFruitore = new DocumentoConversazione();
        docFruitore.setTipo("WSBL");
        docFruitore.setBase("ConversazioneLogicaLatoFruitore.wsbl");
        conversazione.setConversazioneLogicaLatoFruitore(docFruitore);
        parteComune.setSpecificaConversazione(conversazione);
        SpecificaInterfaccia interfaccia = new SpecificaInterfaccia();
        DocumentoInterfaccia docI = new DocumentoInterfaccia();
        docI.setTipo("WSDL");
        docI.setBase("InterfacciaConcettuale.wsdl");
        interfaccia.setInterfacciaConcettuale(docI);
        DocumentoInterfaccia docIErogatore = new DocumentoInterfaccia();
        docIErogatore.setTipo("WSDL");
        docIErogatore.setBase("InterfacciaLogicaErogatore.wsdl");
        interfaccia.setInterfacciaLogicaLatoErogatore(docIErogatore);
        DocumentoInterfaccia docIFruitore = new DocumentoInterfaccia();
        docIFruitore.setTipo("WSDL");
        docIFruitore.setBase("InterfacciaLogicaFruitore.wsdl");
        interfaccia.setInterfacciaLogicaLatoFruitore(docIFruitore);
        parteComune.setSpecificaInterfaccia(interfaccia);
        manifest.setParteComune(parteComune);
        ElencoAllegati allegati = new ElencoAllegati();
        allegati.addGenericoDocumento("Allegato1.doc");
        allegati.addGenericoDocumento("Allegato2.doc");
        allegati.addGenericoDocumento("InterfacciaDefinitoria.xsd");
        manifest.setAllegati(allegati);
        SpecificaSemiformale specifiche = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifiche.addDocumentoSemiformale(docS1);
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifiche.addDocumentoSemiformale(docS2);
        manifest.setSpecificaSemiformale(specifiche);
        if (generaInfoEGovComeSpecificaSemiformale) {
            DocumentoSemiformale docSpecificaEGOV = new DocumentoSemiformale();
            docSpecificaEGOV.setTipo(TipiDocumentoSemiformale.XML.toString());
            if (generaInfoEGovFormatoClientSICA) {
                docSpecificaEGOV.setBase("ProfiloDiCollaborazione.wscp");
            } else {
                docSpecificaEGOV.setBase("ProfiloDiCollaborazione.xml");
            }
            specifiche.addDocumentoSemiformale(docSpecificaEGOV);
            manifest.setSpecificaSemiformale(specifiche);
        } else {
            if (generaInfoEGovFormatoClientSICA) {
                allegati.addGenericoDocumento("ProfiloDiCollaborazione.wscp");
            } else {
                allegati.addGenericoDocumento("ProfiloDiCollaborazione.xml");
            }
            manifest.setAllegati(allegati);
        }
        return manifest;
    }

    private static AccordoServizio getManifestoAS_ParteSpecifica() throws Exception {
        AccordoServizio manifest = new AccordoServizio();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("ASParteSpecifica");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica = new it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica();
        parteSpecifica.setRiferimentoParteComune(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("adsc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", false), "ASParteComune", "2"));
        parteSpecifica.setAdesione(TipiAdesione.AUTOMATICA.toString());
        parteSpecifica.setErogatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", true));
        SpecificaPortiAccesso portiAccesso = new SpecificaPortiAccesso();
        DocumentoInterfaccia docErogatore = new DocumentoInterfaccia();
        docErogatore.setTipo("WSDL");
        docErogatore.setBase("PortiAccessoErogatore.wsdl");
        portiAccesso.setPortiAccessoErogatore(docErogatore);
        DocumentoInterfaccia docFruitore = new DocumentoInterfaccia();
        docFruitore.setTipo("WSDL");
        docFruitore.setBase("PortiAccessoFruitore.wsdl");
        portiAccesso.setPortiAccessoFruitore(docFruitore);
        parteSpecifica.setSpecificaPortiAccesso(portiAccesso);
        SpecificaLivelliServizio sLivServizio = new SpecificaLivelliServizio();
        DocumentoLivelloServizio dsLivServ1 = new DocumentoLivelloServizio();
        dsLivServ1.setTipo(TipiDocumentoLivelloServizio.WSLA.toString());
        dsLivServ1.setBase("LivelloServizioMinimo.wsla");
        sLivServizio.addDocumentoLivelloServizio(dsLivServ1);
        DocumentoLivelloServizio dsLivServ2 = new DocumentoLivelloServizio();
        dsLivServ2.setTipo(TipiDocumentoLivelloServizio.WSLA.toString());
        dsLivServ2.setBase("LivelloServizioOttimale.wsla");
        sLivServizio.addDocumentoLivelloServizio(dsLivServ2);
        parteSpecifica.setSpecificaLivelliServizio(sLivServizio);
        SpecificaSicurezza sSicurezza = new SpecificaSicurezza();
        DocumentoSicurezza dsSicurezza1 = new DocumentoSicurezza();
        dsSicurezza1.setTipo(TipiDocumentoSicurezza.WSPOLICY.toString());
        dsSicurezza1.setBase("SicurezzaDelCanale.wspolicy");
        sSicurezza.addDocumentoSicurezza(dsSicurezza1);
        DocumentoSicurezza dsSicurezza2 = new DocumentoSicurezza();
        dsSicurezza2.setTipo(TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString());
        dsSicurezza2.setBase("LineeGuida.doc");
        sSicurezza.addDocumentoSicurezza(dsSicurezza2);
        parteSpecifica.setSpecificaSicurezza(sSicurezza);
        manifest.setParteSpecifica(parteSpecifica);
        ElencoAllegati elenco = new ElencoAllegati();
        elenco.addGenericoDocumento("Allegato1.doc");
        elenco.addGenericoDocumento("Allegato2.doc");
        manifest.setAllegati(elenco);
        SpecificaSemiformale specifiche = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifiche.addDocumentoSemiformale(docS1);
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifiche.addDocumentoSemiformale(docS2);
        manifest.setSpecificaSemiformale(specifiche);
        return manifest;
    }

    private static it.gov.spcoop.sica.manifest.AccordoCooperazione getManifestoAC() throws Exception {
        it.gov.spcoop.sica.manifest.AccordoCooperazione manifest = new it.gov.spcoop.sica.manifest.AccordoCooperazione();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("AC");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        manifest.setCoordinatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempioCoordinatore", true));
        ElencoAllegati elenco = new ElencoAllegati();
        elenco.addGenericoDocumento("Allegato1.doc");
        elenco.addGenericoDocumento("Allegato2.doc");
        manifest.setAllegati(elenco);
        SpecificaSemiformale specifiche = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifiche.addDocumentoSemiformale(docS1);
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifiche.addDocumentoSemiformale(docS2);
        manifest.setSpecificaSemiformale(specifiche);
        ElencoPartecipanti ePartecipanti = new ElencoPartecipanti();
        ePartecipanti.addPartecipante(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoPartecipante1", true));
        ePartecipanti.addPartecipante(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoPartecipante2", true));
        manifest.setElencoPartecipanti(ePartecipanti);
        ElencoServiziComposti eSC = new ElencoServiziComposti();
        eSC.addServizioComposto(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("sc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoErogatoreServizioComposto1", false), "ASServizioComposto1", "2"));
        eSC.addServizioComposto(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("sc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoErogatoreServizioComposto2", false), "ASServizioComposto2", "2"));
        eSC.addServizioComposto(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("sc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoErogatoreServizioComposto3", false), "ASServizioComposto3", "2"));
        manifest.setServiziComposti(eSC);
        return manifest;
    }

    private static ServizioComposto getManifestoASComposto(boolean generaInfoEGovComeSpecificaSemiformale, boolean generaInfoEGovFormatoClientSICA) throws Exception {
        ServizioComposto manifest = new ServizioComposto();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("ASServizioComposto");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        manifest.setPubblicatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", true));
        manifest.setRiferimentoAccordoCooperazione(SICAtoOpenSPCoopUtilities.buildIDAccordoCooperazioneSica("AC", "2"));
        SpecificaConversazione conversazione = new SpecificaConversazione();
        DocumentoConversazione doc = new DocumentoConversazione();
        doc.setTipo("WSBL");
        doc.setBase("ConversazioneConcettuale.wsbl");
        conversazione.setConversazioneConcettuale(doc);
        DocumentoConversazione docErogatore = new DocumentoConversazione();
        docErogatore.setTipo("WSBL");
        docErogatore.setBase("ConversazioneLogicaLatoErogatore.wsbl");
        conversazione.setConversazioneLogicaLatoErogatore(docErogatore);
        DocumentoConversazione docFruitore = new DocumentoConversazione();
        docFruitore.setTipo("WSBL");
        docFruitore.setBase("ConversazioneLogicaLatoFruitore.wsbl");
        conversazione.setConversazioneLogicaLatoFruitore(docFruitore);
        manifest.setSpecificaConversazione(conversazione);
        SpecificaInterfaccia interfaccia = new SpecificaInterfaccia();
        DocumentoInterfaccia docI = new DocumentoInterfaccia();
        docI.setTipo("WSDL");
        docI.setBase("InterfacciaConcettuale.wsdl");
        interfaccia.setInterfacciaConcettuale(docI);
        DocumentoInterfaccia docIErogatore = new DocumentoInterfaccia();
        docIErogatore.setTipo("WSDL");
        docIErogatore.setBase("InterfacciaLogicaErogatore.wsdl");
        interfaccia.setInterfacciaLogicaLatoErogatore(docIErogatore);
        DocumentoInterfaccia docIFruitore = new DocumentoInterfaccia();
        docIFruitore.setTipo("WSDL");
        docIFruitore.setBase("InterfacciaLogicaFruitore.wsdl");
        interfaccia.setInterfacciaLogicaLatoFruitore(docIFruitore);
        manifest.setSpecificaInterfaccia(interfaccia);
        SpecificaCoordinamento speCorr = new SpecificaCoordinamento();
        DocumentoCoordinamento docCoor = new DocumentoCoordinamento();
        docCoor.setTipo(TipiDocumentoCoordinamento.BPEL.toString());
        docCoor.setBase("Generica Orchestrazione.bpel");
        speCorr.addDocumentoCoordinamento(docCoor);
        DocumentoCoordinamento docCoor2 = new DocumentoCoordinamento();
        docCoor2.setTipo(TipiDocumentoCoordinamento.WSCDL.toString());
        docCoor2.setBase("Generica Orchestrazione.wscdl");
        speCorr.addDocumentoCoordinamento(docCoor2);
        manifest.setSpecificaCoordinamento(speCorr);
        ElencoServiziComponenti componenti = new ElencoServiziComponenti();
        componenti.addServizioComponente(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("ads", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", false), "ASParteSpecifica", "2"));
        componenti.addServizioComponente(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("ads", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", false), "ASParteSpecifica2", "2"));
        manifest.setServiziComponenti(componenti);
        ElencoAllegati allegati = new ElencoAllegati();
        allegati.addGenericoDocumento("Allegato1.doc");
        allegati.addGenericoDocumento("Allegato2.doc");
        allegati.addGenericoDocumento("InterfacciaDefinitoria.xsd");
        manifest.setAllegati(allegati);
        SpecificaSemiformale specifiche = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifiche.addDocumentoSemiformale(docS1);
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifiche.addDocumentoSemiformale(docS2);
        manifest.setSpecificaSemiformale(specifiche);
        if (generaInfoEGovComeSpecificaSemiformale) {
            DocumentoSemiformale docSpecificaEGOV = new DocumentoSemiformale();
            docSpecificaEGOV.setTipo(TipiDocumentoSemiformale.XML.toString());
            if (generaInfoEGovFormatoClientSICA) {
                docSpecificaEGOV.setBase("ProfiloDiCollaborazione.wscp");
            } else {
                docSpecificaEGOV.setBase("ProfiloDiCollaborazione.xml");
            }
            specifiche.addDocumentoSemiformale(docSpecificaEGOV);
            manifest.setSpecificaSemiformale(specifiche);
        } else {
            if (generaInfoEGovFormatoClientSICA) {
                allegati.addGenericoDocumento("ProfiloDiCollaborazione.wscp");
            } else {
                allegati.addGenericoDocumento("ProfiloDiCollaborazione.xml");
            }
            manifest.setAllegati(allegati);
        }
        return manifest;
    }

    private static EgovDecllElement getDichiarazioneEGov(String nomeAccordo) {
        EgovDecllElement egov = new EgovDecllElement();
        egov.setEGovVersion("e-govV1.1");
        egov.setRifDefinizioneInterfaccia(nomeAccordo);
        it.cnipa.collprofiles.OperationListType operations = new it.cnipa.collprofiles.OperationListType();
        OperationType tipoOneWay = new OperationType();
        tipoOneWay.setOperazione("nomeOperationOneWay");
        tipoOneWay.setProfiloDiCollaborazione(TipiProfiliCollaborazione.OneWay.name());
        tipoOneWay.setServizio("nomeServizioOneWay");
        operations.addOperation(tipoOneWay);
        OperationType tipoSincrono = new OperationType();
        tipoSincrono.setOperazione("nomeOperationSincrono");
        tipoSincrono.setProfiloDiCollaborazione(TipiProfiliCollaborazione.Sincrono.name());
        tipoSincrono.setServizio("nomeServizioSincrono");
        operations.addOperation(tipoSincrono);
        OperationType tipoAsincronoSimmetrico = new OperationType();
        tipoAsincronoSimmetrico.setOperazione("nomeOperationAsincronoSimmetricoRichiesta");
        tipoAsincronoSimmetrico.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
        tipoAsincronoSimmetrico.setServizio("nomeServizioAsincronoSimmetrico");
        tipoAsincronoSimmetrico.setOperazioneCorrelata("nomeOperationAsincronoSimmetricoRisposta");
        tipoAsincronoSimmetrico.setServizioCorrelato("nomeServizioCorrelatoAsincronoSimmetrico");
        operations.addOperation(tipoAsincronoSimmetrico);
        OperationType tipoAsincronoAsimmetrico = new OperationType();
        tipoAsincronoAsimmetrico.setOperazione("nomeOperationAsincronoAsimmetricoRichiesta");
        tipoAsincronoAsimmetrico.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
        tipoAsincronoAsimmetrico.setServizio("nomeServizioAsincronoAsimmetrico");
        tipoAsincronoAsimmetrico.setOperazioneCorrelata("nomeOperationAsincronoAsimmetricoRichiestaStato");
        tipoAsincronoAsimmetrico.setServizioCorrelato("nomeServizioAsincronoAsimmetrico");
        operations.addOperation(tipoAsincronoAsimmetrico);
        egov.setOperationList(operations);
        return egov;
    }

    private static ProfiloCollaborazioneEGOV getDichiarazioneEGovFormatoClientSICA(String nomeAccordo) {
        ProfiloCollaborazioneEGOV egov = new ProfiloCollaborazioneEGOV();
        egov.setVersioneEGOV("e-govV1.1");
        egov.setRiferimentoDefinizioneInterfaccia(nomeAccordo);
        OperationListType operations = new OperationListType();
        it.gov.spcoop.sica.wscp.OperationType tipoOneWay = new it.gov.spcoop.sica.wscp.OperationType();
        tipoOneWay.setOperazione("nomeOperationOneWay");
        tipoOneWay.setProfiloDiCollaborazione(it.gov.spcoop.sica.wscp.driver.TipiProfiliCollaborazione.EGOV_IT_MessaggioSingoloOneWay.name());
        tipoOneWay.setServizio("nomeServizioOneWay");
        operations.addCollaborazione(tipoOneWay);
        it.gov.spcoop.sica.wscp.OperationType tipoSincrono = new it.gov.spcoop.sica.wscp.OperationType();
        tipoSincrono.setOperazione("nomeOperationSincrono");
        tipoSincrono.setProfiloDiCollaborazione(it.gov.spcoop.sica.wscp.driver.TipiProfiliCollaborazione.EGOV_IT_ServizioSincrono.name());
        tipoSincrono.setServizio("nomeServizioSincrono");
        operations.addCollaborazione(tipoSincrono);
        it.gov.spcoop.sica.wscp.OperationType tipoAsincronoSimmetrico = new it.gov.spcoop.sica.wscp.OperationType();
        tipoAsincronoSimmetrico.setOperazione("nomeOperationAsincronoSimmetricoRichiesta");
        tipoAsincronoSimmetrico.setProfiloDiCollaborazione(it.gov.spcoop.sica.wscp.driver.TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoSimmetrico.name());
        tipoAsincronoSimmetrico.setServizio("nomeServizioAsincronoSimmetrico");
        tipoAsincronoSimmetrico.setOperazioneCorrelata("nomeOperationAsincronoSimmetricoRisposta");
        tipoAsincronoSimmetrico.setServizioCorrelato("nomeServizioCorrelatoAsincronoSimmetrico");
        operations.addCollaborazione(tipoAsincronoSimmetrico);
        it.gov.spcoop.sica.wscp.OperationType tipoAsincronoAsimmetrico = new it.gov.spcoop.sica.wscp.OperationType();
        tipoAsincronoAsimmetrico.setOperazione("nomeOperationAsincronoAsimmetricoRichiesta");
        tipoAsincronoAsimmetrico.setProfiloDiCollaborazione(it.gov.spcoop.sica.wscp.driver.TipiProfiliCollaborazione.EGOV_IT_ServizioAsincronoAsimmetrico.name());
        tipoAsincronoAsimmetrico.setServizio("nomeServizioAsincronoAsimmetrico");
        tipoAsincronoAsimmetrico.setOperazioneCorrelata("nomeOperationAsincronoAsimmetricoRichiestaStato");
        tipoAsincronoAsimmetrico.setServizioCorrelato("nomeServizioAsincronoAsimmetrico");
        operations.addCollaborazione(tipoAsincronoAsimmetrico);
        egov.setListaCollaborazioni(operations);
        return egov;
    }

    public static void isFileExists(String file) throws Exception {
        if (!new File(file).exists()) {
            throw new Exception(file + " non esistente? Wsdl2Java non ha prodotto l'output atteso");
        }
    }

    protected static class WSDL2JAVA
    extends WSDL2Java {
        private Exception error;

        protected WSDL2JAVA() {
        }

        public Exception getError() {
            return this.error;
        }

        public void run(String[] args) {
            CLArgsParser argsParser = new CLArgsParser(args, options);
            if (null != argsParser.getErrorString()) {
                this.printUsage();
                this.error = new Exception(Messages.getMessage((String)"error01", (String)argsParser.getErrorString()));
                return;
            }
            Vector clOptions = argsParser.getArguments();
            int size = clOptions.size();
            try {
                for (int i = 0; i < size; ++i) {
                    this.parseOption((CLOption)clOptions.get(i));
                }
                this.validateOptions();
                this.parser.run(this.wsdlURI);
            }
            catch (Throwable t) {
                this.error = new Exception("Generazione Stub/Skeleton tramite WSDL2Java fallita: " + t.getMessage(), t);
            }
        }
    }
}

