/*
 * Decompiled with CFR 0.152.
 */
package it.cnipa.collprofiles.driver;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationListType;
import it.cnipa.collprofiles.OperationType;
import it.cnipa.collprofiles.driver.TipiProfiliCollaborazione;
import it.cnipa.collprofiles.driver.XMLUtilsException;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.wsdl.DefinitionWrapper;
import org.openspcoop.dao.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD() throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(XMLUtils.class.getResourceAsStream("/SpecificaSemiformaleEGov.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(EgovDecllElement egov, StringBuffer motivoErroreValidazione) {
        OperationListType operations;
        int size = motivoErroreValidazione.length();
        if (egov.getEGovVersion() == null) {
            motivoErroreValidazione.append("VersioneEGov non definita\n");
        }
        if (egov.getRifDefinizioneInterfaccia() == null) {
            motivoErroreValidazione.append("RifInterfaccia non definita\n");
        }
        if ((operations = egov.getOperationList()) == null) {
            motivoErroreValidazione.append("OperationListType non presente\n");
        } else {
            if (operations.sizeOperationList() <= 0) {
                motivoErroreValidazione.append("OperationListType vuota\n");
            }
            for (int i = 0; i < operations.sizeOperationList(); ++i) {
                OperationType op = operations.getOperation(i);
                if (op.getServizio() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza il servizio\n");
                }
                if (op.getOperazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza l'operation\n");
                }
                if (op.getProfiloDiCollaborazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza un profilo di collaborazione\n");
                }
                if (TipiProfiliCollaborazione.OneWay.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.Sincrono.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) continue;
                motivoErroreValidazione.append("OperationList[" + i + "] con un profilo di collaborazione non conosciuto (" + op.getProfiloDiCollaborazione() + ")\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EgovDecllElement getDichiarazioneEGov(byte[] m, boolean acceptChildUnqualified) throws XMLUtilsException {
        EgovDecllElement egovDecllElement;
        ByteArrayInputStream bin = null;
        try {
            try {
                bin = new ByteArrayInputStream(m);
                egovDecllElement = XMLUtils.getDichiarazioneEGov(bin, acceptChildUnqualified);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (bin == null) throw throwable;
                bin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return egovDecllElement;
        }
        if (bin == null) return egovDecllElement;
        bin.close();
        return egovDecllElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EgovDecllElement getDichiarazioneEGov(File m, boolean acceptChildUnqualified) throws XMLUtilsException {
        EgovDecllElement egovDecllElement;
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(m);
                egovDecllElement = XMLUtils.getDichiarazioneEGov(fin, acceptChildUnqualified);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fin == null) throw throwable;
                fin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return egovDecllElement;
        }
        if (fin == null) return egovDecllElement;
        fin.close();
        return egovDecllElement;
    }

    public static EgovDecllElement getDichiarazioneEGov(String m, boolean acceptChildUnqualified) throws XMLUtilsException {
        return XMLUtils.getDichiarazioneEGov(m.getBytes(), acceptChildUnqualified);
    }

    public static EgovDecllElement getDichiarazioneEGov(InputStream m, boolean acceptChildUnqualified) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            if (XMLUtils.isProfiloCollaborazioneEGOV_NamespaceSPCoopGovIT(xml)) {
                xml = bout.toString().replaceAll("spcoop\\.gov\\.it", "www.cnipa.it").getBytes();
            }
            if (acceptChildUnqualified) {
                xml = XMLUtils.unescapeXMLMalformatoChildElements(xml);
            }
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD();
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (EgovDecllElement)org.openspcoop.dao.commons.XMLUtils.xmlToObj(binTrasformazione, EgovDecllElement.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] unescapeXMLMalformatoChildElements(byte[] xml) {
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(xml);
            Element elemXML = docXML.getDocumentElement();
            String prefixRootElement = elemXML.getPrefix();
            String prefixChildElementEgovVersione = null;
            for (int i = 0; i < elemXML.getChildNodes().getLength(); ++i) {
                Node child = elemXML.getChildNodes().item(i);
                if (!"e-govVersion".equals(child.getLocalName())) continue;
                prefixChildElementEgovVersione = child.getPrefix();
            }
            if (prefixRootElement != null && prefixChildElementEgovVersione == null) {
                String xmlS = new String(xml);
                xmlS = xmlS.replace("<" + prefixRootElement + ":" + "egovDecllElement", "<egovDecllElement");
                xmlS = xmlS.replace("xmlns:" + prefixRootElement, "xmlns");
                xmlS = xmlS.replace("</" + prefixRootElement + ":" + "egovDecllElement", "</egovDecllElement");
                xml = xmlS.getBytes();
            }
            return xml;
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, File out, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(out.getName(), XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, String fileName, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(fileName, XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDichiarazioneEGov(EgovDecllElement manifest, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, OutputStream out, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDichiarazioneEGov_engine(EgovDecllElement manifest, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            org.openspcoop.dao.commons.XMLUtils.objToXml(bout, EgovDecllElement.class, (Object)manifest);
            byte[] dichiarazione = bout.toByteArray();
            if (!namespaceCnipa) {
                dichiarazione = bout.toString().replaceAll("www\\.cnipa\\.it", "spcoop.gov.it").getBytes();
            }
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isProfiloCollaborazioneEGOV(byte[] doc) {
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return "egovDecllElement".equals(elemXML.getLocalName()) && ("http://www.cnipa.it/collProfiles".equals(elemXML.getNamespaceURI()) || "http://spcoop.gov.it/collProfiles".equals(elemXML.getNamespaceURI()));
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isProfiloCollaborazioneEGOV_NamespaceSPCoopGovIT(byte[] doc) {
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return "egovDecllElement".equals(elemXML.getLocalName()) && "http://spcoop.gov.it/collProfiles".equals(elemXML.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String readNomeSPCoop(String QName, Hashtable<String, String> mapPrefixNamespaces) throws XMLUtilsException {
        if (QName == null) {
            return null;
        }
        if (QName.contains(":")) {
            String[] split = QName.split(":");
            if (split.length != 2) {
                throw new XMLUtilsException("QName [" + QName + "] non valido");
            }
            String prefix = split[0].trim();
            String nomeSPCoop = split[1].trim();
            if (mapPrefixNamespaces.containsKey(prefix)) {
                return nomeSPCoop;
            }
            throw new XMLUtilsException("QName [" + QName + "] non valido, prefix [" + prefix + "] non associato a nessun namespace");
        }
        return QName;
    }

    public static void mapProfiloCollaborazioneEGOVIntoAS(byte[] doc, AccordoServizio as, boolean acceptChildUnqualified) throws XMLUtilsException {
        EgovDecllElement egov = null;
        try {
            egov = XMLUtils.getDichiarazioneEGov(doc, acceptChildUnqualified);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Documento con informazione egov non leggibile: " + e.getMessage(), e);
        }
        Hashtable<String, String> mapPrefixNamespaces = new Hashtable<String, String>();
        try {
            Document docXML = org.openspcoop.utils.xml.XMLUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            NamedNodeMap map = elemXML.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node o = map.item(i);
                if (!(o instanceof Attr)) continue;
                Attr attr = (Attr)o;
                String prefix = "";
                if (attr.getPrefix() != null) {
                    prefix = attr.getLocalName();
                }
                mapPrefixNamespaces.put(prefix, attr.getValue());
            }
        }
        catch (Exception e) {
            throw new XMLUtilsException("Documento XML con informazione egov non leggibile: " + e.getMessage(), e);
        }
        Hashtable<String, PortType> servizi = new Hashtable<String, PortType>();
        OperationListType list = egov.getOperationList();
        for (int h = 0; h < list.sizeOperationList(); ++h) {
            OperationType operationType = list.getOperation(h);
            String nomeAzione = XMLUtils.readNomeSPCoop(operationType.getOperazione(), mapPrefixNamespaces);
            String nomeServizio = XMLUtils.readNomeSPCoop(operationType.getServizio(), mapPrefixNamespaces);
            String nomeAzioneCorrelata = XMLUtils.readNomeSPCoop(operationType.getOperazioneCorrelata(), mapPrefixNamespaces);
            String nomeServizioCorrelato = XMLUtils.readNomeSPCoop(operationType.getServizioCorrelato(), mapPrefixNamespaces);
            String profiloCollaborazione = operationType.getProfiloDiCollaborazione();
            PortType pt = null;
            if (servizi.containsKey(nomeServizio)) {
                pt = (PortType)servizi.remove(nomeServizio);
            } else {
                pt = new PortType();
                pt.setProfiloPT("ridefinito");
                if (TipiProfiliCollaborazione.OneWay.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("oneway");
                } else if (TipiProfiliCollaborazione.Sincrono.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("sincrono");
                } else if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("asincronoSimmetrico");
                } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione("asincronoAsimmetrico");
                } else {
                    throw new XMLUtilsException("Profilo di collaborazione non valido [" + profiloCollaborazione + "]");
                }
                pt.setNome(nomeServizio);
            }
            Operation azione = new Operation();
            azione.setNome(nomeAzione);
            azione.setProfAzione("ridefinito");
            if (TipiProfiliCollaborazione.OneWay.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("oneway");
            } else if (TipiProfiliCollaborazione.Sincrono.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("sincrono");
            } else if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("asincronoSimmetrico");
            } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione("asincronoAsimmetrico");
            } else {
                throw new XMLUtilsException("Profilo di collaborazione non valido [" + profiloCollaborazione + "]");
            }
            pt.addAzione(azione);
            servizi.put(nomeServizio, pt);
            if (!TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(profiloCollaborazione) && !TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(profiloCollaborazione) || nomeAzioneCorrelata == null) continue;
            String servizio = nomeServizioCorrelato;
            if (servizio == null) {
                servizio = nomeServizio;
            }
            PortType ptCorrelato = null;
            if (servizi.containsKey(servizio)) {
                ptCorrelato = (PortType)servizi.remove(servizio);
            } else {
                ptCorrelato = new PortType();
                ptCorrelato.setProfiloPT("ridefinito");
                if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                    ptCorrelato.setProfiloCollaborazione("asincronoSimmetrico");
                } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                    ptCorrelato.setProfiloCollaborazione("asincronoAsimmetrico");
                }
                ptCorrelato.setNome(servizio);
            }
            Operation azioneCorrelata = new Operation();
            azioneCorrelata.setNome(nomeAzioneCorrelata);
            azioneCorrelata.setProfAzione("ridefinito");
            if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(profiloCollaborazione)) {
                azioneCorrelata.setProfiloCollaborazione("asincronoSimmetrico");
            } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(profiloCollaborazione)) {
                azioneCorrelata.setProfiloCollaborazione("asincronoAsimmetrico");
            }
            if (nomeServizio != null) {
                azioneCorrelata.setCorrelataServizio(nomeServizio);
            }
            azioneCorrelata.setCorrelata(nomeAzione);
            ptCorrelato.addAzione(azioneCorrelata);
            servizi.put(servizio, ptCorrelato);
        }
        Enumeration keys = servizi.keys();
        while (keys.hasMoreElements()) {
            String pt = (String)keys.nextElement();
            as.addPortType((PortType)servizi.get(pt));
        }
    }

    public static DocumentoSemiformale generaDocumentoSemiformale(AccordoServizio as, AccordoServizioParteComune accServParteComuneSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        DocumentoSemiformale docSemiformalePerManifest = XMLUtils.generaDocumentoSemiformalePerManifesto();
        Documento docSICA = XMLUtils.generaDocumentoSemiformale(as, namespaceCnipa, nomiSPCoopQualified);
        accServParteComuneSICA.addSpecificaSemiformale(docSICA);
        return docSemiformalePerManifest;
    }

    public static DocumentoSemiformale generaDocumentoSemiformale(AccordoServizio as, AccordoServizioComposto accServCompostoSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        DocumentoSemiformale docSemiformalePerManifest = XMLUtils.generaDocumentoSemiformalePerManifesto();
        Documento docSICA = XMLUtils.generaDocumentoSemiformale(as, namespaceCnipa, nomiSPCoopQualified);
        accServCompostoSICA.addSpecificaSemiformale(docSICA);
        return docSemiformalePerManifest;
    }

    private static DocumentoSemiformale generaDocumentoSemiformalePerManifesto() throws XMLUtilsException {
        DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
        docSemiformale.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSemiformale.setBase("ProfiloDiCollaborazione.xml");
        return docSemiformale;
    }

    private static Documento generaDocumentoSemiformale(AccordoServizio as, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        Documento docSICA = new Documento();
        docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSICA.setNome("ProfiloDiCollaborazione.xml");
        try {
            byte[] dichiarazioneEGov = XMLUtils.generaDocumentoEGov(as, namespaceCnipa, nomiSPCoopQualified);
            docSICA.setContenuto(dichiarazioneEGov);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
        }
        return docSICA;
    }

    public static String generaGenericoDocumento(AccordoServizio as, AccordoServizioParteComune accServParteComuneSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        String genericoDocumentoPerManifest = XMLUtils.generaGenericoDocumentoPerManifesto();
        Documento docSICA = XMLUtils.generaGenericoDocumento(as, namespaceCnipa, nomiSPCoopQualified);
        accServParteComuneSICA.addAllegato(docSICA);
        return genericoDocumentoPerManifest;
    }

    public static String generaGenericoDocumento(AccordoServizio as, AccordoServizioComposto accServCompostoSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        String genericoDocumentoPerManifest = XMLUtils.generaGenericoDocumentoPerManifesto();
        Documento docSICA = XMLUtils.generaGenericoDocumento(as, namespaceCnipa, nomiSPCoopQualified);
        accServCompostoSICA.addAllegato(docSICA);
        return genericoDocumentoPerManifest;
    }

    private static String generaGenericoDocumentoPerManifesto() throws XMLUtilsException {
        return "ProfiloDiCollaborazione.xml";
    }

    private static Documento generaGenericoDocumento(AccordoServizio as, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        Documento docSICA = new Documento();
        docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSICA.setNome("ProfiloDiCollaborazione.xml");
        try {
            byte[] dichiarazioneEGov = XMLUtils.generaDocumentoEGov(as, namespaceCnipa, nomiSPCoopQualified);
            docSICA.setContenuto(dichiarazioneEGov);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
        }
        return docSICA;
    }

    private static byte[] generaDocumentoEGov(AccordoServizio as, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        String prefissoNomiSPCoop = "";
        String namespaceQualified = null;
        if (nomiSPCoopQualified) {
            try {
                byte[] wsdlConcettuale = as.getByteWsdlConcettuale();
                if (wsdlConcettuale != null) {
                    RegistroOpenSPCoopUtilities wsdlUtility = new RegistroOpenSPCoopUtilities(null);
                    wsdlConcettuale = wsdlUtility.eliminaImportASParteComune(wsdlConcettuale);
                    DefinitionWrapper wsdl = new DefinitionWrapper(wsdlConcettuale);
                    String targetNamespace = wsdl.getTargetNamespace();
                    String prefix = null;
                    if (targetNamespace != null && (prefix = wsdl.getPrefix(targetNamespace)) == null) {
                        prefix = "tnsService";
                    }
                    if (targetNamespace != null) {
                        prefissoNomiSPCoop = prefix + ":";
                        namespaceQualified = "xmlns:" + prefix + "=\"" + targetNamespace + "\"";
                    }
                }
            }
            catch (Exception e) {
                System.out.println("errore durante la lettura del target namespace del wsdl: " + e.getMessage());
            }
        }
        byte[] dichiarazioneEGov = XMLUtils.generateDichiarazioneEGov(XMLUtils.generaProfiloCollaborazioneEGOV(as, prefissoNomiSPCoop), namespaceCnipa);
        if (nomiSPCoopQualified && namespaceQualified != null) {
            dichiarazioneEGov = new String(dichiarazioneEGov).replaceFirst("egovDecllElement", "egovDecllElement " + namespaceQualified).getBytes();
        }
        return dichiarazioneEGov;
    }

    private static EgovDecllElement generaProfiloCollaborazioneEGOV(AccordoServizio as, String prefissoNomiSPCoop) throws XMLUtilsException {
        if (as.sizePortTypeList() > 0) {
            EgovDecllElement egov = new EgovDecllElement();
            egov.setEGovVersion("e-govV1.1");
            egov.setRifDefinizioneInterfaccia(as.getNome());
            OperationListType operations = new OperationListType();
            Vector<OperationType> operationsSICA_asincrone_nonAncoraInserite = new Vector<OperationType>();
            for (int i = 0; i < as.sizePortTypeList(); ++i) {
                PortType pt = as.getPortType(i);
                String nomeServizio = prefissoNomiSPCoop + pt.getNome();
                for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                    OperationType opSICA;
                    String nomeServizioCorrelato;
                    Operation op = pt.getAzione(j);
                    String nomeAzione = prefissoNomiSPCoop + op.getNome();
                    String nomeAzioneCorrelata = op.getCorrelata();
                    if (nomeAzioneCorrelata != null) {
                        nomeAzioneCorrelata = prefissoNomiSPCoop + nomeAzioneCorrelata;
                    }
                    if ((nomeServizioCorrelato = op.getCorrelataServizio()) != null) {
                        nomeServizioCorrelato = prefissoNomiSPCoop + nomeServizioCorrelato;
                    }
                    String profilo = null;
                    profilo = "ridefinito".equals(op.getProfAzione()) ? op.getProfiloCollaborazione() : pt.getProfiloCollaborazione();
                    if ("asincronoAsimmetrico".equals(profilo) || "asincronoSimmetrico".equals(profilo)) {
                        if (nomeAzioneCorrelata == null) {
                            opSICA = new OperationType();
                            opSICA.setOperazione(nomeAzione);
                            if ("asincronoAsimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
                            } else if ("asincronoSimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
                            }
                            opSICA.setServizio(nomeServizio);
                            operationsSICA_asincrone_nonAncoraInserite.add(opSICA);
                            continue;
                        }
                        opSICA = new OperationType();
                        opSICA.setOperazione(nomeAzioneCorrelata);
                        opSICA.setOperazioneCorrelata(nomeAzione);
                        if ("asincronoAsimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
                        } else if ("asincronoSimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
                        }
                        if (nomeServizioCorrelato != null) {
                            opSICA.setServizio(nomeServizioCorrelato);
                        } else {
                            opSICA.setServizio(nomeServizio);
                        }
                        opSICA.setServizioCorrelato(nomeServizio);
                        operations.addOperation(opSICA);
                        continue;
                    }
                    opSICA = new OperationType();
                    opSICA.setOperazione(nomeAzione);
                    if ("oneway".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.OneWay.name());
                    } else if ("sincrono".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.Sincrono.name());
                    }
                    opSICA.setServizio(nomeServizio);
                    operations.addOperation(opSICA);
                }
            }
            while (operationsSICA_asincrone_nonAncoraInserite.size() > 0) {
                OperationType opSICA = (OperationType)operationsSICA_asincrone_nonAncoraInserite.remove(0);
                boolean find = false;
                for (int i = 0; i < operations.sizeOperationList(); ++i) {
                    if (!opSICA.getServizio().equals(operations.getOperation(i).getServizio()) || !opSICA.getOperazione().equals(operations.getOperation(i).getOperazione())) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                operations.addOperation(opSICA);
            }
            egov.setOperationList(operations);
            return egov;
        }
        throw new XMLUtilsException("PortTypes non definiti per l'accordo di servizio");
    }
}

