/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl.validator;

import java.io.File;
import java.net.URI;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.jvnet.ws.wadl.HTTPMethods;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.wadl.ApplicationWrapper;
import org.openspcoop2.utils.wadl.WADLUtilities;
import org.openspcoop2.utils.wadl.entity.DocumentHttpRequestEntity;
import org.openspcoop2.utils.wadl.entity.DocumentHttpResponseEntity;
import org.openspcoop2.utils.wadl.entity.TextHttpRequestEntity;
import org.openspcoop2.utils.wadl.validator.Validator;
import org.openspcoop2.utils.wadl.validator.WADLValidatorException;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Test {
    public static void main(String[] args) throws Exception {
        System.out.println("Inizializzazione dell'oggetto ApplicationWrapper...");
        XMLUtils xmlUtils = XMLUtils.getInstance();
        URI uri = Test.class.getResource("/org/openspcoop2/utils/wadl/test.wadl").toURI();
        Logger log = Logger.getRootLogger();
        WADLUtilities wadlUtilities = WADLUtilities.getInstance(xmlUtils);
        ApplicationWrapper wr = wadlUtilities.readWADLFromBytes(log, FileSystemUtilities.readBytesFromFile(new File(uri)), true, false, true);
        wr.addResource("test2.xsd", Utilities.getAsByteArray(Test.class.getResourceAsStream("/org/openspcoop2/utils/wadl/test2.xsd")));
        System.out.println("Inizializzazione dell'oggetto ApplicationWrapper completata");
        Validator validator = new Validator(log, wr);
        System.out.println("Test #1 (Richiesta GET con due parametri obbligatori)");
        TextHttpRequestEntity httpEntity = new TextHttpRequestEntity();
        httpEntity.setUrl("/prova2");
        httpEntity.setMethod(HTTPMethods.GET);
        Properties parametersFormBased = new Properties();
        parametersFormBased.put("idTrasmissionePROVA2Required", "true");
        parametersFormBased.put("idTrasmissionePROVA2NOTRequired", "true");
        httpEntity.setParametersFormBased(parametersFormBased);
        Properties parametersTrasporto = new Properties();
        parametersTrasporto.put("idTrasmissionePROVA2headerRequired", "true");
        parametersTrasporto.put("idTrasmissionePROVA2headerNOTRequired", "true");
        httpEntity.setParametersTrasporto(parametersTrasporto);
        validator.validate(httpEntity);
        System.out.println("Test #1 completato");
        System.out.println("Test #2 (Richiesta GET con tipo XML)");
        DocumentHttpRequestEntity httpEntity2 = new DocumentHttpRequestEntity();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElementNS("http://www.openspcoop.org/example/wadl/interno", "test");
        Element idTest = document.createElement("id-test");
        idTest.setTextContent("1");
        root.appendChild(idTest);
        Element nome = document.createElement("nome");
        nome.setTextContent("nome");
        root.appendChild(nome);
        document.appendChild(root);
        httpEntity2.setContent(document);
        httpEntity2.setContentType("application/xml");
        httpEntity2.setUrl("/allineamentopendenze/getStatoTrasmissioni");
        httpEntity2.setMethod(HTTPMethods.POST);
        validator.validate(httpEntity2);
        System.out.println("Test #2 completato");
        System.out.println("Test #3 (Risposta POST con differenti tipi di XML a seconda dello stato, caso 400)");
        DocumentHttpResponseEntity httpEntity3 = new DocumentHttpResponseEntity();
        httpEntity3.setStatus(400);
        Document document1 = builder.newDocument();
        Element raccolta = document1.createElementNS("http://www.openspcoop.org/example/wadl/inline/importInclude", "raccolta");
        Element idRaccolta = document1.createElementNS("http://www.openspcoop.org/example/wadl/inline/importInclude", "id-raccolta");
        idRaccolta.setTextContent("1");
        raccolta.appendChild(idRaccolta);
        Element raccoltaTest = document1.createElementNS("http://www.openspcoop.org/example/wadl/interno", "test");
        Element raccoltaTestIdTest = document1.createElementNS("http://www.openspcoop.org/example/wadl/interno", "id-test");
        raccoltaTestIdTest.setTextContent("1");
        raccoltaTest.appendChild(raccoltaTestIdTest);
        Element raccoltaTestNome = document1.createElementNS("http://www.openspcoop.org/example/wadl/interno", "nome");
        raccoltaTestNome.setTextContent("nome");
        raccoltaTest.appendChild(raccoltaTestNome);
        raccolta.appendChild(raccoltaTest);
        document1.appendChild(raccolta);
        httpEntity3.setContent(document1);
        httpEntity3.setContentType("application/xml");
        httpEntity3.setUrl("/allineamentopendenze/getStatoTrasmissioniConPiuResponse");
        httpEntity3.setMethod(HTTPMethods.POST);
        validator.validate(httpEntity3);
        System.out.println("Test #3 completato");
        System.out.println("Test #4 (Risposta POST con differenti tipi di XML a seconda dello stato, caso 200)");
        DocumentHttpResponseEntity httpEntity4 = new DocumentHttpResponseEntity();
        httpEntity4.setStatus(200);
        Document document2 = builder.newDocument();
        Element root2 = document2.createElementNS("http://www.openspcoop.org/example/wadl/interno", "test");
        Element idTest2 = document2.createElement("id-test");
        idTest2.setTextContent("1");
        root2.appendChild(idTest2);
        Element nome2 = document2.createElement("nome");
        nome2.setTextContent("nome");
        root2.appendChild(nome2);
        document2.appendChild(root2);
        httpEntity4.setContent(document2);
        httpEntity4.setContentType("application/xml");
        httpEntity4.setUrl("/allineamentopendenze/getStatoTrasmissioniConPiuResponse");
        httpEntity4.setMethod(HTTPMethods.POST);
        validator.validate(httpEntity4);
        System.out.println("Test #4 completato");
        System.out.println("Test #5 (Risposta POST con differenti tipi di XML a seconda dello stato, caso di XML sbagliato)");
        DocumentHttpResponseEntity httpEntity5 = new DocumentHttpResponseEntity();
        httpEntity5.setStatus(200);
        Document document3 = builder.newDocument();
        Element root3 = document3.createElement("sbagliato");
        document3.appendChild(root3);
        httpEntity5.setContent(document3);
        httpEntity5.setContentType("application/xml");
        httpEntity5.setUrl("/allineamentopendenze/getStatoTrasmissioniConPiuResponse");
        httpEntity5.setMethod(HTTPMethods.POST);
        try {
            validator.validate(httpEntity5);
            throw new Exception("Errore: Attesa " + WADLValidatorException.class.getName());
        }
        catch (WADLValidatorException e) {
            System.out.println("Test #5 completato");
            return;
        }
    }
}

