/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.IDBuilder;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.PropertyFilter;
import org.openspcoop2.utils.serialization.Utilities;

public class XMLSerializer
implements ISerializer {
    private JsonConfig jsonConfig;
    private net.sf.json.xml.XMLSerializer xmlSerializer;

    public XMLSerializer(Filter filter) {
        this(filter, null, null);
    }

    public XMLSerializer(Filter filter, IDBuilder idBuilder) {
        this(filter, idBuilder, null);
    }

    public XMLSerializer(Filter filter, String[] excludes) {
        this(filter, null, excludes);
    }

    public XMLSerializer(Filter filter, IDBuilder idBuilder, String[] excludes) {
        XMLSerializer filtroInternoOggettiFiltratiDiversiByteArray = null;
        if (filter.sizeFiltersByValue() > 0 || filter.sizeFiltersByName() > 0) {
            filtroInternoOggettiFiltratiDiversiByteArray = new XMLSerializer(new Filter(), idBuilder);
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter((net.sf.json.util.PropertyFilter)new PropertyFilter(filter, idBuilder, filtroInternoOggettiFiltratiDiversiByteArray));
        if (excludes != null) {
            jsonConfig.setExcludes(excludes);
        }
        this.jsonConfig = jsonConfig;
        this.xmlSerializer = new net.sf.json.xml.XMLSerializer();
    }

    @Override
    public String getObject(Object o) throws IOException {
        try {
            Utilities.normalizeDateObjects(o);
            if (o instanceof Enum || o != null && o.getClass().isArray() || o instanceof List || o instanceof Set) {
                JSONArray jsonArray = JSONArray.fromObject((Object)o, (JsonConfig)this.jsonConfig);
                return this.xmlSerializer.write((JSON)jsonArray);
            }
            if (o instanceof Annotation || o != null && o.getClass().isAnnotation()) {
                throw new IOException("'object' is an Annotation.");
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)o, (JsonConfig)this.jsonConfig);
            return this.xmlSerializer.write((JSON)jsonObject);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, OutputStream out) throws IOException {
        try {
            Utilities.normalizeDateObjects(o);
            String s = this.getObject(o);
            out.write(s.getBytes());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, Writer out) throws IOException {
        try {
            Utilities.normalizeDateObjects(o);
            String s = this.getObject(o);
            out.write(s);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

