/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.input.CharSequenceReader;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class TemplateUtils {
    public static Configuration newTemplateEngine() {
        return TemplateUtils.newTemplateEngine(TemplateUtils.class, "", null, null);
    }

    public static Configuration newTemplateEngine(String prefix) {
        return TemplateUtils.newTemplateEngine(TemplateUtils.class, prefix, null, null);
    }

    public static Configuration newTemplateEngine(Class<?> c) {
        return TemplateUtils.newTemplateEngine(c, "", null, null);
    }

    public static Configuration newTemplateEngine(Class<?> c, String prefix) {
        return TemplateUtils.newTemplateEngine(c, prefix, null, null);
    }

    public static Configuration newTemplateEngine(Class<?> c, String prefix, ObjectWrapper wrapper) {
        return TemplateUtils.newTemplateEngine(c, prefix, wrapper, null);
    }

    public static Configuration newTemplateEngine(Class<?> c, String prefix, ObjectWrapper wrapper, TemplateLoader templateLoader) {
        Configuration cfgFreeMarker = new Configuration(Configuration.VERSION_2_3_23);
        cfgFreeMarker.setClassForTemplateLoading(c, prefix);
        if (wrapper != null) {
            cfgFreeMarker.setObjectWrapper(wrapper);
        }
        if (templateLoader != null) {
            cfgFreeMarker.setTemplateLoader(templateLoader);
        }
        return cfgFreeMarker;
    }

    public static Template getTemplate(Configuration cfg, String templateName) throws IOException {
        return cfg.getTemplate(templateName);
    }

    public static Template getTemplate(String templateName) throws IOException {
        Configuration cfg = TemplateUtils.newTemplateEngine();
        return cfg.getTemplate(templateName);
    }

    public static Template getTemplate(String prefix, String templateName) throws IOException {
        Configuration cfg = TemplateUtils.newTemplateEngine(prefix);
        return cfg.getTemplate(templateName);
    }

    public static Template getTemplate(Class<?> c, String prefix, String templateName) throws IOException {
        Configuration cfg = TemplateUtils.newTemplateEngine(c, prefix);
        return cfg.getTemplate(templateName);
    }

    public static Template getTemplate(Class<?> c, String prefix, ObjectWrapper wrapper, String templateName) throws IOException {
        Configuration cfg = TemplateUtils.newTemplateEngine(c, prefix, wrapper);
        return cfg.getTemplate(templateName);
    }

    public static Template buildTemplate(String name, byte[] bytes) throws IOException {
        return new Template(name, (Reader)new CharSequenceReader((CharSequence)new String(bytes)), TemplateUtils.newTemplateEngine());
    }

    public static byte[] toByteArray(Template template, Map<?, ?> map) throws IOException, TemplateException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bout);
        template.process(map, (Writer)writer);
        writer.flush();
        writer.close();
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    public static String toString(Template template, Map<?, ?> map) throws IOException, TemplateException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bout);
        template.process(map, (Writer)writer);
        writer.flush();
        writer.close();
        bout.flush();
        bout.close();
        return bout.toString();
    }

    public static void writeFile(Template template, Map<?, ?> map, File file, boolean overwrite) throws Exception {
        if (!overwrite && file.exists()) {
            System.out.println(": WARNING !! File [" + file.getAbsolutePath() + "] is already exist, it is not overwritten !!");
            return;
        }
        FileSystemUtilities.mkdirParentDirectory(file);
        FileSystemUtilities.writeFile(file, TemplateUtils.toByteArray(template, map));
    }
}

