/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.SSLConfig;
import org.openspcoop2.utils.resources.SSLHostNameVerifierDisabled;

public class SSLUtilities {
    public static SSLContext generateSSLContext(SSLConfig sslConfig, StringBuffer bfLog) throws UtilsException {
        SSLContext sslContext = null;
        bfLog.append("Creo contesto SSL...\n");
        KeyManager[] km = null;
        TrustManager[] tm = null;
        FileInputStream finKeyStore = null;
        FileInputStream finTrustStore = null;
        try {
            Object truststore;
            if (sslConfig.getKeyStoreLocation() != null) {
                bfLog.append("Gestione keystore...\n");
                KeyStore keystore = KeyStore.getInstance(sslConfig.getKeyStoreType());
                finKeyStore = new FileInputStream(sslConfig.getKeyStoreLocation());
                keystore.load(finKeyStore, sslConfig.getKeyStorePassword().toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(sslConfig.getKeyManagementAlgorithm());
                keyManagerFactory.init(keystore, sslConfig.getKeyPassword().toCharArray());
                km = keyManagerFactory.getKeyManagers();
                bfLog.append("Gestione keystore effettuata\n");
            }
            if (sslConfig.getTrustStoreLocation() != null) {
                bfLog.append("Gestione truststore...\n");
                truststore = KeyStore.getInstance(sslConfig.getTrustStoreType());
                finTrustStore = new FileInputStream(sslConfig.getTrustStoreLocation());
                ((KeyStore)truststore).load(finTrustStore, sslConfig.getTrustStorePassword().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(sslConfig.getTrustManagementAlgorithm());
                trustManagerFactory.init((KeyStore)truststore);
                tm = trustManagerFactory.getTrustManagers();
                bfLog.append("Gestione truststore effettuata\n");
            }
            sslContext = SSLContext.getInstance(sslConfig.getSslType());
            sslContext.init(km, tm, null);
            truststore = sslContext;
            return truststore;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (finKeyStore != null) {
                    finKeyStore.close();
                }
            }
            catch (Exception e) {}
            try {
                if (finTrustStore != null) {
                    finTrustStore.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static HostnameVerifier generateHostnameVerifier(SSLConfig sslConfig, StringBuffer bfLog, Logger log, Loader loader) throws UtilsException {
        try {
            if (sslConfig.isHostnameVerifier()) {
                if (sslConfig.getClassNameHostnameVerifier() != null) {
                    bfLog.append("HostNamve verifier enabled [" + sslConfig.getClassNameHostnameVerifier() + "]\n");
                    HostnameVerifier verifica = (HostnameVerifier)loader.newInstance(sslConfig.getClassNameHostnameVerifier());
                    return verifica;
                }
                bfLog.append("HostName verifier enabled\n");
                return null;
            }
            bfLog.append("HostName verifier disabled\n");
            SSLHostNameVerifierDisabled disabilitato = new SSLHostNameVerifierDisabled(log);
            return disabilitato;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void setSSLContextIntoJavaProperties(SSLConfig sslConfig, StringBuffer bfLog) throws UtilsException {
        bfLog.append("Creo contesto SSL...\n");
        try {
            if (sslConfig.getKeyStoreLocation() != null) {
                bfLog.append("Gestione keystore...\n");
                System.setProperty("javax.net.ssl.keyStore", sslConfig.getKeyStoreLocation());
                if (sslConfig.getKeyStoreType() != null) {
                    System.setProperty("javax.net.ssl.keyStoreType", sslConfig.getKeyStoreType());
                }
                if (sslConfig.getKeyStorePassword() != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", sslConfig.getKeyStorePassword());
                }
                if (sslConfig.getKeyPassword() != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", sslConfig.getKeyStorePassword());
                    if (sslConfig.getKeyStorePassword() != null && !sslConfig.getKeyPassword().equals(sslConfig.getKeyStorePassword())) {
                        throw new UtilsException("Keystore and key password in java must be equals");
                    }
                }
                bfLog.append("Gestione keystore effettuata\n");
            }
            if (sslConfig.getTrustStoreLocation() != null) {
                bfLog.append("Gestione truststore...\n");
                System.setProperty("javax.net.ssl.trustStore", sslConfig.getTrustStoreLocation());
                if (sslConfig.getKeyStoreType() != null) {
                    System.setProperty("javax.net.ssl.trustStoreType", sslConfig.getTrustStoreType());
                }
                if (sslConfig.getKeyStorePassword() != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", sslConfig.getTrustStorePassword());
                }
                bfLog.append("Gestione truststore effettuata\n");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

