/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.nio.charset.CharsetEncoder;
import javax.mail.internet.MimeUtility;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.RFC2047Encoding;

public class RFC2047Utilities {
    public static void main(String[] args) throws Exception {
        String string_iso_8859_1 = "f\u00fcr psychisch";
        String string_us_ascii = "fur psychisch";
        System.out.println("IS [" + string_iso_8859_1 + "] in CHARSET ISO_8859_1 ?: " + RFC2047Utilities.isAllCharactersInCharset(string_iso_8859_1, Charset.ISO_8859_1));
        System.out.println("IS [" + string_iso_8859_1 + "] in CHARSET US_ASCII ?: " + RFC2047Utilities.isAllCharactersInCharset(string_iso_8859_1, Charset.US_ASCII));
        System.out.println("IS [" + string_us_ascii + "] in CHARSET ISO_8859_1 ?: " + RFC2047Utilities.isAllCharactersInCharset(string_us_ascii, Charset.ISO_8859_1));
        System.out.println("IS [" + string_us_ascii + "] in CHARSET US_ASCII ?: " + RFC2047Utilities.isAllCharactersInCharset(string_us_ascii, Charset.US_ASCII));
        System.out.println("\n*** RFC2047 ISO_8859_1 B ***");
        String var_RFC2047_ISO_8859_1_B = RFC2047Utilities.encode(string_iso_8859_1, Charset.ISO_8859_1, RFC2047Encoding.B);
        System.out.println("[" + string_iso_8859_1 + "] encoded in RFC2047(" + Charset.ISO_8859_1 + "," + (Object)((Object)RFC2047Encoding.B) + "): " + var_RFC2047_ISO_8859_1_B);
        System.out.println("Decode: " + RFC2047Utilities.decode(var_RFC2047_ISO_8859_1_B));
        System.out.println("\n*** RFC2047 ISO_8859_1 Q ***");
        String var_RFC2047_ISO_8859_1_Q = RFC2047Utilities.encode(string_iso_8859_1, Charset.ISO_8859_1, RFC2047Encoding.Q);
        System.out.println("[" + string_iso_8859_1 + "] encoded in RFC2047(" + Charset.ISO_8859_1 + "," + (Object)((Object)RFC2047Encoding.Q) + "): " + var_RFC2047_ISO_8859_1_Q);
        System.out.println("Decode: " + RFC2047Utilities.decode(var_RFC2047_ISO_8859_1_Q));
        System.out.println("\n*** RFC2047 US_ASCII B ***");
        String var_RFC2047_US_ASCII_B = RFC2047Utilities.encode(string_iso_8859_1, Charset.US_ASCII, RFC2047Encoding.B);
        System.out.println("[" + string_iso_8859_1 + "] encoded in RFC2047(" + Charset.US_ASCII + "," + (Object)((Object)RFC2047Encoding.B) + "): " + var_RFC2047_US_ASCII_B);
        System.out.println("Decode: " + RFC2047Utilities.decode(var_RFC2047_US_ASCII_B));
        System.out.println("\n*** RFC2047 US_ASCII Q ***");
        String var_RFC2047_US_ASCII_Q = RFC2047Utilities.encode(string_iso_8859_1, Charset.US_ASCII, RFC2047Encoding.Q);
        System.out.println("[" + string_iso_8859_1 + "] encoded in RFC2047(" + Charset.US_ASCII + "," + (Object)((Object)RFC2047Encoding.Q) + "): " + var_RFC2047_US_ASCII_Q);
        System.out.println("Decode: " + RFC2047Utilities.decode(var_RFC2047_US_ASCII_Q));
    }

    public static String encode(String value, Charset charset, RFC2047Encoding encoding) throws UtilsException {
        try {
            return MimeUtility.encodeWord((String)value, (String)charset.getValue(), (String)encoding.name());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String decode(String value) throws UtilsException {
        try {
            return MimeUtility.decodeWord((String)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static boolean isAllCharactersInCharset(String value, Charset charset) throws UtilsException {
        try {
            CharsetEncoder encoder = java.nio.charset.Charset.forName(charset.getValue()).newEncoder();
            return encoder.canEncode(value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

