/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesUtilities {
    public static Properties searchLocalImplementation(String OPENSPCOOP2_LOCAL_HOME, Logger log, String variabile, String path, String confDirectory) {
        Properties p6;
        Properties p1 = PropertiesUtilities.examineStep1(log, variabile);
        if (p1 != null) {
            return p1;
        }
        Properties p2 = PropertiesUtilities.examineStep2(log, variabile);
        if (p2 != null) {
            return p2;
        }
        Properties p3 = PropertiesUtilities.examineStep3(OPENSPCOOP2_LOCAL_HOME, log, path);
        if (p3 != null) {
            return p3;
        }
        Properties p4 = PropertiesUtilities.examineStep4(OPENSPCOOP2_LOCAL_HOME, log, path);
        if (p4 != null) {
            return p4;
        }
        Properties p5 = PropertiesUtilities.examineStep5(log, path);
        if (p5 != null) {
            return p5;
        }
        File fConfDirectory = null;
        if (confDirectory != null) {
            fConfDirectory = new File(confDirectory);
        }
        if (fConfDirectory != null && fConfDirectory.exists() && fConfDirectory.isDirectory() && (p6 = PropertiesUtilities.examineStep6(log, path, fConfDirectory)) != null) {
            return p6;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties examineStep1(Logger log, String variabile) {
        String file = System.getenv(variabile);
        String subject = "Variabile di sistema " + variabile;
        if (file != null) {
            File ffile = new File(file);
            if (!ffile.exists()) {
                log.error((Object)("[" + subject + "] File non esistente: " + ffile.getAbsolutePath()));
                return null;
            }
            if (!ffile.canRead()) {
                log.error((Object)("[" + subject + "] File non accessibile: " + ffile.getAbsolutePath()));
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(ffile);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error((Object)("[" + subject + "] file di properties non utilizzabile: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception eClose) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties examineStep2(Logger log, String variabile) {
        String file = System.getProperty(variabile);
        String subject = "Proprieta' di sistema " + variabile;
        if (file != null) {
            File ffile = new File(file);
            if (!ffile.exists()) {
                log.error((Object)("[" + subject + "] File non esistente: " + ffile.getAbsolutePath()));
                return null;
            }
            if (!ffile.canRead()) {
                log.error((Object)("[" + subject + "] File non accessibile: " + ffile.getAbsolutePath()));
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(ffile);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error((Object)("[" + subject + "] file di properties non utilizzabile: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception eClose) {}
            }
        }
        return null;
    }

    private static Properties examineStep3(String OPENSPCOOP2_LOCAL_HOME, Logger log, String path) {
        String dir = System.getenv(OPENSPCOOP2_LOCAL_HOME);
        String subject = "Variabile di sistema " + OPENSPCOOP2_LOCAL_HOME;
        if (dir != null) {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                log.error((Object)("[" + subject + "] Directory non esistente: " + fDir.getAbsolutePath()));
                return null;
            }
            if (!fDir.canRead()) {
                log.error((Object)("[" + subject + "] Directory non accessibile: " + fDir.getAbsolutePath()));
                return null;
            }
            return PropertiesUtilities.getPropertiesReader(log, fDir.getAbsolutePath() + File.separatorChar + path, subject);
        }
        return null;
    }

    private static Properties examineStep4(String OPENSPCOOP2_LOCAL_HOME, Logger log, String path) {
        String dir = System.getProperty(OPENSPCOOP2_LOCAL_HOME);
        String subject = "Proprieta' di sistema " + OPENSPCOOP2_LOCAL_HOME;
        if (dir != null) {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                log.error((Object)("[" + subject + "] Directory non esistente: " + fDir.getAbsolutePath()));
                return null;
            }
            if (!fDir.canRead()) {
                log.error((Object)("[" + subject + "] Directory non accessibile: " + fDir.getAbsolutePath()));
                return null;
            }
            return PropertiesUtilities.getPropertiesReader(log, fDir.getAbsolutePath() + File.separatorChar + path, subject);
        }
        return null;
    }

    private static Properties examineStep5(Logger log, String path) {
        return PropertiesUtilities.getPropertiesReader(log, PropertiesUtilities.class.getResourceAsStream("/" + path), "CLASSPATH: " + path);
    }

    private static Properties examineStep6(Logger log, String path, File fConfDirectory) {
        File f = new File(fConfDirectory, path);
        if (f.exists()) {
            return PropertiesUtilities.getPropertiesReader(log, f.getAbsolutePath(), "CONFIG_DIR_OPENSPCOOP/" + path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesReader(Logger log, String path, String subject) {
        if (path != null) {
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            if (!f.canRead()) {
                log.error((Object)("[" + subject + "] file di properties non accessibile: " + f.getAbsolutePath()));
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                Properties properties = PropertiesUtilities.getPropertiesReader(log, is, subject);
                return properties;
            }
            catch (IOException e) {
                log.error((Object)("[" + subject + "] file di properties non utilizzabile: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception eClose) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesReader(Logger log, InputStream is, String subject) {
        if (is != null) {
            Properties propertiesReader = null;
            try {
                propertiesReader = new Properties();
                propertiesReader.load(is);
            }
            catch (IOException e) {
                propertiesReader = null;
                log.error((Object)("[" + subject + "] file di properties non utilizzabile: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception eClose) {}
            }
            if (propertiesReader != null) {
                return propertiesReader;
            }
            return null;
        }
        return null;
    }
}

