/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.apache.commons.lang.ObjectUtils;
import org.openspcoop2.utils.UtilsException;

public class MimeTypes {
    private Hashtable<String, Object> mapMimeToExt = new Hashtable();
    private Hashtable<String, String> mapExtToMime = new Hashtable();
    private static MimeTypes mimeTypes = null;

    MimeTypes() throws UtilsException {
        InputStream is = null;
        BufferedReader br = null;
        InputStreamReader ir = null;
        try {
            String line;
            String file = "/org/openspcoop2/utils/resources/mime.types";
            is = MimeTypes.class.getResourceAsStream(file);
            if (is == null) {
                throw new Exception("File [" + file + "] in classpath not found");
            }
            ir = new InputStreamReader(is);
            br = new BufferedReader(ir);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.contains("\t")) {
                    throw new Exception("Line[" + line + "] contains tabs");
                }
                String[] tmp = line.split(" ");
                if (tmp.length < 2) {
                    this.mapMimeToExt.put(tmp[0].trim(), ObjectUtils.NULL);
                    continue;
                }
                StringBuffer bf = new StringBuffer();
                for (int i = 1; i < tmp.length; ++i) {
                    bf.append(" EXT-" + i + "=[" + tmp[i].trim() + "]");
                    this.mapExtToMime.put(tmp[i].trim(), tmp[0].trim());
                }
                this.mapMimeToExt.put(tmp[0].trim(), tmp[1].trim());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception eClose) {}
            try {
                if (ir != null) {
                    ir.close();
                }
            }
            catch (Exception eClose) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public String getMimeType(String ext) {
        return this.mapExtToMime.get(ext.trim().toLowerCase());
    }

    public String getExtension(String mime) {
        Object o = this.mapMimeToExt.get(mime.trim().toLowerCase());
        if (o == null) {
            return null;
        }
        if (o instanceof ObjectUtils.Null) {
            return null;
        }
        return (String)o;
    }

    public boolean existsExtension(String ext) {
        return this.mapExtToMime.containsKey(ext.trim().toLowerCase());
    }

    public boolean existsMimeType(String mime, boolean checkExistsExtension) {
        if (this.mapMimeToExt.containsKey(mime.trim().toLowerCase())) {
            if (checkExistsExtension) {
                String ext = this.getExtension(mime);
                return ext != null;
            }
            return true;
        }
        return false;
    }

    private static synchronized void init() throws UtilsException {
        if (mimeTypes == null) {
            mimeTypes = new MimeTypes();
        }
    }

    public static MimeTypes getInstance() throws UtilsException {
        if (mimeTypes == null) {
            MimeTypes.init();
        }
        return mimeTypes;
    }
}

