/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.http.HttpServletResponse;
import org.apache.soap.encoding.soapenc.Base64;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.HttpBodyParameters;
import org.openspcoop2.utils.resources.HttpResponseBody;
import org.openspcoop2.utils.resources.MimeTypes;

public class HttpUtilities {
    public static final int HTTP_CONNECTION_TIMEOUT = 10000;
    public static final int HTTP_READ_CONNECTION_TIMEOUT = 120000;
    public static final String HEADER_X_DOWNLOAD = "application/x-download";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_ATTACH_FILE = "attachment; filename=";

    public static void setOutputFile(HttpServletResponse response, boolean noCache, String fileName) throws UtilsException {
        String mimeType = null;
        if (fileName.contains(".")) {
            String ext = null;
            try {
                ext = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            }
            catch (Exception e) {
                // empty catch block
            }
            MimeTypes mimeTypes = MimeTypes.getInstance();
            mimeType = ext != null && mimeTypes.existsExtension(ext) ? mimeTypes.getMimeType(ext) : HEADER_X_DOWNLOAD;
        } else {
            mimeType = HEADER_X_DOWNLOAD;
        }
        HttpUtilities.setOutputFile(response, noCache, fileName, mimeType);
    }

    public static void setOutputFile(HttpServletResponse response, boolean noCache, String fileName, String mimeType) throws UtilsException {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        response.setHeader(HEADER_CONTENT_DISPOSITION, "attachment; filename=\"" + fileName + "\"");
        if (noCache) {
            HttpUtilities.setNoCache(response);
        }
    }

    public static void setNoCache(HttpServletResponse response) throws UtilsException {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static void setChunkedStreamingMode(HttpURLConnection httpConn, int chunkLength, String httpMethod, String contentType) throws UtilsException {
        HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
        if (params.isDoOutput()) {
            httpConn.setChunkedStreamingMode(chunkLength);
        }
    }

    public static boolean isHttpBodyPermitted(boolean isRequest, String httpMethod, String contentType) throws UtilsException {
        HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
        if (isRequest) {
            return params.isDoOutput();
        }
        return params.isDoInput();
    }

    public static void setStream(HttpURLConnection httpConn, String httpMethod) throws UtilsException {
        HttpUtilities.setStream(httpConn, httpMethod, null);
    }

    public static void setStream(HttpURLConnection httpConn, String httpMethod, String contentType) throws UtilsException {
        try {
            HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
            httpConn.setRequestMethod(httpMethod);
            if (params.isDoOutput()) {
                httpConn.setDoOutput(params.isDoOutput());
            }
            if (params.isDoInput()) {
                httpConn.setDoInput(params.isDoInput());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static byte[] requestHTTPFile(String path) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, null, null);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, readTimeout, connectTimeout, null, null);
    }

    public static byte[] requestHTTPFile(String path, String username, String password) throws UtilsException {
        return HttpUtilities.requestHTTPFile(path, 120000, 10000, username, password);
    }

    public static byte[] requestHTTPFile(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        HttpResponseBody res = HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, username, password);
        return res.getResponse();
    }

    public static HttpResponseBody getHTTPResponse(String path) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, null, null);
    }

    public static HttpResponseBody getHTTPResponse(String path, int readTimeout, int connectTimeout) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, readTimeout, connectTimeout, null, null);
    }

    public static HttpResponseBody getHTTPResponse(String path, String username, String password) throws UtilsException {
        return HttpUtilities.getHTTPResponse(path, 120000, 10000, username, password);
    }

    public static HttpResponseBody getHTTPResponse(String path, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        InputStream is = null;
        ByteArrayOutputStream outResponse = null;
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setConnectTimeout(connectTimeout);
            httpConn.setReadTimeout(readTimeout);
            if (username != null && password != null) {
                String authentication = username + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                httpConn.setRequestProperty("Authorization", authentication);
            }
            HttpUtilities.setStream(httpConn, "GET");
            int resultHTTPOperation = httpConn.getResponseCode();
            if (resultHTTPOperation == 404) {
                throw new UtilsException("404");
            }
            outResponse = new ByteArrayOutputStream();
            if (resultHTTPOperation > 399) {
                is = httpConn.getErrorStream();
                if (is == null) {
                    is = httpConn.getInputStream();
                }
            } else {
                is = httpConn.getInputStream();
                if (is == null) {
                    is = httpConn.getErrorStream();
                }
            }
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                outResponse.write(readB, 0, readByte);
            }
            is.close();
            httpConn.disconnect();
            byte[] xmlottenuto = outResponse.toByteArray();
            outResponse.close();
            HttpResponseBody response = new HttpResponseBody();
            response.setResponse(xmlottenuto);
            response.setResultHTTPOperation(resultHTTPOperation);
            return response;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (outResponse != null) {
                    outResponse.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e.getMessage() != null && e.getMessage().contains("404")) {
                throw new UtilsException("404");
            }
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
    }

    public static void check(String path) throws Exception {
        HttpUtilities.check(path, 120000, 10000, null, null);
    }

    public static void check(String path, int readTimeout, int connectTimeout) throws Exception {
        HttpUtilities.check(path, readTimeout, connectTimeout, null, null);
    }

    public static void check(String path, String username, String password) throws Exception {
        HttpUtilities.check(path, 120000, 10000, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(String path, int readTimeout, int connectTimeout, String username, String password) throws Exception {
        InputStream is = null;
        ByteArrayOutputStream outResponse = null;
        HttpURLConnection httpConn = null;
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            httpConn = (HttpURLConnection)connection;
            httpConn.setConnectTimeout(connectTimeout);
            httpConn.setReadTimeout(readTimeout);
            if (username != null && password != null) {
                String authentication = username + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                httpConn.setRequestProperty("Authorization", authentication);
            }
            HttpUtilities.setStream(httpConn, "GET");
            int resultHTTPOperation = httpConn.getResponseCode();
            if (resultHTTPOperation != 200) {
                if (resultHTTPOperation > 399) {
                    is = httpConn.getErrorStream();
                    if (is == null) {
                        is = httpConn.getInputStream();
                    }
                } else {
                    is = httpConn.getInputStream();
                    if (is == null) {
                        is = httpConn.getErrorStream();
                    }
                }
                if (is != null) {
                    outResponse = new ByteArrayOutputStream();
                    byte[] readB = new byte[65536];
                    int readByte = 0;
                    while ((readByte = is.read(readB)) != -1) {
                        outResponse.write(readB, 0, readByte);
                    }
                    is.close();
                    outResponse.flush();
                    outResponse.close();
                    throw new Exception("Response Code (" + resultHTTPOperation + "): " + outResponse.toString());
                }
                throw new Exception("Response Code (" + resultHTTPOperation + ")");
            }
        }
        finally {
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception eClose) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception eis) {}
            try {
                if (outResponse != null) {
                    outResponse.close();
                }
            }
            catch (Exception eis) {}
        }
    }
}

