/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import org.openspcoop2.utils.UtilsException;

public class HttpBodyParameters {
    private boolean doOutput = false;
    private boolean doInput = false;

    public HttpBodyParameters(String httpMethod, String contentType) throws UtilsException {
        String m = httpMethod;
        if (m != null) {
            m = m.trim();
        }
        if ("OPTIONS".equalsIgnoreCase(m)) {
            this.doOutput = contentType != null && !"".equals(contentType) ? false : false;
            this.doInput = true;
        } else if ("GET".equalsIgnoreCase(m)) {
            this.doOutput = false;
            this.doInput = true;
        } else if ("HEAD".equalsIgnoreCase(m)) {
            this.doOutput = false;
            this.doInput = false;
        } else if ("POST".equalsIgnoreCase(m)) {
            this.doOutput = true;
            this.doInput = true;
        } else if ("PUT".equalsIgnoreCase(m)) {
            this.doOutput = true;
            this.doInput = true;
        } else if ("DELETE".equalsIgnoreCase(m)) {
            this.doOutput = false;
            this.doInput = true;
        } else if ("TRACE".equalsIgnoreCase(m)) {
            this.doOutput = false;
            this.doInput = true;
        } else {
            throw new UtilsException("HttpMethod [" + httpMethod + "] unsupported");
        }
    }

    public boolean isDoOutput() {
        return this.doOutput;
    }

    public boolean isDoInput() {
        return this.doInput;
    }
}

