/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileSystemUtilities {
    public static void copy(File in, File out) throws IOException {
        FileSystemUtilities.copy(in.getAbsolutePath(), out.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String in, String out) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(in);
            fout = new FileOutputStream(out);
            FileSystemUtilities.copy(fin, fout);
            fout.flush();
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    public static void copyDirectory(String srcPath, String dstPath) throws IOException {
        FileSystemUtilities.copyDirectory(new File(srcPath), new File(dstPath));
    }

    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                if (".svn".equals(files[i])) continue;
                FileSystemUtilities.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else {
            int len;
            if (!srcPath.exists()) {
                return;
            }
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(dstPath);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static String readFile(String f) throws Exception {
        return FileSystemUtilities.readFile(new File(f));
    }

    public static String readFile(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        ByteArrayOutputStream byteInputBuffer = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = fis.read(readB)) != -1) {
            byteInputBuffer.write(readB, 0, readByte);
        }
        fis.close();
        byteInputBuffer.flush();
        byteInputBuffer.close();
        return byteInputBuffer.toString();
    }

    public static byte[] readBytesFromFile(String f) throws Exception {
        return FileSystemUtilities.readBytesFromFile(new File(f));
    }

    public static byte[] readBytesFromFile(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        ByteArrayOutputStream byteInputBuffer = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = fis.read(readB)) != -1) {
            byteInputBuffer.write(readB, 0, readByte);
        }
        fis.close();
        byteInputBuffer.flush();
        byteInputBuffer.close();
        return byteInputBuffer.toByteArray();
    }

    public static void writeFile(String f, byte[] contenuto) throws Exception {
        FileSystemUtilities.writeFile(new File(f), contenuto);
    }

    public static void writeFile(File f, byte[] contenuto) throws Exception {
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(contenuto);
        fos.flush();
        fos.close();
    }

    public static void writeFile(String f, byte[] ... args) throws Exception {
        FileSystemUtilities.writeFile(new File(f), args);
    }

    public static void writeFile(File f, byte[] ... args) throws Exception {
        if (args != null) {
            FileOutputStream fos = new FileOutputStream(f);
            for (int i = 0; i < args.length; ++i) {
                fos.write(args[i]);
            }
            fos.flush();
            fos.close();
        }
    }

    public static void copyFileAndReplaceAllKeywords(String read, String write, String keyword, String values) throws Exception {
        FileSystemUtilities.copyFileAndReplaceAllKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceAllKeywords(File read, File write, String keyword, String values) throws Exception {
        String[] k = new String[]{keyword};
        String[] v = new String[]{values};
        FileSystemUtilities.copyFileAndReplaceAllKeywords(read, write, k, v);
    }

    public static void copyFileAndReplaceAllKeywords(String read, String write, String[] keyword, String[] values) throws Exception {
        FileSystemUtilities.copyFileAndReplaceAllKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceAllKeywords(File read, File write, String[] keyword, String[] values) throws Exception {
        String file = FileSystemUtilities.readFile(read);
        for (int i = 0; i < keyword.length; ++i) {
            int indexOf = file.indexOf(keyword[i]);
            while (indexOf >= 0) {
                file = file.replace(keyword[i], values[i]);
                indexOf = file.indexOf(keyword[i], indexOf + values[i].length());
            }
        }
        FileSystemUtilities.writeFile(write, file.getBytes());
    }

    public static void copyFileAndReplaceKeywords(String read, String write, String keyword, String values) throws Exception {
        FileSystemUtilities.copyFileAndReplaceKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceKeywords(File read, File write, String keyword, String values) throws Exception {
        String[] k = new String[]{keyword};
        String[] v = new String[]{values};
        FileSystemUtilities.copyFileAndReplaceKeywords(read, write, k, v);
    }

    public static void copyFileAndReplaceKeywords(String read, String write, String[] keyword, String[] values) throws Exception {
        FileSystemUtilities.copyFileAndReplaceKeywords(new File(read), new File(write), keyword, values);
    }

    public static void copyFileAndReplaceKeywords(File read, File write, String[] keyword, String[] values) throws Exception {
        String file = FileSystemUtilities.readFile(read);
        for (int i = 0; i < keyword.length; ++i) {
            file = file.replace(keyword[i], values[i]);
        }
        FileSystemUtilities.writeFile(write, file.getBytes());
    }

    public static boolean deleteDir(String dir) {
        File d = new File(dir);
        if (!d.exists()) {
            return true;
        }
        return FileSystemUtilities.deleteDir(d);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileSystemUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean moveToDir(String src, String destDir) {
        File file = new File(src);
        File dir = new File(destDir);
        return FileSystemUtilities.moveToDir(file, dir);
    }

    public static boolean moveToDir(File src, File destDir) {
        boolean success = src.renameTo(new File(destDir, src.getName()));
        return success;
    }

    public static boolean moveToFile(String src, String destFile) {
        File file = new File(src);
        File dir = new File(destFile);
        return FileSystemUtilities.moveToDir(file, dir);
    }

    public static boolean moveToFile(File src, File destFile) {
        boolean success = src.renameTo(destFile);
        return success;
    }

    public static void mkdirParentDirectory(File file) throws Exception {
        FileSystemUtilities.mkdirParentDirectory(file.getAbsolutePath());
    }

    public static void mkdirParentDirectory(String file) throws Exception {
        try {
            File p = new File(file);
            if (p.getParentFile() == null) {
                return;
            }
            if (p.getParentFile().exists()) {
                return;
            }
            FileSystemUtilities.mkdirParentDirectory(p.getParentFile().getAbsolutePath());
            if (!p.getParentFile().mkdir()) {
                throw new Exception("Directory [" + p.getParentFile().getAbsolutePath() + "] non esistente e creazione non riuscita");
            }
        }
        catch (Exception e) {
            throw new Exception("mkdirParentDirectory non riuscito: " + e.getMessage(), e);
        }
    }
}

