/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mail;

import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mail.Mail;
import org.openspcoop2.utils.mail.MailAttach;
import org.openspcoop2.utils.mail.MailBinaryAttach;
import org.openspcoop2.utils.mail.MailTextAttach;
import org.openspcoop2.utils.mail.Sender;
import org.openspcoop2.utils.resources.SSLUtilities;

public class CommonsNetSender
extends Sender {
    protected CommonsNetSender(Logger log) {
        super(log);
    }

    @Override
    public void send(Mail mail, boolean debug) throws UtilsException {
        AuthenticatingSMTPClient client = null;
        try {
            int reply;
            client = new AuthenticatingSMTPClient(mail.getEncoding());
            client.setDefaultTimeout(this.getReadTimeout());
            client.setConnectTimeout(this.getConnectionTimeout());
            if (mail.getSslConfig() != null) {
                StringBuffer bf = new StringBuffer();
                SSLContext sslContext = SSLUtilities.generateSSLContext(mail.getSslConfig(), bf);
                if (debug) {
                    this.log.debug((Object)bf.toString());
                }
                client.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
            }
            this.log.debug((Object)("Connect to [" + mail.getServerHost() + ":" + mail.getServerPort() + "] ..."));
            client.connect(mail.getServerHost(), mail.getServerPort());
            this.log.debug((Object)("Connected to [" + mail.getServerHost() + ":" + mail.getServerPort() + "]"));
            boolean esito = client.login();
            CommonsNetSender.checkReply((SMTPClient)client, esito, "Login failed");
            if (mail.isStartTls()) {
                esito = client.execTLS();
                CommonsNetSender.checkReply((SMTPClient)client, esito, "STARTTLS was not accepted");
            }
            String replyString = client.getReplyString();
            if (debug) {
                this.log.debug((Object)("ReplyString: " + replyString));
            }
            if (!SMTPReply.isPositiveCompletion((int)(reply = client.getReplyCode()))) {
                throw new Exception("SMTP server refused connection " + client.getReply() + client.getReplyString());
            }
            if (mail.getUsername() != null) {
                if (debug) {
                    this.log.debug((Object)("Authenticating [" + mail.getUsername() + "] ..."));
                }
                esito = client.auth(AuthenticatingSMTPClient.AUTH_METHOD.LOGIN, mail.getUsername(), mail.getPassword());
                CommonsNetSender.checkReply((SMTPClient)client, esito, "Authentication failed");
                if (debug) {
                    this.log.debug((Object)("Authenticating [" + mail.getUsername() + "] ok"));
                }
            }
            if (debug) {
                this.log.debug((Object)("Set sender [" + mail.getFrom() + "] ..."));
            }
            esito = client.setSender(mail.getFrom());
            CommonsNetSender.checkReply((SMTPClient)client, esito, "Set sender[" + mail.getFrom() + "] failed");
            if (debug) {
                this.log.debug((Object)("Set to [" + mail.getTo() + "] ..."));
            }
            esito = client.addRecipient(mail.getTo());
            CommonsNetSender.checkReply((SMTPClient)client, esito, "Set to[" + mail.getTo() + "] failed");
            List<String> ccList = mail.getCc();
            if (ccList != null && ccList.size() > 0) {
                for (String cc : ccList) {
                    if (debug) {
                        this.log.debug((Object)("Add cc [" + cc + "] ..."));
                    }
                    esito = client.addRecipient(cc);
                    CommonsNetSender.checkReply((SMTPClient)client, esito, "Set cc[" + cc + "] failed");
                }
            }
            boolean attach = mail.getBody().getAttachments() != null && mail.getBody().getAttachments().size() > 0;
            Writer writer = client.sendMessageData();
            if (writer != null) {
                if (debug) {
                    this.log.debug((Object)"Send ...");
                }
                if (debug) {
                    this.log.debug((Object)("Subject [" + mail.getSubject() + "] ..."));
                }
                SimpleSMTPHeader header = new SimpleSMTPHeader(mail.getFrom(), mail.getTo(), mail.getSubject());
                if (debug) {
                    this.log.debug((Object)("Body (" + mail.getBody().getContentType() + ") [" + mail.getBody().getMessage() + "] ..."));
                }
                TimeZone tz = TimeZone.getTimeZone("GMT");
                Date now = new Date();
                header.addHeaderField("Date", CommonsNetSender.formatSMTPDate(now, tz));
                ccList = mail.getCc();
                if (ccList != null && ccList.size() > 0) {
                    for (String cc : ccList) {
                        header.addCC(cc);
                    }
                }
                MimeMultipart multipart = null;
                if (attach) {
                    multipart = new MimeMultipart();
                    if (mail.getBody().getMessage() != null) {
                        MimeBodyPart messagePart = new MimeBodyPart();
                        messagePart.setText(mail.getBody().getMessage());
                        if (mail.getBody().getContentType() != null) {
                            messagePart.setHeader("Content-Type", mail.getBody().getContentType());
                        }
                        multipart.addBodyPart((BodyPart)messagePart);
                    }
                    for (MailAttach mailAttach : mail.getBody().getAttachments()) {
                        MimeBodyPart attachmentPart = new MimeBodyPart();
                        if (mailAttach instanceof MailTextAttach) {
                            MailTextAttach text = (MailTextAttach)mailAttach;
                            attachmentPart.setText(text.getContent());
                        } else {
                            String msg = "La libreria CommonsNet non funziona correttamente con gli attachments di tipo binario. Usare il sender di tipo CommonsMail";
                            this.log.warn((Object)msg);
                            System.out.println(msg);
                            MailBinaryAttach bin = (MailBinaryAttach)mailAttach;
                            attachmentPart.setContent((Object)bin.getContent(), mailAttach.getContentType());
                        }
                        attachmentPart.setFileName(mailAttach.getName());
                        attachmentPart.setHeader("Content-Type", mailAttach.getContentType());
                        multipart.addBodyPart((BodyPart)attachmentPart);
                    }
                }
                if (!attach) {
                    if (mail.getBody().getContentType() != null) {
                        header.addHeaderField("Content-Type", mail.getBody().getContentType());
                    }
                } else {
                    header.addHeaderField("Content-Type", multipart.getContentType());
                }
                writer.write(header.toString());
                if (!attach) {
                    writer.write(mail.getBody().getMessage());
                } else {
                    WriterOutputStream ww = new WriterOutputStream(writer);
                    multipart.writeTo((OutputStream)ww);
                    ww.flush();
                    ww.close();
                }
                writer.close();
                if (!client.completePendingCommand()) {
                    throw new Exception("Failure to send the email " + client.getReply() + client.getReplyString());
                }
            } else {
                throw new Exception("Failure to send the email " + client.getReply() + client.getReplyString());
            }
            if (debug) {
                this.log.debug((Object)"Send finished");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                client.logout();
            }
            catch (Exception e) {}
            try {
                client.disconnect();
            }
            catch (Exception e) {}
        }
    }

    private static String formatSMTPDate(Date date, TimeZone tz) throws IllegalArgumentException {
        Locale loc = Locale.US;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE", loc);
        dateFormat.setTimeZone(tz);
        String day = dateFormat.format(date);
        day = day.substring(0, 3);
        dateFormat = new SimpleDateFormat("MMM", loc);
        dateFormat.setTimeZone(tz);
        String month = dateFormat.format(date);
        month = month.substring(0, 3);
        dateFormat = new SimpleDateFormat("dd", loc);
        dateFormat.setTimeZone(tz);
        String dayNum = dateFormat.format(date);
        dateFormat = new SimpleDateFormat("yyyy HH:mm:ss", loc);
        dateFormat.setTimeZone(tz);
        String rest = dateFormat.format(date);
        String result = new String(day + ", " + dayNum + " " + month + " " + rest + " +0000");
        return result;
    }

    private static void checkReply(SMTPClient sc, boolean esito, String object) throws Exception {
        if (SMTPReply.isNegativeTransient((int)sc.getReplyCode())) {
            throw new Exception(object + ", transient SMTP error " + sc.getReply() + sc.getReplyString());
        }
        if (SMTPReply.isNegativePermanent((int)sc.getReplyCode())) {
            throw new Exception(object + ", permanent SMTP error " + sc.getReply() + sc.getReplyString());
        }
        if (!esito) {
            throw new Exception(object + ", [" + esito + "] " + sc.getReply() + sc.getReplyString());
        }
    }
}

