/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.jdbc.BinaryStreamNotSupportedException;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class TestJDBCAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        TipiDatabase tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        Class.forName(driver).newInstance();
        Connection con = null;
        try {
            con = DriverManager.getConnection(url, userName, password);
            TestJDBCAdapter.testBytes(con, tipoDatabase);
            TestJDBCAdapter.testInputStream(con, tipoDatabase, true, false);
            TestJDBCAdapter.testInputStream(con, tipoDatabase, false, true);
            TestJDBCAdapter.testInputStream(con, tipoDatabase, false, false);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testBytes(Connection con, TipiDatabase tipoDatabase) throws Exception {
        Statement stmtDelete = null;
        Statement stmtInsert = null;
        Statement stmtQuery = null;
        ResultSet rsQuery = null;
        InputStream pdfIs = null;
        try {
            int i;
            byte[] read;
            System.out.println("\n\n*** Test bytes[] ***");
            pdfIs = TestJDBCAdapter.class.getResourceAsStream("/org/openspcoop2/utils/jdbc/test.pdf");
            if (pdfIs == null) {
                throw new Exception("test.pdf resource not found");
            }
            byte[] data = Utilities.getAsByteArray(pdfIs);
            String delete = "delete from prova_bytes";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter(tipoDatabase);
            System.out.println("Creato IJDBCAdapter di tipo " + jdbcAdapter.getClass().getName());
            ISQLQueryObject sqlQuery = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
            sqlQuery.addInsertTable("prova_bytes");
            sqlQuery.addInsertField("descrizione", "?");
            sqlQuery.addInsertField("contenuto", "?");
            stmtInsert = con.prepareStatement(sqlQuery.createSQLInsert());
            stmtInsert.setString(1, "descrizione di esempio");
            jdbcAdapter.setBinaryData((PreparedStatement)stmtInsert, 2, data);
            int row = stmtInsert.executeUpdate();
            System.out.println("Documento PDF inserito: " + row);
            String query = "select * from prova_bytes";
            stmtQuery = con.createStatement();
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                read = jdbcAdapter.getBinaryData(rsQuery, "contenuto");
                for (i = 0; i < data.length; ++i) {
                    if (data[i] == read[i]) continue;
                    File fTmpOriginale = File.createTempFile("orig", "tmp");
                    File fTmpLettoDaDB = File.createTempFile("lettoDaDB", "tmp");
                    FileSystemUtilities.writeFile(fTmpOriginale, data);
                    FileSystemUtilities.writeFile(fTmpLettoDaDB, read);
                    throw new Exception("Documento salvato su database e riletto risulta differente. Salvate le immagini nei seguenti file temporanei: originale[" + fTmpOriginale.getAbsolutePath() + "] prelevatoDaDatabase[" + fTmpLettoDaDB.getAbsolutePath() + "]");
                }
            } else {
                throw new Exception("Nessuna insert effettuata");
            }
            System.out.println("Documento PDF inserito e riletto dal database tramite columnName sono equivalenti");
            rsQuery.close();
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                read = jdbcAdapter.getBinaryData(rsQuery, 2);
                for (i = 0; i < data.length; ++i) {
                    if (data[i] == read[i]) continue;
                    File fTmpOriginale = File.createTempFile("orig", "tmp");
                    File fTmpLettoDaDB = File.createTempFile("lettoDaDB", "tmp");
                    FileSystemUtilities.writeFile(fTmpOriginale, data);
                    FileSystemUtilities.writeFile(fTmpLettoDaDB, read);
                    throw new Exception("Documento salvato su database e riletto risulta differente (read by index). Salvate le immagini nei seguenti file temporanei: originale[" + fTmpOriginale.getAbsolutePath() + "] prelevatoDaDatabase[" + fTmpLettoDaDB.getAbsolutePath() + "]");
                }
            } else {
                throw new Exception("Nessuna insert effettuata");
            }
            System.out.println("Documento PDF inserito e riletto dal database tramite index sono equivalenti");
        }
        finally {
            try {
                pdfIs.close();
            }
            catch (Exception eClose) {}
            try {
                stmtDelete.close();
            }
            catch (Exception eClose) {}
            try {
                stmtInsert.close();
            }
            catch (Exception eClose) {}
            try {
                rsQuery.close();
            }
            catch (Exception eClose) {}
            try {
                stmtQuery.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testInputStream(Connection con, TipiDatabase tipoDatabase, boolean withLength, boolean bufferEnabled) throws Exception {
        Statement stmtDelete = null;
        Statement stmtInsert = null;
        Statement stmtQuery = null;
        ResultSet rsQuery = null;
        InputStream pdfIs = null;
        try {
            int i;
            byte[] read;
            InputStream isRead;
            System.out.println("\n\n*** Test InputStream (lenght:" + withLength + " buffer:" + bufferEnabled + ") ***");
            pdfIs = TestJDBCAdapter.class.getResourceAsStream("/org/openspcoop2/utils/jdbc/test.pdf");
            if (pdfIs == null) {
                throw new Exception("test.pdf resource not found");
            }
            byte[] data = Utilities.getAsByteArray(pdfIs);
            pdfIs.close();
            pdfIs = TestJDBCAdapter.class.getResourceAsStream("/org/openspcoop2/utils/jdbc/test.pdf");
            int lenght = -1;
            if (withLength) {
                lenght = data.length;
            }
            String delete = "delete from prova_bytes";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter(tipoDatabase);
            System.out.println("Creato IJDBCAdapter di tipo " + jdbcAdapter.getClass().getName());
            ISQLQueryObject sqlQuery = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
            sqlQuery.addInsertTable("prova_bytes");
            sqlQuery.addInsertField("descrizione", "?");
            sqlQuery.addInsertField("contenuto", "?");
            stmtInsert = con.prepareStatement(sqlQuery.createSQLInsert());
            stmtInsert.setString(1, "descrizione di esempio");
            BinaryStreamNotSupportedException eNotSupported = null;
            if (withLength) {
                jdbcAdapter.setBinaryData((PreparedStatement)stmtInsert, 2, pdfIs, lenght);
            } else {
                String msgEccezioneAtteso = "SetBinaryStream non supportata dal tipo di database utilizzato";
                try {
                    jdbcAdapter.setBinaryData((PreparedStatement)stmtInsert, 2, pdfIs, bufferEnabled);
                }
                catch (BinaryStreamNotSupportedException e) {
                    if (!bufferEnabled) {
                        if (!e.getMessage().startsWith(msgEccezioneAtteso)) {
                            throw new Exception("Ottenuta eccezione [" + e.getMessage() + "] differente da quella attesa [" + msgEccezioneAtteso + "...]");
                        }
                        eNotSupported = e;
                    }
                    throw e;
                }
            }
            if (!withLength && !bufferEnabled && eNotSupported != null) {
                eNotSupported.printStackTrace(System.out);
                return;
            }
            int row = stmtInsert.executeUpdate();
            System.out.println("Documento PDF inserito: " + row);
            String query = "select * from prova_bytes";
            stmtQuery = con.createStatement();
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                isRead = jdbcAdapter.getBinaryStream(rsQuery, "contenuto");
                read = Utilities.getAsByteArray(isRead);
                for (i = 0; i < data.length; ++i) {
                    if (data[i] == read[i]) continue;
                    File fTmpOriginale = File.createTempFile("orig", "tmp");
                    File fTmpLettoDaDB = File.createTempFile("lettoDaDB", "tmp");
                    FileSystemUtilities.writeFile(fTmpOriginale, data);
                    FileSystemUtilities.writeFile(fTmpLettoDaDB, read);
                    throw new Exception("Documento salvato su database e riletto risulta differente. Salvate le immagini nei seguenti file temporanei: originale[" + fTmpOriginale.getAbsolutePath() + "] prelevatoDaDatabase[" + fTmpLettoDaDB.getAbsolutePath() + "]");
                }
            } else {
                throw new Exception("Nessuna insert effettuata");
            }
            System.out.println("Documento PDF inserito e riletto dal database tramite columnName sono equivalenti");
            rsQuery.close();
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                isRead = jdbcAdapter.getBinaryStream(rsQuery, 2);
                read = Utilities.getAsByteArray(isRead);
                for (i = 0; i < data.length; ++i) {
                    if (data[i] == read[i]) continue;
                    File fTmpOriginale = File.createTempFile("orig", "tmp");
                    File fTmpLettoDaDB = File.createTempFile("lettoDaDB", "tmp");
                    FileSystemUtilities.writeFile(fTmpOriginale, data);
                    FileSystemUtilities.writeFile(fTmpLettoDaDB, read);
                    throw new Exception("Documento salvato su database e riletto risulta differente (read by index). Salvate le immagini nei seguenti file temporanei: originale[" + fTmpOriginale.getAbsolutePath() + "] prelevatoDaDatabase[" + fTmpLettoDaDB.getAbsolutePath() + "]");
                }
            } else {
                throw new Exception("Nessuna insert effettuata");
            }
            System.out.println("Documento PDF inserito e riletto dal database tramite index sono equivalenti");
        }
        finally {
            try {
                pdfIs.close();
            }
            catch (Exception eClose) {}
            try {
                stmtDelete.close();
            }
            catch (Exception eClose) {}
            try {
                stmtInsert.close();
            }
            catch (Exception eClose) {}
            try {
                rsQuery.close();
            }
            catch (Exception eClose) {}
            try {
                stmtQuery.close();
            }
            catch (Exception eClose) {}
        }
    }
}

