/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.AbstractJDBCAdapter;

public class StreamJDBCAdapter
extends AbstractJDBCAdapter {
    protected StreamJDBCAdapter(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, int index) throws UtilsException, SQLException {
        return this.readIs(rs.getBinaryStream(index), index + "");
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, String rsName) throws UtilsException, SQLException {
        return this.readIs(rs.getBinaryStream(rsName), rsName);
    }

    @Override
    public void setBinaryData(PreparedStatement s, int index, byte[] data) throws UtilsException, SQLException {
        ByteArrayInputStream bin = null;
        try {
            bin = data != null ? new ByteArrayInputStream(data) : new ByteArrayInputStream("".getBytes());
        }
        catch (Exception e) {
            throw new UtilsException("StreamJDBCAppender error, set binary parameter [indice:" + index + "]" + e.getMessage());
        }
        s.setBinaryStream(index, (InputStream)bin, data.length);
    }

    private byte[] readIs(InputStream is, String indice) throws UtilsException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                os.write(readB, 0, readByte);
            }
            is.close();
            byte[] dati = os.toByteArray();
            os.close();
            return dati;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception io) {
                // empty catch block
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception io) {
                // empty catch block
            }
            throw new UtilsException("StreamJDBCAppender error, reading binary parameter [indice:" + indice + "]" + e.getMessage());
        }
    }
}

