/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.DB2KeyGenerator;
import org.openspcoop2.utils.jdbc.HyperSQLKeyGenerator;
import org.openspcoop2.utils.jdbc.IKeyGenerator;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;
import org.openspcoop2.utils.jdbc.MySQLKeyGenerator;
import org.openspcoop2.utils.jdbc.OracleKeyGenerator;
import org.openspcoop2.utils.jdbc.PostgreSQLKeyGenerator;
import org.openspcoop2.utils.jdbc.SQLServerKeyGenerator;

public class KeyGeneratorFactory {
    public static IKeyGenerator createKeyGeneratorFactory(String tipoDatabase, Connection connection, IKeyGeneratorObject object) throws KeyGeneratorException {
        return KeyGeneratorFactory.toKeyGenerator(tipoDatabase, connection, object);
    }

    public static IKeyGenerator toKeyGenerator(String tipoDatabase, Connection connection, IKeyGeneratorObject object) throws KeyGeneratorException {
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            return new PostgreSQLKeyGenerator(connection, object);
        }
        if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            return new MySQLKeyGenerator(connection, object);
        }
        if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            return new OracleKeyGenerator(connection, object);
        }
        if (TipiDatabase.HSQL.equals(tipoDatabase)) {
            return new HyperSQLKeyGenerator(connection, object);
        }
        if (TipiDatabase.SQLSERVER.toString().equals(tipoDatabase)) {
            return new SQLServerKeyGenerator(connection, object);
        }
        if (TipiDatabase.DB2.toString().equals(tipoDatabase)) {
            return new DB2KeyGenerator(connection, object);
        }
        throw new KeyGeneratorException("Tipo database non gestito [" + tipoDatabase + "]");
    }
}

