/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;

public class JDBCUtilities {
    private static int SQL_SERVER_TRANSACTION_SNAPSHOT = 4096;

    public static void closePreparedStatement(Hashtable<String, PreparedStatement> tablePstmt, Logger log) {
        if (tablePstmt != null && tablePstmt.keys().hasMoreElements()) {
            ArrayList<String> listKeys = Collections.list(tablePstmt.keys());
            Collections.sort(listKeys);
            for (int i = 0; i < listKeys.size(); ++i) {
                String key = listKeys.get(i);
                PreparedStatement pstmt = tablePstmt.get(key);
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    log.debug((Object)("Utilities.closePreparedStatement error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e));
                }
                tablePstmt.remove(key);
            }
        }
    }

    public static void executePreparedStatement(Hashtable<String, PreparedStatement> tablePstmt) throws UtilsException {
        if (tablePstmt != null && tablePstmt.keys().hasMoreElements()) {
            ArrayList<String> listKeys = Collections.list(tablePstmt.keys());
            Collections.sort(listKeys);
            for (int i = 0; i < listKeys.size(); ++i) {
                String key = listKeys.get(i);
                PreparedStatement pstmt = tablePstmt.get(key);
                try {
                    pstmt.execute();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.executePreparedStatement error: Riscontrato errore durante l'esecuzione della PreparedStatement [" + key + "]: " + e, e);
                }
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.executePreparedStatement error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e, e);
                }
                tablePstmt.remove(key);
            }
        }
    }

    public static void addPreparedStatement(Hashtable<String, PreparedStatement> pstmtSorgente, Hashtable<String, PreparedStatement> pstmtDestinazione, Logger log) throws UtilsException {
        Enumeration<String> keys = pstmtSorgente.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!pstmtDestinazione.containsKey(key)) {
                pstmtDestinazione.put(key, pstmtSorgente.get(key));
                continue;
            }
            try {
                PreparedStatement pstmt = pstmtSorgente.get(key);
                pstmt.close();
            }
            catch (Exception e) {
                throw new UtilsException("Utilities.closePreparedStatementGiaPresente error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e, e);
            }
        }
    }

    public static void setSQLStringValue(PreparedStatement pstmt, int index, String value) throws SQLException {
        if (value != null && !"".equals(value)) {
            pstmt.setString(index, value);
        } else {
            pstmt.setString(index, null);
        }
    }

    public static boolean isTransactionIsolationNone(int transactionIsolationLevel) {
        return transactionIsolationLevel == 0;
    }

    public static boolean isTransactionIsolationReadUncommitted(int transactionIsolationLevel) {
        return transactionIsolationLevel == 1;
    }

    public static boolean isTransactionIsolationReadCommitted(int transactionIsolationLevel) {
        return transactionIsolationLevel == 2;
    }

    public static boolean isTransactionIsolationRepeatableRead(int transactionIsolationLevel) {
        return transactionIsolationLevel == 4;
    }

    public static boolean isTransactionIsolationSerializable(int transactionIsolationLevel) {
        return transactionIsolationLevel == 8;
    }

    public static boolean isTransactionIsolationSqlServerSnapshot(int transactionIsolationLevel) {
        return transactionIsolationLevel == SQL_SERVER_TRANSACTION_SNAPSHOT;
    }

    public static void setTransactionIsolationSerializable(String tipoDatabase, Connection connection) throws SQLException {
        JDBCUtilities.setTransactionIsolationSerializable(TipiDatabase.toEnumConstant(tipoDatabase), connection);
    }

    public static void setTransactionIsolationSerializable(TipiDatabase tipoDatabase, Connection connection) throws SQLException {
        if (tipoDatabase != null && TipiDatabase.SQLSERVER.equals(tipoDatabase)) {
            connection.setTransactionIsolation(SQL_SERVER_TRANSACTION_SNAPSHOT);
        } else {
            connection.setTransactionIsolation(8);
        }
    }
}

