/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jaxb;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.openspcoop2.utils.jaxb.DecimalWrapper;

public class Decimal2String
extends XmlAdapter<String, DecimalWrapper> {
    public String marshal(DecimalWrapper v) throws Exception {
        int i;
        if (v == null) {
            return null;
        }
        StringBuffer pattern = new StringBuffer();
        for (i = 0; i < v.getMaxInteger(); ++i) {
            pattern.append("0");
        }
        if (v.getMaxDecimal() > 0) {
            pattern.append(".");
            for (i = 0; i < v.getMaxDecimal(); ++i) {
                pattern.append("0");
            }
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat(pattern.toString(), dfs);
        String value = df.format(v.getObject());
        if (v.getMinInteger() != v.getMaxInteger() || v.getMinDecimal() != v.getMaxDecimal()) {
            if (value.contains(".")) {
                String[] split = value.split("\\.");
                String left = split[0];
                String right = split[1];
                if (v.getMinInteger() != v.getMaxInteger()) {
                    left = this.getLeftMinString(split[0], v.getMinInteger());
                }
                if (v.getMinDecimal() != v.getMaxDecimal()) {
                    right = this.getRightMinString(split[1], v.getMinDecimal());
                }
                value = left + "." + right;
            } else {
                value = this.getLeftMinString(value, v.getMinInteger());
            }
            return value;
        }
        return value;
    }

    private String getLeftMinString(String value, int min) {
        StringBuffer bf = new StringBuffer();
        for (int i = value.length() - 1; i >= 0; --i) {
            if (value.charAt(i) != '0' || !this.onlyLeftZero(value, i)) {
                bf.append(value.charAt(i));
                continue;
            }
            if (bf.length() >= min) break;
            bf.append(value.charAt(i));
        }
        return bf.reverse().toString();
    }

    private String getRightMinString(String value, int min) {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '0' || !this.onlyRightZero(value, i)) {
                bf.append(value.charAt(i));
                continue;
            }
            if (bf.length() >= min) break;
            bf.append(value.charAt(i));
        }
        return bf.reverse().toString();
    }

    private boolean onlyLeftZero(String value, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (value.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    private boolean onlyRightZero(String value, int fromIndex) {
        for (int i = fromIndex; i < value.length(); ++i) {
            if (value.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    public DecimalWrapper unmarshal(String sParam) throws Exception {
        if (sParam == null) {
            return null;
        }
        String s = sParam.trim();
        StringBuffer pattern = new StringBuffer();
        DecimalWrapper dw = new DecimalWrapper();
        if (s.contains(".")) {
            int i;
            String[] split = s.split("\\.");
            dw.setMinInteger(split[0].length());
            dw.setMaxInteger(split[0].length());
            for (i = 0; i < split[0].length(); ++i) {
                pattern.append("0");
            }
            pattern.append(".");
            dw.setMinDecimal(split[1].length());
            dw.setMaxDecimal(split[1].length());
            for (i = 0; i < split[1].length(); ++i) {
                pattern.append("0");
            }
        } else {
            dw.setMinInteger(s.length());
            dw.setMaxInteger(s.length());
            for (int i = 0; i < s.length(); ++i) {
                pattern.append("0");
            }
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat(pattern.toString(), dfs);
        Object o = df.parseObject(s);
        dw.setObject(o);
        return dw;
    }
}

