/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.notifier.unblocked;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class PipedUnblockedStream
extends InputStream {
    protected Logger log = null;
    private long sizeBuffer;
    private ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private byte[] bytesReceived = null;
    private int indexNextByteReceivedForRead = -1;
    private boolean stop = false;
    private static final int ITERAZIONI_WAIT = 128;

    public PipedUnblockedStream(Logger log, long sizeBuffer) {
        this.log = log;
        this.sizeBuffer = sizeBuffer / 2L;
    }

    private void readWaitBytes() throws IOException {
        int i = 0;
        while (!this.stop && this.bout.size() == 0 && i < 128) {
            try {
                Thread.sleep(i + 1);
                i += i;
            }
            catch (Exception exception) {}
        }
        if (i >= 128) {
            throw new IOException("Timeout, no bytes available for read");
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesAvailableForRead;
        if (this.bytesReceived == null) {
            if (this.stop) {
                if (this.bout == null) {
                    return -1;
                }
                if (this.bout.size() <= 0) {
                    this.bout.close();
                    this.bout = null;
                    return -1;
                }
            } else if (this.bout.size() == 0) {
                this.readWaitBytes();
            }
        }
        if (this.bytesReceived == null && this.stop) {
            if (this.bout == null) {
                return -1;
            }
            if (this.bout.size() <= 0) {
                this.bout.close();
                this.bout = null;
                return -1;
            }
        }
        if (this.bytesReceived == null) {
            ByteArrayOutputStream byteArrayOutputStream = this.bout;
            synchronized (byteArrayOutputStream) {
                this.bout.flush();
                this.bytesReceived = this.bout.toByteArray();
                this.indexNextByteReceivedForRead = 0;
                this.bout.reset();
            }
        }
        if ((bytesAvailableForRead = this.bytesReceived.length - this.indexNextByteReceivedForRead) == len) {
            for (int i = 0; i < len; ++i) {
                b[off + i] = this.bytesReceived[this.indexNextByteReceivedForRead];
                ++this.indexNextByteReceivedForRead;
            }
            this.bytesReceived = null;
            this.indexNextByteReceivedForRead = -1;
            return len;
        }
        if (bytesAvailableForRead > len) {
            int i = 0;
            for (i = 0; i < len; ++i) {
                b[off + i] = this.bytesReceived[this.indexNextByteReceivedForRead];
                ++this.indexNextByteReceivedForRead;
            }
            return len;
        }
        for (int i = 0; i < bytesAvailableForRead; ++i) {
            b[off + i] = this.bytesReceived[this.indexNextByteReceivedForRead];
            ++this.indexNextByteReceivedForRead;
        }
        this.bytesReceived = null;
        this.indexNextByteReceivedForRead = -1;
        return bytesAvailableForRead;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b);
    }

    @Override
    public void close() throws IOException {
        if (!this.stop) {
            if (this.bout.size() <= 0) {
                this.bout.close();
                this.bout = null;
            }
            this.stop = true;
        }
    }

    private void writeWaitEmptyBuffer() throws IOException {
        int i = 0;
        while (!this.stop && this.bout.size() > 0 && i < 128) {
            try {
                Thread.sleep(i + 1);
                i += i;
            }
            catch (Exception exception) {}
        }
        if (i >= 128) {
            throw new IOException("Timeout, no buffer available for write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte b) throws IOException {
        if (this.bout == null) {
            throw new IOException("Stream already closed");
        }
        if ((long)this.bout.size() > this.sizeBuffer) {
            this.writeWaitEmptyBuffer();
        }
        ByteArrayOutputStream byteArrayOutputStream = this.bout;
        synchronized (byteArrayOutputStream) {
            this.bout.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        if (this.bout == null) {
            throw new IOException("Stream already closed");
        }
        if ((long)this.bout.size() > this.sizeBuffer) {
            this.writeWaitEmptyBuffer();
        }
        ByteArrayOutputStream byteArrayOutputStream = this.bout;
        synchronized (byteArrayOutputStream) {
            this.bout.write(b);
        }
    }
}

