/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.CompressorType;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class CompressorUtilities {
    public static void main(String[] args) throws Exception {
        String test = "<prova xmlns=\"www.test.it\">PROVA</prova>";
        byte[] testB = test.getBytes();
        System.out.println("\n\n=== DEFLATER ===");
        byte[] compress = CompressorUtilities.compress(testB, CompressorType.DEFLATER);
        System.out.println("Compresso, dimensione: " + compress.length);
        System.out.println("Compresso, in stringa: " + new String(compress));
        System.out.println("De-Compresso, in stringa: " + new String(CompressorUtilities.decompress(compress, CompressorType.DEFLATER)));
        System.out.println("\n\n=== GZIP ===");
        compress = CompressorUtilities.compress(testB, CompressorType.GZIP);
        System.out.println("Compresso, dimensione: " + compress.length);
        System.out.println("Compresso, in stringa: " + new String(compress));
        System.out.println("De-Compresso, in stringa: " + new String(CompressorUtilities.decompress(compress, CompressorType.GZIP)));
        System.out.println("\n\n=== ZIP ===");
        compress = CompressorUtilities.compress(testB, CompressorType.ZIP);
        System.out.println("Compresso, dimensione: " + compress.length);
        System.out.println("Compresso, in stringa: " + new String(compress));
        System.out.println("De-Compresso, in stringa: " + new String(CompressorUtilities.decompress(compress, CompressorType.ZIP)));
    }

    public static byte[] compress(byte[] content, CompressorType type) throws UtilsException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputStream out = null;
            switch (type) {
                case DEFLATER: {
                    out = new DeflaterOutputStream(baos);
                    out.write(content);
                    break;
                }
                case GZIP: {
                    out = new GZIPOutputStream(baos);
                    out.write(content);
                    break;
                }
                case ZIP: {
                    out = new ZipOutputStream(baos);
                    ((ZipOutputStream)out).putNextEntry(new ZipEntry("dat"));
                    out.write(content);
                    ((ZipOutputStream)out).closeEntry();
                }
            }
            out.flush();
            out.close();
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] bytes, CompressorType type) throws UtilsException {
        InputStream in = null;
        ByteArrayInputStream bin = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            bin = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[8192];
            switch (type) {
                case DEFLATER: {
                    int len;
                    in = new InflaterInputStream(bin);
                    while ((len = in.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    break;
                }
                case GZIP: {
                    int len;
                    in = new GZIPInputStream(bin);
                    while ((len = in.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    break;
                }
                case ZIP: {
                    File f = File.createTempFile("unzip", "zip");
                    try {
                        int len;
                        FileSystemUtilities.writeFile(f, bytes);
                        ZipFile zf = new ZipFile(f);
                        ZipEntry ze = zf.entries().nextElement();
                        in = zf.getInputStream(ze);
                        while ((len = in.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                        break;
                    }
                    finally {
                        f.delete();
                    }
                }
            }
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

