/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id;

import java.util.Hashtable;
import java.util.Random;

public class IDUtilities {
    private static long uniqueSerialNumber;
    private static final char[] symbols;
    private static final Random random;
    private static final Hashtable<String, char[]> mapRandom;

    public static synchronized long getUniqueSerialNumber() {
        if (uniqueSerialNumber + 1L > Long.MAX_VALUE) {
            uniqueSerialNumber = 0L;
        }
        return ++uniqueSerialNumber;
    }

    private static synchronized char[] getBufferForRandom(int length) {
        String key = length + "";
        if (mapRandom.containsKey(key)) {
            return mapRandom.get(key);
        }
        char[] buf = new char[length];
        mapRandom.put(key, buf);
        return buf;
    }

    public static String generateAlphaNumericRandomString(int length) {
        char[] buf = IDUtilities.getBufferForRandom(length);
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = symbols[random.nextInt(symbols.length)];
        }
        return new String(buf);
    }

    static {
        char ch;
        uniqueSerialNumber = 0L;
        StringBuilder tmp = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        symbols = tmp.toString().toCharArray();
        random = new Random();
        mapRandom = new Hashtable();
    }
}

