/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.digest;

import org.apache.log4j.Logger;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.digest.IDigestReader;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecurityDigestReader
implements IDigestReader {
    private Logger log;
    private AbstractXPathExpressionEngine xpathEngine;
    private AbstractXMLUtils xmlUtils;

    public WSSecurityDigestReader(AbstractXMLUtils xmlUtils, AbstractXPathExpressionEngine xpathEngine) {
        this(Logger.getLogger(WSSecurityDigestReader.class), xmlUtils, xpathEngine);
    }

    public WSSecurityDigestReader(Logger log, AbstractXMLUtils xmlUtils, AbstractXPathExpressionEngine xpathEngine) {
        this.log = log;
        this.xmlUtils = xmlUtils;
        this.xpathEngine = xpathEngine;
    }

    @Override
    public String getDigest(Element element, String referenceId, DynamicNamespaceContext dnc) throws UtilsException {
        try {
            String xPathReferenceElement = "//{http://www.w3.org/2000/09/xmldsig#}Reference[@URI='" + referenceId + "']";
            Node n = null;
            try {
                this.log.debug((Object)("Search referenceId con xpath [" + xPathReferenceElement + "] ..."));
                n = (Node)this.xpathEngine.getMatchPattern(element, dnc, xPathReferenceElement, XPathReturnType.NODE);
            }
            catch (XPathNotFoundException notFound) {
                xPathReferenceElement = "//Reference[@URI='" + referenceId + "']";
                this.log.debug((Object)("Search(2) referenceId con xpath [" + xPathReferenceElement + "] ..."));
                try {
                    n = (Node)this.xpathEngine.getMatchPattern(element, dnc, xPathReferenceElement, XPathReturnType.NODE);
                }
                catch (XPathNotFoundException notFoundInternal) {
                    this.log.debug((Object)("Reference id [" + referenceId + "] non troavata"));
                    return null;
                }
            }
            byte[] nBytes = this.xmlUtils.toByteArray(n);
            this.log.debug((Object)("Found Reference Element [" + this.xmlUtils.toString(n) + "]"));
            String xPathDigestValue = "//{http://www.w3.org/2000/09/xmldsig#}DigestValue/text()";
            String digest = null;
            try {
                this.log.debug((Object)("Search digestValue con xpath [" + xPathDigestValue + "] ..."));
                digest = (String)this.xpathEngine.getMatchPattern(this.xmlUtils.newDocument(nBytes), dnc, xPathDigestValue, XPathReturnType.STRING);
            }
            catch (XPathNotFoundException notFound) {
                xPathDigestValue = "//DigestValue/text()";
                this.log.debug((Object)("Search(2) digestValue con xpath [" + xPathDigestValue + "] ..."));
                digest = (String)this.xpathEngine.getMatchPattern(element, dnc, xPathReferenceElement, XPathReturnType.STRING);
            }
            this.log.debug((Object)("Found DigestValue [" + digest + "]"));
            return digest;
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la getDigest", (Throwable)e);
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

