/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.csv.CSVPrinter;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;

public class Printer {
    private OutputStream out;
    private Writer writer;
    private CSVPrinter csvPrinter;

    public Printer(Format format, File file) throws UtilsException {
        this(format, file, "UTF-8");
    }

    public Printer(Format format, File file, String charset) throws UtilsException {
        try {
            this.out = new FileOutputStream(file);
            this.writer = new OutputStreamWriter(this.out, charset);
            this.csvPrinter = new CSVPrinter((Appendable)this.writer, format.getCsvFormat());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Printer(Format format, OutputStream out) throws UtilsException {
        this(format, out, "UTF-8");
    }

    public Printer(Format format, OutputStream out, String charset) throws UtilsException {
        try {
            this.writer = new OutputStreamWriter(out, charset);
            this.csvPrinter = new CSVPrinter((Appendable)this.writer, format.getCsvFormat());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Printer(Format format, Writer writer) throws UtilsException {
        try {
            this.csvPrinter = new CSVPrinter((Appendable)writer, format.getCsvFormat());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public Printer(Format format, Appendable appendable) throws UtilsException {
        try {
            this.csvPrinter = new CSVPrinter(appendable, format.getCsvFormat());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void close() {
        try {
            if (this.csvPrinter != null) {
                this.csvPrinter.flush();
                this.csvPrinter.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void println() throws UtilsException {
        try {
            this.csvPrinter.println();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void print(Object line) throws UtilsException {
        try {
            this.csvPrinter.print(line);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void printRecord(Iterable<?> values) throws UtilsException {
        try {
            this.csvPrinter.printRecord(values);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void printRecord(Object ... values) throws UtilsException {
        try {
            this.csvPrinter.printRecord(values);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void printComment(String comment) throws UtilsException {
        try {
            this.csvPrinter.printComment(comment);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

