/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.csv;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;
import org.openspcoop2.utils.csv.MapResult;
import org.openspcoop2.utils.csv.ParserMappingRecord;
import org.openspcoop2.utils.csv.ParserRegexpNotFound;
import org.openspcoop2.utils.csv.ParserResult;
import org.openspcoop2.utils.csv.Record;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class Parser {
    private static final String PARSER_NAME_PREFIX_ = "mapping.field.";
    private static final String PARSER_REGEXP_PREFIX_ = "mapping.regexp.";
    private static final String PARSER_REGEXP_SUFFIX_NOT_FOUND = ".notFound";
    private static final String PARSER_DEFAULT_PREFIX_ = "mapping.default.";
    private static final String PARSER_CONSTANT_PREFIX_ = "mapping.constant.";
    private static final String PARSER_REQUIRED_PREFIX_ = "mapping.required.";
    private List<ParserMappingRecord> mapping;

    public Parser(List<ParserMappingRecord> mapping) throws UtilsException {
        if (mapping == null || mapping.size() <= 0) {
            throw new UtilsException("Map is null");
        }
        for (int i = 0; i < mapping.size(); ++i) {
            if (mapping.get(i).getName() == null) {
                throw new UtilsException("RecordMapping[" + i + "] without name");
            }
            if (mapping.get(i).getConstantValue() != null || mapping.get(i).getCsvPosition() != null || mapping.get(i).getCsvColumnName() != null) continue;
            throw new UtilsException("RecordMapping[" + i + "] name[" + mapping.get(i).getName() + "] without almost one required field: constantValue, csvPosition, csvColumnName");
        }
        this.mapping = mapping;
    }

    public Parser(InputStream is, boolean positionMapping) throws UtilsException {
        Properties p = null;
        try {
            p = new Properties();
            p.load(is);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.init(p, positionMapping);
    }

    public Parser(Properties properties, boolean positionMapping) throws UtilsException {
        this.init(properties, positionMapping);
    }

    private void init(Properties properties, boolean positionMapping) throws UtilsException {
        Properties names = Utilities.readProperties(PARSER_NAME_PREFIX_, properties);
        Properties regexps = Utilities.readProperties(PARSER_REGEXP_PREFIX_, properties);
        Properties constants = Utilities.readProperties(PARSER_CONSTANT_PREFIX_, properties);
        Properties required = Utilities.readProperties(PARSER_REQUIRED_PREFIX_, properties);
        Properties defaults = Utilities.readProperties(PARSER_DEFAULT_PREFIX_, properties);
        if (names.size() <= 0) {
            throw new UtilsException("No mapping exists");
        }
        this.mapping = new ArrayList<ParserMappingRecord>();
        Enumeration<Object> enNames = names.keys();
        while (enNames.hasMoreElements()) {
            String key = (String)enNames.nextElement();
            String value = names.getProperty(key);
            if (value == null) {
                throw new UtilsException("Property [mapping.field." + key + "] without value");
            }
            value = value.trim();
            ParserMappingRecord recordMapping = null;
            if (constants.containsKey(key)) {
                if ("true".equalsIgnoreCase(constants.getProperty(key).trim())) {
                    recordMapping = ParserMappingRecord.newCsvConstantRecord(key, value);
                } else if (!"false".equalsIgnoreCase(required.getProperty(key).trim())) {
                    throw new UtilsException("Property [mapping.constant." + key + "] with wrong value (expected true/false): " + required.getProperty(key).trim());
                }
            }
            if (recordMapping == null) {
                String[] regExpr = null;
                ParserRegexpNotFound regexpNotFoundBehaviour = null;
                if (regexps.containsKey(key) && regexps.getProperty(key) != null) {
                    ArrayList<String> r = new ArrayList<String>();
                    r.add(regexps.getProperty(key).trim());
                    int index = 1;
                    while (regexps.containsKey(key + "." + index) && regexps.getProperty(key + "." + index) != null) {
                        r.add(regexps.getProperty(key + "." + index).trim());
                        ++index;
                    }
                    regExpr = r.toArray(new String[1]);
                    if (regexps.containsKey(key + PARSER_REGEXP_SUFFIX_NOT_FOUND) && regexps.getProperty(key + PARSER_REGEXP_SUFFIX_NOT_FOUND) != null) {
                        String tmp = regexps.getProperty(key + PARSER_REGEXP_SUFFIX_NOT_FOUND).trim();
                        ParserRegexpNotFound[] p = ParserRegexpNotFound.values();
                        for (int i = 0; i < p.length; ++i) {
                            if (!p[i].toString().equals(tmp)) continue;
                            regexpNotFoundBehaviour = p[i];
                            break;
                        }
                        if (regexpNotFoundBehaviour == null) {
                            throw new UtilsException("Property [mapping.regexp." + key + PARSER_REGEXP_SUFFIX_NOT_FOUND + "] with wrong value (expected: " + ArrayUtils.toString((Object)p) + "): " + tmp);
                        }
                    }
                }
                String defaultValue = null;
                if (defaults.containsKey(key) && defaults.getProperty(key) != null) {
                    defaultValue = defaults.getProperty(key).trim();
                }
                if (positionMapping) {
                    try {
                        int intValue = Integer.parseInt(value);
                        if (intValue < 0) {
                            throw new Exception("Negative Number");
                        }
                        recordMapping = ParserMappingRecord.newCsvColumnPositionRecord(key, (Integer)intValue, defaultValue, regexpNotFoundBehaviour, regExpr);
                    }
                    catch (Exception e) {
                        throw new UtilsException("Property [mapping.field." + key + "] with wrong value (expected positive number): " + e.getMessage(), e);
                    }
                } else {
                    recordMapping = ParserMappingRecord.newCsvColumnNameRecord(key, value, defaultValue, regexpNotFoundBehaviour, regExpr);
                }
                if (required.containsKey(key)) {
                    if ("true".equalsIgnoreCase(required.getProperty(key).trim())) {
                        recordMapping.setRequired(true);
                    } else if ("false".equalsIgnoreCase(required.getProperty(key).trim())) {
                        recordMapping.setRequired(false);
                    } else {
                        throw new UtilsException("Property [mapping.required." + key + "] with wrong value (expected true/false): " + required.getProperty(key).trim());
                    }
                }
            }
            this.mapping.add(recordMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParserResult parseCsvFile(Format format, String csvContent) throws UtilsException {
        StringReader reader = null;
        try {
            reader = new StringReader(csvContent);
            ParserResult parserResult = this.parseCsvFile(format, reader);
            return parserResult;
        }
        finally {
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public ParserResult parseCsvFile(Format format, byte[] csv) throws UtilsException {
        return this.parseCsvFile(format, csv, "UTF-8", false);
    }

    public ParserResult parseCsvFile(Format format, byte[] csv, String charset) throws UtilsException {
        return this.parseCsvFile(format, csv, charset, false);
    }

    public ParserResult parseCsvFile(Format format, byte[] csv, boolean enableBomInputStream) throws UtilsException {
        return this.parseCsvFile(format, csv, "UTF-8", enableBomInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParserResult parseCsvFile(Format format, byte[] csv, String charset, boolean enableBomInputStream) throws UtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(csv);
            ParserResult parserResult = this.parseCsvFile(format, bin, charset, enableBomInputStream);
            return parserResult;
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public ParserResult parseCsvFile(Format format, File file) throws UtilsException {
        return this.parseCsvFile(format, file, "UTF-8", false);
    }

    public ParserResult parseCsvFile(Format format, File file, String charset) throws UtilsException {
        return this.parseCsvFile(format, file, charset, false);
    }

    public ParserResult parseCsvFile(Format format, File file, boolean enableBomInputStream) throws UtilsException {
        return this.parseCsvFile(format, file, "UTF-8", enableBomInputStream);
    }

    public ParserResult parseCsvFile(Format format, File file, String charset, boolean enableBomInputStream) throws UtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            ParserResult parserResult = this.parseCsvFile(format, fin, charset, enableBomInputStream);
            return parserResult;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public ParserResult parseCsvFile(Format format, InputStream is) throws UtilsException {
        return this.parseCsvFile(format, is, "UTF-8", false);
    }

    public ParserResult parseCsvFile(Format format, InputStream is, String charset) throws UtilsException {
        return this.parseCsvFile(format, is, charset, false);
    }

    public ParserResult parseCsvFile(Format format, InputStream is, boolean enableBomInputStream) throws UtilsException {
        return this.parseCsvFile(format, is, "UTF-8", enableBomInputStream);
    }

    public ParserResult parseCsvFile(Format format, InputStream is, String charset, boolean enableBomInputStream) throws UtilsException {
        InputStreamReader reader = null;
        BOMInputStream bomInputStream = null;
        try {
            if (enableBomInputStream) {
                bomInputStream = new BOMInputStream(is);
                reader = new InputStreamReader((InputStream)bomInputStream, charset);
            } else {
                reader = new InputStreamReader(is, charset);
            }
            ParserResult parserResult = this.parseCsvFile(format, reader);
            return parserResult;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bomInputStream != null) {
                    bomInputStream.close();
                }
            }
            catch (Exception eClose) {}
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParserResult parseCsvFile(Format format, Reader reader) throws UtilsException {
        CSVParser parser = null;
        ParserResult parserResult = null;
        try {
            parser = new CSVParser(reader, format.getCsvFormat());
            parserResult = new ParserResult();
            parserResult.setHeaderMap(parser.getHeaderMap());
            for (CSVRecord record : parser.getRecords()) {
                if (format.isSkipEmptyRecord() && Parser.isRecordEmpty(record)) continue;
                Record recordBean = new Record();
                recordBean.setComment(record.getComment());
                recordBean.setCsvLine(record.getRecordNumber());
                recordBean.setRecord(record);
                MapResult recordMap = new MapResult();
                try {
                    for (int i = 0; i < this.mapping.size(); ++i) {
                        ParserMappingRecord mappingRecord = this.mapping.get(i);
                        String key = mappingRecord.getName();
                        String valore = null;
                        if (mappingRecord.getConstantValue() != null) {
                            valore = mappingRecord.getConstantValue();
                        } else {
                            String tmpValue = null;
                            if (mappingRecord.getCsvPosition() != null) {
                                if (mappingRecord.getCsvPosition() >= record.size()) throw new Exception("Record with index [" + mappingRecord.getCsvPosition() + "] is greather or equals record size [" + record.size() + "]");
                                tmpValue = record.get(mappingRecord.getCsvPosition().intValue());
                            } else {
                                if (!record.isMapped(mappingRecord.getCsvColumnName())) throw new Exception("Record with column name [" + mappingRecord.getCsvColumnName() + "] not exists");
                                tmpValue = record.get(mappingRecord.getCsvColumnName());
                            }
                            if (tmpValue != null && mappingRecord.getRegexpr() != null) {
                                String[] pattern = mappingRecord.getRegexpr();
                                String regExpValue = null;
                                for (int j = 0; j < pattern.length; ++j) {
                                    try {
                                        regExpValue = RegularExpressionEngine.getStringMatchPattern(tmpValue, pattern[j]);
                                        if (regExpValue == null) continue;
                                        break;
                                    }
                                    catch (RegExpNotFoundException notFound) {
                                        // empty catch block
                                    }
                                }
                                if (regExpValue == null) {
                                    if (ParserRegexpNotFound.ERROR.equals((Object)mappingRecord.getRegexpNotFoundBehaviour())) {
                                        throw new Exception("Mapping for field [" + mappingRecord.getName() + "] failed, regular expression not match (value [" + tmpValue + "])");
                                    }
                                    if (ParserRegexpNotFound.NULL.equals((Object)mappingRecord.getRegexpNotFoundBehaviour())) {
                                        tmpValue = null;
                                    } else if (ParserRegexpNotFound.ORIGINAL.equals((Object)mappingRecord.getRegexpNotFoundBehaviour())) {
                                        // empty if block
                                    }
                                } else {
                                    tmpValue = regExpValue;
                                }
                            }
                            if (tmpValue == null && mappingRecord.getDefaultValue() != null) {
                                tmpValue = mappingRecord.getDefaultValue();
                            }
                            if (tmpValue == null && mappingRecord.isRequired()) {
                                throw new Exception("Mapping for field [" + mappingRecord.getName() + "] failed");
                            }
                            valore = tmpValue;
                        }
                        recordMap.add(key, valore);
                    }
                }
                catch (Exception e) {
                    throw new Exception("Record Line[" + record.getRecordNumber() + "] [" + record + "]: " + e.getMessage(), e);
                }
                finally {
                    try {
                        if (parser != null) {
                            parser.close();
                            parser = null;
                        }
                    }
                    catch (Exception eClose) {}
                }
                recordBean.setMap(recordMap);
                parserResult.getRecords().add(recordBean);
            }
            ParserResult i$ = parserResult;
            return i$;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public static boolean isRecordEmpty(CSVRecord record) {
        for (int i = 0; i < record.size(); ++i) {
            if (record.get(i) == null || record.get(i).trim().equals("")) continue;
            return false;
        }
        return true;
    }
}

