/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v2_3.govway.reader;

import it.link.pdd.tools.migrazione_govway.drivers.DriverConfigurazioneServiziOpenSPCoopV2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataServizioIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataSoggettoErogatoreIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteApplicative;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteDelegate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaServiziApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.reader.govway.IConfigurazioneServiziReader;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.driver.DriverAvanzatoGovway;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.reader.ConfigurazioneServiziConverter;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.ApiWrapper;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.PortaApplicativaWrapper;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.PortaDelegataWrapper;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.SoggettoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ApplicativoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ErogazioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.FruizioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.InputWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.MultitenantConfigurazione;
import it.link.pdd.tools.migrazione_govway.writer.govway.utils.ConverterContext;
import it.link.pdd.tools.migrazione_govway.writer.govway.utils.ConverterHttpServletRequestWrapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiEnv;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.Ruolo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.context.IContext;
import org.slf4j.Logger;

public class ConfigurazioneServiziReader
implements IConfigurazioneServiziReader {
    private IDriverRegistroServiziGet driverRegistro;
    private IDriverConfigurazioneGet driverConfigurazione;
    private DriverConfigurazioneServiziOpenSPCoopV2 driverAvanzato;
    private boolean dsMode;
    private Connection connection;
    private ConfigurazioneServiziConverter converter;
    private Logger log;
    private List<AccordoServizioParteComune> lstAspc;
    private SoggettiEnv env;

    private SoggettiEnv getEnv() throws Exception {
        if (this.env == null) {
            this.env = new SoggettiEnv((HttpServletRequest)new ConverterHttpServletRequestWrapper(), null, (IContext)new ConverterContext(this.log));
        }
        return this.env;
    }

    public void closeConnection() throws SQLException {
        if (!this.dsMode) {
            this.connection.close();
        }
    }

    public ConfigurazioneServiziReader(DatabaseProperties initIn, DatabaseProperties initOut, Logger log) throws Exception {
        try (Connection connectionAvanzato = null;){
            DriverAvanzatoGovway avanzato;
            this.dsMode = initIn.isDataSourceMode();
            this.log = log;
            if (this.dsMode) {
                this.driverRegistro = new DriverRegistroServiziDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV2(initIn.getJndiName(), initIn.getJndiProp(), log, initIn.getTipoDatabase());
                avanzato = new DriverAvanzatoGovway(initOut.getJndiName(), initOut.getJndiProp(), log, initOut.getTipoDatabase());
            } else {
                Class.forName(initIn.getDriverJDBC());
                this.connection = DriverManager.getConnection(initIn.getConnectionURL(), initIn.getUsername(), initIn.getPassword());
                connectionAvanzato = DriverManager.getConnection(initOut.getConnectionURL(), initOut.getUsername(), initOut.getPassword());
                this.driverRegistro = new DriverRegistroServiziDB(this.connection, log, initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(this.connection, log, initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV2(this.connection, log, initIn.getTipoDatabase());
                avanzato = new DriverAvanzatoGovway(connectionAvanzato, log, initOut.getTipoDatabase());
            }
            Map<String, String> soggettiDefault = avanzato.getSoggettiDefault();
            this.converter = ConfigurazioneServiziConverter.getInstance(soggettiDefault);
            this.lstAspc = new ArrayList<AccordoServizioParteComune>();
            try {
                List lstIdAspc = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
                for (IDAccordo id : lstIdAspc) {
                    this.lstAspc.add(this.driverRegistro.getAccordoServizioParteComune(id));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    public InputWrapper<IDSoggetto, it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper> findAllSoggetti() throws Exception {
        ArrayList<SoggettoWrapper> lst = new ArrayList<SoggettoWrapper>();
        HashMap<IDSoggetto, String> lstIdNonMigrati = new HashMap<IDSoggetto, String>();
        String nomeSoggettoReferenteDefault = MigrazioneProperties.getInstance().getNomeSoggettoReferenteDefault();
        boolean migraSoggettiProxy = this.driverAvanzato.migraSoggettiProxy();
        try {
            FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
            List<IDSoggetto> allIdSoggetti = this.driverConfigurazione.getAllIdSoggetti(filtroRicerca);
            allIdSoggetti = this.sort(allIdSoggetti, migraSoggettiProxy);
            for (IDSoggetto id : allIdSoggetti) {
                if (id.getNome().equals(nomeSoggettoReferenteDefault)) continue;
                if (!this.isSoggettoMigrabile(id.getTipo())) {
                    lstIdNonMigrati.put(id, "Soggetto di tipo [" + id.getTipo() + "] non migrabile");
                    continue;
                }
                if (!this.getEnv().soggettiHelper.checkSimpleName(id.getNome(), "soggetto")) {
                    lstIdNonMigrati.put(id, this.getEnv().soggettiHelper.getPd().getMessage());
                    continue;
                }
                Soggetto soggetto = this.driverConfigurazione.getSoggetto(id);
                SoggettoWrapper wrapper = new SoggettoWrapper();
                wrapper.setSoggetto(soggetto);
                wrapper.setSoggettoReg(this.driverRegistro.getSoggetto(id));
                wrapper.setDominio(this.driverAvanzato.getDominio(soggetto.getId().longValue()));
                wrapper.setKey(id);
                lst.add(wrapper);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return this.converter.toSoggettiList(lst, lstIdNonMigrati);
    }

    private List<IDSoggetto> sort(List<IDSoggetto> allIdSoggetti, boolean migraSoggettiProxy) {
        HashMap map = new HashMap();
        for (IDSoggetto id : allIdSoggetti) {
            if (!map.containsKey(id.getTipo())) {
                map.put(id.getTipo(), new ArrayList());
            }
            ((List)map.get(id.getTipo())).add(id);
        }
        ArrayList<IDSoggetto> soggetti = (ArrayList<IDSoggetto>)map.remove("PROXY");
        if (!migraSoggettiProxy) {
            soggetti = new ArrayList<IDSoggetto>();
        }
        for (String id : map.keySet()) {
            soggetti.addAll((Collection)map.get(id));
        }
        return soggetti;
    }

    public InputWrapper<String, it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper> findAllApi() throws Exception {
        ArrayList<ApiWrapper> lst = new ArrayList<ApiWrapper>();
        HashMap<String, String> lstIdDaScartare = new HashMap<String, String>();
        ArrayList<AccordoServizioParteSpecifica> lstAspsCollezionati = new ArrayList<AccordoServizioParteSpecifica>();
        try {
            IDAccordo idAccordo;
            List allIdPorteDelegate = new ArrayList();
            try {
                allIdPorteDelegate = this.driverConfigurazione.getAllIdPorteDelegate(new FiltroRicercaPorteDelegate());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            for (IDPortaDelegata id : allIdPorteDelegate) {
                PortaDelegata portaDelegata = this.driverConfigurazione.getPortaDelegata(id);
                String checkPortaDelegata = this.checkPortaDelegata(portaDelegata);
                IDServizio idServizio = new IDServizio(new IDSoggetto(portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome()), portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome());
                if (checkPortaDelegata != null) {
                    this.log.warn("Porta Delegata [" + id + "] non migrata. Motivazione: " + checkPortaDelegata);
                    Object idAccordoString = null;
                    try {
                        AccordoServizioParteSpecifica asps = this.driverRegistro.getAccordoServizioParteSpecifica(idServizio);
                        AccordoServizioParteComune aspc = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(asps.getIdAccordo().longValue());
                        idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(aspc);
                        idAccordoString = idAccordo.toString();
                    }
                    catch (Exception e) {
                        idAccordoString = "Impossibile trovare l'Accordo per la Porta Delegata [" + id + "]";
                    }
                    lstIdDaScartare.put((String)idAccordoString, "Porta Delegata [" + id + "] non migrata. Motivazione: " + checkPortaDelegata);
                    continue;
                }
                AccordoServizioParteSpecifica asps = this.driverRegistro.getAccordoServizioParteSpecifica(idServizio);
                lstAspsCollezionati.add(asps);
            }
            List allIdPorteApplicative = new ArrayList();
            try {
                allIdPorteApplicative = this.driverConfigurazione.getAllIdPorteApplicative(new FiltroRicercaPorteApplicative());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            for (IDPortaApplicativaByNome id : allIdPorteApplicative) {
                AccordoServizioParteSpecifica asps;
                PortaApplicativa portaApplicativa = this.driverConfigurazione.getPortaApplicativa(id);
                String checkPortaApplicativa = this.checkPortaApplicativa(portaApplicativa);
                IDServizio idServizio = new IDServizio(new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario()), portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome());
                if (checkPortaApplicativa != null) {
                    this.log.warn("Porta applicativa [" + id + "] non migrata. Motivazione: " + checkPortaApplicativa);
                    Object idAccordoString = null;
                    try {
                        asps = this.driverRegistro.getAccordoServizioParteSpecifica(idServizio);
                        idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(asps);
                        idAccordoString = idAccordo.toString();
                    }
                    catch (Exception e) {
                        idAccordoString = "Impossibile trovare l'Accordo per la Porta Applicativa [" + id + "]";
                    }
                    lstIdDaScartare.put((String)idAccordoString, "Porta applicativa [" + id + "] non migrata. Motivazione: " + checkPortaApplicativa);
                    continue;
                }
                PortaApplicativaWrapper wrapper = new PortaApplicativaWrapper();
                wrapper.setPortaApplicativa(portaApplicativa);
                asps = this.driverRegistro.getAccordoServizioParteSpecifica(idServizio);
                lstAspsCollezionati.add(asps);
            }
            for (AccordoServizioParteSpecifica asps : lstAspsCollezionati) {
                AccordoServizioParteComune aspc = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(asps.getIdAccordo().longValue(), true);
                String idAccordo2 = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(aspc).toString();
                String check = this.checkASPS(aspc, asps, false);
                if (check != null) {
                    lstIdDaScartare.put(idAccordo2, check);
                    continue;
                }
                lstIdDaScartare.remove(idAccordo2);
                aspc.setNome(this.getNomeAspc(aspc));
                ApiWrapper wrap = new ApiWrapper();
                wrap.setAspc(aspc);
                wrap.setKey(idAccordo2);
                lst.add(wrap);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return this.converter.toApiList(lst, lstIdDaScartare);
    }

    private String getNomeAspc(AccordoServizioParteComune aspc) {
        if (this.existAccordoStessoNomeDiversoReferente(aspc, this.lstAspc)) {
            return aspc.getNome() + "-" + aspc.getSoggettoReferente().getNome();
        }
        return aspc.getNome();
    }

    private boolean existAccordoStessoNomeDiversoReferente(AccordoServizioParteComune aspc, List<AccordoServizioParteComune> lst) {
        for (AccordoServizioParteComune as : lst) {
            if (as.getId() == aspc.getId() || !as.getNome().equals(aspc.getNome()) || as.getSoggettoReferente().equals((Object)aspc.getSoggettoReferente())) continue;
            List<String> fieldsNotCheck = Arrays.asList("id", "soggettoReferente");
            return as.equals((Object)aspc, fieldsNotCheck);
        }
        return false;
    }

    private String checkASPS(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, boolean checkPortType) {
        if (!asps.getNome().equals(asps.getServizio().getNome())) {
            return "Nome dell'accordo parte specifica [" + asps.getNome() + "] diverso dal nome del servizio [" + asps.getServizio().getNome() + "]";
        }
        String nomePT = asps.getPortType();
        if (nomePT == null) {
            return "Nome del portType nullo";
        }
        if (checkPortType && aspc.getPortTypeList().isEmpty()) {
            return "Accordo [" + aspc.getNome() + "] non possiede port type";
        }
        boolean found = false;
        for (PortType pt : aspc.getPortTypeList()) {
            if (!pt.getNome().equals(nomePT)) continue;
            found = true;
            if (pt.getProfiloCollaborazione().equals(ProfiloCollaborazione.ASINCRONO_ASIMMETRICO) || pt.getProfiloCollaborazione().equals(ProfiloCollaborazione.ASINCRONO_SIMMETRICO)) {
                return "Port type [" + nomePT + "] possiede un profilo [" + pt.getProfiloCollaborazione() + "]";
            }
            try {
                if (!this.getEnv().soggettiHelper.checkNCName(pt.getNome(), "Port-type [" + pt.getNome() + "]")) {
                    return this.getEnv().soggettiHelper.getPd().getMessage();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Operation azione : pt.getAzioneList()) {
                if (azione.getProfiloCollaborazione().equals(ProfiloCollaborazione.ASINCRONO_ASIMMETRICO) || azione.getProfiloCollaborazione().equals(ProfiloCollaborazione.ASINCRONO_SIMMETRICO)) {
                    return "Azione [" + azione.getNome() + "] possiede un profilo [" + azione.getProfiloCollaborazione() + "]";
                }
                try {
                    if (this.getEnv().soggettiHelper.checkNCName(azione.getNome(), "Azione [" + azione.getNome() + "]")) continue;
                    return this.getEnv().soggettiHelper.getPd().getMessage();
                }
                catch (Exception exception) {
                }
            }
        }
        if (checkPortType && !found) {
            return "Accordo [" + aspc.getNome() + "] non possiede port type [" + nomePT + "] corrispondente";
        }
        try {
            if (!this.getEnv().soggettiHelper.checkNCName(aspc.getNome(), "API")) {
                return this.getEnv().soggettiHelper.getPd().getMessage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aspc.getWsdlLogicoFruitore() != null) {
            return "Wsdl logico fruitore presente";
        }
        if (!this.isSoggettoMigrabile(aspc.getSoggettoReferente().getTipo())) {
            return "Soggetto referente di tipo [" + aspc.getSoggettoReferente().getTipo() + "] non migrabile";
        }
        return null;
    }

    private String checkPortaDelegata(PortaDelegata portaDelegata) throws it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverConfigurazioneException {
        if (portaDelegata.getSoggettoErogatore().getIdentificazione() == null || !portaDelegata.getSoggettoErogatore().getIdentificazione().equals(PortaDelegataSoggettoErogatoreIdentificazione.STATIC)) {
            return "Valore mode_soggetto_erogatore [" + portaDelegata.getSoggettoErogatore().getIdentificazione() + "]";
        }
        if (portaDelegata.getServizio().getIdentificazione() == null || !portaDelegata.getServizio().getIdentificazione().equals(PortaDelegataServizioIdentificazione.STATIC)) {
            return "Valore mode_servizio [" + portaDelegata.getServizio().getIdentificazione() + "]";
        }
        if (portaDelegata.getLocalForward() != null && !portaDelegata.getLocalForward().equals(StatoFunzionalita.DISABILITATO)) {
            return "Valore local_forward [" + portaDelegata.getLocalForward() + "]";
        }
        if (this.driverAvanzato.getDominio(portaDelegata.getIdSoggetto().longValue()).equals((Object)DominioEnum.ESTERNO)) {
            return "Soggetto fruitore esterno";
        }
        if (!this.isSoggettoMigrabile(portaDelegata.getTipoSoggettoProprietario())) {
            return "Soggetto proprietario di tipo [" + portaDelegata.getTipoSoggettoProprietario() + "] non migrabile";
        }
        if (!this.isSoggettoMigrabile(portaDelegata.getSoggettoErogatore().getTipo())) {
            return "Soggetto erogatore di tipo [" + portaDelegata.getSoggettoErogatore().getTipo() + "] non migrabile";
        }
        IDServizio idServizio = new IDServizio(new IDSoggetto(portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome()), portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome());
        AccordoServizioParteSpecifica asps = this.driverRegistro.getAccordoServizioParteSpecifica(idServizio);
        AccordoServizioParteComune aspc = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(asps.getIdAccordo().longValue());
        String checkASPS = this.checkASPS(aspc, asps, true);
        if (checkASPS != null) {
            return "Accordo di servizio [" + asps.getNome() + "] non migrato. Motivo: " + checkASPS;
        }
        return null;
    }

    private String checkPortaApplicativa(PortaApplicativa portaApplicativa) throws it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverConfigurazioneException {
        if (portaApplicativa.getSoggettoVirtuale() != null && (portaApplicativa.getSoggettoVirtuale().getId() != null || portaApplicativa.getSoggettoVirtuale().getNome() != null || portaApplicativa.getSoggettoVirtuale().getTipo() != null)) {
            return "Valore soggetto virtuale[" + portaApplicativa.getSoggettoVirtuale().toString().replaceAll("\n", "") + "]";
        }
        if (portaApplicativa.getServizioApplicativoList().size() > 1) {
            return "Numero Servizi Applicativi non consentito. Trovato [" + portaApplicativa.getServizioApplicativoList().size() + "]";
        }
        if (this.driverAvanzato.getDominio(portaApplicativa.getIdSoggetto().longValue()).equals((Object)DominioEnum.ESTERNO)) {
            return "Soggetto erogatore esterno";
        }
        if (!this.isSoggettoMigrabile(portaApplicativa.getTipoSoggettoProprietario())) {
            return "Soggetto proprietario di tipo [" + portaApplicativa.getTipoSoggettoProprietario() + "] non migrabile";
        }
        IDServizio idServizio = new IDServizio(new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario()), portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome());
        AccordoServizioParteSpecifica asps = this.driverRegistro.getAccordoServizioParteSpecifica(idServizio);
        AccordoServizioParteComune aspc = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(asps.getIdAccordo().longValue());
        String checkASPS = this.checkASPS(aspc, asps, true);
        if (checkASPS != null) {
            return "Accordo di servizio [" + asps.getNome() + "] non migrato. Motivo: " + checkASPS;
        }
        return null;
    }

    private boolean isSoggettoMigrabile(String tipo) {
        return !this.converter.getProfilo(tipo).equals((Object)ProfiloEnum.SPCOOP) || "SPC".equals(tipo);
    }

    public InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> findAllErogazioni(Map<String, String> idAccordoNonMigrati) throws Exception {
        List allIdPorteApplicative;
        FiltroRicercaPorteApplicative filtroRicerca2;
        HashMap<IDPortaApplicativaByNome, String> lstIdDaScartare = new HashMap<IDPortaApplicativaByNome, String>();
        ArrayList<PortaApplicativaWrapper> lst = new ArrayList<PortaApplicativaWrapper>();
        try {
            filtroRicerca2 = new FiltroRicercaPorteApplicative();
            filtroRicerca2.setTipoServizio("PROXY");
            allIdPorteApplicative = this.driverConfigurazione.getAllIdPorteApplicative(filtroRicerca2);
            for (IDPortaApplicativaByNome id : allIdPorteApplicative) {
                this.addPA(lstIdDaScartare, idAccordoNonMigrati, lst, id);
            }
        }
        catch (DriverConfigurazioneNotFound filtroRicerca2) {
            // empty catch block
        }
        try {
            filtroRicerca2 = new FiltroRicercaPorteApplicative();
            filtroRicerca2.setTipoServizio("SPC");
            allIdPorteApplicative = this.driverConfigurazione.getAllIdPorteApplicative(filtroRicerca2);
            for (IDPortaApplicativaByNome id : allIdPorteApplicative) {
                this.addPA(lstIdDaScartare, idAccordoNonMigrati, lst, id);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return this.converter.toErogazioniList(lst, lstIdDaScartare);
    }

    private void addPA(Map<IDPortaApplicativaByNome, String> lstIdDaScartare, Map<String, String> idAccordoNonMigrati, List<PortaApplicativaWrapper> lst, IDPortaApplicativaByNome id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound, it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        PortaApplicativa portaApplicativa = this.driverConfigurazione.getPortaApplicativa(id);
        String checkPortaApplicativa = this.checkPortaApplicativa(portaApplicativa);
        if (checkPortaApplicativa != null) {
            this.log.warn("Porta applicativa [" + id + "] non migrata. Motivazione: " + checkPortaApplicativa);
            lstIdDaScartare.put(id, checkPortaApplicativa);
        } else {
            if (portaApplicativa.getServizioApplicativoList().size() > 0) {
                portaApplicativa.getServizioApplicativoList().set(0, ((DriverConfigurazioneDB)this.driverConfigurazione).getServizioApplicativo(portaApplicativa.getServizioApplicativo(0).getId().longValue()));
            }
            PortaApplicativaWrapper wrapper = new PortaApplicativaWrapper();
            wrapper.setPortaApplicativa(portaApplicativa);
            IDServizio idServizio = new IDServizio(new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario()), portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome());
            AccordoServizioParteSpecifica asps = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteSpecifica(idServizio, true);
            wrapper.setIdServizio(IDServizioFactory.getInstance().getIDServizioFromValues(idServizio.getTipoServizio(), idServizio.getServizio(), idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getVersioneServizioAsInt()));
            AccordoServizioParteComune aspc = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(asps.getIdAccordo().longValue());
            String kacc = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(asps).toString();
            if (idAccordoNonMigrati.containsKey(kacc)) {
                this.log.warn("Porta applicativa [" + id + "] non migrata in quanto l'accordo corrispondente non e' stato migrato. Motivazione: " + idAccordoNonMigrati.get(kacc));
                lstIdDaScartare.put(id, "Accordo corrispondente non migrato. Motivazione: " + idAccordoNonMigrati.get(kacc));
            } else {
                wrapper.setNomeASPC(this.getNomeAspc(aspc));
                wrapper.setNomeSoggettoReferente(aspc.getSoggettoReferente().getNome());
                ArrayList<Long> lstIdSoggettiFruitore = new ArrayList<Long>();
                ArrayList<String> lstNomiSoggettiFruitore = new ArrayList<String>();
                ArrayList<String> lstNomiSoggettiFruitoreNonMigrabili = new ArrayList<String>();
                for (Fruitore fruit : asps.getFruitoreList()) {
                    if (this.isSoggettoMigrabile(fruit.getTipo())) {
                        lstIdSoggettiFruitore.add(fruit.getId());
                        lstNomiSoggettiFruitore.add(fruit.getNome());
                        continue;
                    }
                    lstNomiSoggettiFruitoreNonMigrabili.add(fruit.getTipo() + "/" + fruit.getNome());
                }
                wrapper.setTipoMultitenant(this.getTipoMultitenant(portaApplicativa.getIdSoggetto(), lstIdSoggettiFruitore).toString());
                wrapper.setFruitori(lstNomiSoggettiFruitore);
                wrapper.setFruitoriNonMigrabili(lstNomiSoggettiFruitoreNonMigrabili);
                wrapper.setKey(id);
                wrapper.setPortType(asps.getPortType());
                wrapper.setAsps(asps);
                lst.add(wrapper);
            }
        }
    }

    public InputWrapper<IDPortaDelegata, FruizioneWrapper> findAllFruizioni(Map<String, String> idAccordoNonMigrati) throws Exception {
        List allIdPorteDelegate;
        FiltroRicercaPorteDelegate filtroRicerca2;
        HashMap<IDPortaDelegata, String> lstIdDaScartare = new HashMap<IDPortaDelegata, String>();
        ArrayList<PortaDelegataWrapper> lst = new ArrayList<PortaDelegataWrapper>();
        try {
            filtroRicerca2 = new FiltroRicercaPorteDelegate();
            filtroRicerca2.setTipoServizio("PROXY");
            allIdPorteDelegate = this.driverConfigurazione.getAllIdPorteDelegate(filtroRicerca2);
            for (IDPortaDelegata id : allIdPorteDelegate) {
                this.addPd(id, lst, lstIdDaScartare, idAccordoNonMigrati);
            }
        }
        catch (DriverConfigurazioneNotFound filtroRicerca2) {
            // empty catch block
        }
        try {
            filtroRicerca2 = new FiltroRicercaPorteDelegate();
            filtroRicerca2.setTipoServizio("SPC");
            allIdPorteDelegate = this.driverConfigurazione.getAllIdPorteDelegate(filtroRicerca2);
            for (IDPortaDelegata id : allIdPorteDelegate) {
                this.addPd(id, lst, lstIdDaScartare, idAccordoNonMigrati);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return this.converter.toFruizioniList(lst, lstIdDaScartare);
    }

    private void addPd(IDPortaDelegata id, List<PortaDelegataWrapper> lst, Map<IDPortaDelegata, String> lstIdDaScartare, Map<String, String> idAccordoNonMigrati) throws DriverConfigurazioneException, DriverConfigurazioneNotFound, it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        PortaDelegata portaDelegata = this.driverConfigurazione.getPortaDelegata(id);
        String checkPortaDelegata = this.checkPortaDelegata(portaDelegata);
        if (checkPortaDelegata != null) {
            this.log.warn("Porta Delegata [" + id + "] non migrata. Motivazione: " + checkPortaDelegata);
            lstIdDaScartare.put(id, checkPortaDelegata);
        } else {
            IDServizio idServizio = new IDServizio(new IDSoggetto(portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome()), portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome());
            AccordoServizioParteSpecifica asps = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteSpecifica(idServizio, true);
            Connettore conn = null;
            for (Fruitore fruitore : asps.getFruitoreList()) {
                if (fruitore.getIdSoggetto() != portaDelegata.getIdSoggetto() || fruitore.getConnettore() == null || fruitore.getConnettore().getTipo().equals(TipiConnettore.DISABILITATO.toString())) continue;
                conn = fruitore.getConnettore();
            }
            if (conn == null && asps.getServizio().getConnettore() != null && !asps.getServizio().getConnettore().getTipo().equals(TipiConnettore.DISABILITATO.toString())) {
                conn = asps.getServizio().getConnettore();
            }
            if (conn == null) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto = this.driverRegistro.getSoggetto(new IDSoggetto(asps.getServizio().getTipoSoggettoErogatore(), asps.getServizio().getNomeSoggettoErogatore()));
                conn = soggetto.getConnettore();
            }
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoErogatore = ((DriverRegistroServiziDB)this.driverRegistro).getSoggetto(asps.getIdSoggetto().longValue());
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoFruitore = ((DriverRegistroServiziDB)this.driverRegistro).getSoggetto(portaDelegata.getIdSoggetto().longValue());
            PortaDelegataWrapper pdWrapper = new PortaDelegataWrapper();
            if (portaDelegata.getServizioApplicativoList().size() > 0) {
                ArrayList<String> serviziApplicativiAutorizzati = new ArrayList<String>();
                for (ServizioApplicativo sa : portaDelegata.getServizioApplicativoList()) {
                    serviziApplicativiAutorizzati.add(sa.getNome());
                }
                pdWrapper.setServiziApplicativiAutorizzati(serviziApplicativiAutorizzati);
            }
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComune aspc = this.driverRegistro.getAccordoServizioParteComune(idAccordo);
            String kacc = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(asps).toString();
            if (idAccordoNonMigrati.containsKey(kacc)) {
                this.log.warn("Porta delegata [" + id + "] non migrata in quanto l'accordo corrispondente non e' stato migrato. Motivazione: " + idAccordoNonMigrati.get(kacc));
                lstIdDaScartare.put(id, "Accordo corrispondente non migrato. Motivazione: " + idAccordoNonMigrati.get(kacc));
            } else {
                pdWrapper.setIdServizio(IDServizioFactory.getInstance().getIDServizioFromValues(asps.getServizio().getTipo(), asps.getServizio().getNome(), soggettoErogatore.getTipo(), soggettoErogatore.getNome(), 1));
                pdWrapper.setIdFruitore(new org.openspcoop2.core.id.IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getIdentificativoPorta()));
                pdWrapper.setConnettore(conn);
                pdWrapper.setNomeApi(this.getNomeAspc(aspc));
                pdWrapper.setPortaDelegata(portaDelegata);
                pdWrapper.setIdAccordo(idAccordo);
                pdWrapper.setTipoMultitenant(this.getTipoMultitenant(portaDelegata.getIdSoggetto(), asps.getIdSoggetto()).toString());
                pdWrapper.setKey(id);
                pdWrapper.setPortType(asps.getPortType());
                pdWrapper.setAsps(asps);
                lst.add(pdWrapper);
            }
        }
    }

    public InputWrapper<IDRuolo, Ruolo> findAllRuoli() throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo>();
        HashMap<IDRuolo, String> lstIdDaScartare = new HashMap<IDRuolo, String>();
        try {
            List allIdRuoli = this.driverRegistro.getAllIdRuoli(new FiltroRicercaRuoli());
            for (IDRuolo id : allIdRuoli) {
                if (!this.getEnv().soggettiHelper.checkNCName(id.getNome(), "ruolo")) {
                    lstIdDaScartare.put(id, this.getEnv().soggettiHelper.getPd().getMessage());
                    continue;
                }
                lst.add(this.driverRegistro.getRuolo(id));
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return this.converter.toRuoliList(lst, lstIdDaScartare);
    }

    public InputWrapper<IDServizioApplicativo, ApplicativoWrapper> findAllApplicativi() throws Exception {
        List allIdServiziApplicativi;
        FiltroRicercaServiziApplicativi filtroRicerca2;
        ArrayList<ServizioApplicativo> lst = new ArrayList<ServizioApplicativo>();
        HashMap<IDServizioApplicativo, String> lstIdDaScartare = new HashMap<IDServizioApplicativo, String>();
        try {
            filtroRicerca2 = new FiltroRicercaServiziApplicativi();
            filtroRicerca2.setTipoSoggetto("PROXY");
            allIdServiziApplicativi = this.driverConfigurazione.getAllIdServiziApplicativi(filtroRicerca2);
            for (IDServizioApplicativo id : allIdServiziApplicativi) {
                this.addSA(lst, lstIdDaScartare, id);
            }
        }
        catch (DriverConfigurazioneNotFound filtroRicerca2) {
            // empty catch block
        }
        try {
            filtroRicerca2 = new FiltroRicercaServiziApplicativi();
            filtroRicerca2.setTipoSoggetto("SPC");
            allIdServiziApplicativi = this.driverConfigurazione.getAllIdServiziApplicativi(filtroRicerca2);
            for (IDServizioApplicativo id : allIdServiziApplicativi) {
                this.addSA(lst, lstIdDaScartare, id);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return this.converter.toApplicativiList(lst, lstIdDaScartare);
    }

    private void addSA(List<ServizioApplicativo> lst, Map<IDServizioApplicativo, String> lstIdDaScartare, IDServizioApplicativo id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound, Exception {
        ServizioApplicativo servizioApplicativo = this.driverConfigurazione.getServizioApplicativo(id);
        if (servizioApplicativo.getInvocazionePorta() == null || servizioApplicativo.getInvocazionePorta().getCredenzialiList() == null || servizioApplicativo.getInvocazionePorta().getCredenzialiList().isEmpty()) {
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "] non migrato perche' non possiede credenziali");
        } else if (this.driverAvanzato.getDominio(servizioApplicativo.getIdSoggetto().longValue()).equals((Object)DominioEnum.ESTERNO)) {
            lstIdDaScartare.put(id, "Soggetto proprietario [" + servizioApplicativo.getTipoSoggettoProprietario() + "/" + servizioApplicativo.getNomeSoggettoProprietario() + "] di tipo ESTERNO");
        } else if (!this.isSoggettoMigrabile(servizioApplicativo.getTipoSoggettoProprietario())) {
            lstIdDaScartare.put(id, "Tipo soggetto proprietario [" + servizioApplicativo.getTipoSoggettoProprietario() + "] non migrabile");
        } else if (!this.getEnv().soggettiHelper.checkIntegrationEntityName(servizioApplicativo.getNome(), "servizioApplicativo")) {
            lstIdDaScartare.put(id, this.getEnv().soggettiHelper.getPd().getMessage());
        } else {
            lst.add(servizioApplicativo);
        }
    }

    private MultitenantConfigurazione.TIPO_MULTITENANT getTipoMultitenant(Long idSoggettoPrimario, List<Long> idSoggettiSecondari) throws DriverConfigurazioneException {
        for (Long idSoggettoSecondario : idSoggettiSecondari) {
            MultitenantConfigurazione.TIPO_MULTITENANT tipo = this.getTipoMultitenant(idSoggettoPrimario, idSoggettoSecondario);
            if (tipo.equals((Object)MultitenantConfigurazione.TIPO_MULTITENANT.TUTTI)) {
                return MultitenantConfigurazione.TIPO_MULTITENANT.TUTTI;
            }
            if (!tipo.equals((Object)MultitenantConfigurazione.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE)) continue;
            return MultitenantConfigurazione.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE;
        }
        return MultitenantConfigurazione.TIPO_MULTITENANT.ESTERNI;
    }

    private MultitenantConfigurazione.TIPO_MULTITENANT getTipoMultitenant(Long idSoggettoPrimario, Long idSoggettoSecondario) throws DriverConfigurazioneException {
        if (idSoggettoSecondario == idSoggettoPrimario) {
            return MultitenantConfigurazione.TIPO_MULTITENANT.TUTTI;
        }
        if (this.driverAvanzato.getDominio(idSoggettoSecondario.longValue()).equals((Object)DominioEnum.INTERNO)) {
            return MultitenantConfigurazione.TIPO_MULTITENANT.ESCLUDI_FRUITORE_EROGATORE;
        }
        return MultitenantConfigurazione.TIPO_MULTITENANT.ESTERNI;
    }
}

