/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v2_3.govway.reader;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaRisposta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaRispostaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Credenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneContenutiApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CorrelazioneApplicativaGestioneIdentificazioneFallita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataAzioneIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataServizioIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataSoggettoErogatoreIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalitaConWarning;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.TipoAutorizzazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.ValidazioneContenutiApplicativiTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.CredenzialiSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RuoloSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.ApiWrapper;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.PortaApplicativaWrapper;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.PortaDelegataWrapper;
import it.link.pdd.tools.migrazione_govway.v2_3.govway.wrapper.SoggettoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.AbstractFruizioneErogazioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ApplicativoWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.ErogazioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.FruizioneWrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.govway.InputWrapper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneBasic;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneDisabilitata;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneHttps;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneAbilitataNew;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneDisabilitata;
import org.openspcoop2.core.config.rs.server.model.AllAnyEnum;
import org.openspcoop2.core.config.rs.server.model.Api;
import org.openspcoop2.core.config.rs.server.model.ApiAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiAllegatoGenerico;
import org.openspcoop2.core.config.rs.server.model.ApiAllegatoSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiAzione;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoGenerico;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaLivelloServizio;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSicurezza;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazione;
import org.openspcoop2.core.config.rs.server.model.ApiInterfacciaSoap;
import org.openspcoop2.core.config.rs.server.model.ApiServizio;
import org.openspcoop2.core.config.rs.server.model.Applicativo;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpBasic;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttps;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttpsConfigurazioneManuale;
import org.openspcoop2.core.config.rs.server.model.AuthenticationPrincipal;
import org.openspcoop2.core.config.rs.server.model.BaseConnettoreHttp;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpBasic;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttps;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsClient;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsServer;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneProxy;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreHttp;
import org.openspcoop2.core.config.rs.server.model.ContestoEnum;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneApplicativo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneSoggetto;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiestaEnum;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRispostaEnum;
import org.openspcoop2.core.config.rs.server.model.Erogazione;
import org.openspcoop2.core.config.rs.server.model.FonteEnum;
import org.openspcoop2.core.config.rs.server.model.FormatoSoapEnum;
import org.openspcoop2.core.config.rs.server.model.Fruizione;
import org.openspcoop2.core.config.rs.server.model.KeystoreEnum;
import org.openspcoop2.core.config.rs.server.model.ModalitaAccessoEnum;
import org.openspcoop2.core.config.rs.server.model.ModalitaIdentificazioneAzioneEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutenticazione;
import org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.OneOfApiAllegatoAllegato;
import org.openspcoop2.core.config.rs.server.model.OneOfApiBaseTipoInterfaccia;
import org.openspcoop2.core.config.rs.server.model.OneOfApiImplAllegatoAllegato;
import org.openspcoop2.core.config.rs.server.model.OneOfAuthenticationHttpsCertificato;
import org.openspcoop2.core.config.rs.server.model.OneOfBaseCredenzialiCredenziali;
import org.openspcoop2.core.config.rs.server.model.Ruolo;
import org.openspcoop2.core.config.rs.server.model.RuoloAllegatoAPI;
import org.openspcoop2.core.config.rs.server.model.RuoloAllegatoAPIImpl;
import org.openspcoop2.core.config.rs.server.model.Soggetto;
import org.openspcoop2.core.config.rs.server.model.SslTipologiaEnum;
import org.openspcoop2.core.config.rs.server.model.StatoFunzionalitaConWarningEnum;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneHttps;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.model.TipoAutorizzazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaLivelloServizioEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaSemiformaleEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaSicurezzaEnum;
import org.openspcoop2.core.config.rs.server.model.TipoValidazioneEnum;
import org.openspcoop2.core.config.rs.server.model.Validazione;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.service.beans.ProfiloCollaborazioneEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

public class ConfigurazioneServiziConverter {
    private static ConfigurazioneServiziConverter instance;
    private MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI tipo = MigrazioneProperties.getInstance().getTipoMigrazioneServizi();
    private String nomeSoggettoReferenteDefault = MigrazioneProperties.getInstance().getNomeSoggettoReferenteDefault();
    private Map<String, String> soggettiDefault;

    public static ConfigurazioneServiziConverter getInstance(Map<String, String> soggettiDefault) throws Exception {
        if (instance == null) {
            instance = new ConfigurazioneServiziConverter(soggettiDefault);
        }
        return instance;
    }

    public ConfigurazioneServiziConverter(Map<String, String> soggettiDefault) throws Exception {
        this.soggettiDefault = soggettiDefault;
    }

    public InputWrapper<IDRuolo, Ruolo> toRuoliList(List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo> lst, Map<IDRuolo, String> idNonMigrati) {
        ArrayList<Ruolo> lstOut = new ArrayList<Ruolo>();
        InputWrapper iw = new InputWrapper();
        for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo ruolo : lst) {
            lstOut.add(this.toRuolo(ruolo));
        }
        iw.setElementiNonMigrati(idNonMigrati);
        iw.setElementi(lstOut);
        return iw;
    }

    private Ruolo toRuolo(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo ruoloInput) {
        Ruolo ruolo = new Ruolo();
        ContestoEnum contesto = null;
        switch (ruoloInput.getContestoUtilizzo()) {
            case PORTA_APPLICATIVA: {
                contesto = ContestoEnum.EROGAZIONE;
                break;
            }
            case PORTA_DELEGATA: {
                contesto = ContestoEnum.FRUIZIONE;
                break;
            }
            case QUALSIASI: {
                contesto = ContestoEnum.QUALSIASI;
            }
        }
        ruolo.setContesto(contesto);
        ruolo.setDescrizione(ruoloInput.getDescrizione());
        FonteEnum fonte = null;
        switch (ruoloInput.getTipologia()) {
            case ESTERNO: {
                fonte = FonteEnum.ESTERNA;
                break;
            }
            case INTERNO: {
                fonte = FonteEnum.REGISTRO;
                break;
            }
            case QUALSIASI: {
                fonte = FonteEnum.QUALSIASI;
            }
        }
        ruolo.setFonte(fonte);
        ruolo.setIdentificativoEsterno(ruoloInput.getNomeEsterno());
        ruolo.setNome(ruoloInput.getNome());
        return ruolo;
    }

    public InputWrapper<IDSoggetto, it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper> toSoggettiList(List<SoggettoWrapper> lst, Map<IDSoggetto, String> idSoggettiNonMigrati) throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper> lstOut = new ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper>();
        InputWrapper iw = new InputWrapper();
        for (SoggettoWrapper soggetto : lst) {
            lstOut.addAll(this.toSoggettiList(soggetto));
        }
        HashMap<CallSite, it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper> mapFiltrata = new HashMap<CallSite, it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper>();
        for (it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper wrap : lstOut) {
            String k = wrap.getProfilo() + wrap.getSoggetto().getNome();
            if (!mapFiltrata.containsKey(k)) {
                mapFiltrata.put((CallSite)((Object)k), wrap);
                continue;
            }
            if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW)) {
                iw.addWarning((Object)wrap, "Conversione (in profilo API Gateway) non necessaria esistendo sulla base dati sorgente un soggetto con stesso nome e tipo PROXY.");
                continue;
            }
            idSoggettiNonMigrati.put((IDSoggetto)wrap.getKey(), "Conversione (in profilo API Gateway) non necessaria esistendo sulla base dati sorgente un soggetto con stesso nome e tipo PROXY.");
        }
        iw.setElementiNonMigrati(idSoggettiNonMigrati);
        iw.setElementi(Arrays.asList(mapFiltrata.values().toArray(new it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper[0])));
        return iw;
    }

    private List<it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper> toSoggettiList(SoggettoWrapper soggetto) throws ProtocolException {
        ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper>();
        List<String> tipi = this.getTipi(soggetto.getSoggetto().getTipo());
        for (String tipo : tipi) {
            lst.add(this.toSoggetto(soggetto, tipo));
        }
        return lst;
    }

    private boolean isSpc2Gw(String tipo, String tipoOriginale) {
        return this.tipo.equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW) && !tipo.equals(tipoOriginale);
    }

    private it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper toSoggetto(SoggettoWrapper wrapperIn, String tipo) throws ProtocolException {
        it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper wrapper = new it.link.pdd.tools.migrazione_govway.wrapper.govway.SoggettoWrapper();
        wrapper.setKey((Object)wrapperIn.getKey());
        Soggetto sogg = new Soggetto();
        if (wrapperIn.getSoggetto().getNome().equals(this.nomeSoggettoReferenteDefault)) {
            sogg.setNome(this.soggettiDefault.get(this.getTipoSoggetto(tipo)));
        } else {
            sogg.setNome(wrapperIn.getSoggetto().getNome());
        }
        sogg.setDescrizione(wrapperIn.getSoggetto().getDescrizione());
        sogg.setDominio(wrapperIn.getDominio());
        wrapper.setCambioTipo(!wrapperIn.getSoggetto().getTipo().equals(tipo));
        wrapper.setProfilo(this.getProfilo(tipo));
        if (wrapperIn.getSoggettoReg().getRuoli() != null && wrapperIn.getSoggettoReg().getRuoli().getRuoloList() != null && !wrapperIn.getSoggettoReg().getRuoli().getRuoloList().isEmpty()) {
            ArrayList<String> ruoli = new ArrayList<String>();
            for (RuoloSoggetto ruolo : wrapperIn.getSoggettoReg().getRuoli().getRuoloList()) {
                ruoli.add(ruolo.getNome());
            }
            sogg.setRuoli(ruoli);
        }
        if (wrapperIn.getSoggettoReg().getCredenziali() != null) {
            sogg.setCredenziali(this.getCredenziali(wrapperIn.getSoggettoReg().getCredenziali(), this.isSpc2Gw(tipo, wrapperIn.getSoggetto().getTipo())));
            if (CredenzialeTipo.BASIC.equals(wrapperIn.getSoggettoReg().getCredenziali().getTipo())) {
                ((AuthenticationHttpBasic)sogg.getCredenziali()).setModalitaAccesso(ModalitaAccessoEnum.HTTP_BASIC);
            } else if (CredenzialeTipo.SSL.equals(wrapperIn.getSoggettoReg().getCredenziali().getTipo())) {
                ((AuthenticationHttps)sogg.getCredenziali()).setModalitaAccesso(ModalitaAccessoEnum.HTTPS);
            } else if (CredenzialeTipo.PRINCIPAL.equals(wrapperIn.getSoggettoReg().getCredenziali().getTipo())) {
                ((AuthenticationPrincipal)sogg.getCredenziali()).setModalitaAccesso(ModalitaAccessoEnum.PRINCIPAL);
            }
        }
        wrapper.setSoggetto(sogg);
        return wrapper;
    }

    private OneOfBaseCredenzialiCredenziali getCredenziali(CredenzialiSoggetto credenzialiIn, boolean addPrefix) {
        if (CredenzialeTipo.BASIC.equals(credenzialiIn.getTipo())) {
            AuthenticationHttpBasic credenziali = new AuthenticationHttpBasic();
            credenziali.setUsername((addPrefix ? "api_" : "") + credenzialiIn.getUser());
            credenziali.setPassword(credenzialiIn.getPassword());
            return credenziali;
        }
        if (CredenzialeTipo.SSL.equals(credenzialiIn.getTipo())) {
            AuthenticationHttps credenziali = new AuthenticationHttps();
            AuthenticationHttpsConfigurazioneManuale authenticationHttpsConfigurazioneManuale = new AuthenticationHttpsConfigurazioneManuale();
            authenticationHttpsConfigurazioneManuale.setSubject(credenzialiIn.getSubject() + (addPrefix ? "profilo=api/" : ""));
            authenticationHttpsConfigurazioneManuale.setTipo(TipoAutenticazioneHttps.CONFIGURAZIONE_MANUALE);
            credenziali.setCertificato((OneOfAuthenticationHttpsCertificato)authenticationHttpsConfigurazioneManuale);
            return credenziali;
        }
        if (CredenzialeTipo.PRINCIPAL.equals(credenzialiIn.getTipo())) {
            AuthenticationPrincipal credenziali = new AuthenticationPrincipal();
            credenziali.setUserid((addPrefix ? "api_" : "") + credenzialiIn.getUser());
            return credenziali;
        }
        return null;
    }

    private OneOfBaseCredenzialiCredenziali getCredenziali(Credenziali credenzialiIn, boolean addPrefix) {
        if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo.BASIC.equals(credenzialiIn.getTipo())) {
            AuthenticationHttpBasic credenziali = new AuthenticationHttpBasic();
            credenziali.setUsername((addPrefix ? "api_" : "") + credenzialiIn.getUser());
            credenziali.setPassword(credenzialiIn.getPassword());
            return credenziali;
        }
        if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo.SSL.equals(credenzialiIn.getTipo())) {
            AuthenticationHttps credenziali = new AuthenticationHttps();
            AuthenticationHttpsConfigurazioneManuale authenticationHttpsConfigurazioneManuale = new AuthenticationHttpsConfigurazioneManuale();
            authenticationHttpsConfigurazioneManuale.setSubject(credenzialiIn.getSubject() + (addPrefix ? "profilo=api/" : ""));
            authenticationHttpsConfigurazioneManuale.setTipo(TipoAutenticazioneHttps.CONFIGURAZIONE_MANUALE);
            credenziali.setCertificato((OneOfAuthenticationHttpsCertificato)authenticationHttpsConfigurazioneManuale);
            return credenziali;
        }
        if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo.PRINCIPAL.equals(credenzialiIn.getTipo())) {
            AuthenticationPrincipal credenziali = new AuthenticationPrincipal();
            credenziali.setUserid((addPrefix ? "api_" : "") + credenzialiIn.getUser());
            return credenziali;
        }
        return null;
    }

    public InputWrapper<String, it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper> toApiList(List<ApiWrapper> lst, Map<String, String> lstIdDaScartare) throws ProtocolException {
        ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper> lstOut = new ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper>();
        InputWrapper iw = new InputWrapper();
        for (ApiWrapper wrap : lst) {
            lstOut.addAll(this.toApiList(wrap));
        }
        HashMap<CallSite, it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper> mapFiltrata = new HashMap<CallSite, it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper>();
        for (it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper wrap : lstOut) {
            String k = wrap.getProfilo() + wrap.getApi().getNome() + wrap.getApi().getVersione() + wrap.getApi().getReferente();
            if (!mapFiltrata.containsKey(k)) {
                mapFiltrata.put((CallSite)((Object)k), wrap);
                continue;
            }
            boolean incompatibile = false;
            it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper apiWrapperOriginal = (it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper)mapFiltrata.get(k);
            for (ApiServizio serv : wrap.getServizi()) {
                if (incompatibile) break;
                boolean foundS = false;
                for (ApiServizio servOr : apiWrapperOriginal.getServizi()) {
                    if (!servOr.getNome().equals(serv.getNome())) continue;
                    foundS = true;
                }
                if (foundS) continue;
                incompatibile = true;
            }
            if (!incompatibile) {
                for (ApiAzione az : wrap.getAzioni().keySet()) {
                    if (incompatibile) break;
                    boolean foundA = false;
                    for (ApiAzione azOrig : apiWrapperOriginal.getAzioni().keySet()) {
                        if (!azOrig.getNome().equals(az.getNome())) continue;
                        foundA = true;
                    }
                    if (foundA) continue;
                    incompatibile = true;
                }
            }
            if (!incompatibile) continue;
            lstIdDaScartare.put(((String)wrap.getKey()).toString(), "API PROXY gia migrato con differenti set di servizi/azioni");
            iw.removeAllWarnings((Object)wrap);
        }
        iw.setElementiNonMigrati(lstIdDaScartare);
        iw.setElementi(Arrays.asList(mapFiltrata.values().toArray(new it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper[0])));
        return iw;
    }

    private List<it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper> toApiList(ApiWrapper wrap) throws ProtocolException {
        ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper>();
        List<String> tipi = this.getTipi(wrap.getAspc().getSoggettoReferente().getTipo());
        for (String tipo : tipi) {
            lst.add(this.toApi(wrap, tipo));
        }
        return lst;
    }

    private it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper toApi(ApiWrapper wrap, String tipo) throws ProtocolException {
        it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper apiwrapper = new it.link.pdd.tools.migrazione_govway.wrapper.govway.ApiWrapper();
        apiwrapper.setCambioTipo(!wrap.getAspc().getSoggettoReferente().getTipo().equals(tipo));
        Api api = new Api();
        apiwrapper.setKey((Object)wrap.getKey());
        AccordoServizioParteComune aspc = wrap.getAspc();
        api.setDescrizione(aspc.getDescrizione());
        api.setNome(aspc.getNome());
        ApiInterfacciaSoap tipoInterfaccia = new ApiInterfacciaSoap();
        tipoInterfaccia.setProtocollo(TipoApiEnum.SOAP);
        tipoInterfaccia.setFormato(FormatoSoapEnum._1);
        api.setTipoInterfaccia((OneOfApiBaseTipoInterfaccia)tipoInterfaccia);
        api.setVersione(Integer.valueOf(1));
        if (aspc.getByteWsdlConcettuale() != null) {
            api.setInterfaccia(aspc.getByteWsdlConcettuale());
        } else if (aspc.getByteWsdlLogicoErogatore() != null) {
            api.setInterfaccia(aspc.getByteWsdlLogicoErogatore());
        } else if (aspc.getByteWsdlLogicoFruitore() != null) {
            api.setInterfaccia(aspc.getByteWsdlLogicoFruitore());
        }
        if (aspc.sizeAllegatoList() > 0) {
            ArrayList<ApiAllegato> lstAllegati = new ArrayList<ApiAllegato>();
            for (Documento allegato : aspc.getAllegatoList()) {
                ApiAllegato apiAllegato = new ApiAllegato();
                RuoloAllegatoAPI ruolo = (RuoloAllegatoAPI)Enums.ruoliApiFromDocumento.get(Enum.valueOf(RuoliDocumento.class, allegato.getRuolo()));
                switch (ruolo) {
                    case ALLEGATO: {
                        ApiAllegatoGenerico ag = new ApiAllegatoGenerico();
                        ag.setRuolo(ruolo);
                        ag.setDocumento(allegato.getByteContenuto());
                        ag.setNome(allegato.getFile());
                        apiAllegato.setAllegato((OneOfApiAllegatoAllegato)ag);
                        break;
                    }
                    case SPECIFICASEMIFORMALE: {
                        ApiAllegatoGenerico ag = new ApiAllegatoSpecificaSemiformale();
                        ag.setRuolo(ruolo);
                        ag.setDocumento(allegato.getByteContenuto());
                        ag.setNome(allegato.getFile());
                        TipiDocumentoSemiformale tipoD = Enum.valueOf(TipiDocumentoSemiformale.class, allegato.getTipo());
                        ag.setTipoSpecifica((TipoSpecificaSemiformaleEnum)Helper.apiEnumToGovway((Enum)tipoD, TipoSpecificaSemiformaleEnum.class));
                        apiAllegato.setAllegato((OneOfApiAllegatoAllegato)ag);
                        break;
                    }
                }
                lstAllegati.add(apiAllegato);
            }
            apiwrapper.setAllegati(lstAllegati);
        }
        ProfiloEnum profilo = this.getProfilo(tipo);
        api.setReferente(this.getNomeReferente(tipo, aspc.getSoggettoReferente().getNome()));
        apiwrapper.setApi(api);
        apiwrapper.setProfilo(profilo);
        ArrayList<ApiServizio> servizi = new ArrayList<ApiServizio>();
        HashMap<ApiAzione, String> azioni = new HashMap<ApiAzione, String>();
        if (aspc.getPortTypeList() != null) {
            for (PortType pt : aspc.getPortTypeList()) {
                ApiServizio apiservizio = new ApiServizio();
                apiservizio.setDescrizione(pt.getDescrizione());
                apiservizio.setNome(pt.getNome());
                ProfiloCollaborazioneEnum profiloCollaborazione = null;
                switch (pt.getProfiloCollaborazione()) {
                    case ASINCRONO_ASIMMETRICO: {
                        profiloCollaborazione = ProfiloCollaborazioneEnum.ASINCRONOASIMMETRICO;
                        break;
                    }
                    case ASINCRONO_SIMMETRICO: {
                        profiloCollaborazione = ProfiloCollaborazioneEnum.ASINCRONOSIMMETRICO;
                        break;
                    }
                    case ONEWAY: {
                        profiloCollaborazione = ProfiloCollaborazioneEnum.ONEWAY;
                        break;
                    }
                    case SINCRONO: {
                        profiloCollaborazione = ProfiloCollaborazioneEnum.SINCRONO;
                    }
                }
                apiservizio.setRiferimentoIdRichiesta(Boolean.valueOf(false));
                apiservizio.setProfiloCollaborazione(profiloCollaborazione);
                servizi.add(apiservizio);
                if (pt.getAzioneList() == null) continue;
                for (Operation azione : pt.getAzioneList()) {
                    ApiAzione azioneapi = new ApiAzione();
                    azioneapi.setNome(azione.getNome());
                    ProfiloCollaborazioneEnum profiloCollaborazioneAzione = null;
                    switch (azione.getProfiloCollaborazione()) {
                        case ASINCRONO_ASIMMETRICO: {
                            profiloCollaborazioneAzione = ProfiloCollaborazioneEnum.ASINCRONOASIMMETRICO;
                            break;
                        }
                        case ASINCRONO_SIMMETRICO: {
                            profiloCollaborazioneAzione = ProfiloCollaborazioneEnum.ASINCRONOSIMMETRICO;
                            break;
                        }
                        case ONEWAY: {
                            profiloCollaborazioneAzione = ProfiloCollaborazioneEnum.ONEWAY;
                            break;
                        }
                        case SINCRONO: {
                            profiloCollaborazioneAzione = ProfiloCollaborazioneEnum.SINCRONO;
                        }
                    }
                    azioneapi.setProfiloCollaborazione(profiloCollaborazioneAzione);
                    azioneapi.setRiferimentoIdRichiesta(Boolean.valueOf(false));
                    if (azione.getIdCollaborazione() != null) {
                        azioneapi.setIdCollaborazione(Boolean.valueOf(azione.getIdCollaborazione().equals(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.ABILITATO)));
                    }
                    azioni.put(azioneapi, pt.getNome());
                }
            }
        }
        apiwrapper.setServizi(servizi);
        apiwrapper.setAzioni(azioni);
        return apiwrapper;
    }

    private String getNomeReferente(String tipo, String nome) throws ProtocolException {
        ProfiloEnum profilo = this.getProfilo(tipo);
        String tipoSoggetto = this.getTipoSoggetto(tipo);
        String referenteDefault = this.soggettiDefault.get(tipoSoggetto);
        if (profilo.equals((Object)ProfiloEnum.SPCOOP)) {
            return nome.equals(this.nomeSoggettoReferenteDefault) ? referenteDefault : nome;
        }
        return referenteDefault;
    }

    public InputWrapper<IDPortaDelegata, FruizioneWrapper> toFruizioniList(List<PortaDelegataWrapper> lst, Map<IDPortaDelegata, String> lstIdDaScartare) throws Exception {
        ArrayList<FruizioneWrapper> lstOut = new ArrayList<FruizioneWrapper>();
        InputWrapper iw = new InputWrapper();
        Map<String, List<PortaDelegataWrapper>> map = this.getPDMap(lst);
        for (PortaDelegataWrapper portaDelegata : lst) {
            int conflictIndex = this.conflictIndex(portaDelegata, map);
            int index = this.index(portaDelegata, map);
            portaDelegata.setIndex(index);
            if (conflictIndex > 0) {
                lstIdDaScartare.put(portaDelegata.getKey(), "Presente un'altra porta delegata con stesso servizio, diversa azione ed entrambe con modalita identificazione diversa da STATIC");
                continue;
            }
            lstOut.addAll(this.toFruizioneList(portaDelegata, (InputWrapper<IDPortaDelegata, FruizioneWrapper>)iw, this.getPredefinita(portaDelegata, map)));
        }
        HashMap<CallSite, FruizioneWrapper> mapFiltrata = new HashMap<CallSite, FruizioneWrapper>();
        for (FruizioneWrapper wrap : lstOut) {
            String k = wrap.getProfilo() + wrap.getNomeSoggettoErogatore() + wrap.getFruizione().getFruizioneNome() + wrap.getFruizione().getApiVersione() + wrap.getNomeFruitore() + wrap.getGruppo();
            if (!mapFiltrata.containsKey(k)) {
                mapFiltrata.put((CallSite)((Object)k), wrap);
                continue;
            }
            if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW)) {
                iw.addWarning((Object)wrap, "Conversione (in profilo API Gateway) non necessaria esistendo sulla base dati sorgente una fruizione equivalente e di tipo PROXY.");
                continue;
            }
            lstIdDaScartare.put((IDPortaDelegata)wrap.getKey(), "Conversione (in profilo API Gateway) non necessaria esistendo sulla base dati sorgente una fruizione equivalente e di tipo PROXY.");
            iw.removeAllWarnings((Object)wrap);
        }
        iw.setElementiNonMigrati(lstIdDaScartare);
        iw.setElementi(Arrays.asList(mapFiltrata.values().toArray(new FruizioneWrapper[0])));
        return iw;
    }

    private int index(PortaDelegataWrapper portaDelegata, Map<String, List<PortaDelegataWrapper>> map) {
        return map.get(this.getPDKey(portaDelegata)).size();
    }

    private int conflictIndex(PortaDelegataWrapper portaDelegata, Map<String, List<PortaDelegataWrapper>> map) {
        if (portaDelegata.getPortaDelegata().getAzione() == null || portaDelegata.getPortaDelegata().getAzione().getIdentificazione().equals(PortaDelegataAzioneIdentificazione.STATIC)) {
            return 0;
        }
        List<PortaDelegataWrapper> list = map.get(this.getPDKey(portaDelegata));
        ArrayList<PortaDelegataWrapper> listNonStatic = new ArrayList<PortaDelegataWrapper>();
        if (list.size() == 1) {
            return 0;
        }
        for (PortaDelegataWrapper pd : list) {
            if (pd.getPortaDelegata().getAzione() == null || pd.getPortaDelegata().getAzione().getIdentificazione().equals(PortaDelegataAzioneIdentificazione.STATIC)) continue;
            listNonStatic.add(pd);
        }
        return listNonStatic.indexOf(portaDelegata);
    }

    private PortaDelegataWrapper getPredefinita(PortaDelegataWrapper portaDelegata, Map<String, List<PortaDelegataWrapper>> map) {
        List<PortaDelegataWrapper> list = map.get(this.getPDKey(portaDelegata));
        if (list.size() == 1) {
            return portaDelegata;
        }
        for (PortaDelegataWrapper pd : list) {
            if (pd.getPortaDelegata().getAzione() != null) continue;
            return pd;
        }
        return list.get(0);
    }

    private Map<String, List<PortaDelegataWrapper>> getPDMap(List<PortaDelegataWrapper> lst) {
        HashMap<String, List<PortaDelegataWrapper>> map = new HashMap<String, List<PortaDelegataWrapper>>();
        for (PortaDelegataWrapper pd : lst) {
            String key = this.getPDKey(pd);
            List lstPD = null;
            lstPD = map.containsKey(key) ? (List)map.get(key) : new ArrayList();
            lstPD.add(pd);
            map.put(key, lstPD);
        }
        return map;
    }

    private String getPDKey(PortaDelegataWrapper pd) {
        return String.join((CharSequence)"_", Arrays.asList(pd.getIdFruitore().getTipo(), pd.getIdFruitore().getNome(), pd.getIdServizio().getTipo(), pd.getIdServizio().getNome(), pd.getIdServizio().getSoggettoErogatore().getTipo(), pd.getIdServizio().getSoggettoErogatore().getNome()));
    }

    private List<FruizioneWrapper> toFruizioneList(PortaDelegataWrapper portaDelegataWrapper, InputWrapper<IDPortaDelegata, FruizioneWrapper> iw, PortaDelegataWrapper portaDelegataPredefinitaWrapper) throws ProtocolException {
        ArrayList<FruizioneWrapper> lst = new ArrayList<FruizioneWrapper>();
        List<String> tipi = this.getTipi(portaDelegataWrapper.getIdServizio().getTipo());
        for (String tipo : tipi) {
            lst.add(this.toFruizione(portaDelegataWrapper, iw, portaDelegataPredefinitaWrapper, tipo));
        }
        return lst;
    }

    private List<String> getTipi(String tipo) {
        ArrayList<String> lst = new ArrayList<String>();
        ProfiloEnum profilo = this.getProfilo(tipo);
        if (ProfiloEnum.APIGATEWAY.equals((Object)profilo)) {
            lst.add(tipo);
        } else {
            switch (this.tipo) {
                case SPC_E_GW: {
                    lst.add(tipo);
                    lst.add("PROXY");
                    break;
                }
                case GW: {
                    lst.add("PROXY");
                    break;
                }
                case SPC: {
                    lst.add(tipo);
                }
            }
        }
        return lst;
    }

    /*
     * WARNING - void declaration
     */
    private FruizioneWrapper toFruizione(PortaDelegataWrapper portaDelegataWrapper, InputWrapper<IDPortaDelegata, FruizioneWrapper> iw, PortaDelegataWrapper portaDelegataPredefinitaWrapper, String tipoServizio) throws ProtocolException {
        FruizioneWrapper w = new FruizioneWrapper();
        w.setKey((Object)portaDelegataWrapper.getKey());
        Fruizione fruizione = new Fruizione();
        fruizione.setApiNome(portaDelegataWrapper.getNomeApi());
        fruizione.setFruizioneNome(portaDelegataWrapper.getIdServizio().getNome());
        fruizione.setApiSoapServizio(portaDelegataWrapper.getPortType());
        fruizione.setApiVersione(Integer.valueOf(1));
        fruizione.setDescrizione(portaDelegataWrapper.getPortaDelegata().getDescrizione());
        ProfiloEnum profilo = this.getProfilo(tipoServizio);
        w.setCambioTipo(!tipoServizio.equals(portaDelegataWrapper.getIdServizio().getTipo()));
        fruizione.setApiReferente(this.getNomeReferente(tipoServizio, portaDelegataWrapper.getIdAccordo().getSoggettoReferente().getNome()));
        w.setProfilo(profilo);
        if (portaDelegataWrapper.getPortaDelegata().getAutenticazione() != null) {
            fruizione.setAutenticazione(this.getAutenticazione(portaDelegataWrapper.getPortaDelegata().getAutenticazione(), portaDelegataWrapper.getPortaDelegata().getAutenticazioneOpzionale()));
        }
        fruizione.setAutorizzazione(this.getAutorizzazione(portaDelegataWrapper.getPortaDelegata().getAutorizzazione(), false));
        if (portaDelegataWrapper.getConnettore() != null) {
            fruizione.setConnettore((BaseConnettoreHttp)this.toConnettore(portaDelegataWrapper.getConnettore()));
            w.setLocationConnettore(this.getConnettorePath(portaDelegataWrapper.getConnettore().getProperties()));
        } else {
            ConnettoreHttp conn = new ConnettoreHttp();
            fruizione.setConnettore((BaseConnettoreHttp)conn);
        }
        List<String> checkConnettore = this.checkConnettore(fruizione.getConnettore());
        if (checkConnettore != null) {
            for (String string : checkConnettore) {
                iw.addWarning((Object)w, string);
            }
        }
        w.setLocationWsSecurityRichiesta(this.getWsSecPath(portaDelegataWrapper.getPortaDelegata().getMessageSecurity(), true));
        w.setLocationWsSecurityRisposta(this.getWsSecPath(portaDelegataWrapper.getPortaDelegata().getMessageSecurity(), false));
        fruizione.setErogatore(portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getNome());
        fruizione.setTipoServizio(this.getTipoServizio(tipoServizio));
        w.setCorrelazioneApplicativaRichiestaLst(this.getCorrAppRichiesta(portaDelegataWrapper.getPortaDelegata().getCorrelazioneApplicativa()));
        w.setCorrelazioneApplicativaRispostaLst(this.getCorrAppRisposta(portaDelegataWrapper.getPortaDelegata().getCorrelazioneApplicativaRisposta()));
        w.setValidazione(this.getValidazioneFruizione(portaDelegataWrapper.getPortaDelegata().getValidazioneContenutiApplicativi(), w, iw));
        w.setMessageSecurity(portaDelegataWrapper.getPortaDelegata().getMessageSecurity());
        if (portaDelegataWrapper.getPortaDelegata().getMtomProcessor() != null) {
            w.setMtomProcessor(portaDelegataWrapper.getPortaDelegata().getMtomProcessor());
            iw.addWarning((Object)w, "Impossibile migrare opzioni MTOM");
        }
        w.setNomeServizio(portaDelegataWrapper.getIdServizio().getNome());
        w.setNomeSoggettoErogatore(portaDelegataWrapper.getIdServizio().getSoggettoErogatore().getNome());
        w.setNomeFruitore(portaDelegataWrapper.getIdFruitore().getNome());
        if (portaDelegataWrapper.getServiziApplicativiAutorizzati() != null && fruizione.getAutorizzazione() != null && fruizione.getAutorizzazione() instanceof APIImplAutorizzazioneAbilitataNew && ((APIImplAutorizzazioneAbilitataNew)fruizione.getAutorizzazione()).isRichiedente().booleanValue()) {
            ArrayList<ControlloAccessiAutorizzazioneApplicativo> controlloAccessiLst = new ArrayList<ControlloAccessiAutorizzazioneApplicativo>();
            for (String sa : portaDelegataWrapper.getServiziApplicativiAutorizzati()) {
                ControlloAccessiAutorizzazioneApplicativo e = new ControlloAccessiAutorizzazioneApplicativo();
                e.setApplicativo(sa);
                controlloAccessiLst.add(e);
            }
            w.setControlloAccessiLst(controlloAccessiLst);
        }
        w.setFruizione(fruizione);
        if (portaDelegataWrapper.getPortaDelegata().getAzione() != null) {
            if (portaDelegataWrapper.getPortaDelegata().getAzione().getIdentificazione() != null && portaDelegataWrapper.getPortaDelegata().getAzione().getIdentificazione().equals(PortaDelegataAzioneIdentificazione.STATIC)) {
                w.setUrlAzione(portaDelegataWrapper.getPortaDelegata().getAzione().getNome());
            }
            if (portaDelegataWrapper.getIndex() > 1 && portaDelegataWrapper.getPortaDelegata().getId() != portaDelegataPredefinitaWrapper.getPortaDelegata().getId()) {
                w.setGruppo(portaDelegataWrapper.getPortaDelegata().getAzione().getNome());
                if (!portaDelegataWrapper.getConnettore().equals((Object)portaDelegataPredefinitaWrapper.getConnettore(), false)) {
                    iw.addWarning((Object)w, "Impossibile migrare il connettore per il gruppo " + w.getGruppo());
                }
            }
            if (portaDelegataWrapper.getPortaDelegata().getAzione().getNome() == null) {
                void var10_19;
                ApiImplUrlInvocazione urlInvocazione = new ApiImplUrlInvocazione();
                Object var10_13 = null;
                boolean urlBased = false;
                switch (portaDelegataWrapper.getPortaDelegata().getAzione().getIdentificazione()) {
                    case CONTENT_BASED: {
                        ModalitaIdentificazioneAzioneEnum modalitaIdentificazioneAzioneEnum = ModalitaIdentificazioneAzioneEnum.CONTENT_BASED;
                        break;
                    }
                    case INPUT_BASED: {
                        ModalitaIdentificazioneAzioneEnum modalitaIdentificazioneAzioneEnum = ModalitaIdentificazioneAzioneEnum.INPUT_BASED;
                        break;
                    }
                    case SOAP_ACTION_BASED: {
                        ModalitaIdentificazioneAzioneEnum modalitaIdentificazioneAzioneEnum = ModalitaIdentificazioneAzioneEnum.SOAP_ACTION_BASED;
                        break;
                    }
                    case STATIC: {
                        break;
                    }
                    case URL_BASED: {
                        ModalitaIdentificazioneAzioneEnum modalitaIdentificazioneAzioneEnum = ModalitaIdentificazioneAzioneEnum.URL_BASED;
                        urlBased = true;
                        break;
                    }
                    case WSDL_BASED: {
                        ModalitaIdentificazioneAzioneEnum modalitaIdentificazioneAzioneEnum = ModalitaIdentificazioneAzioneEnum.INTERFACE_BASED;
                        break;
                    }
                }
                urlInvocazione.setModalita((ModalitaIdentificazioneAzioneEnum)var10_19);
                if (portaDelegataWrapper.getPortaDelegata().getAzione().getForceWsdlBased() != null) {
                    urlInvocazione.setForceInterface(Boolean.valueOf(portaDelegataWrapper.getPortaDelegata().getAzione().getForceWsdlBased().equals(StatoFunzionalita.ABILITATO)));
                }
                urlInvocazione.setNome(portaDelegataWrapper.getPortaDelegata().getAzione().getNome());
                if (portaDelegataWrapper.getPortaDelegata().getAzione().getPattern() != null) {
                    if (urlBased) {
                        boolean soggettoOk = portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore() != null && portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getTipo() != null && portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getNome() != null && PortaDelegataSoggettoErogatoreIdentificazione.STATIC.equals(portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getIdentificazione());
                        boolean servizioOk = portaDelegataWrapper.getPortaDelegata().getServizio() != null && portaDelegataWrapper.getPortaDelegata().getServizio().getTipo() != null && portaDelegataWrapper.getPortaDelegata().getServizio().getNome() != null && PortaDelegataServizioIdentificazione.STATIC.equals(portaDelegataWrapper.getPortaDelegata().getServizio().getIdentificazione());
                        boolean oldFormato = false;
                        String exprAttesa = null;
                        if (soggettoOk && servizioOk) {
                            StringBuilder sbOld = new StringBuilder();
                            sbOld.append(".*");
                            sbOld.append(portaDelegataWrapper.getPortaDelegata().getTipoSoggettoProprietario()).append(portaDelegataWrapper.getPortaDelegata().getNomeSoggettoProprietario());
                            sbOld.append("/");
                            sbOld.append(portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getTipo()).append(portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getNome());
                            sbOld.append("/");
                            sbOld.append(portaDelegataWrapper.getPortaDelegata().getServizio().getTipo()).append(portaDelegataWrapper.getPortaDelegata().getServizio().getNome());
                            sbOld.append("/([^/|^?]*).*");
                            exprAttesa = sbOld.toString();
                            if (exprAttesa.equals(portaDelegataWrapper.getPortaDelegata().getAzione().getPattern())) {
                                oldFormato = true;
                            }
                        } else {
                            if (soggettoOk || portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore() != null) {
                                // empty if block
                            }
                            if (servizioOk || portaDelegataWrapper.getPortaDelegata().getServizio() != null) {
                                // empty if block
                            }
                        }
                        if (!oldFormato && exprAttesa != null) {
                            iw.addWarning((Object)w, "Rilevata espressione regolare (" + portaDelegataWrapper.getPortaDelegata().getAzione().getPattern() + ") modificata rispetto a quello di default attesa (" + exprAttesa + "); la configurazione \u00e8 stata allineata comunque al nuovo formato. Si suggerisce di verificare il vecchio pattern per capire le motivazione della precedente modifica");
                        }
                        boolean tipoTrasparente = ProfiloEnum.APIGATEWAY.equals((Object)profilo);
                        StringBuilder sbNew = new StringBuilder();
                        sbNew.append(".*/");
                        sbNew.append("(?:");
                        sbNew.append(tipoTrasparente ? "gw" : this.getTipoSoggetto(portaDelegataWrapper.getPortaDelegata().getTipoSoggettoProprietario()));
                        sbNew.append("_)?").append(portaDelegataWrapper.getPortaDelegata().getNomeSoggettoProprietario());
                        sbNew.append("/");
                        sbNew.append("(?:");
                        sbNew.append(tipoTrasparente ? "gw" : this.getTipoSoggetto(portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getTipo()));
                        sbNew.append("_)?").append(portaDelegataWrapper.getPortaDelegata().getSoggettoErogatore().getNome());
                        sbNew.append("/");
                        sbNew.append("(?:");
                        sbNew.append(tipoTrasparente ? "gw" : this.getTipoServizio(portaDelegataWrapper.getPortaDelegata().getServizio().getTipo()));
                        sbNew.append("_)?").append(portaDelegataWrapper.getPortaDelegata().getServizio().getNome());
                        sbNew.append("/v1/([^/|^?]*).*");
                        urlInvocazione.setPattern(sbNew.toString());
                    } else {
                        urlInvocazione.setPattern(portaDelegataWrapper.getPortaDelegata().getAzione().getPattern());
                    }
                }
                w.setUrlInvocazione(urlInvocazione);
            }
        }
        w.setAllegati(this.getAllegati(portaDelegataWrapper.getAsps()));
        w.setTipoMultitenant(AbstractFruizioneErogazioneWrapper.TIPO_MULTITENANT.valueOf((String)portaDelegataWrapper.getTipoMultitenant()));
        w.setNomePorta(portaDelegataWrapper.getPortaDelegata().getNome());
        return w;
    }

    private List<ApiImplAllegato> getAllegati(AccordoServizioParteSpecifica asps) {
        if (asps.sizeAllegatoList() > 0) {
            ArrayList<ApiImplAllegato> allegati = new ArrayList<ApiImplAllegato>();
            for (Documento allegato : asps.getAllegatoList()) {
                ApiImplAllegato apiAllegato = new ApiImplAllegato();
                RuoloAllegatoAPIImpl ruolo = (RuoloAllegatoAPIImpl)Enums.ruoliApiImplFromDocumento.get(RuoliDocumento.valueOf((String)allegato.getRuolo()));
                switch (ruolo) {
                    case ALLEGATO: {
                        ApiImplAllegatoGenerico ag = new ApiImplAllegatoGenerico();
                        ag.setRuolo(ruolo);
                        ag.setDocumento(allegato.getByteContenuto());
                        ag.setNome(allegato.getFile());
                        apiAllegato.setAllegato((OneOfApiImplAllegatoAllegato)ag);
                        break;
                    }
                    case SPECIFICASEMIFORMALE: {
                        ApiImplAllegatoGenerico ag = new ApiImplAllegatoSpecificaSemiformale();
                        ag.setRuolo(ruolo);
                        ag.setDocumento(allegato.getByteContenuto());
                        ag.setNome(allegato.getFile());
                        TipiDocumentoSemiformale tipo = Enum.valueOf(TipiDocumentoSemiformale.class, allegato.getTipo());
                        ag.setTipoSpecifica((TipoSpecificaSemiformaleEnum)Helper.apiEnumToGovway((Enum)tipo, TipoSpecificaSemiformaleEnum.class));
                        apiAllegato.setAllegato((OneOfApiImplAllegatoAllegato)ag);
                        break;
                    }
                    case SPECIFICALIVELLOSERVIZIO: {
                        ApiImplAllegatoGenerico ag = new ApiImplAllegatoSpecificaLivelloServizio();
                        ag.setRuolo(ruolo);
                        ag.setDocumento(allegato.getByteContenuto());
                        ag.setNome(allegato.getFile());
                        TipiDocumentoSemiformale tipo = Enum.valueOf(TipiDocumentoLivelloServizio.class, allegato.getTipo());
                        ag.setTipoSpecifica((TipoSpecificaLivelloServizioEnum)Helper.apiEnumToGovway((Enum)tipo, TipoSpecificaLivelloServizioEnum.class));
                        apiAllegato.setAllegato((OneOfApiImplAllegatoAllegato)ag);
                        break;
                    }
                    case SPECIFICASICUREZZA: {
                        ApiImplAllegatoGenerico ag = new ApiImplAllegatoSpecificaSicurezza();
                        ag.setRuolo(ruolo);
                        ag.setDocumento(allegato.getByteContenuto());
                        ag.setNome(allegato.getFile());
                        TipiDocumentoSemiformale tipo = Enum.valueOf(TipiDocumentoSicurezza.class, allegato.getTipo());
                        ag.setTipoSpecifica((TipoSpecificaSicurezzaEnum)Helper.apiEnumToGovway((Enum)tipo, TipoSpecificaSicurezzaEnum.class));
                        apiAllegato.setAllegato((OneOfApiImplAllegatoAllegato)ag);
                        break;
                    }
                }
                allegati.add(apiAllegato);
            }
            return allegati;
        }
        return null;
    }

    private boolean checkConnettore(PortaApplicativaWrapper portaApplicativaWrapper, PortaApplicativaWrapper portaApplicativaPredefinitaWrapper) {
        ConnettoreHttp c1 = this.getConnettore(portaApplicativaWrapper);
        ConnettoreHttp c2 = this.getConnettore(portaApplicativaPredefinitaWrapper);
        return c1.toString().equals(c2.toString());
    }

    public ProfiloEnum getProfilo(String tipo) {
        return tipo.equals("PROXY") ? ProfiloEnum.APIGATEWAY : ProfiloEnum.SPCOOP;
    }

    private String getTipoServizio(String tipoServizio) throws ProtocolException {
        if (tipoServizio.equals("PROXY")) {
            return "gw";
        }
        return ProtocolFactoryManager.getInstance().getProtocolFactoryByName("spcoop").createTraduttore().toRegistryServiceType(tipoServizio);
    }

    private String getTipoSoggetto(String tipoSoggetto) throws ProtocolException {
        if (tipoSoggetto.equals("PROXY")) {
            return "gw";
        }
        return ProtocolFactoryManager.getInstance().getProtocolFactoryByName("spcoop").createTraduttore().toRegistryOrganizationType(tipoSoggetto);
    }

    private OneOfAPIImplAutorizzazione getAutorizzazione(String autorizzazione, boolean forceRichiedente) {
        if (forceRichiedente) {
            APIImplAutorizzazioneAbilitataNew autorizzazioneNew = new APIImplAutorizzazioneAbilitataNew();
            autorizzazioneNew.setTipo(TipoAutorizzazioneEnum.ABILITATO);
            autorizzazioneNew.setRichiedente(Boolean.valueOf(true));
            return autorizzazioneNew;
        }
        if (TipoAutorizzazione.DISABILITATO.equals(autorizzazione)) {
            APIImplAutorizzazioneDisabilitata authzDisabilitata = new APIImplAutorizzazioneDisabilitata();
            authzDisabilitata.setTipo(TipoAutorizzazioneEnum.DISABILITATO);
            return authzDisabilitata;
        }
        APIImplAutorizzazioneAbilitataNew autorizzazioneNew = new APIImplAutorizzazioneAbilitataNew();
        autorizzazioneNew.setTipo(TipoAutorizzazioneEnum.ABILITATO);
        if (TipoAutorizzazione.isAuthenticationRequired((String)autorizzazione)) {
            autorizzazioneNew.setRichiedente(Boolean.valueOf(true));
        }
        if (TipoAutorizzazione.isRolesRequired((String)autorizzazione)) {
            autorizzazioneNew.setRuoli(Boolean.valueOf(true));
            autorizzazioneNew.setRuoliRichiesti(AllAnyEnum.ALL);
            autorizzazioneNew.setRuoliFonte(FonteEnum.QUALSIASI);
        }
        return autorizzazioneNew;
    }

    private OneOfAPIImplAutenticazione getAutenticazione(String autenticazione, StatoFunzionalita autenticazioneOpzionale) {
        APIImplAutenticazioneDisabilitata autenticazioneNew = null;
        if (!(autenticazione == null || "".equals(autenticazione) || "none".equals(autenticazione) || "disabilitato".equals(autenticazione) || "disabilitata".equals(autenticazione))) {
            if ("ssl".equals(autenticazione)) {
                autenticazioneNew = new APIImplAutenticazioneHttps();
                ((APIImplAutenticazioneHttps)autenticazioneNew).setTipo(TipoAutenticazioneEnum.HTTPS);
                ((APIImplAutenticazioneHttps)autenticazioneNew).setOpzionale(Boolean.valueOf(autenticazioneOpzionale != null && StatoFunzionalita.ABILITATO.equals(autenticazioneOpzionale)));
            } else if ("basic".equals(autenticazione)) {
                autenticazioneNew = new APIImplAutenticazioneBasic();
                ((APIImplAutenticazioneBasic)autenticazioneNew).setTipo(TipoAutenticazioneEnum.HTTP_BASIC);
                ((APIImplAutenticazioneBasic)autenticazioneNew).setOpzionale(Boolean.valueOf(autenticazioneOpzionale != null && StatoFunzionalita.ABILITATO.equals(autenticazioneOpzionale)));
            } else if ("principal".equals(autenticazione)) {
                autenticazioneNew = new APIImplAutenticazionePrincipal();
                ((APIImplAutenticazionePrincipal)autenticazioneNew).setTipo(TipoAutenticazioneEnum.PRINCIPAL);
                ((APIImplAutenticazionePrincipal)autenticazioneNew).setOpzionale(Boolean.valueOf(autenticazioneOpzionale != null && StatoFunzionalita.ABILITATO.equals(autenticazioneOpzionale)));
                ((APIImplAutenticazionePrincipal)autenticazioneNew).setTipoPrincipal(TipoAutenticazionePrincipal.CONTAINER);
            } else {
                System.out.println("Tipo autenticazione '" + autenticazione + "' non supportata");
                autenticazioneNew = new APIImplAutenticazioneDisabilitata();
                autenticazioneNew.setTipo(TipoAutenticazioneEnum.DISABILITATO);
            }
        } else {
            autenticazioneNew = new APIImplAutenticazioneDisabilitata();
            autenticazioneNew.setTipo(TipoAutenticazioneEnum.DISABILITATO);
        }
        return autenticazioneNew;
    }

    private List<String> checkConnettore(BaseConnettoreHttp conn) {
        if (conn.getEndpoint() == null) {
            String endpoint = "http://TODO";
            conn.setEndpoint(endpoint);
            return Arrays.asList("Endpoint connettore non definito. Impostato valore di default " + endpoint);
        }
        return null;
    }

    private ConnettoreHttp getConnettore(String tipoConnettore, Map<String, String> properties) {
        ConnettoreHttp conn = new ConnettoreHttp();
        conn.setTipo(ConnettoreEnum.HTTP);
        if (properties.containsKey("location")) {
            conn.setEndpoint(properties.get("location"));
        }
        if (tipoConnettore.equals(TipiConnettore.HTTP.toString())) {
            if (properties.containsKey("user") && properties.containsKey("password")) {
                ConnettoreConfigurazioneHttpBasic autenticazioneHttp = new ConnettoreConfigurazioneHttpBasic();
                autenticazioneHttp.setUsername(properties.get("user"));
                autenticazioneHttp.setPassword(properties.get("password"));
                conn.setAutenticazioneHttp(autenticazioneHttp);
            }
        } else if (tipoConnettore.equals(TipiConnettore.HTTPS.toString())) {
            String sslType;
            ConnettoreConfigurazioneHttps autenticazioneHttps = new ConnettoreConfigurazioneHttps();
            ConnettoreConfigurazioneHttpsServer server = new ConnettoreConfigurazioneHttpsServer();
            server.setAlgoritmo(properties.get("trustManagementAlgorithm"));
            server.setTruststoreTipo(KeystoreEnum.fromValue((String)properties.get("trustStoreType")));
            server.setTruststorePath(properties.get("trustStoreLocation"));
            server.setTruststorePassword(properties.get("trustStorePassword"));
            autenticazioneHttps.setServer(server);
            if (properties.containsKey("keyStoreLocation")) {
                ConnettoreConfigurazioneHttpsClient client = new ConnettoreConfigurazioneHttpsClient();
                client.setAlgoritmo(properties.get("keyManagementAlgorithm"));
                client.setKeystoreTipo(KeystoreEnum.fromValue((String)properties.get("keyStoreType")));
                client.setKeystorePath(properties.get("keyStoreLocation"));
                client.setKeystorePassword(properties.get("keyStorePassword"));
                client.setKeyPassword(properties.get("keyPassword"));
                autenticazioneHttps.setClient(client);
            }
            if ((sslType = properties.get("sslType")).equals("TLS")) {
                autenticazioneHttps.setTipologia(SslTipologiaEnum.TLSV1);
            } else if (sslType.equals("SSL")) {
                autenticazioneHttps.setTipologia(SslTipologiaEnum.SSLV3);
            } else {
                autenticazioneHttps.setTipologia(SslTipologiaEnum.fromValue((String)sslType));
            }
            conn.setAutenticazioneHttps(autenticazioneHttps);
        }
        if (properties.containsKey("proxyPort")) {
            ConnettoreConfigurazioneProxy proxy = new ConnettoreConfigurazioneProxy();
            proxy.setHostname(properties.get("proxyHostname"));
            proxy.setPorta(Integer.valueOf(Integer.parseInt(properties.get("proxyPort"))));
            proxy.setUsername(properties.get("proxyUsername"));
            proxy.setPassword(properties.get("proxyPassword"));
            conn.setProxy(proxy);
        }
        if (properties.containsKey("connection-timeout") || properties.containsKey("connection-timeout")) {
            ConnettoreConfigurazioneTimeout tempiRisposta = new ConnettoreConfigurazioneTimeout();
            if (properties.containsKey("connection-timeout")) {
                tempiRisposta.setConnectionTimeout(Integer.valueOf(Integer.parseInt(properties.get("connection-timeout"))));
            }
            if (properties.containsKey("connection-timeout")) {
                tempiRisposta.setConnectionReadTimeout(Integer.valueOf(Integer.parseInt(properties.get("read-connection-timeout"))));
            }
            conn.setTempiRisposta(tempiRisposta);
        }
        return conn;
    }

    private ConnettoreHttp toConnettore(Connettore connettore) {
        return this.getConnettore(connettore.getTipo(), connettore.getProperties());
    }

    private ConnettoreHttp toConnettore(it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore connettore) {
        return this.getConnettore(connettore.getTipo(), connettore.getProperties());
    }

    public InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> toErogazioniList(List<PortaApplicativaWrapper> lst, Map<IDPortaApplicativaByNome, String> lstIdDaScartare) throws Exception {
        ArrayList<ErogazioneWrapper> lstOut = new ArrayList<ErogazioneWrapper>();
        InputWrapper iw = new InputWrapper();
        Map<String, List<PortaApplicativaWrapper>> map = this.getPAMap(lst);
        for (PortaApplicativaWrapper pa : lst) {
            pa.setIndex(map.size());
            lstOut.addAll(this.toErogazioneList(pa, (InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper>)iw, this.getPredefinita(pa, map)));
        }
        HashMap<CallSite, ErogazioneWrapper> mapFiltrata = new HashMap<CallSite, ErogazioneWrapper>();
        for (ErogazioneWrapper erogazione : lstOut) {
            String k = erogazione.getErogazione().getErogazioneNome() + erogazione.getErogazione().getApiVersione() + erogazione.getProfilo() + erogazione.getNomeSoggettoErogatore() + erogazione.getErogazione().getTipoServizio() + erogazione.getGruppo();
            if (!mapFiltrata.containsKey(k)) {
                mapFiltrata.put((CallSite)((Object)k), erogazione);
                continue;
            }
            if (MigrazioneProperties.getInstance().getTipoMigrazioneServizi().equals((Object)MigrazioneProperties.TIPO_MIGRAZIONE_SERVIZI.SPC_E_GW)) {
                iw.addWarning((Object)erogazione, "Conversione (in profilo API Gateway) non necessaria esistendo sulla base dati sorgente una erogazione equivalente e di tipo PROXY.");
                continue;
            }
            lstIdDaScartare.put((IDPortaApplicativaByNome)erogazione.getKey(), "Conversione (in profilo API Gateway) non necessaria esistendo sulla base dati sorgente una erogazione equivalente e di tipo PROXY.");
            iw.removeAllWarnings((Object)erogazione);
        }
        iw.setElementiNonMigrati(lstIdDaScartare);
        iw.setElementi(Arrays.asList(mapFiltrata.values().toArray(new ErogazioneWrapper[0])));
        return iw;
    }

    private List<ErogazioneWrapper> toErogazioneList(PortaApplicativaWrapper pa, InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> iw, PortaApplicativaWrapper predefinita) throws Exception {
        ArrayList<ErogazioneWrapper> lst = new ArrayList<ErogazioneWrapper>();
        List<String> tipi = this.getTipi(pa.getIdServizio().getTipo());
        for (String tipo : tipi) {
            lst.add(this.toErogazione(pa, iw, predefinita, tipo));
        }
        return lst;
    }

    private PortaApplicativaWrapper getPredefinita(PortaApplicativaWrapper portaApplicativa, Map<String, List<PortaApplicativaWrapper>> map) {
        List<PortaApplicativaWrapper> list = map.get(this.getPAKey(portaApplicativa));
        if (list.size() == 1) {
            return portaApplicativa;
        }
        for (PortaApplicativaWrapper pa : list) {
            if (pa.getPortaApplicativa().getAzione() != null) continue;
            return pa;
        }
        return list.get(0);
    }

    private Map<String, List<PortaApplicativaWrapper>> getPAMap(List<PortaApplicativaWrapper> lst) {
        HashMap<String, List<PortaApplicativaWrapper>> map = new HashMap<String, List<PortaApplicativaWrapper>>();
        for (PortaApplicativaWrapper pa : lst) {
            String key = this.getPAKey(pa);
            List lstPD = null;
            lstPD = map.containsKey(key) ? (List)map.get(key) : new ArrayList();
            lstPD.add(pa);
            map.put(key, lstPD);
        }
        return map;
    }

    private String getPAKey(PortaApplicativaWrapper pa) {
        return String.join((CharSequence)"_", Arrays.asList(pa.getIdServizio().getTipo(), pa.getIdServizio().getNome(), pa.getIdServizio().getSoggettoErogatore().getTipo(), pa.getIdServizio().getSoggettoErogatore().getNome()));
    }

    private ErogazioneWrapper toErogazione(PortaApplicativaWrapper portaApplicativaWrapper, InputWrapper<IDPortaApplicativaByNome, ErogazioneWrapper> iw, PortaApplicativaWrapper portaApplicativaPredefinitaWrapper, String tipo) throws Exception {
        List<String> checkConnettore;
        ErogazioneWrapper eWrapper = new ErogazioneWrapper();
        eWrapper.setKey((Object)portaApplicativaPredefinitaWrapper.getKey());
        Erogazione erogazione = new Erogazione();
        erogazione.setApiNome(portaApplicativaWrapper.getNomeASPC());
        erogazione.setErogazioneNome(portaApplicativaWrapper.getIdServizio().getNome());
        erogazione.setApiSoapServizio(portaApplicativaWrapper.getPortType());
        erogazione.setApiVersione(Integer.valueOf(1));
        ProfiloEnum profilo = this.getProfilo(tipo);
        erogazione.setApiReferente(this.getNomeReferente(tipo, portaApplicativaWrapper.getNomeSoggettoReferente()));
        eWrapper.setProfilo(profilo);
        boolean isProfiloInizialeProxy = portaApplicativaWrapper.getIdServizio().getTipo().equals("PROXY");
        eWrapper.setCambioTipo(!tipo.equals(portaApplicativaWrapper.getIdServizio().getTipo()));
        if (portaApplicativaWrapper.getFruitoriNonMigrabili() != null && !portaApplicativaWrapper.getFruitoriNonMigrabili().isEmpty()) {
            iw.addWarning((Object)eWrapper, "Fruitori non migrabili: " + String.join((CharSequence)" ", portaApplicativaWrapper.getFruitoriNonMigrabili()));
        }
        if (portaApplicativaWrapper.getPortaApplicativa().getAutenticazione() != null && isProfiloInizialeProxy && !eWrapper.isMigrazioneSpc2Gw() && !eWrapper.isMigrazioneSpcEGw()) {
            erogazione.setAutenticazione(this.getAutenticazione(portaApplicativaWrapper.getPortaApplicativa().getAutenticazione(), portaApplicativaWrapper.getPortaApplicativa().getAutenticazioneOpzionale()));
        }
        if (portaApplicativaWrapper.getPortaApplicativa().getAutorizzazione() != null || !isProfiloInizialeProxy) {
            erogazione.setAutorizzazione(this.getAutorizzazione(portaApplicativaWrapper.getPortaApplicativa().getAutorizzazione(), !isProfiloInizialeProxy));
            if (eWrapper.isMigrazioneSpc2Gw() || eWrapper.isMigrazioneSpcEGw()) {
                APIImplAutenticazioneHttps autenticazione = new APIImplAutenticazioneHttps();
                autenticazione.setTipo(TipoAutenticazioneEnum.HTTPS);
                autenticazione.setOpzionale(Boolean.valueOf(false));
                erogazione.setAutenticazione((OneOfAPIImplAutenticazione)autenticazione);
                eWrapper.setAggiungiCredenzialiASoggetto(true);
            }
            if (erogazione.getAutorizzazione() != null && erogazione.getAutorizzazione() instanceof APIImplAutorizzazioneAbilitataNew && ((APIImplAutorizzazioneAbilitataNew)erogazione.getAutorizzazione()).isRichiedente().booleanValue()) {
                ArrayList<ControlloAccessiAutorizzazioneSoggetto> controlloAccessiLst = new ArrayList<ControlloAccessiAutorizzazioneSoggetto>();
                for (String fruitore : portaApplicativaWrapper.getFruitori()) {
                    ControlloAccessiAutorizzazioneSoggetto e = new ControlloAccessiAutorizzazioneSoggetto();
                    e.setSoggetto(fruitore);
                    controlloAccessiLst.add(e);
                }
                eWrapper.setControlloAccessiLst(controlloAccessiLst);
            }
        }
        erogazione.setConnettore((BaseConnettoreHttp)this.getConnettore(portaApplicativaWrapper));
        if (erogazione.getConnettore() != null && portaApplicativaWrapper.getPortaApplicativa().sizeServizioApplicativoList() > 0 && portaApplicativaWrapper.getPortaApplicativa().getServizioApplicativo(0).getInvocazioneServizio() != null) {
            eWrapper.setLocationConnettore(this.getConnettorePath(portaApplicativaWrapper.getPortaApplicativa().getServizioApplicativo(0).getInvocazioneServizio().getConnettore().getProperties()));
        }
        if ((checkConnettore = this.checkConnettore(erogazione.getConnettore())) != null) {
            for (String warn : checkConnettore) {
                iw.addWarning((Object)eWrapper, warn);
            }
        }
        erogazione.setTipoServizio(this.getTipoServizio(tipo));
        eWrapper.setCorrelazioneApplicativaRichiestaLst(this.getCorrAppRichiesta(portaApplicativaWrapper.getPortaApplicativa().getCorrelazioneApplicativa()));
        eWrapper.setCorrelazioneApplicativaRispostaLst(this.getCorrAppRisposta(portaApplicativaWrapper.getPortaApplicativa().getCorrelazioneApplicativaRisposta()));
        eWrapper.setValidazione(this.getValidazioneErogazione(portaApplicativaWrapper.getPortaApplicativa().getValidazioneContenutiApplicativi(), eWrapper, iw));
        eWrapper.setMessageSecurity(portaApplicativaWrapper.getPortaApplicativa().getMessageSecurity());
        if (portaApplicativaWrapper.getPortaApplicativa().getMtomProcessor() != null) {
            eWrapper.setMtomProcessor(portaApplicativaWrapper.getPortaApplicativa().getMtomProcessor());
            iw.addWarning((Object)eWrapper, "Impossibile migrare le opzioni MTOM");
        }
        eWrapper.setNomeServizio(portaApplicativaWrapper.getIdServizio().getNome());
        eWrapper.setNomeSoggettoErogatore(portaApplicativaWrapper.getIdServizio().getSoggettoErogatore().getNome());
        eWrapper.setErogazione(erogazione);
        eWrapper.setNomePorta(portaApplicativaWrapper.getPortaApplicativa().getNome());
        if (portaApplicativaWrapper.getIndex() > 1 && portaApplicativaWrapper.getPortaApplicativa().getAzione() != null && !portaApplicativaWrapper.equals(portaApplicativaPredefinitaWrapper)) {
            eWrapper.setGruppo(portaApplicativaWrapper.getPortaApplicativa().getAzione().getNome());
            if (!this.checkConnettore(portaApplicativaWrapper, portaApplicativaPredefinitaWrapper)) {
                iw.addWarning((Object)eWrapper, "Impossibile migrare il connettore per il gruppo " + eWrapper.getGruppo());
            }
        }
        eWrapper.setAllegati(this.getAllegati(portaApplicativaWrapper.getAsps()));
        eWrapper.setLocationWsSecurityRichiesta(this.getWsSecPath(portaApplicativaWrapper.getPortaApplicativa().getMessageSecurity(), true));
        eWrapper.setLocationWsSecurityRisposta(this.getWsSecPath(portaApplicativaWrapper.getPortaApplicativa().getMessageSecurity(), false));
        eWrapper.setTipoMultitenant(AbstractFruizioneErogazioneWrapper.TIPO_MULTITENANT.valueOf((String)portaApplicativaWrapper.getTipoMultitenant()));
        return eWrapper;
    }

    private ConnettoreHttp getConnettore(PortaApplicativaWrapper portaApplicativaWrapper) {
        if (portaApplicativaWrapper.getPortaApplicativa().getServizioApplicativoList().size() > 0 && portaApplicativaWrapper.getPortaApplicativa().getServizioApplicativo(0).getInvocazioneServizio() != null) {
            return this.toConnettore(portaApplicativaWrapper.getPortaApplicativa().getServizioApplicativo(0).getInvocazioneServizio().getConnettore());
        }
        ConnettoreHttp connettore = new ConnettoreHttp();
        return connettore;
    }

    private String getConnettorePath(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        for (String k : properties.keySet()) {
            if (!k.equals("keyStoreLocation") && !k.equals("trustStoreLocation")) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(k + "=" + properties.get(k));
        }
        return sb.toString();
    }

    private String getWsSecPath(MessageSecurity messageSecurity, boolean req) {
        StringBuilder sb = new StringBuilder();
        if (messageSecurity != null) {
            List parameterList = null;
            if (req) {
                parameterList = messageSecurity.getRequestFlow() != null ? messageSecurity.getRequestFlow().getParameterList() : null;
            } else {
                List list = parameterList = messageSecurity.getResponseFlow() != null ? messageSecurity.getResponseFlow().getParameterList() : null;
            }
            if (parameterList != null) {
                for (MessageSecurityFlowParameter param : parameterList) {
                    if (!param.getNome().endsWith("PropFile") && !param.getNome().equals("passwordCallbackClass")) continue;
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(param.getNome() + "=" + param.getValore());
                }
            }
        }
        return sb.toString();
    }

    private Validazione getValidazioneErogazione(ValidazioneContenutiApplicativi validContAppl, ErogazioneWrapper wrap, InputWrapper<?, ErogazioneWrapper> iw) {
        if (validContAppl != null && ValidazioneContenutiApplicativiTipo.OPENSPCOOP.equals(validContAppl.getTipo())) {
            iw.addWarning((Object)wrap, "Rilevata validazione di tipo OpenSPCoop");
        }
        return this.getValidazione(validContAppl);
    }

    private Validazione getValidazioneFruizione(ValidazioneContenutiApplicativi validContAppl, FruizioneWrapper wrap, InputWrapper<?, FruizioneWrapper> iw) {
        if (validContAppl != null && ValidazioneContenutiApplicativiTipo.OPENSPCOOP.equals(validContAppl.getTipo())) {
            iw.addWarning((Object)wrap, "Rilevata validazione di tipo OpenSPCoop");
        }
        return this.getValidazione(validContAppl);
    }

    private Validazione getValidazione(ValidazioneContenutiApplicativi validContAppl) {
        if (validContAppl != null && !validContAppl.getStato().equals(StatoFunzionalitaConWarning.DISABILITATO)) {
            Validazione validazione = new Validazione();
            validazione.setMtom(Boolean.valueOf(validContAppl.getAcceptMtomMessage() != null && StatoFunzionalita.ABILITATO.equals(validContAppl.getAcceptMtomMessage())));
            validazione.setRidefinito(Boolean.valueOf(true));
            StatoFunzionalitaConWarningEnum stato = null;
            switch (validContAppl.getStato()) {
                case ABILITATO: {
                    stato = StatoFunzionalitaConWarningEnum.ABILITATO;
                    break;
                }
                case DISABILITATO: {
                    stato = StatoFunzionalitaConWarningEnum.DISABILITATO;
                    break;
                }
                case WARNING_ONLY: {
                    stato = StatoFunzionalitaConWarningEnum.WARNINGONLY;
                }
            }
            validazione.setStato(stato);
            TipoValidazioneEnum tipo = null;
            switch (validContAppl.getTipo()) {
                case OPENSPCOOP: {
                    tipo = TipoValidazioneEnum.INTERFACE;
                    break;
                }
                case WSDL: {
                    tipo = TipoValidazioneEnum.INTERFACE;
                    break;
                }
                case XSD: {
                    tipo = TipoValidazioneEnum.XSD;
                }
            }
            validazione.setTipo(tipo);
            return validazione;
        }
        return null;
    }

    private List<org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta> getCorrAppRisposta(CorrelazioneApplicativaRisposta correlazioneApplicativaRisposta) {
        if (correlazioneApplicativaRisposta != null) {
            ArrayList<org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta> lst = new ArrayList<org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta>();
            for (CorrelazioneApplicativaRispostaElemento elem : correlazioneApplicativaRisposta.getElementoList()) {
                org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta risp = new org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta();
                risp.setElemento(elem.getNome());
                CorrelazioneApplicativaRispostaEnum identificazioneTipo = null;
                if (elem.getIdentificazione() != null) {
                    switch (elem.getIdentificazione()) {
                        case CONTENT_BASED: {
                            identificazioneTipo = CorrelazioneApplicativaRispostaEnum.CONTENT_BASED;
                            break;
                        }
                        case DISABILITATO: {
                            identificazioneTipo = CorrelazioneApplicativaRispostaEnum.DISABILITATO;
                            break;
                        }
                        case INPUT_BASED: {
                            identificazioneTipo = CorrelazioneApplicativaRispostaEnum.INPUT_BASED;
                        }
                    }
                } else {
                    identificazioneTipo = CorrelazioneApplicativaRispostaEnum.DISABILITATO;
                }
                risp.setIdentificazione(elem.getPattern());
                risp.setIdentificazioneTipo(identificazioneTipo);
                risp.setGenerazioneErroreIdentificazioneFallita(Boolean.valueOf(elem.getIdentificazioneFallita() != null && elem.getIdentificazioneFallita().equals(CorrelazioneApplicativaGestioneIdentificazioneFallita.BLOCCA)));
                lst.add(risp);
            }
            return lst;
        }
        return null;
    }

    private List<CorrelazioneApplicativaRichiesta> getCorrAppRichiesta(CorrelazioneApplicativa correlazioneApplicativa) {
        if (correlazioneApplicativa != null) {
            ArrayList<CorrelazioneApplicativaRichiesta> lst = new ArrayList<CorrelazioneApplicativaRichiesta>();
            for (CorrelazioneApplicativaElemento elem : correlazioneApplicativa.getElementoList()) {
                CorrelazioneApplicativaRichiesta richiesta = new CorrelazioneApplicativaRichiesta();
                richiesta.setElemento(elem.getNome());
                CorrelazioneApplicativaRichiestaEnum identificazioneTipo = null;
                if (elem.getIdentificazione() != null) {
                    switch (elem.getIdentificazione()) {
                        case CONTENT_BASED: {
                            identificazioneTipo = CorrelazioneApplicativaRichiestaEnum.CONTENT_BASED;
                            break;
                        }
                        case DISABILITATO: {
                            identificazioneTipo = CorrelazioneApplicativaRichiestaEnum.DISABILITATO;
                            break;
                        }
                        case INPUT_BASED: {
                            identificazioneTipo = CorrelazioneApplicativaRichiestaEnum.INPUT_BASED;
                            break;
                        }
                        case URL_BASED: {
                            identificazioneTipo = CorrelazioneApplicativaRichiestaEnum.URL_BASED;
                        }
                    }
                } else {
                    identificazioneTipo = CorrelazioneApplicativaRichiestaEnum.DISABILITATO;
                }
                richiesta.setIdentificazione(elem.getPattern());
                richiesta.setIdentificazioneTipo(identificazioneTipo);
                richiesta.setGenerazioneErroreIdentificazioneFallita(Boolean.valueOf(elem.getIdentificazioneFallita() != null && elem.getIdentificazioneFallita().equals(CorrelazioneApplicativaGestioneIdentificazioneFallita.BLOCCA)));
                lst.add(richiesta);
            }
            return lst;
        }
        return null;
    }

    public InputWrapper<IDServizioApplicativo, ApplicativoWrapper> toApplicativiList(List<ServizioApplicativo> lst, Map<IDServizioApplicativo, String> lstIdDaScartare) throws Exception {
        ArrayList<ApplicativoWrapper> lstOut = new ArrayList<ApplicativoWrapper>();
        InputWrapper iw = new InputWrapper();
        for (ServizioApplicativo sa : lst) {
            lstOut.addAll(this.toServizioApplicativoList(sa));
        }
        HashMap<CallSite, ApplicativoWrapper> mapFiltrata = new HashMap<CallSite, ApplicativoWrapper>();
        for (ApplicativoWrapper wrap : lstOut) {
            String k = wrap.getProfilo() + wrap.getSoggetto() + wrap.getApplicativo().getNome();
            if (!mapFiltrata.containsKey(k)) {
                mapFiltrata.put((CallSite)((Object)k), wrap);
                continue;
            }
            iw.addWarning((Object)wrap, "Applicativo PROXY gia migrato");
            iw.removeAllWarnings((Object)wrap);
        }
        iw.setElementiNonMigrati(lstIdDaScartare);
        iw.setElementi(Arrays.asList(mapFiltrata.values().toArray(new ApplicativoWrapper[0])));
        return iw;
    }

    private List<ApplicativoWrapper> toServizioApplicativoList(ServizioApplicativo servizioApplicativo) throws Exception {
        ArrayList<ApplicativoWrapper> lst = new ArrayList<ApplicativoWrapper>();
        List<String> tipi = this.getTipi(servizioApplicativo.getTipoSoggettoProprietario());
        for (String tipo : tipi) {
            lst.add(this.toServizioApplicativo(servizioApplicativo, tipo));
        }
        return lst;
    }

    private ApplicativoWrapper toServizioApplicativo(ServizioApplicativo servizioApplicativo, String tipo) {
        ApplicativoWrapper aw = new ApplicativoWrapper();
        aw.setCambioTipo(!servizioApplicativo.getTipoSoggettoProprietario().equals(tipo));
        IDServizioApplicativo k = new IDServizioApplicativo();
        IDSoggetto idSoggettoProprietario = new IDSoggetto(servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario());
        k.setIdSoggettoProprietario(idSoggettoProprietario);
        k.setNome(servizioApplicativo.getNome());
        aw.setKey((Object)k);
        aw.setProfilo(this.getProfilo(tipo));
        Applicativo applicativo = new Applicativo();
        applicativo.setNome(servizioApplicativo.getNome());
        if (servizioApplicativo.getInvocazionePorta() != null && servizioApplicativo.getInvocazionePorta().getRuoli() != null && servizioApplicativo.getInvocazionePorta().getRuoli().getRuoloList() != null && !servizioApplicativo.getInvocazionePorta().getRuoli().getRuoloList().isEmpty()) {
            ArrayList<String> ruoli = new ArrayList<String>();
            for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Ruolo ruolo : servizioApplicativo.getInvocazionePorta().getRuoli().getRuoloList()) {
                ruoli.add(ruolo.getNome());
            }
            applicativo.setRuoli(ruoli);
        }
        if (servizioApplicativo.getInvocazionePorta().getCredenzialiList() != null && !servizioApplicativo.getInvocazionePorta().getCredenzialiList().isEmpty()) {
            Credenziali credenzialiIn = (Credenziali)servizioApplicativo.getInvocazionePorta().getCredenzialiList().get(0);
            applicativo.setCredenziali(this.getCredenziali(credenzialiIn, this.isSpc2Gw(tipo, servizioApplicativo.getTipoSoggettoProprietario())));
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo.BASIC.equals(credenzialiIn.getTipo())) {
                ((AuthenticationHttpBasic)applicativo.getCredenziali()).setModalitaAccesso(ModalitaAccessoEnum.HTTP_BASIC);
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo.SSL.equals(credenzialiIn.getTipo())) {
                ((AuthenticationHttps)applicativo.getCredenziali()).setModalitaAccesso(ModalitaAccessoEnum.HTTPS);
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo.PRINCIPAL.equals(credenzialiIn.getTipo())) {
                ((AuthenticationPrincipal)applicativo.getCredenziali()).setModalitaAccesso(ModalitaAccessoEnum.PRINCIPAL);
            }
        }
        aw.setSoggetto(servizioApplicativo.getNomeSoggettoProprietario());
        aw.setApplicativo(applicativo);
        return aw;
    }
}

