/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v2_3.govway.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB_LIB;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DriverAvanzatoGovway {
    public DataSource datasource = null;
    protected Connection globalConnection = null;
    protected boolean atomica = true;
    protected Logger log = null;
    protected String tipoDB = null;

    public DriverAvanzatoGovway(String nomeDataSource, Properties context, String tipoDB) throws Exception {
        this(nomeDataSource, context, null, tipoDB);
    }

    public DriverAvanzatoGovway(String nomeDataSource, Properties context, Logger alog, String tipoDB) throws Exception {
        this(nomeDataSource, context, alog, tipoDB, false);
    }

    public DriverAvanzatoGovway(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        this.initDriverConfigurazioneFindAll(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD);
    }

    public DriverAvanzatoGovway(Connection connection, Logger alog, String tipoDB) throws Exception {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
        } else {
            this.log = alog;
            DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
        }
        if (connection == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection con, Properties context) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.atomica = false;
        this.tipoDB = tipoDB;
    }

    private void initDriverConfigurazioneFindAll(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
            } else {
                this.log = alog;
                DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
            }
            InitialContext initCtx = new InitialContext(context);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            initCtx.close();
        }
        catch (NamingException ne) {
            this.log.error("Impossibile recuperare il context: " + ne.getMessage());
            throw new Exception("Impossibile recuperare il context: " + ne.getMessage());
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            throw new Exception("Il tipoDatabase non puo essere null.");
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
    }

    public Map<String, String> getSoggettiDefault() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getSoggettiDefault...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addWhereCondition("soggetti.is_default=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setInt(1, 1);
            rs = stm.executeQuery();
            HashMap<String, String> soggetti = new HashMap<String, String>();
            while (rs.next()) {
                soggetti.put(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
            }
            this.log.debug("getSoggettiDefault OK");
            HashMap<String, String> hashMap = soggetti;
            return hashMap;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getSoggettiDefault error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

