/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerGestoreRepositoryEGovException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class TimerGestoreRepositoryEGovThread
extends Thread {
    private static final long serialVersionUID = 1L;
    private long timeout = 10L;
    private long scadenzaMessaggio = 7200L;
    private OpenSPCoopProperties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger log;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;
    private boolean stop = false;

    public TimerGestoreRepositoryEGovThread() throws TimerGestoreRepositoryEGovException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new TimerGestoreRepositoryEGovException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreRepositoryEGov");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreRepositoryEGov.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_REPOSITORY_EGOV@", "GestoreRepositoryEGov");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new TimerGestoreRepositoryEGovException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestoreRepositoryEGov");
        }
        try {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new TimerGestoreRepositoryEGovException("Riscontrato errore durante la lettura delle configurazione per il Thread GestoreRepositoryEGov");
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String sec = "secondi";
        if (this.timeout == 1L) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + sec);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        String s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreRepositoryEGovAbilitatoLog();
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void run() {
        block4: while (!this.stop) {
            try {
                this.checkRepositoryEGov();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "checkRepositoryEGov()");
            }
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue block4;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRepositoryEGov() throws TimerGestoreRepositoryEGovException {
        if (!this.propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
            return;
        }
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
            return;
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreRepositoryEGov] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.lowDebug("Gestione precedente del controllo Repository Buste e-Gov ancora in corso...");
            return;
        }
        this.gestioneAttiva = true;
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("controlloInCorso"), this.msgDiag.getLivello("controlloInCorso"));
        RepositoryEGov repositoryEGov = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreRepositoryEGov");
            repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta());
            RepositoryEGov rBuste = new RepositoryEGov(openspcoopstate.getStatoRichiesta());
            Vector idMsgINBOX = rBuste.getBusteDaEliminareFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            Vector idMsgOUTBOX = rBuste.getBusteDaEliminareFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            while (idMsgINBOX.size() > 0 || idMsgOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_BUSTE_INBOX@", idMsgINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_BUSTE_OUTBOX@", idMsgOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricercaMessaggiDaEliminare"), this.msgDiag.getLivello("ricercaMessaggiDaEliminare"));
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgINBOX.size(); ++i) {
                    idMsgDaEliminare = (String)idMsgINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        repositoryEGov.eliminaBustaFromInBox(idMsgDaEliminare);
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgOUTBOX.size(); ++i) {
                    idMsgDaEliminare = (String)idMsgOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        repositoryEGov.eliminaBustaFromOutBox(idMsgDaEliminare);
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                idMsgINBOX = rBuste.getBusteDaEliminareFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
                idMsgOUTBOX = rBuste.getBusteDaEliminareFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBuste");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
            this.gestioneAttiva = false;
        }
    }
}

