/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.log4j.Logger;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.utils.date.DateManager;

public class TimerGestoreRepositoryEGovImpl
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    private SessionContext sessionContext;
    private Timer timer;
    private long timeout = 10L;
    private long scadenzaMessaggio = 7200L;
    private OpenSPCoopProperties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger log;
    private boolean deployFromOpenSPCoop = false;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;

    public void ejbCreate() throws CreateException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new CreateException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreRepositoryEGov");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreRepositoryEGov.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_REPOSITORY_EGOV@", "GestoreRepositoryEGov");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestoreRepositoryEGov");
        }
        try {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new CreateException("Riscontrato errore durante la lettura delle configurazione per il Thread GestoreRepositoryEGov");
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String sec = "secondi";
        if (this.timeout == 1L) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + sec);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        String s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreRepositoryEGovAbilitatoLog();
    }

    public void ejbRemove() throws EJBException {
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbTimeout(Timer timer) throws EJBException {
        if (!this.deployFromOpenSPCoop) {
            this.stop(timer);
            return;
        }
        if (!this.propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
            this.stop(timer);
            return;
        }
        if (timer == null || !OpenSPCoopStartup.initialize) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
            this.stop(timer);
            return;
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreRepositoryEGov] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.lowDebug("Gestione precedente del controllo Repository Buste e-Gov ancora in corso...");
            return;
        }
        this.gestioneAttiva = true;
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("controlloInCorso"), this.msgDiag.getLivello("controlloInCorso"));
        RepositoryEGov repositoryEGov = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreRepositoryEGov");
            repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta());
            RepositoryEGov rBuste = new RepositoryEGov(openspcoopstate.getStatoRichiesta());
            Vector idMsgINBOX = rBuste.getBusteDaEliminareFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            Vector idMsgOUTBOX = rBuste.getBusteDaEliminareFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            while (idMsgINBOX.size() > 0 || idMsgOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_BUSTE_INBOX@", idMsgINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_BUSTE_OUTBOX@", idMsgOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricercaMessaggiDaEliminare"), this.msgDiag.getLivello("ricercaMessaggiDaEliminare"));
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgINBOX.size(); ++i) {
                    idMsgDaEliminare = (String)idMsgINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        repositoryEGov.eliminaBustaFromInBox(idMsgDaEliminare);
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgOUTBOX.size(); ++i) {
                    idMsgDaEliminare = (String)idMsgOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        repositoryEGov.eliminaBustaFromOutBox(idMsgDaEliminare);
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                idMsgINBOX = rBuste.getBusteDaEliminareFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
                idMsgOUTBOX = rBuste.getBusteDaEliminareFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBuste");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
            this.gestioneAttiva = false;
        }
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.sessionContext = aContext;
    }

    public boolean start() throws EJBException {
        if (this.timer != null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("timerGiaAvviato"), this.msgDiag.getLivello("timerGiaAvviato"));
            return false;
        }
        if (this.propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
            this.deployFromOpenSPCoop = true;
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("avvioInCorso"), this.msgDiag.getLivello("avvioInCorso"));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Date now = DateManager.getDate();
            long timeout = 1000L * this.timeout;
            try {
                TimerService ts = this.sessionContext.getTimerService();
                this.timer = ts.createTimer(now, timeout, (Serializable)((Object)"GestoreRepositoryEGov"));
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("avvioEffettuato"), this.msgDiag.getLivello("avvioEffettuato"));
            }
            catch (Exception e) {
                this.stop();
                this.msgDiag.fatalOpenSPCoop("Impossibile creare il timer gestore del Repository e-Gov");
            }
            return this.timer != null;
        }
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
        return false;
    }

    public boolean isStarted() throws EJBException {
        return this.timer != null;
    }

    public void stop(Timer atimer) throws EJBException {
        if (atimer != null) {
            atimer.cancel();
        }
    }

    public void stop() throws EJBException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

