/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerGestorePuliziaMessaggiAnomaliThreadException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class TimerGestorePuliziaMessaggiAnomaliThread
extends Thread {
    private static final long serialVersionUID = 1L;
    private long timeout = 10L;
    private OpenSPCoopProperties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger log = null;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;
    private boolean stop = false;

    public TimerGestorePuliziaMessaggiAnomaliThread() throws TimerGestorePuliziaMessaggiAnomaliThreadException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new TimerGestorePuliziaMessaggiAnomaliThreadException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreConsistenzaDatabase");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new TimerGestorePuliziaMessaggiAnomaliThreadException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestorePuliziaMessaggiAnomali");
        }
        try {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new TimerGestorePuliziaMessaggiAnomaliThreadException("Riscontrato errore durante la lettura delle configurazione per il Thread GestorePuliziaMessaggiAnomali");
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog();
    }

    public void run() {
        block4: while (!this.stop) {
            try {
                this.checkGestorePuliziaMessaggiAnomali();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "checkGestorePuliziaMessaggiAnomali()");
            }
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue block4;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkGestorePuliziaMessaggiAnomali() throws TimerGestorePuliziaMessaggiAnomaliThreadException {
        if (!this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
            return;
        }
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
            return;
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreConsistenzaDatabase] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.lowDebug("Gestione precedente della pulizia messaggi anomali ancora in corso...");
            return;
        }
        this.gestioneAttiva = true;
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("controlloInCorso"), this.msgDiag.getLivello("controlloInCorso"));
        RollbackRepositoryEGov rollbackEGovMessaggio = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreConsistenzaDatabase");
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.msgDiag);
            Vector<String> busteEGovInutiliINBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            Vector<String> busteEGovInutiliOUTBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            while (busteEGovInutiliINBOX.size() > 0 || busteEGovInutiliOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_INBOX@", busteEGovInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_OUTBOX@", busteEGovInutiliOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricercaMessaggiDaEliminare"), this.msgDiag.getLivello("ricercaMessaggiDaEliminare"));
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < busteEGovInutiliINBOX.size(); ++i) {
                    idMsgDaEliminare = busteEGovInutiliINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoInBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < busteEGovInutiliOUTBOX.size(); ++i) {
                    idMsgDaEliminare = busteEGovInutiliOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                busteEGovInutiliINBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
                busteEGovInutiliOUTBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiInconsistenti");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
            this.gestioneAttiva = false;
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }
}

