/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.utils.date.DateManager;

public class TimerGestorePuliziaMessaggiAnomaliImpl
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    private SessionContext sessionContext;
    private Timer timer;
    private long timeout = 10L;
    private OpenSPCoopProperties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger log = null;
    private boolean deployFromOpenSPCoop = false;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;

    public void ejbCreate() throws CreateException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new CreateException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreConsistenzaDatabase");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestorePuliziaMessaggiAnomali");
        }
        try {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new CreateException("Riscontrato errore durante la lettura delle configurazione per il Thread GestorePuliziaMessaggiAnomali");
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog();
    }

    public void ejbRemove() throws EJBException {
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbTimeout(Timer timer) throws EJBException {
        if (!this.deployFromOpenSPCoop) {
            this.stop(timer);
            return;
        }
        if (!this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
            this.stop(timer);
            return;
        }
        if (timer == null || !OpenSPCoopStartup.initialize) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
            this.stop(timer);
            return;
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreConsistenzaDatabase] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.lowDebug("Gestione precedente della pulizia messaggi anomali ancora in corso...");
            return;
        }
        this.gestioneAttiva = true;
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("controlloInCorso"), this.msgDiag.getLivello("controlloInCorso"));
        RollbackRepositoryEGov rollbackEGovMessaggio = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreConsistenzaDatabase");
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.msgDiag);
            Vector<String> busteEGovInutiliINBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            Vector<String> busteEGovInutiliOUTBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            while (busteEGovInutiliINBOX.size() > 0 || busteEGovInutiliOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_INBOX@", busteEGovInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_OUTBOX@", busteEGovInutiliOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricercaMessaggiDaEliminare"), this.msgDiag.getLivello("ricercaMessaggiDaEliminare"));
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < busteEGovInutiliINBOX.size(); ++i) {
                    idMsgDaEliminare = busteEGovInutiliINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoInBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < busteEGovInutiliOUTBOX.size(); ++i) {
                    idMsgDaEliminare = busteEGovInutiliOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                busteEGovInutiliINBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromInBox(200, this.logQuery, this.propertiesReader.isForceIndex());
                busteEGovInutiliOUTBOX = gestoreMsgSearch.readBusteEGovNonRiferiteDaMessaggiFromOutBox(200, this.logQuery, this.propertiesReader.isForceIndex());
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiInconsistenti");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
            this.gestioneAttiva = false;
        }
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.sessionContext = aContext;
    }

    public boolean start() throws EJBException {
        if (this.timer != null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("timerGiaAvviato"), this.msgDiag.getLivello("timerGiaAvviato"));
            return false;
        }
        if (this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
            this.deployFromOpenSPCoop = true;
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("avvioInCorso"), this.msgDiag.getLivello("avvioInCorso"));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Date now = DateManager.getDate();
            long timeout = 1000L * this.timeout;
            try {
                TimerService ts = this.sessionContext.getTimerService();
                this.timer = ts.createTimer(now, timeout, (Serializable)((Object)"GestoreConsistenzaDatabase"));
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("avvioEffettuato"), this.msgDiag.getLivello("avvioEffettuato"));
            }
            catch (Exception e) {
                this.stop();
                this.msgDiag.fatalOpenSPCoop("Impossibile creare il timer Gestore dei Messaggi");
            }
            return this.timer != null;
        }
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
        return false;
    }

    public boolean isStarted() throws EJBException {
        return this.timer != null;
    }

    public void stop(Timer atimer) throws EJBException {
        if (atimer != null) {
            atimer.cancel();
        }
    }

    public void stop() throws EJBException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

