/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.JMSReceiver;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerGestoreMessaggiThreadException;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;

public class TimerGestoreMessaggiThread
extends Thread {
    private long timeout = 10L;
    private long scadenzaMessaggio = 7200L;
    private OpenSPCoopProperties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger log = null;
    private boolean logQuery = false;
    private boolean stop = false;
    private boolean gestioneAttiva = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerGestoreMessaggiThread() throws TimerGestoreMessaggiThreadException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new TimerGestoreMessaggiThreadException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreMessaggi");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new TimerGestoreMessaggiThreadException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestoreMessaggi");
        }
        this.msgDiag.lowDebug("Avvio TimerGestoreMessaggiThread...");
        try {
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreMessaggiThread");
            throw new TimerGestoreMessaggiThreadException("Riscontrato errore durante la lettura delle configurazione per il Thread GestoreMessaggi");
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreMessaggiAbilitatoLog();
        this.msgDiag.lowDebug("TimerGestoreMessaggiThread avviato");
    }

    public void run() {
        block4: while (!this.stop) {
            try {
                this.checkGestoreMessaggi();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "checkGestoreMessaggi()");
            }
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue block4;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkGestoreMessaggi() throws TimerGestoreMessaggiThreadException {
        if (!this.propertiesReader.isTimerGestoreMessaggiAbilitato()) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
            this.log.info((Object)("[check] isTimerGestoreMessaggiAbilitato:" + this.propertiesReader.isTimerGestoreMessaggiAbilitato()));
            return;
        }
        if (!OpenSPCoopStartup.initialize) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
            throw new TimerGestoreMessaggiThreadException("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreMessaggi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.lowDebug("Gestione precedente del controllo Repository Messaggi ancora in corso...");
            return;
        }
        this.gestioneAttiva = true;
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("controlloInCorso"), this.msgDiag.getLivello("controlloInCorso"));
        GestoreMessaggi gestoreMsg = null;
        RollbackRepositoryEGov rollbackEGovMessaggio = null;
        RollbackRepositoryEGov rollbackEGovRepository = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreMessaggi");
            JMSReceiver receiverJMS = null;
            if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                receiverJMS = new JMSReceiver(this.propertiesReader.getIdentificativoPortaDefault(), "ForcedDeleteMessage", this.propertiesReader.singleConnection_NodeReceiver());
            }
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.msgDiag);
            Vector<String> idMsgInutiliINBOX = gestoreMsgSearch.readMessaggiInutiliIntoInbox("GestoreMessaggi", 200, this.logQuery);
            Vector<String> idMsgInutiliOUTBOX = gestoreMsgSearch.readMessaggiInutiliIntoOutbox("GestoreMessaggi", 200, this.logQuery);
            Vector<String> idMsgScadutiINBOX = gestoreMsgSearch.readMessaggiScadutiIntoInbox(this.scadenzaMessaggio, 200, this.logQuery);
            Vector<String> idMsgScadutiOUTBOX = gestoreMsgSearch.readMessaggiScadutiIntoOutbox(this.scadenzaMessaggio, 200, this.logQuery);
            long timeoutRicezioneContenutiApplicativiNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi() * 3L;
            Vector<String> idMsgServizioRicezioneContenutiApplicativiNonGestiti = gestoreMsgSearch.readMsgForRicezioneContenutiApplicativiNonGestiti(timeoutRicezioneContenutiApplicativiNonGestiti, 200, this.logQuery);
            long timeoutRicezioneBusteEGovNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneBusteEgov() * 3L;
            Vector<String> idMsgServizioRicezioneBusteEGovNonGestiti = gestoreMsgSearch.readMsgForRicezioneBusteEGovNonGestiti(timeoutRicezioneBusteEGovNonGestiti, 200, this.logQuery);
            while (idMsgInutiliINBOX.size() > 0 || idMsgInutiliOUTBOX.size() > 0 || idMsgScadutiINBOX.size() > 0 || idMsgScadutiOUTBOX.size() > 0 || idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() > 0 || idMsgServizioRicezioneBusteEGovNonGestiti.size() > 0) {
                String strMessageSelector;
                String rifMsg;
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_INBOX@", idMsgInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_OUTBOX@", idMsgInutiliOUTBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_INBOX@", idMsgScadutiINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_OUTBOX@", idMsgScadutiOUTBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_CONTENUTI_APPLICATIVI@", idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_BUSTE_EGOV@", idMsgServizioRicezioneBusteEGovNonGestiti.size() + "");
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricercaMessaggiDaEliminare"), this.msgDiag.getLivello("ricercaMessaggiDaEliminare"));
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgInutiliINBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgInutiliINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag);
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgInutiliOUTBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgInutiliOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag);
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgScadutiINBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgScadutiINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag);
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoInBox();
                        rifMsg = gestoreMsg.getRiferimentoMessaggio();
                        if (rifMsg == null) {
                            if (receiverJMS != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + idMsgDaEliminare + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBusteEGov");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("messaggioNonConsumato.codaJMS"), this.msgDiag.getLivello("messaggioNonConsumato.codaJMS"));
                            }
                        } else {
                            rollbackEGovRepository = new RollbackRepositoryEGov(rifMsg, openspcoopstate.getStatoRichiesta(), true);
                            rollbackEGovRepository.rollbackBustaIntoOutBox(false);
                            if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("messaggioNonConsumato.codaJMS"), this.msgDiag.getLivello("messaggioNonConsumato.codaJMS"));
                            }
                        }
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgScadutiOUTBOX.size(); ++i) {
                    idMsgDaEliminare = idMsgScadutiOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag);
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox();
                        rifMsg = gestoreMsg.getRiferimentoMessaggio();
                        if (rifMsg == null) {
                            if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + idMsgDaEliminare + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("messaggioNonConsumato.codaJMS"), this.msgDiag.getLivello("messaggioNonConsumato.codaJMS"));
                            }
                        } else {
                            rollbackEGovRepository = new RollbackRepositoryEGov(rifMsg, openspcoopstate.getStatoRichiesta(), true);
                            rollbackEGovRepository.rollbackBustaIntoInBox(false);
                            if (receiverJMS != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBusteEGov");
                                this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("messaggioNonConsumato.codaJMS"), this.msgDiag.getLivello("messaggioNonConsumato.codaJMS"));
                            }
                        }
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneContenutiApplicativi");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < idMsgServizioRicezioneContenutiApplicativiNonGestiti.size(); ++i) {
                    idMsgDaEliminare = idMsgServizioRicezioneContenutiApplicativiNonGestiti.get(i);
                    String idEGovDaEliminare = idMsgDaEliminare.split("@")[0];
                    String servizioApplicativoDaEliminare = idMsgDaEliminare.split("@")[1];
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idEGovDaEliminare);
                    try {
                        String strMessageSelector2;
                        String rifMsg2;
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idEGovDaEliminare, "INBOX", this.msgDiag);
                        if (receiverJMS != null && (rifMsg2 = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector2 = "ID = '" + rifMsg2 + "'")) {
                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("messaggioNonConsumato.codaJMS"), this.msgDiag.getLivello("messaggioNonConsumato.codaJMS"));
                        }
                        gestoreMsg.eliminaDestinatarioMessaggio(servizioApplicativoDaEliminare, gestoreMsg.getRiferimentoMessaggio());
                        if (!gestoreMsg.existsServiziApplicativiDestinatariMessaggio()) {
                            rollbackEGovMessaggio = new RollbackRepositoryEGov(idEGovDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                            rollbackEGovMessaggio.rollbackBustaIntoInBox();
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        }
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneDestinatarioMessaggio"), this.msgDiag.getLivello("eliminazioneDestinatarioMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + ")");
                    }
                }
                this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneBusteEGov");
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < idMsgServizioRicezioneBusteEGovNonGestiti.size(); ++i) {
                    idMsgDaEliminare = idMsgServizioRicezioneBusteEGovNonGestiti.get(i);
                    this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag);
                        rollbackEGovMessaggio = new RollbackRepositoryEGov(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackEGovMessaggio.rollbackBustaIntoOutBox();
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        if (receiverJMS != null && (rifMsg = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneBusteEGov", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBusteEGov");
                            this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("messaggioNonConsumato.codaJMS"), this.msgDiag.getLivello("messaggioNonConsumato.codaJMS"));
                        }
                        gestoreMsg.deleteMessage();
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneMessaggio"), this.msgDiag.getLivello("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackEGovMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackEGovMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneBusteEGovNonGestiti(" + idMsgDaEliminare + ")");
                    }
                }
                idMsgInutiliINBOX = gestoreMsgSearch.readMessaggiInutiliIntoInbox("GestoreMessaggi", 200, this.logQuery);
                idMsgInutiliOUTBOX = gestoreMsgSearch.readMessaggiInutiliIntoOutbox("GestoreMessaggi", 200, this.logQuery);
                idMsgScadutiINBOX = gestoreMsgSearch.readMessaggiScadutiIntoInbox(this.scadenzaMessaggio, 200, this.logQuery);
                idMsgScadutiOUTBOX = gestoreMsgSearch.readMessaggiScadutiIntoOutbox(this.scadenzaMessaggio, 200, this.logQuery);
                idMsgServizioRicezioneContenutiApplicativiNonGestiti = gestoreMsgSearch.readMsgForRicezioneContenutiApplicativiNonGestiti(timeoutRicezioneContenutiApplicativiNonGestiti, 200, this.logQuery);
                idMsgServizioRicezioneBusteEGovNonGestiti = gestoreMsgSearch.readMsgForRicezioneBusteEGovNonGestiti(timeoutRicezioneBusteEGovNonGestiti, 200, this.logQuery);
            }
            GestoreCorrelazioneApplicativa gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), this.log);
            int offsetCorrelazioni = 0;
            Vector<Long> correlazioni = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(200, offsetCorrelazioni, this.logQuery);
            this.msgDiag.addKeyword("@TIPO_RICERCA@", "CorrelazioniApplicative");
            while (correlazioni.size() > 0) {
                this.msgDiag.addKeyword("@NUMERO_CORRELAZIONI_APPLICATIVE@", correlazioni.size() + "");
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricercaCorrelazioniApplicativeScadute"), this.msgDiag.getLivello("ricercaCorrelazioniApplicativeScadute"));
                while (correlazioni.size() > 0) {
                    Long idCorrelazioneScaduta = correlazioni.remove(0);
                    String idEGovCorrelato = null;
                    String idApplicativo = null;
                    try {
                        String[] id = gestoreCorrelazioneApplicativa.getIDMappingCorrelazioneApplicativa(idCorrelazioneScaduta);
                        this.msgDiag.addKeyword("@ID_EGOV_DA_ELIMINARE@", id[0]);
                        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", id[1]);
                        gestoreCorrelazioneApplicativa.deleteCorrelazioneApplicativa(idCorrelazioneScaduta);
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("eliminazioneCorrelazioneApplicativaScaduta"), this.msgDiag.getLivello("eliminazioneCorrelazioneApplicativaScaduta"));
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_egov:" + idEGovCorrelato + ")");
                    }
                }
                correlazioni = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(200, offsetCorrelazioni += correlazioni.size(), this.logQuery);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggi");
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
            this.gestioneAttiva = false;
        }
    }
}

