/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.timers;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.Riscontri;
import org.openspcoop.egov.RollbackRepositoryEGov;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.EJBUtils;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.InoltroBusteEGovMessage;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.date.DateManager;

public class TimerGestoreBusteNonRiscontrateImpl
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    private SessionContext sessionContext;
    private Timer timer;
    private long timeout = 10L;
    private OpenSPCoopProperties propertiesReader;
    private ConfigurazionePdDReader configurazionePdDReader;
    private RegistroServiziReader registroServiziReader;
    private MsgDiagnostico msgDiag;
    private Logger log;
    private boolean deployFromOpenSPCoop = false;
    private boolean gestioneAttiva = false;
    private boolean logQuery = false;
    private static INodeSender nodeSender = null;
    private static String tipoNodeSender = null;

    public void ejbCreate() throws CreateException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoopStartup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new CreateException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreBusteNonRiscontrate");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreRiscontriRicevute.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_RISCONTRI_RICEVUTE@", "GestoreBusteNonRiscontrate");
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico per il Thread GestoreBusteNonRiscontrate");
        }
        try {
            this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        }
        catch (Exception e) {
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del Reader della Configurazione");
        }
        if (this.configurazionePdDReader.getTimeoutRiscontro() < 1L) {
            this.msgDiag.logErroreGenerico("timeout per le buste non riscontrate: is <= 0 ??", "getTimeoutRiscontro()");
            throw new CreateException("Riscontrato errore durante la lettura del timeout per le buste non riscontrate");
        }
        try {
            this.registroServiziReader = RegistroServiziReader.getInstance();
        }
        catch (Exception e) {
            throw new CreateException("Riscontrato Errore durante l'inizializzazione del Reader del registro dei Servizi");
        }
        try {
            this.timeout = this.configurazionePdDReader.getTimeoutRiscontro();
            String minuti = "minuti";
            if (this.timeout == 1L) {
                minuti = "minuto";
            }
            this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + minuti);
            this.propertiesReader = OpenSPCoopProperties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            throw new CreateException("Riscontrato errore durante la lettura dellea configurazione per il Thread GestoreBusteNonRiscontrate");
        }
        if (nodeSender == null) {
            try {
                nodeSender = EJBUtils.getNodeSender(this.propertiesReader, this.log);
                tipoNodeSender = this.propertiesReader.getNodeSender();
            }
            catch (Exception e) {
                throw new CreateException("Riscontrato errore durante l'inizializzazione del Thread GestoreBusteNonRiscontrate: " + e.getMessage());
            }
        }
        this.logQuery = this.propertiesReader.isTimerGestoreRiscontriRicevuteAbilitatoLog();
    }

    public void ejbRemove() throws EJBException {
    }

    public void ejbActivate() throws EJBException {
    }

    public void ejbPassivate() throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbTimeout(Timer timer) throws EJBException {
        if (!this.deployFromOpenSPCoop) {
            this.stop(timer);
            return;
        }
        if (!this.propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
            this.stop(timer);
            return;
        }
        if (timer == null || !OpenSPCoopStartup.initialize) {
            this.msgDiag.fatalOpenSPCoop("Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata");
            this.stop(timer);
            return;
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.log.error((Object)("[GestoreBusteNonRiscontrate] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (this.gestioneAttiva) {
            this.msgDiag.lowDebug("Gestione precedente del controllo Riscontri/Ricevute ancora in corso...");
            return;
        }
        this.gestioneAttiva = true;
        if (this.configurazionePdDReader.getTimeoutRiscontro() < 1L) {
            this.msgDiag.logErroreGenerico("timeout per le buste non riscontrate: is <= 0 ??", "getTimeoutRiscontro()");
            return;
        }
        this.timeout = this.configurazionePdDReader.getTimeoutRiscontro();
        String minuti = "minuti";
        if (this.timeout == 1L) {
            minuti = "minuto";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + minuti);
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("controlloInCorso"), this.msgDiag.getLivello("controlloInCorso"));
        GestoreMessaggi gestoreMsg = null;
        RepositoryEGov repositoryEGov = null;
        Riscontri gestoreRiscontri = null;
        RollbackRepositoryEGov rollbackRepositoryEGov = null;
        OpenSPCoopStateful openspcoopState = new OpenSPCoopStateful();
        try {
            openspcoopState.initResource(this.propertiesReader.getIdentitaPortaDefault(), "GestoreBusteNonRiscontrate");
            Riscontri rBuste = new Riscontri(openspcoopState.getStatoRichiesta());
            int offsetRiscontri = 0;
            Vector busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, 200, offsetRiscontri, this.logQuery);
            while (busteOneWayToSend != null && busteOneWayToSend.size() > 0) {
                for (int i = 0; i < busteOneWayToSend.size(); ++i) {
                    Busta bustaToSend = (Busta)busteOneWayToSend.get(i);
                    this.msgDiag.addKeywords(bustaToSend, true);
                    Date scadenza = bustaToSend.getScadenza();
                    Timestamp now = DateManager.getTimestamp();
                    if (scadenza.before(now)) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("bustaNonRiscontrataScaduta"), this.msgDiag.getLivello("bustaNonRiscontrataScaduta"));
                        try {
                            repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                            repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                            gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                            gestoreMsg.validateAndDeleteMsgOneWayRiscontrato();
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataScaduta(" + bustaToSend.getID() + ")");
                        }
                        continue;
                    }
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("bustaNonRiscontrata"), this.msgDiag.getLivello("bustaNonRiscontrata"));
                    try {
                        ServizioApplicativo sa;
                        IDPortaDelegata idPD;
                        RichiestaDelegata richiestaDelegata;
                        ProprietaErroreApplicativo erroreAppl;
                        IDServizio servizioBusta;
                        block58: {
                            GestoreMessaggi messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.log, this.msgDiag);
                            if (!messaggioDaInviare.existsMessage_noCache()) {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("bustaNonRiscontrata.messaggioNonEsistente"), this.msgDiag.getLivello("bustaNonRiscontrata.messaggioNonEsistente"));
                                try {
                                    repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                                    repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                                    gestoreRiscontri = new Riscontri(openspcoopState.getStatoRichiesta());
                                    gestoreRiscontri.validazioneRiscontroRicevuto(bustaToSend.getID());
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataNonEsistente(" + bustaToSend.getID() + ")");
                                }
                                continue;
                            }
                            IDSoggetto soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                            IDSoggetto identitaPdD = null;
                            String dominioRD = null;
                            try {
                                dominioRD = this.configurazionePdDReader.getDominio(soggettoBustaNonRiscontrata);
                                if (dominioRD == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "BustaNonRiscontrata getDominio(" + soggettoBustaNonRiscontrata + ")");
                            }
                            identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault() : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                            servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                            repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                            Integrazione infoIntegrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                            erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD();
                            erroreAppl.setDominio(identitaPdD.getCodicePorta());
                            richiestaDelegata = new RichiestaDelegata(soggettoBustaNonRiscontrata, infoIntegrazione.getLocationPD(), infoIntegrazione.getServizioApplicativo(), servizioBusta, infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                            richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                            richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                            richiestaDelegata.setIdCollaborazione(bustaToSend.getCollaborazione());
                            richiestaDelegata.setProfiloCollaborazione(bustaToSend.getProfiloDiCollaborazione());
                            idPD = richiestaDelegata.getIdPortaDelegata();
                            idPD.setSoggettoFruitore(soggettoBustaNonRiscontrata);
                            sa = null;
                            String servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                            try {
                                if (servizioApplicativo != null) {
                                    this.configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block58;
                                throw e;
                            }
                        }
                        String implementazioneMittente = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente()), null);
                        String implementazioneDestinatario = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario()), null);
                        this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                        String profiloGestione = this.registroServiziReader.getProfiloGestioneFruizioneServizio(servizioBusta, null);
                        richiestaDelegata.setProfiloGestione(profiloGestione);
                        PortaDelegata pd = this.configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        boolean oneWayStateless = this.configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, bustaToSend.getProfiloDiCollaborazione());
                        boolean oneWayVersione11 = this.propertiesReader.isGestioneOnewayStateful_1_1() && !oneWayStateless;
                        InoltroBusteEGovMessage inoltroMSG = new InoltroBusteEGovMessage();
                        inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                        inoltroMSG.setBusta(bustaToSend);
                        inoltroMSG.setOneWayVersione11(oneWayVersione11);
                        if (oneWayVersione11) {
                            OpenSPCoopStateless stateless = new OpenSPCoopStateless();
                            StatelessMessage statelessMessage = new StatelessMessage();
                            statelessMessage.setBusta(bustaToSend);
                            stateless.setStatoRichiesta((IState)statelessMessage);
                            inoltroMSG.setOpenspcoopstate(stateless);
                        }
                        inoltroMSG.setImplementazionePdDSoggettoMittente(implementazioneMittente);
                        inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazioneDestinatario);
                        gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                        if ("db".equals(tipoNodeSender)) {
                            gestoreMsg.ripristinaMessaggio();
                            continue;
                        }
                        try {
                            nodeSender.send(inoltroMSG, "InoltroBusteEGov", this.msgDiag, this.propertiesReader.getIdentificativoPortaDefault(), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                            continue;
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBusteEGov)");
                            if (openspcoopState != null) {
                                openspcoopState.releaseResource();
                            }
                            this.gestioneAttiva = false;
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "RespedizioneBustaNonRiscontrata ErroreGenerale(" + bustaToSend.getID() + ")");
                    }
                }
                busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, 200, offsetRiscontri += busteOneWayToSend.size(), this.logQuery);
            }
            ProfiloDiCollaborazione pBuste = new ProfiloDiCollaborazione(openspcoopState.getStatoRichiesta());
            int offsetBusteAsincrone = 0;
            Vector busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, 200, offsetBusteAsincrone, this.logQuery);
            while (busteAsincroneToSend != null && busteAsincroneToSend.size() > 0) {
                for (int i = 0; i < busteAsincroneToSend.size(); ++i) {
                    Busta bustaToSend = (Busta)busteAsincroneToSend.get(i);
                    this.msgDiag.addKeywords(bustaToSend, true);
                    Date scadenza = bustaToSend.getScadenza();
                    Timestamp now = DateManager.getTimestamp();
                    if (scadenza.before(now)) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricevutaAsincronaNonRicevuta.bustaScaduta"), this.msgDiag.getLivello("ricevutaAsincronaNonRicevuta.bustaScaduta"));
                        try {
                            rollbackRepositoryEGov = new RollbackRepositoryEGov(bustaToSend.getID(), openspcoopState.getStatoRichiesta(), true);
                            rollbackRepositoryEGov.rollbackBustaIntoOutBox();
                            ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                            gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                            gestoreMsg.deleteMessage();
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaScaduta(" + bustaToSend.getID() + ")");
                        }
                        continue;
                    }
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricevutaAsincronaNonRicevuta"), this.msgDiag.getLivello("ricevutaAsincronaNonRicevuta"));
                    try {
                        ServizioApplicativo sa;
                        RichiestaDelegata richiestaDelegata;
                        ProprietaErroreApplicativo erroreAppl;
                        block59: {
                            GestoreMessaggi messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.log, this.msgDiag);
                            if (!messaggioDaInviare.existsMessage_noCache()) {
                                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("ricevutaAsincronaNonRicevuta.messaggioNonEsistente"), this.msgDiag.getLivello("ricevutaAsincronaNonRicevuta.messaggioNonEsistente"));
                                try {
                                    repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                                    repositoryEGov.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                                    rollbackRepositoryEGov = new RollbackRepositoryEGov(bustaToSend.getID(), openspcoopState.getStatoRichiesta(), true);
                                    rollbackRepositoryEGov.rollbackBustaIntoOutBox();
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaNonEsistente(" + bustaToSend.getID() + ")");
                                }
                                continue;
                            }
                            IDSoggetto soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                            IDSoggetto identitaPdD = null;
                            String dominioRD = null;
                            try {
                                dominioRD = this.configurazionePdDReader.getDominio(soggettoBustaNonRiscontrata);
                                if (dominioRD == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "BustaAsincrona getDominio(" + soggettoBustaNonRiscontrata + ")");
                            }
                            identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault() : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                            IDServizio servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                            repositoryEGov = new RepositoryEGov(openspcoopState.getStatoRichiesta(), true);
                            Integrazione infoIntegrazione = repositoryEGov.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                            erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD();
                            erroreAppl.setDominio(identitaPdD.getCodicePorta());
                            richiestaDelegata = new RichiestaDelegata(soggettoBustaNonRiscontrata, infoIntegrazione.getLocationPD(), infoIntegrazione.getServizioApplicativo(), servizioBusta, infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                            richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(bustaToSend.getProfiloDiCollaborazione()) && bustaToSend.getRiferimentoMessaggio() == null) {
                                richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                            } else {
                                richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                            }
                            richiestaDelegata.setRicevutaAsincrona(false);
                            IDPortaDelegata idPD = richiestaDelegata.getIdPortaDelegata();
                            idPD.setSoggettoFruitore(soggettoBustaNonRiscontrata);
                            sa = null;
                            String servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                            try {
                                if (servizioApplicativo != null) {
                                    this.configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block59;
                                throw e;
                            }
                        }
                        this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                        InoltroBusteEGovMessage inoltroMSG = new InoltroBusteEGovMessage();
                        inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                        inoltroMSG.setBusta(bustaToSend);
                        gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag);
                        if ("db".equals(tipoNodeSender)) {
                            gestoreMsg.ripristinaMessaggio();
                            continue;
                        }
                        try {
                            nodeSender.send(inoltroMSG, "InoltroBusteEGov", this.msgDiag, this.propertiesReader.getIdentificativoPortaDefault(), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                            continue;
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "Asincrono GenericLib.nodeSender.send(InoltroBusteEGov)");
                            if (openspcoopState != null) {
                                openspcoopState.releaseResource();
                            }
                            this.gestioneAttiva = false;
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Send non riuscita", (Throwable)e);
                        this.msgDiag.logErroreGenerico(e, "RespedizioneBustaAsincrona ErroreGenerale(" + bustaToSend.getID() + ")");
                    }
                }
                busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, 200, offsetBusteAsincrone += busteAsincroneToSend.size(), this.logQuery);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBusteNonRiscontrate");
            return;
        }
        finally {
            if (openspcoopState != null) {
                openspcoopState.releaseResource();
            }
            this.gestioneAttiva = false;
        }
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.sessionContext = aContext;
    }

    public boolean start() throws EJBException {
        if (this.timer != null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("timerGiaAvviato"), this.msgDiag.getLivello("timerGiaAvviato"));
            return false;
        }
        if (this.propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
            this.deployFromOpenSPCoop = true;
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("avvioInCorso"), this.msgDiag.getLivello("avvioInCorso"));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Date now = DateManager.getDate();
            long timeout = 60000L * this.timeout;
            try {
                TimerService ts = this.sessionContext.getTimerService();
                this.timer = ts.createTimer(now, timeout, (Serializable)((Object)"GestoreBusteNonRiscontrate"));
                this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("avvioEffettuato"), this.msgDiag.getLivello("avvioEffettuato"));
            }
            catch (Exception e) {
                this.stop();
                this.msgDiag.fatalOpenSPCoop("Impossibile creare il timer per la Gestione delle buste non riscontrate");
            }
            return this.timer != null;
        }
        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("disabilitato"), this.msgDiag.getLivello("disabilitato"));
        return false;
    }

    public boolean isStarted() throws EJBException {
        return this.timer != null;
    }

    public void stop(Timer atimer) throws EJBException {
        if (atimer != null) {
            atimer.cancel();
        }
    }

    public void stop() throws EJBException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

