/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services.skeleton;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.LetturaParametriBusta;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.pdd.services.ServicesUtils;
import org.openspcoop.pdd.services.skeleton.SPCoopException;
import org.openspcoop.pdd.services.skeleton.SPCoopHeaderInfo;
import org.openspcoop.pdd.services.skeleton.SPCoopMessage;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.utils.SoapUtils;
import org.w3c.dom.Element;

public class IntegrationManager
implements ServiceLifecycle {
    public static final String ID_MODULO = "IntegrationManager";
    private OpenSPCoopProperties propertiesReader;
    private ClassNameProperties className;
    private MsgDiagnostico msgDiag = null;
    private ConfigurazionePdDReader configurazionePdDReader;

    public void init(Object arg0) {
        this.propertiesReader = OpenSPCoopProperties.getInstance();
        this.className = ClassNameProperties.getInstance();
        this.msgDiag = new MsgDiagnostico(ID_MODULO);
        this.msgDiag.setPrefixMsgPersonalizzati("integrationManager.");
        this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
    }

    public void destroy() {
    }

    private String autenticazione() throws SPCoopException {
        MessageContext msgContext = MessageContext.getCurrentContext();
        Credenziali credenziali = (Credenziali)msgContext.getProperty("openspcoop.credenziali");
        String credenzialiFornite = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            credenzialiFornite = "(";
            if (credenziali.getUsername() != null) {
                credenzialiFornite = credenziali.getPassword() == null || "".equals(credenziali.getPassword()) ? credenzialiFornite + " Basic Username: " + credenziali.getUsername() + "  Basic Password: non definita" : credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
            }
            if (credenziali.getSubject() != null) {
                credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
            }
            credenzialiFornite = credenzialiFornite + ") ";
        }
        this.msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
        String servizio_applicativo = null;
        String tipoAutenticazione = this.configurazionePdDReader.getIntegrationManagerAuthentication();
        if ("none".equalsIgnoreCase(tipoAutenticazione)) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("autenticazioneNonImpostata"), this.msgDiag.getLivello("autenticazioneNonImpostata"));
            throw new SPCoopException("OPENSPCOOP_ORG_519", "Sistema non disponibile");
        }
        String authClass = this.className.getAutenticazione(tipoAutenticazione);
        IAutenticazione auth = null;
        try {
            Class<?> c = Class.forName(authClass);
            auth = (IAutenticazione)c.newInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione + ") Class.forName(" + authClass + ")");
            throw new SPCoopException("OPENSPCOOP_ORG_503", "Sistema non disponibile");
        }
        if (!auth.process(credenziali)) {
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", auth.getMsgError());
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("servizioApplicativo.identificazioneTramiteCredenziali"), this.msgDiag.getLivello("servizioApplicativo.identificazioneTramiteCredenziali"));
            throw new SPCoopException(auth.getCodiceErrore(), auth.getMsgError());
        }
        servizio_applicativo = auth.getServizioApplicativo();
        if (servizio_applicativo == null) {
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio applicativo non autenticato");
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("servizioApplicativo.identificazioneTramiteCredenziali"), this.msgDiag.getLivello("servizioApplicativo.identificazioneTramiteCredenziali"));
            throw new SPCoopException("OPENSPCOOP_ORG_503", "Sistema non disponibile");
        }
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizio_applicativo);
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizio_applicativo);
        return servizio_applicativo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getAllMessagesId_engine(String tipoServizio, String servizio, String azione, int counter) throws SPCoopException {
        String[] stringArray;
        String tipoOperazione = null;
        tipoOperazione = counter < 0 ? (servizio == null && azione == null ? "getAllMessagesId" : "getAllMessagesIdByService") : (servizio == null && azione == null ? "getNextMessagesId" : "getNextMessagesIdByService");
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            throw new SPCoopException("OPENSPCOOP_ORG_532", "Sistema non disponibile");
        }
        String servizio_applicativo = null;
        OpenSPCoopState stato = null;
        try {
            try {
                servizio_applicativo = this.autenticazione();
                String tipoServizioLog = "";
                String servizioLog = "";
                String azioneLog = "";
                String counterLog = "";
                if (tipoServizio != null) {
                    tipoServizioLog = " tipoServizio[" + tipoServizio + "]";
                }
                if (servizio != null) {
                    servizioLog = " servizio[" + servizio + "]";
                }
                if (azione != null) {
                    azioneLog = " azione[" + azione + "]";
                }
                if (counter >= 0) {
                    counterLog = " counter[" + counter + "]";
                }
                this.msgDiag.lowDebug(tipoOperazione + " ServizioApplicativo[" + servizio_applicativo + "]" + tipoServizioLog + servizioLog + azioneLog + counterLog);
                Vector<String> ids = null;
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, this.msgDiag);
                ids = counter < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione) : gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione, counter);
                if (ids.size() == 0) {
                    this.msgDiag.lowDebug("[" + tipoOperazione + "] Nessun messaggio rilevato per il servizio applicativo: " + servizio_applicativo);
                    throw new SPCoopException("OPENSPCOOP_ORG_406", "Non sono stati rilevati messaggi per il servizio applicativo", servizio_applicativo);
                }
                String[] idsResponse = new String[ids.size()];
                stringArray = idsResponse = ids.toArray(idsResponse);
                Object var18_18 = null;
            }
            catch (Exception e) {
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                this.msgDiag.logErroreGenerico(e, "getAllMessagesId(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            try {
                if (stato == null) throw throwable;
                stato.releaseResource();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return stringArray;
        }
        if (stato == null) return stringArray;
        stato.releaseResource();
        return stringArray;
    }

    public String[] getAllMessagesId() throws SPCoopException {
        return this.getAllMessagesId_engine(null, null, null, -1);
    }

    public String[] getAllMessagesIdByService(String tipoServizio, String servizio, String azione) throws SPCoopException {
        return this.getAllMessagesId_engine(tipoServizio, servizio, azione, -1);
    }

    public String[] getNextMessagesId(int counter) throws SPCoopException {
        return this.getAllMessagesId_engine(null, null, null, counter);
    }

    public String[] getNextMessagesIdByService(int counter, String tipoServizio, String servizio, String azione) throws SPCoopException {
        return this.getAllMessagesId_engine(tipoServizio, servizio, azione, counter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SPCoopMessage getMessage_engine(String idEGov, boolean isRiferimentoMessaggio) throws SPCoopException {
        SPCoopMessage sPCoopMessage;
        String tipoOperazione = null;
        tipoOperazione = isRiferimentoMessaggio ? "getMessageByReference" : "getMessage";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (isRiferimentoMessaggio) {
            this.msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idEGov);
            this.msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idEGov);
        } else {
            this.msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGov);
            this.msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGov);
        }
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            throw new SPCoopException("OPENSPCOOP_ORG_532", "Sistema non disponibile");
        }
        String servizio_applicativo = null;
        OpenSPCoopState stato = null;
        try {
            try {
                SPCoopHeaderInfo spcoopHeaderInfo;
                GestoreMessaggi gestoreMessaggi;
                block28: {
                    servizio_applicativo = this.autenticazione();
                    this.msgDiag.lowDebug(tipoOperazione + " ServizioApplicativo[" + servizio_applicativo + "] ID[" + idEGov + "]");
                    stato = new OpenSPCoopStateful();
                    stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                    gestoreMessaggi = new GestoreMessaggi(stato, true, idEGov, "INBOX", this.msgDiag);
                    if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo, isRiferimentoMessaggio)) {
                        this.msgDiag.lowDebug("[" + tipoOperazione + "] Il messaggio richiesto con ID: " + idEGov + " non risulta esistere.");
                        throw new SPCoopException("OPENSPCOOP_ORG_407", "Non e' stato rilevato il messaggio richiesto dal servizio applicativo", servizio_applicativo);
                    }
                    boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo, isRiferimentoMessaggio);
                    if (!authorized) {
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("servizioApplicativo.nonAutorizzato"), this.msgDiag.getLivello("servizioApplicativo.nonAutorizzato"));
                        throw new SPCoopException("OPENSPCOOP_ORG_404", "Servizio non invocabile dal servizio applicativo ", servizio_applicativo);
                    }
                    String idMessaggioRichiesto = idEGov;
                    try {
                        if (isRiferimentoMessaggio) {
                            idMessaggioRichiesto = gestoreMessaggi.mapRiferimentoIntoIDEgov();
                        }
                    }
                    catch (Exception e) {
                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("mappingRifMsgToIdEGov.nonRiuscito"), this.msgDiag.getLivello("mappingRifMsgToIdEGov.nonRiuscito"));
                        throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                    }
                    RepositoryEGov repository = new RepositoryEGov(stato.getStatoRichiesta(), true);
                    spcoopHeaderInfo = null;
                    try {
                        LetturaParametriBusta parametri = new LetturaParametriBusta();
                        parametri.setMittente(true);
                        parametri.setDestinatario(true);
                        parametri.setRiferimentoMessaggio(true);
                        parametri.setServizio(true);
                        parametri.setAzione(true);
                        parametri.setCollaborazione(true);
                        Busta busta = repository.getSomeValuesFromInBox(idMessaggioRichiesto, parametri);
                        if (busta != null) {
                            spcoopHeaderInfo = new SPCoopHeaderInfo();
                            spcoopHeaderInfo.setID(idMessaggioRichiesto);
                            spcoopHeaderInfo.setRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                            spcoopHeaderInfo.setTipoMittente(busta.getTipoMittente());
                            spcoopHeaderInfo.setMittente(busta.getMittente());
                            spcoopHeaderInfo.setTipoDestinatario(busta.getTipoDestinatario());
                            spcoopHeaderInfo.setDestinatario(busta.getDestinatario());
                            spcoopHeaderInfo.setTipoServizio(busta.getTipoServizio());
                            spcoopHeaderInfo.setServizio(busta.getServizio());
                            spcoopHeaderInfo.setAzione(busta.getAzione());
                            spcoopHeaderInfo.setIdCollaborazione(busta.getCollaborazione());
                            busta.setID(idMessaggioRichiesto);
                            this.msgDiag.addKeywords(busta, true);
                        }
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "ReadInformazioniEGov(" + tipoOperazione + "," + idMessaggioRichiesto + ")");
                        if (e.getMessage() == null) throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                        if (e.getMessage().indexOf("Busta non trovata") >= 0) break block28;
                        throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                    }
                }
                boolean sbustamento_soap = gestoreMessaggi.sbustamentoSoap(servizio_applicativo, isRiferimentoMessaggio);
                Message consegnaAxisMessage = null;
                try {
                    consegnaAxisMessage = gestoreMessaggi.getMessage(isRiferimentoMessaggio);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "gestoreMessaggi.getMessage(" + isRiferimentoMessaggio + "," + tipoOperazione + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                }
                if (this.configurazionePdDReader.dumpMessaggi()) {
                    this.msgDiag.mediumDebug("Dump applicativo messaggio ritornato...");
                    Dump dumpApplicativo = new Dump(this.propertiesReader.getIdentificativoPortaDefault(), ID_MODULO, idEGov);
                    dumpApplicativo.dumpIntegrationManagerGetMessage(consegnaAxisMessage);
                }
                SPCoopMessage msgReturn = null;
                try {
                    if (!sbustamento_soap) {
                        msgReturn = new SPCoopMessage(consegnaAxisMessage, false, spcoopHeaderInfo);
                    } else {
                        byte[] sbustato = SoapUtils.sbustamentoMessaggio((Message)consegnaAxisMessage);
                        msgReturn = new SPCoopMessage(sbustato, false, spcoopHeaderInfo);
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "buildMsgReturn(" + idEGov + "," + tipoOperazione + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_523", "Sistema non disponibile", servizio_applicativo);
                }
                sPCoopMessage = msgReturn;
                Object var17_22 = null;
            }
            catch (Exception e) {
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                this.msgDiag.logErroreGenerico(e, "getMessage(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
            }
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            try {
                if (stato == null) throw throwable;
                stato.releaseResource();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return sPCoopMessage;
        }
        if (stato == null) return sPCoopMessage;
        stato.releaseResource();
        return sPCoopMessage;
    }

    public SPCoopMessage getMessage(String idEGov) throws SPCoopException {
        return this.getMessage_engine(idEGov, false);
    }

    public SPCoopMessage getMessageByReference(String riferimentoMsg) throws SPCoopException {
        return this.getMessage_engine(riferimentoMsg, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteMessage_engine(String idEGov, boolean isRiferimentoMessaggio) throws SPCoopException {
        String tipoOperazione = null;
        tipoOperazione = isRiferimentoMessaggio ? "deleteMessageByReference" : "deleteMessage";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (isRiferimentoMessaggio) {
            this.msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idEGov);
            this.msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idEGov);
        } else {
            this.msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGov);
            this.msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGov);
        }
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            throw new SPCoopException("OPENSPCOOP_ORG_532", "Sistema non disponibile");
        }
        GestoreMessaggi gestoreMessaggi = null;
        String servizio_applicativo = null;
        OpenSPCoopState stato = null;
        try {
            try {
                servizio_applicativo = this.autenticazione();
                this.msgDiag.lowDebug(tipoOperazione + " ServizioApplicativo[" + servizio_applicativo + "] ID[" + idEGov + "]");
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                gestoreMessaggi = new GestoreMessaggi(stato, true, idEGov, "INBOX", this.msgDiag);
                if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo, isRiferimentoMessaggio)) {
                    this.msgDiag.lowDebug("[" + tipoOperazione + "] Il messaggio richiesto con ID: " + idEGov + " non risulta esistere.");
                    throw new SPCoopException("OPENSPCOOP_ORG_407", "Non e' stato rilevato il messaggio richiesto dal servizio applicativo", servizio_applicativo);
                }
                boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo, isRiferimentoMessaggio);
                if (!authorized) {
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("servizioApplicativo.nonAutorizzato"), this.msgDiag.getLivello("servizioApplicativo.nonAutorizzato"));
                    throw new SPCoopException("OPENSPCOOP_ORG_404", "Servizio non invocabile dal servizio applicativo ", servizio_applicativo);
                }
                String idMessaggioRichiesto = idEGov;
                try {
                    if (isRiferimentoMessaggio) {
                        idMessaggioRichiesto = gestoreMessaggi.mapRiferimentoIntoIDEgov();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("mappingRifMsgToIdEGov.nonRiuscito"), this.msgDiag.getLivello("mappingRifMsgToIdEGov.nonRiuscito"));
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                }
                try {
                    GestoreMessaggi gestoreEliminazione = new GestoreMessaggi(stato, true, idMessaggioRichiesto, "INBOX", this.msgDiag);
                    gestoreEliminazione.eliminaDestinatarioMessaggio(servizio_applicativo, gestoreEliminazione.getRiferimentoMessaggio());
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + tipoOperazione + "," + servizio_applicativo + "," + idEGov + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_522", "Sistema non disponibile", servizio_applicativo);
                }
                Object var12_14 = null;
            }
            catch (Exception e) {
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                this.msgDiag.logErroreGenerico(e, "deleteMessage(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                if (stato == null) throw throwable;
                stato.releaseResource();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (stato == null) return;
        stato.releaseResource();
        return;
    }

    public void deleteMessage(String idEGov) throws SPCoopException {
        this.deleteMessage_engine(idEGov, false);
    }

    public void deleteMessageByReference(String riferimentoMsg) throws SPCoopException {
        this.deleteMessage_engine(riferimentoMsg, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteAllMessages() throws SPCoopException {
        Vector<String> ids;
        String tipoOperazione = "deleteAllMessages";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            logCore.error((Object)("[IntegrationManager][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            throw new SPCoopException("OPENSPCOOP_ORG_532", "Sistema non disponibile");
        }
        String servizio_applicativo = null;
        OpenSPCoopState stato = null;
        try {
            try {
                servizio_applicativo = this.autenticazione();
                this.msgDiag.lowDebug("deleteAllMessages SA[" + servizio_applicativo + "]");
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                GestoreMessaggi gestoreSearchID = new GestoreMessaggi(stato, true, this.msgDiag);
                ids = gestoreSearchID.getIDMessaggi_ServizioApplicativo(servizio_applicativo);
                if (ids.size() == 0) {
                    this.msgDiag.lowDebug("[" + tipoOperazione + "] Nessun messaggio rilevato per il servizio applicativo: " + servizio_applicativo);
                    throw new SPCoopException("OPENSPCOOP_ORG_406", "Non sono stati rilevati messaggi per il servizio applicativo", servizio_applicativo);
                }
                for (int i = 0; i < ids.size(); ++i) {
                    String idMessaggio = ids.get(i);
                    GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", this.msgDiag);
                    if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo)) {
                        this.msgDiag.lowDebug("[" + tipoOperazione + "] Il messaggio richiesto con ID: " + idMessaggio + " non risulta esistere.");
                        throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile", servizio_applicativo);
                    }
                    boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo);
                    if (authorized) continue;
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("servizioApplicativo.nonAutorizzato"), this.msgDiag.getLivello("servizioApplicativo.nonAutorizzato"));
                    throw new SPCoopException("OPENSPCOOP_ORG_404", "Servizio non invocabile dal servizio applicativo ", servizio_applicativo);
                }
            }
            catch (Exception e) {
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                this.msgDiag.logErroreGenerico(e, "deleteAllMessages(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile", servizio_applicativo);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                if (stato == null) throw throwable;
                stato.releaseResource();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        while (ids.size() > 0) {
            String idEGov = ids.remove(0);
            try {
                GestoreMessaggi gestoreEliminazione = new GestoreMessaggi(stato, true, idEGov, "INBOX", this.msgDiag);
                gestoreEliminazione.eliminaDestinatarioMessaggio(servizio_applicativo, gestoreEliminazione.getRiferimentoMessaggio());
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + tipoOperazione + "," + servizio_applicativo + "," + idEGov + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_522", "Sistema non disponibile", servizio_applicativo);
            }
        }
        Object var12_14 = null;
        try {}
        catch (Exception eClose) {
            return;
        }
        if (stato == null) return;
        stato.releaseResource();
    }

    private SPCoopMessage invocaPortaDelegata_engine(String tipoOperazione, String portaDelegata, SPCoopMessage msg, String idInvocazionePerRiferimento) throws SPCoopException {
        OpenSPCoopState stato;
        block56: {
            Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)ID_MODULO);
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                logCore.error((Object)("[IntegrationManager][InvocaPortaDelegata] PD(" + portaDelegata + ") Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                throw new SPCoopException("OPENSPCOOP_ORG_532", "Sistema non disponibile");
            }
            stato = null;
            MessageContext msgContext = MessageContext.getCurrentContext();
            Credenziali credenziali = (Credenziali)msgContext.getProperty("openspcoop.credenziali");
            String credenzialiFornite = "";
            if (credenziali != null) {
                if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                    credenzialiFornite = "(";
                    if (credenziali.getUsername() != null) {
                        credenzialiFornite = credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
                    }
                    if (credenziali.getSubject() != null) {
                        credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
                    }
                    credenzialiFornite = credenzialiFornite + ") ";
                }
                this.msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
            }
            String invPerRiferimento = "";
            if (idInvocazionePerRiferimento != null) {
                invPerRiferimento = " idInvocazionePerRiferimento[" + idInvocazionePerRiferimento + "]";
            }
            String riferimentoMessaggio = "";
            if (msg.getSpcoopHeaderInfo() != null && msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() != null) {
                riferimentoMessaggio = " riferimentoMessaggio[" + msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() + "]";
            }
            this.msgDiag.lowDebug(tipoOperazione + " PD[" + portaDelegata + "]" + credenzialiFornite + invPerRiferimento + riferimentoMessaggio);
            Message axisMsgRequest = null;
            if (idInvocazionePerRiferimento != null) {
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(), ID_MODULO);
                try {
                    GestoreMessaggi gestoreMessaggio = new GestoreMessaggi(stato, true, idInvocazionePerRiferimento, "INBOX", this.msgDiag);
                    axisMsgRequest = gestoreMessaggio.getMessage();
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "gestoreMessaggio.getMessagePerRiferimento(" + idInvocazionePerRiferimento + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
                }
                stato.releaseResource();
                stato = null;
            } else {
                try {
                    axisMsgRequest = SoapUtils.build((byte[])msg.getMessage(), (boolean)msg.getImbustamento(), (boolean)this.propertiesReader.isDeleteInstructionTargetMachineXml());
                }
                catch (Exception e) {
                    if (this.configurazionePdDReader.dumpMessaggi()) {
                        Dump dumpApplicativo = new Dump(ID_MODULO, "InvocaPortaDelegata", "Ricostruzione msg con errore per PD:" + portaDelegata);
                        dumpApplicativo.dumpRichiesta(msg.getMessage());
                    }
                    if (!msg.getImbustamento()) {
                        this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("buildMsg.nonRiuscito"), this.msgDiag.getLivello("buildMsg.nonRiuscito"));
                        throw new SPCoopException("OPENSPCOOP_ORG_421", "I byte inviati al servizio di ricezione contenuti applicativi non formano un messaggio soap: " + e.getMessage());
                    }
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("buildMsg.imbustamentoSOAP.nonRiuscito"), this.msgDiag.getLivello("buildMsg.imbustamentoSOAP.nonRiuscito"));
                    throw new SPCoopException("OPENSPCOOP_ORG_422", "I byte inviati al servizio di ricezione contenuti applicativi non sono utilizzabili per un imbustamento soap: " + e.getMessage());
                }
            }
            HeaderIntegrazione headerIntegrazioneRichiesta = new HeaderIntegrazione();
            SPCoopHeaderInfo spcoopHeaderInfo = msg.getSpcoopHeaderInfo();
            if (spcoopHeaderInfo != null) {
                if (spcoopHeaderInfo.getTipoMittente() != null && !"".equals(spcoopHeaderInfo.getTipoMittente())) {
                    headerIntegrazioneRichiesta.getEgov().setTipoMittente(spcoopHeaderInfo.getTipoMittente());
                }
                if (spcoopHeaderInfo.getMittente() != null && !"".equals(spcoopHeaderInfo.getMittente())) {
                    headerIntegrazioneRichiesta.getEgov().setMittente(spcoopHeaderInfo.getMittente());
                }
                if (spcoopHeaderInfo.getTipoDestinatario() != null && !"".equals(spcoopHeaderInfo.getTipoDestinatario())) {
                    headerIntegrazioneRichiesta.getEgov().setTipoDestinatario(spcoopHeaderInfo.getTipoDestinatario());
                }
                if (spcoopHeaderInfo.getDestinatario() != null && !"".equals(spcoopHeaderInfo.getDestinatario())) {
                    headerIntegrazioneRichiesta.getEgov().setDestinatario(spcoopHeaderInfo.getDestinatario());
                }
                if (spcoopHeaderInfo.getTipoServizio() != null && !"".equals(spcoopHeaderInfo.getTipoServizio())) {
                    headerIntegrazioneRichiesta.getEgov().setTipoServizio(spcoopHeaderInfo.getTipoServizio());
                }
                if (spcoopHeaderInfo.getServizio() != null && !"".equals(spcoopHeaderInfo.getServizio())) {
                    headerIntegrazioneRichiesta.getEgov().setServizio(spcoopHeaderInfo.getServizio());
                }
                if (spcoopHeaderInfo.getAzione() != null && !"".equals(spcoopHeaderInfo.getAzione())) {
                    headerIntegrazioneRichiesta.getEgov().setAzione(spcoopHeaderInfo.getAzione());
                }
                if (spcoopHeaderInfo.getID() != null && !"".equals(spcoopHeaderInfo.getID())) {
                    headerIntegrazioneRichiesta.getEgov().setID(spcoopHeaderInfo.getID());
                }
                if (spcoopHeaderInfo.getIdCollaborazione() != null && !"".equals(spcoopHeaderInfo.getIdCollaborazione())) {
                    headerIntegrazioneRichiesta.getEgov().setIdCollaborazione(spcoopHeaderInfo.getIdCollaborazione());
                }
                if (spcoopHeaderInfo.getRiferimentoMessaggio() != null && !"".equals(spcoopHeaderInfo.getRiferimentoMessaggio())) {
                    headerIntegrazioneRichiesta.getEgov().setRiferimentoMessaggio(spcoopHeaderInfo.getRiferimentoMessaggio());
                }
            }
            if (msg.getIDApplicativo() != null && !"".equals(msg.getIDApplicativo())) {
                headerIntegrazioneRichiesta.setIdApplicativo(msg.getIDApplicativo());
            }
            if (msg.getServizioApplicativo() != null && !"".equals(msg.getServizioApplicativo())) {
                headerIntegrazioneRichiesta.setServizioApplicativo(msg.getServizioApplicativo());
            }
            Properties headerTrasporto = null;
            if (this.propertiesReader.integrationManager_readInformazioniTrasporto()) {
                HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                headerTrasporto = new Properties();
                Enumeration enTrasporto = req.getHeaderNames();
                while (enTrasporto.hasMoreElements()) {
                    String nomeProperty = (String)enTrasporto.nextElement();
                    headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
                }
            }
            ParametriPortaDelegata parPD = new ParametriPortaDelegata();
            parPD.setLocation(portaDelegata);
            parPD.setUrlInvocazionePD(portaDelegata);
            if (this.propertiesReader.integrationManager_readInformazioniTrasporto()) {
                parPD.setParametersTrasporto(headerTrasporto);
            }
            parPD.setNomePortaDelegataURLBased(this.propertiesReader.integrationManager_isNomePortaDelegataUrlBased());
            RicezioneContenutiApplicativiContext context = new RicezioneContenutiApplicativiContext();
            context.setCredenziali(credenziali);
            context.setIdModulo("RicezioneContenutiApplicativiIntegrationManager");
            context.setGestioneRisposta(true);
            context.setInvocazionePDPerRiferimento(idInvocazionePerRiferimento != null);
            context.setMessageRequest(axisMsgRequest);
            context.setParPD(parPD);
            context.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
            String protocollo = "http";
            if (credenziali.getSubject() != null) {
                protocollo = "https";
            }
            String ip = (String)msgContext.getProperty("openspcoop.remoteAddr");
            String port = (String)msgContext.getProperty("openspcoop.remotePort");
            String user = "";
            if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                user = ":";
                user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
            }
            context.setFromLocation(protocollo + ":" + ip + ":" + port + user);
            RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
            gestoreRichiesta.process();
            Message axisMsgResponse = context.getMessageResponse();
            if (axisMsgResponse == null) break block56;
            if (axisMsgResponse.getSOAPBody().hasFault()) {
                SPCoopException exc = null;
                try {
                    SOAPFault fault = axisMsgResponse.getSOAPBody().getFault();
                    if (fault.getFaultActor() != null && fault.getFaultActor().equals(context.getProprietaErroreAppl().getFaultActor())) {
                        if (this.propertiesReader.isErroreApplicativoIntoDetails()) {
                            AxisFault f = ((org.apache.axis.message.SOAPFault)fault).getFault();
                            Element[] el = f.getFaultDetails();
                            MessageElement prova = new MessageElement(el[0]);
                            String PROVA = prova.getAsString();
                            exc = ServicesUtils.mapXMLIntoSPCoopException(PROVA);
                        } else {
                            exc = ServicesUtils.mapXMLIntoSPCoopException(fault.getFaultString());
                        }
                        if (exc == null) {
                            throw new Exception("Costruzione Eccezione fallita: null");
                        }
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "buildSPCoopException(" + tipoOperazione + ")");
                    throw new SPCoopException("OPENSPCOOP_ORG_524", "Sistema non disponibile");
                }
                if (exc != null) {
                    exc.buildAxisFault();
                    throw exc;
                }
            }
            Properties headerIntegrazioneRisposta = context.getHeaderIntegrazioneRisposta();
            SPCoopHeaderInfo spcoopHeaderInfoResponse = null;
            if (headerIntegrazioneRisposta != null) {
                Properties keyValue = this.propertiesReader.getKeyValue_HeaderIntegrazione();
                spcoopHeaderInfoResponse = new SPCoopHeaderInfo();
                spcoopHeaderInfoResponse.setID(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("idegov")));
                spcoopHeaderInfoResponse.setRiferimentoMessaggio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("riferimentoMessaggio")));
                spcoopHeaderInfoResponse.setIdCollaborazione(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("idCollaborazione")));
                spcoopHeaderInfoResponse.setMittente(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("mittente")));
                spcoopHeaderInfoResponse.setTipoMittente(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoMittente")));
                spcoopHeaderInfoResponse.setDestinatario(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("destinatario")));
                spcoopHeaderInfoResponse.setTipoDestinatario(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoDestinatario")));
                spcoopHeaderInfoResponse.setServizio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("servizio")));
                spcoopHeaderInfoResponse.setTipoServizio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoServizio")));
                spcoopHeaderInfoResponse.setAzione(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("azione")));
            }
            SPCoopMessage msgReturn = null;
            try {
                msgReturn = new SPCoopMessage(axisMsgResponse, false, spcoopHeaderInfoResponse);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "buildSPCoopMessage_response(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_523", "Sistema non disponibile");
            }
            SPCoopMessage sPCoopMessage = msgReturn;
            Object var31_36 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            return sPCoopMessage;
        }
        try {
            try {
                this.msgDiag.logErroreGenerico("Risposta non presente", "gestioneRisposta(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_511", "Sistema non disponibile");
            }
            catch (Exception e) {
                if (e instanceof SPCoopException) {
                    throw (SPCoopException)((Object)e);
                }
                this.msgDiag.logErroreGenerico(e, "invocaPortaDelegata(" + tipoOperazione + ")");
                throw new SPCoopException("OPENSPCOOP_ORG_500", "Sistema non disponibile");
            }
        }
        catch (Throwable throwable) {
            Object var31_37 = null;
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {}
            throw throwable;
        }
    }

    public SPCoopMessage invocaPortaDelegata(String portaDelegata, SPCoopMessage msg) throws SPCoopException {
        String tipoOperazione = "invocaPortaDelegata";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (msg == null || msg.getMessage() == null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("invocazionePortaDelegata.contenutoApplicativoNonPresente"), this.msgDiag.getLivello("invocazionePortaDelegata.contenutoApplicativoNonPresente"));
            throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
        }
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    public SPCoopMessage invocaPortaDelegataPerRiferimento(String portaDelegata, SPCoopMessage msg, String riferimentoMessaggio) throws SPCoopException {
        String tipoOperazione = "invocaPortaDelegataPerRiferimento";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (riferimentoMessaggio == null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente"), this.msgDiag.getLivello("invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente"));
            throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
        }
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, riferimentoMessaggio);
    }

    public SPCoopMessage sendRispostaAsincronaSimmetrica(String portaDelegata, SPCoopMessage msg) throws SPCoopException {
        String tipoOperazione = "sendRispostaAsincronaSimmetrica";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (msg == null || msg.getMessage() == null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("invocazionePortaDelegata.contenutoApplicativoNonPresente"), this.msgDiag.getLivello("invocazionePortaDelegata.contenutoApplicativoNonPresente"));
            throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
        }
        if (msg.getSpcoopHeaderInfo() == null || msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() == null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente"), this.msgDiag.getLivello("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente"));
            throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
        }
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    public SPCoopMessage sendRichiestaStatoAsincronaAsimmetrica(String portaDelegata, SPCoopMessage msg) throws SPCoopException {
        String tipoOperazione = "sendRichiestaStatoAsincronaAsimmetrica";
        this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        if (msg == null || msg.getMessage() == null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("invocazionePortaDelegata.contenutoApplicativoNonPresente"), this.msgDiag.getLivello("invocazionePortaDelegata.contenutoApplicativoNonPresente"));
            throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
        }
        if (msg.getSpcoopHeaderInfo() == null || msg.getSpcoopHeaderInfo().getRiferimentoMessaggio() == null) {
            this.msgDiag.logPersonalizzato(this.msgDiag.getMessaggio("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente"), this.msgDiag.getLivello("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente"));
            throw new SPCoopException("OPENSPCOOP_ORG_520", "Sistema non disponibile");
        }
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }
}

