/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.utils.UtilsException;

public class ServletUtils {
    public static Credenziali getCredenziali(HttpServletRequest req) throws Exception {
        X509Certificate[] certs;
        String decodeAuth;
        String[] decodeAuthSplit;
        Credenziali credenziali = new Credenziali();
        String auth = req.getHeader("authorization");
        if (auth != null && (decodeAuthSplit = (decodeAuth = new String(Base64.decode((String)auth.substring(6)))).split(":")).length > 1) {
            credenziali.setUsername(decodeAuthSplit[0]);
            credenziali.setPassword(decodeAuthSplit[1]);
        }
        if ((certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
            credenziali.setSubject(certs[0].getSubjectX500Principal().getName());
            credenziali.setCertificati(certs);
        }
        return credenziali;
    }

    public static void checkEmptyBody(Message axisMsgRequest) throws SOAPException, AxisFault {
        SOAPBody body = (SOAPBody)axisMsgRequest.getSOAPBody();
        boolean bodyNull = false;
        if (body == null) {
            bodyNull = true;
        } else {
            Iterator it = body.getChildElements();
            if (!it.hasNext()) {
                bodyNull = true;
            }
        }
        if (bodyNull) {
            if (body == null) {
                body = (SOAPBody)axisMsgRequest.getSOAPEnvelope().addBody();
            }
            body.addChildElement("OpenSPCoop_Body_Vuoto");
        }
    }

    public static void checkAxisMessage(Message axisMsgRequest) throws AxisFault {
        try {
            axisMsgRequest.getSOAPEnvelope().getAsString();
        }
        catch (Exception ex) {
            throw new AxisFault(ex.toString());
        }
    }

    public static String getLocation(HttpServletRequest req, Credenziali credenziali) {
        String protocollo = "http";
        if (credenziali.getSubject() != null) {
            protocollo = "https";
        }
        String ip = req.getRemoteAddr();
        String port = "" + req.getRemotePort();
        String user = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            user = ":";
            user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
        }
        return protocollo + ":" + ip + ":" + port + user;
    }

    public static String getSoapAction(HttpServletRequest req) {
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            if (!"SOAPAction".equalsIgnoreCase(nomeProperty)) continue;
            return req.getHeader(nomeProperty);
        }
        return null;
    }

    public static ParametriPortaDelegata getParametriPortaDelegata(HttpServletRequest req) {
        String locationPD;
        String servletContext;
        String urlInvocazione = req.getRequestURI();
        if (!urlInvocazione.endsWith("/")) {
            urlInvocazione = urlInvocazione + "/";
        }
        if (!(servletContext = req.getServletPath()).endsWith("/")) {
            servletContext = servletContext + "/";
        }
        String identificazioneDinamicaPD = locationPD = urlInvocazione.substring(urlInvocazione.indexOf(servletContext) + servletContext.length());
        if (locationPD.indexOf(47) != -1) {
            identificazioneDinamicaPD = locationPD;
            locationPD = identificazioneDinamicaPD.substring(0, identificazioneDinamicaPD.indexOf(47));
        }
        Properties identificazionePDFormBased = new Properties();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String nomeProperty = (String)en.nextElement();
            identificazionePDFormBased.setProperty(nomeProperty, req.getParameter(nomeProperty));
        }
        Properties headerTrasporto = new Properties();
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
        }
        ParametriPortaDelegata parPD = new ParametriPortaDelegata();
        parPD.setLocation(locationPD);
        parPD.setUrlInvocazionePD(identificazioneDinamicaPD);
        parPD.setParameters(identificazionePDFormBased);
        parPD.setParametersTrasporto(headerTrasporto);
        parPD.setNomePortaDelegataURLBased(true);
        return parPD;
    }

    public static String checkMustUnderstand(Message axisMessage) throws AxisFault {
        try {
            SOAPEnvelope envelope = axisMessage.getSOAPEnvelope();
            SOAPHeader header = (SOAPHeader)envelope.getHeader();
            OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();
            if (openspcoopProperties != null) {
                if (openspcoopProperties.isBypassFilterMustUnderstandEnabledForAllHeaders()) {
                    return null;
                }
                Properties filtri = openspcoopProperties.getBypassFilterMustUnderstandProperties();
                if (filtri != null && filtri.size() > 0) {
                    return ServletUtils.checkMustUnderstandAxisHeaderElement(header, filtri);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AxisFault("BypassMustUnderstand, errore durante il set processed degli header con mustUnderstand='1' e actor non presente: ", (Throwable)ex);
        }
        return null;
    }

    public static String checkMustUnderstandAxisHeaderElement(SOAPHeader header, Properties filtri) throws UtilsException {
        String error = null;
        try {
            Iterator it = header.getChildElements();
            while (it.hasNext()) {
                SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                if (element.getActor() != null || !element.getMustUnderstand()) continue;
                boolean checked = false;
                Enumeration<Object> en = filtri.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!key.equals(element.getLocalName()) || !filtri.get(key).equals(element.getNamespaceURI())) continue;
                    checked = true;
                    break;
                }
                if (checked) continue;
                if (error == null) {
                    error = element.getLocalName();
                    continue;
                }
                error = error + ", " + element.getLocalName();
            }
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.bypassMustUnderstandAxisHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), (Throwable)e);
        }
        return error;
    }
}

