/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.utils.SoapUtils;

public class RicezioneContenutiApplicativiHTTPtoSOAP
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ID_MODULO = "RicezioneContenutiApplicativiHTTP";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        Message responseAxisMessage = null;
        ServletOutputStream outputStreamResponseServlet = res.getOutputStream();
        OpenSPCoopProperties openSPCoopProperties = OpenSPCoopProperties.getInstance();
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        XMLBuilder xmlBuilder = new XMLBuilder();
        ProprietaErroreApplicativo proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD();
        proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault());
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        proprietaErroreAppl.setFaultAsXML(true);
        RicezioneContenutiApplicativiContext context = new RicezioneContenutiApplicativiContext();
        String errorImbustamentoSoapNonRiuscito = null;
        try {
            X509Certificate[] certs;
            String decodeAuth;
            String[] decodeAuthSplit;
            String locationPD;
            String servletContext;
            boolean imbustamentoConAttachment = false;
            String tipoAttachment = "application/openspcoop";
            String imb = req.getHeader(openSPCoopProperties.getTunnelSOAPKeyWord());
            if (imb != null && "true".equals(imb.trim())) {
                imbustamentoConAttachment = true;
                String mime = req.getHeader(openSPCoopProperties.getTunnelSOAPKeyWordMimeType());
                if (mime != null) {
                    tipoAttachment = mime.trim();
                }
            }
            if (imb == null && req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWord()) != null && "true".equalsIgnoreCase(req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWord()))) {
                imbustamentoConAttachment = true;
                if (req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWordMimeType()) != null) {
                    tipoAttachment = req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWordMimeType());
                }
            }
            Message axisMsgRequest = null;
            String tipoLetturaRisposta = null;
            try {
                if (imbustamentoConAttachment) {
                    tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + tipoAttachment;
                    axisMsgRequest = SoapUtils.imbustamentoMessaggioConAttachment((InputStream)req.getInputStream(), (String)tipoAttachment, (boolean)MailcapActivationReader.existsDataContentHandler(tipoAttachment));
                } else {
                    tipoLetturaRisposta = "Imbustamento messaggio in un messaggio SOAP";
                    ServletInputStream isReceive = req.getInputStream();
                    ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
                    byte[] readB = new byte[65536];
                    int readByte = 0;
                    while ((readByte = isReceive.read(readB)) != -1) {
                        byteBuffer.write(readB, 0, readByte);
                    }
                    byteBuffer.flush();
                    byteBuffer.close();
                    if (byteBuffer.size() <= 0) {
                        throw new Exception("Ricevuto nessun contenuto da imbustare");
                    }
                    axisMsgRequest = SoapUtils.imbustamentoMessaggio((byte[])byteBuffer.toByteArray(), (boolean)openSPCoopProperties.isDeleteInstructionTargetMachineXml());
                    isReceive.close();
                }
            }
            catch (Exception e) {
                axisMsgRequest = null;
                errorImbustamentoSoapNonRiuscito = tipoLetturaRisposta + " con errore: " + e.getMessage();
            }
            if (axisMsgRequest == null) {
                throw new Exception("ImbustamentoSOAP non riuscito");
            }
            String urlInvocazione = req.getRequestURI();
            if (!urlInvocazione.endsWith("/")) {
                urlInvocazione = urlInvocazione + "/";
            }
            if (!(servletContext = req.getServletPath()).endsWith("/")) {
                servletContext = servletContext + "/";
            }
            String identificazioneDinamicaPD = locationPD = urlInvocazione.substring(urlInvocazione.indexOf(servletContext) + servletContext.length());
            if (locationPD.indexOf(47) != -1) {
                identificazioneDinamicaPD = locationPD;
                locationPD = identificazioneDinamicaPD.substring(0, identificazioneDinamicaPD.indexOf(47));
            }
            Properties identificazionePDFormBased = new Properties();
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String nomeProperty = (String)en.nextElement();
                identificazionePDFormBased.setProperty(nomeProperty, req.getParameter(nomeProperty));
            }
            Properties headerTrasporto = new Properties();
            Enumeration enTrasporto = req.getHeaderNames();
            while (enTrasporto.hasMoreElements()) {
                String nomeProperty = (String)enTrasporto.nextElement();
                headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
                if (!"SOAPAction".equalsIgnoreCase(nomeProperty)) continue;
                context.setSoapAction(req.getHeader(nomeProperty));
            }
            ParametriPortaDelegata parPD = new ParametriPortaDelegata();
            parPD.setLocation(locationPD);
            parPD.setUrlInvocazionePD(identificazioneDinamicaPD);
            parPD.setParameters(identificazionePDFormBased);
            parPD.setParametersTrasporto(headerTrasporto);
            parPD.setNomePortaDelegataURLBased(true);
            Credenziali credenziali = new Credenziali();
            String auth = req.getHeader("authorization");
            if (auth != null && (decodeAuthSplit = (decodeAuth = new String(Base64.decode((String)auth.substring(6)))).split(":")).length > 1) {
                credenziali.setUsername(decodeAuthSplit[0]);
                credenziali.setPassword(decodeAuthSplit[1]);
            }
            if ((certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
                credenziali.setSubject(certs[0].getSubjectX500Principal().getName());
                credenziali.setCertificati(certs);
            }
            String protocollo = "http";
            if (credenziali.getSubject() != null) {
                protocollo = "https";
            }
            String ip = req.getRemoteAddr();
            String port = "" + req.getRemotePort();
            String user = "";
            if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                user = ":";
                user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
            }
            context.setFromLocation(protocollo + ":" + ip + ":" + port + user);
            context.setCredenziali(credenziali);
            context.setIdModulo(ID_MODULO);
            context.setGestioneRisposta(true);
            context.setInvocazionePDPerRiferimento(false);
            context.setMessageRequest(axisMsgRequest);
            context.setParPD(parPD);
            RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
            gestoreRichiesta.process();
            responseAxisMessage = context.getMessageResponse();
        }
        catch (Exception e) {
            logCore.error((Object)"ImbustamentoSoap non riuscito", (Throwable)e);
            if (errorImbustamentoSoapNonRiuscito != null) {
                logCore.error((Object)"ImbustamentoSOAP", (Throwable)e);
                msgDiag.logErroreGenerico(errorImbustamentoSoapNonRiuscito + "  " + e.getMessage(), "ImbustamentoSOAP");
                responseAxisMessage = xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_422", "I byte inviati al servizio di ricezione contenuti applicativi non sono utilizzabili per un imbustamento soap: " + errorImbustamentoSoapNonRiuscito);
            }
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale(richiesta)");
            responseAxisMessage = xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile");
        }
        if (context.getHeaderIntegrazioneRisposta() != null) {
            Enumeration<Object> en = context.getHeaderIntegrazioneRisposta().keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                res.setHeader(key, context.getHeaderIntegrazioneRisposta().getProperty(key));
            }
        }
        try {
            SOAPBody body;
            boolean rispostaPresente = true;
            if (openSPCoopProperties.isHttp202OneWay() && ((body = responseAxisMessage.getSOAPBody()) == null || body.getChildNodes().getLength() == 0)) {
                SOAPHeader header = responseAxisMessage.getSOAPHeader();
                if (header == null || header.getChildNodes().getLength() == 0) {
                    rispostaPresente = false;
                } else if (!openSPCoopProperties.isHttp202OneWay_PD_HTTPEmptyResponse()) {
                    rispostaPresente = false;
                }
            }
            if (rispostaPresente) {
                if (responseAxisMessage.getSOAPBody() != null && responseAxisMessage.getSOAPBody().hasFault()) {
                    String msgError = null;
                    msgError = responseAxisMessage.getSOAPBody().getFault().getFaultString() != null ? responseAxisMessage.getSOAPBody().getFault().getFaultString() : "Ricevuto SoapFault con codice: " + responseAxisMessage.getSOAPBody().getFault().getFaultCode();
                    outputStreamResponseServlet.write(msgError.getBytes());
                } else {
                    outputStreamResponseServlet.write(SoapUtils.sbustamentoMessaggio((Message)responseAxisMessage));
                }
                res.setContentType(responseAxisMessage.getContentType((SOAPConstants)new SOAP11Constants()));
            }
        }
        catch (Exception e) {
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale(risposta)");
            try {
                outputStreamResponseServlet.write(xmlBuilder.buildBytes_Eccezione(openSPCoopProperties.getIdentificativoPortaDefault(), ID_MODULO, proprietaErroreAppl.transformFaultCode("OPENSPCOOP_ORG_500"), "Sistema non disponibile", "EccezioneProcessamento"));
            }
            catch (Exception error) {
                outputStreamResponseServlet.write(error.toString().getBytes());
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

