/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.Message;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.ParametriPortaDelegata;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.pdd.services.ServletUtils;

public class RicezioneContenutiApplicativiDirect
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ID_MODULO = "RicezioneContenutiApplicativiDirect";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        Message responseAxisMessage = null;
        ServletOutputStream outputStreamResponseServlet = res.getOutputStream();
        OpenSPCoopProperties openSPCoopProperties = OpenSPCoopProperties.getInstance();
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        XMLBuilder xmlBuilder = new XMLBuilder();
        ProprietaErroreApplicativo proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD();
        proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault());
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        proprietaErroreAppl.setFaultAsXML(true);
        RicezioneContenutiApplicativiContext context = new RicezioneContenutiApplicativiContext();
        try {
            Message axisMsgRequest = null;
            axisMsgRequest = new Message((Object)req.getInputStream(), false, req.getContentType(), req.getContextPath());
            axisMsgRequest.getMimeHeaders().addHeader(req.getHeader("SOAPAction"), req.getHeader("SOAPAction"));
            ServletUtils.checkAxisMessage(axisMsgRequest);
            String mustUnderstandError = ServletUtils.checkMustUnderstand(axisMsgRequest);
            ParametriPortaDelegata parPD = ServletUtils.getParametriPortaDelegata(req);
            Credenziali credenziali = ServletUtils.getCredenziali(req);
            context.setFromLocation(ServletUtils.getLocation(req, credenziali));
            context.setSoapAction(ServletUtils.getSoapAction(req));
            context.setCredenziali(credenziali);
            context.setIdModulo(ID_MODULO);
            context.setGestioneRisposta(true);
            context.setInvocazionePDPerRiferimento(false);
            context.setMessageRequest(axisMsgRequest);
            context.setParPD(parPD);
            if (mustUnderstandError == null) {
                RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
                gestoreRichiesta.process();
                responseAxisMessage = context.getMessageResponse();
            } else {
                msgDiag.errorOpenSPCoop("Did not understand \"MustUnderstand\" header(s) : " + mustUnderstandError);
                responseAxisMessage = xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_427", "Did not understand \"MustUnderstand\" header(s) : " + mustUnderstandError);
            }
        }
        catch (Exception e) {
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale(richiesta)");
            responseAxisMessage = xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_426", e.toString());
        }
        if (context.getHeaderIntegrazioneRisposta() != null) {
            Enumeration<Object> en = context.getHeaderIntegrazioneRisposta().keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                res.setHeader(key, context.getHeaderIntegrazioneRisposta().getProperty(key));
            }
        }
        try {
            SOAPBody body;
            boolean rispostaPresente = true;
            if (openSPCoopProperties.isHttp202OneWay() && ((body = responseAxisMessage.getSOAPBody()) == null || body.getChildNodes().getLength() == 0)) {
                SOAPHeader header = responseAxisMessage.getSOAPHeader();
                if (header == null || header.getChildNodes().getLength() == 0) {
                    rispostaPresente = false;
                } else if (!openSPCoopProperties.isHttp202OneWay_PD_HTTPEmptyResponse()) {
                    rispostaPresente = false;
                }
            }
            if (rispostaPresente) {
                res.setContentType(responseAxisMessage.getContentType((SOAPConstants)new SOAP11Constants()));
                responseAxisMessage.writeTo((OutputStream)outputStreamResponseServlet);
                if (responseAxisMessage.getSOAPBody() != null && responseAxisMessage.getSOAPBody().hasFault()) {
                    res.setStatus(500);
                }
            }
        }
        catch (Exception e) {
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale(risposta)");
            try {
                outputStreamResponseServlet.write(xmlBuilder.buildBytes_Eccezione(openSPCoopProperties.getIdentificativoPortaDefault(), ID_MODULO, proprietaErroreAppl.transformFaultCode("OPENSPCOOP_ORG_500"), "Sistema non disponibile", "EccezioneProcessamento"));
            }
            catch (Exception error) {
                outputStreamResponseServlet.write(error.toString().getBytes());
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

