/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Integrazione;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.RepositoryEGov;
import org.openspcoop.egov.ValidazioneSintattica;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.RichiestaDelegata;
import org.openspcoop.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.GestoreMessaggiException;
import org.openspcoop.pdd.core.IdentificazionePortaDelegata;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop.pdd.core.autorizzazione.IAutorizzazione;
import org.openspcoop.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop.pdd.core.node.INodeReceiver;
import org.openspcoop.pdd.core.node.INodeSender;
import org.openspcoop.pdd.core.node.NodeTimeoutException;
import org.openspcoop.pdd.core.state.IOpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopState;
import org.openspcoop.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop.pdd.logger.Dump;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.mdb.EsitoLib;
import org.openspcoop.pdd.mdb.Imbustamento;
import org.openspcoop.pdd.mdb.ImbustamentoMessage;
import org.openspcoop.pdd.mdb.InoltroBusteEGov;
import org.openspcoop.pdd.mdb.SbustamentoRisposte;
import org.openspcoop.pdd.monitor.InfoAttraversamentoPdD;
import org.openspcoop.pdd.monitor.NotificaTempiAttraversamentoPdDUtility;
import org.openspcoop.pdd.monitor.TipoPdD;
import org.openspcoop.pdd.services.OpenSPCoopStartup;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiGestioneRisposta;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;

public class RicezioneContenutiApplicativi {
    public static final String ID_MODULO = "RicezioneContenutiApplicativi";
    public static boolean initializeService = false;
    private static INodeSender nodeSender = null;
    private static INodeReceiver nodeReceiver = null;
    public static Hashtable<String, IGestoreIntegrazionePD> gestoriIntegrazionePD = new Hashtable();
    public static String[] defaultGestoriIntegrazionePD = null;
    public static Hashtable<String, IAutorizzazione> gestoriAutorizzazione = new Hashtable();
    private RicezioneContenutiApplicativiContext msgContext;
    boolean responseAsByte = false;

    public static synchronized void initializeService(ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            Class<?> c = Class.forName(classTypeNodeSender);
            nodeSender = (INodeSender)c.newInstance();
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            Class<?> c = Class.forName(classType);
            nodeReceiver = (INodeReceiver)c.newInstance();
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        defaultGestoriIntegrazionePD = propertiesReader.getTipoIntegrazionePD();
        for (int i = 0; i < defaultGestoriIntegrazionePD.length; ++i) {
            classType = className.getIntegrazionePortaDelegata(defaultGestoriIntegrazionePD[i]);
            try {
                Class<?> c = Class.forName(classType);
                gestoriIntegrazionePD.put(defaultGestoriIntegrazionePD[i], (IGestoreIntegrazionePD)c.newInstance());
                logCore.info((Object)("Inizializzazione gestore integrazione servizioApplicativo->PdD di tipo " + defaultGestoriIntegrazionePD[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + defaultGestoriIntegrazionePD[i] + "]: " + e.getMessage());
            }
        }
        initializeService = true;
    }

    public static synchronized void aggiornaListaGestoreIntegrazione(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriIntegrazionePD.contains(newTipo)) {
            return;
        }
        String classType = className.getIntegrazionePortaDelegata(newTipo);
        try {
            Class<?> c = Class.forName(classType);
            gestoriIntegrazionePD.put(newTipo, (IGestoreIntegrazionePD)c.newInstance());
            logCore.info((Object)("Inizializzazione gestore integrazione servizioApplicativo->PdD di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    public static synchronized void aggiornaListaGestoreAutorizzazione(String newTipo, ClassNameProperties className, OpenSPCoopProperties propertiesReader, Logger logCore) throws Exception {
        if (gestoriAutorizzazione.contains(newTipo)) {
            return;
        }
        String classType = className.getAutorizzazione(newTipo);
        try {
            Class<?> c = Class.forName(classType);
            gestoriAutorizzazione.put(newTipo, (IAutorizzazione)c.newInstance());
            logCore.info((Object)("Inizializzazione gestore autorizzazione di tipo " + newTipo + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione di tipo [" + newTipo + "]: " + e.getMessage());
        }
    }

    public RicezioneContenutiApplicativi(RicezioneContenutiApplicativiContext context) {
        this.msgContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void process() {
        block272: {
            block269: {
                block267: {
                    block266: {
                        dataIngressoMessaggio = DateManager.getTimestamp();
                        logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
                        if (logCore == null) {
                            logCore = Logger.getLogger((String)"RicezioneContenutiApplicativi");
                        }
                        if ((requestMessage = this.msgContext.getMessageRequest()) == null) {
                            try {
                                requestMessage = this.msgContext.getMessageRequestFromByte();
                                this.responseAsByte = true;
                            }
                            catch (Exception e) {
                                logCore.error((Object)("Lettura del messaggio di richiesta non riuscita: " + e.getMessage()));
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.setMessageResponseIntoContext(new Message((Object)new AxisFault("ErroreLetturaMessaggioRichiesta")), logCore, null, null);
                                }
                                return;
                            }
                        }
                        parPD = this.msgContext.getParPD();
                        credenziali = this.msgContext.getCredenziali();
                        className = ClassNameProperties.getInstance();
                        propertiesReader = OpenSPCoopProperties.getInstance();
                        if (propertiesReader == null) {
                            logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(new Message((Object)new AxisFault("ErroreInizializzazioneOpenSPCoop")), logCore, null, null);
                            }
                            return;
                        }
                        configurazionePdDReader = ConfigurazionePdDReader.getInstance();
                        registroServiziReader = RegistroServiziReader.getInstance();
                        identitaPdD = propertiesReader.getIdentitaPortaDefault();
                        xmlBuilder = new XMLBuilder();
                        proprietaErroreAppl = propertiesReader.getProprietaGestioneErrorePD();
                        proprietaErroreAppl.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreAppl.setIdModulo(this.msgContext.getIdModulo());
                        this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                        openspcoopstate = null;
                        imbustamentoMSG = new ImbustamentoMessage();
                        if (!OpenSPCoopStartup.initialize) {
                            logCore.error((Object)"[RicezioneContenutiApplicativi]  Inizializzazione di OpenSPCoop non correttamente effettuata");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_501", "Sistema non disponibile"), logCore, null, null);
                            }
                            return;
                        }
                        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                            logCore.error((Object)("[RicezioneContenutiApplicativi]  Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_532", "Sistema non disponibile"), logCore, null, null);
                            }
                            return;
                        }
                        if (!TimerThreshold.freeSpace) {
                            logCore.error((Object)"[RicezioneContenutiApplicativi]  Non sono disponibili abbastanza risorse per la gestione della richiesta");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_533", "Sistema non disponibile"), logCore, null, null);
                            }
                            return;
                        }
                        msgDiag = new MsgDiagnostico(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo());
                        msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
                        msgDiag.setDelegata(true);
                        msgDiag.setPorta(parPD.getLocation() + "_urlInvocazione(" + parPD.getUrlInvocazionePD() + ")");
                        if (credenziali != null) {
                            if (credenziali.getUsername() != null) {
                                msgDiag.setServizioApplicativo("username(" + credenziali.getUsername() + ")");
                            } else if (credenziali.getSubject() != null) {
                                msgDiag.setServizioApplicativo("subject(" + credenziali.getSubject() + ")");
                            }
                        }
                        credenzialiFornite = "";
                        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                            credenzialiFornite = "(";
                            if (credenziali.getUsername() != null) {
                                credenzialiFornite = credenziali.getPassword() == null || "".equals(credenziali.getPassword()) != false ? credenzialiFornite + " Basic Username: " + credenziali.getUsername() + "  Basic Password: non definita" : credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
                            }
                            if (credenziali.getSubject() != null) {
                                credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
                            }
                            credenzialiFornite = credenzialiFornite + ") ";
                        }
                        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
                        try {
                            if (!RicezioneContenutiApplicativi.initializeService) {
                                msgDiag.mediumDebug("Inizializzazione risorse statiche...");
                                RicezioneContenutiApplicativi.initializeService(className, propertiesReader, logCore);
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "InizializzazioneRisorseServizioRicezioneContenutiApplicativi");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_501", "Sistema non disponibile"), logCore, msgDiag, null);
                            }
                            return;
                        }
                        msgDiag.mediumDebug("Controllo non esistenza di una busta eGov...");
                        vs = new ValidazioneSintattica(requestMessage);
                        if (vs.existsHeaderEGov()) {
                            msgDiag.logPersonalizzato(msgDiag.getMessaggio("richiestaContenenteBustaEGov"), msgDiag.getLivello("richiestaContenenteBustaEGov"));
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_420", "Il messaggio Soap inviato al servizio di ricezione contenuti applicativi presenta nell'header una busta eGov"), logCore, msgDiag, null);
                            }
                            return;
                        }
                        msgDiag.mediumDebug("Identificazione porta delegata e soggetto fruitore...");
                        identificazione = new IdentificazionePortaDelegata(parPD);
                        if (!identificazione.process()) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", identificazione.getMsgError());
                            msgDiag.logPersonalizzato(msgDiag.getMessaggio("portaDelegataNonEsistente"), msgDiag.getLivello("portaDelegataNonEsistente"));
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, identificazione.getCodiceErrore(), identificazione.getMsgError()), logCore, msgDiag, null);
                            }
                            return;
                        }
                        parPD.setLocation(identificazione.getNomePDIndivituata());
                        soggettoFruitore = identificazione.getSoggettoSPCoop();
                        pd = identificazione.getPd();
                        identitaPdD = soggettoFruitore;
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(parPD.getLocation());
                        idPD.setSoggettoFruitore(soggettoFruitore);
                        msgDiag.setDominioSPCoop(identitaPdD.getCodicePorta());
                        msgDiag.setFruitore(soggettoFruitore);
                        msgDiag.addKeyword("@PORTA_DELEGATA@", identificazione.getNomePDIndivituata());
                        msgDiag.addKeywords(soggettoFruitore);
                        proprietaErroreAppl.setDominio(identitaPdD.getCodicePorta());
                        this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                        msgDiag.mediumDebug("Lettura header di integrazione...");
                        headerIntegrazioneRichiesta = null;
                        headerIntegrazioneRichiesta = this.msgContext.getHeaderIntegrazioneRichiesta() != null ? this.msgContext.getHeaderIntegrazioneRichiesta() : new HeaderIntegrazione();
                        headerIntegrazioneRisposta = null;
                        tipiIntegrazionePD = null;
                        try {
                            tipiIntegrazionePD = configurazionePdDReader.getTipiIntegrazione(pd);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "getTipiIntegrazione(pd)");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, null);
                            }
                            return;
                        }
                        if (tipiIntegrazionePD == null) {
                            tipiIntegrazionePD = RicezioneContenutiApplicativi.defaultGestoriIntegrazionePD;
                        }
                        for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                            try {
                                if (!RicezioneContenutiApplicativi.gestoriIntegrazionePD.containsKey(tipiIntegrazionePD[i])) {
                                    RicezioneContenutiApplicativi.aggiornaListaGestoreIntegrazione(tipiIntegrazionePD[i], className, propertiesReader, logCore);
                                }
                                if ((gestore = RicezioneContenutiApplicativi.gestoriIntegrazionePD.get(tipiIntegrazionePD[i])) != null) {
                                    gestore.readHeader(headerIntegrazioneRichiesta, requestMessage, parPD, propertiesReader.deleteHeaderIntegrazionePD());
                                    continue;
                                }
                                msgDiag.logErroreGenerico("Lettura Gestore header di integrazione [" + tipiIntegrazionePD[i] + "]  non riuscita: non inizializzato", "gestoriIntegrazionePD.get(" + tipiIntegrazionePD[i] + ")");
                                continue;
                            }
                            catch (Exception e) {
                                msgDiag.lowDebug("Errore durante la lettura dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                            }
                        }
                        msgDiag.mediumDebug("Autenticazione del servizio applicativo...");
                        tipoAutenticazione = identificazione.getTipoAutenticazione();
                        servizioApplicativo = "Anonimo";
                        if ("none".equalsIgnoreCase(tipoAutenticazione)) {
                            if (headerIntegrazioneRichiesta.getServizioApplicativo() != null) {
                                servizioApplicativo = headerIntegrazioneRichiesta.getServizioApplicativo();
                                existsServizioApplicativo = false;
                                try {
                                    existsServizioApplicativo = configurazionePdDReader.existsServizioApplicativo(idPD, servizioApplicativo);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "existsServizioApplicativo(idPD," + servizioApplicativo + ")");
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, null);
                                    }
                                    return;
                                }
                                if (!existsServizioApplicativo) {
                                    msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo);
                                    msgDiag.logPersonalizzato(msgDiag.getMessaggio("servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita"), msgDiag.getLivello("servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita"));
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_402", "L'identita' del servizio applicativo fornita non esiste nella configurazione della Porta di Dominio: " + servizioApplicativo), logCore, msgDiag, null);
                                    }
                                    return;
                                }
                            }
                        } else {
                            authClass = className.getAutenticazione(tipoAutenticazione);
                            auth = null;
                            try {
                                c = Class.forName(authClass);
                                auth = (IAutenticazione)c.newInstance();
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione + ") Class.forName(" + authClass + ")");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_503", "Sistema non disponibile"), logCore, msgDiag, null);
                                }
                                return;
                            }
                            if (!auth.process(credenziali, soggettoFruitore, parPD.getLocation())) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", auth.getMsgError());
                                msgDiag.logPersonalizzato(msgDiag.getMessaggio("servizioApplicativoFruitore.identificazioneTramiteCredenziali"), msgDiag.getLivello("servizioApplicativoFruitore.identificazioneTramiteCredenziali"));
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, auth.getCodiceErrore(), msgDiag.getMessaggio("servizioApplicativoFruitore.identificazioneTramiteCredenziali")), logCore, msgDiag, null);
                                }
                                return;
                            }
                            servizioApplicativo = auth.getServizioApplicativo();
                        }
                        msgDiag.setPorta(parPD.getLocation());
                        msgDiag.setServizioApplicativo(servizioApplicativo);
                        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo);
                        msgDiag.mediumDebug("Get servizio applicativo...");
                        sa = null;
                        try {
                            sa = configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block266;
                            msgDiag.logErroreGenerico(e, "getServizioApplicativo(idPD," + servizioApplicativo + ")");
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, null);
                            }
                            return;
                        }
                    }
                    msgDiag.mediumDebug("Aggiornamento gestione errore del servizio applicativo...");
                    try {
                        configurazionePdDReader.aggiornaProprietaGestioneErrorePD(proprietaErroreAppl, sa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "aggiornaProprietaGestioneErrorePD(proprietaErroreAppl," + servizioApplicativo + ")");
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, null);
                        }
                        return;
                    }
                    this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                    msgDiag.mediumDebug("Lettura servizio SPCoop associato alla PD invocata...");
                    idModuloInAttesa = null;
                    if (this.msgContext.isGestioneRisposta()) {
                        idModuloInAttesa = this.msgContext.getIdModulo();
                    }
                    richiestaDelegata = new RichiestaDelegata(soggettoFruitore, parPD.getLocation(), servizioApplicativo, idModuloInAttesa, proprietaErroreAppl, identitaPdD);
                    try {
                        if (configurazionePdDReader.identificazioneContentBased(pd)) {
                            soapEnvelopeRequest = requestMessage.getSOAPEnvelope();
                            richiestaDelegata.setIdServizio(configurazionePdDReader.getIDServizio(pd, parPD, soapEnvelopeRequest, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith("IntegrationManager")));
                        } else {
                            richiestaDelegata.setIdServizio(configurazionePdDReader.getIDServizio(pd, parPD, null, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith("IntegrationManager")));
                        }
                        if (richiestaDelegata.getIdServizio() == null) {
                            throw new DriverConfigurazioneNotFound("Identificazione Servizio non riuscita");
                        }
                        if (richiestaDelegata.getIdServizio().getSoggettoErogatore() == null || richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome() == null || richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo() == null) {
                            throw new DriverConfigurazioneNotFound("Identificazione SoggettoErogatore non riuscita");
                        }
                        if (richiestaDelegata.getIdServizio().getTipoServizio() == null || richiestaDelegata.getIdServizio().getServizio() == null) {
                            throw new DriverConfigurazioneNotFound("Identificazione Servizio (tipo/nome) non riuscita");
                        }
                        headerIntegrazioneRisposta = new HeaderIntegrazione();
                        headerIntegrazioneRisposta.getEgov().setTipoMittente(soggettoFruitore.getTipo());
                        headerIntegrazioneRisposta.getEgov().setMittente(soggettoFruitore.getNome());
                        headerIntegrazioneRisposta.getEgov().setTipoDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo());
                        headerIntegrazioneRisposta.getEgov().setDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome());
                        headerIntegrazioneRisposta.getEgov().setTipoServizio(richiestaDelegata.getIdServizio().getTipoServizio());
                        headerIntegrazioneRisposta.getEgov().setServizio(richiestaDelegata.getIdServizio().getServizio());
                        headerIntegrazioneRisposta.getEgov().setAzione(richiestaDelegata.getIdServizio().getAzione());
                        if (headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                            headerIntegrazioneRisposta.getEgov().setRiferimentoMessaggio(headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio());
                        }
                    }
                    catch (DriverConfigurazioneNotFound e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("identificazioneDinamicaServizioSPCoopNonRiuscita"), msgDiag.getLivello("identificazioneDinamicaServizioSPCoopNonRiuscita"));
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_403", "Riscontrato errore durante l'identificazione del servizio SPCoop associato alla porta delegata, utilizzando il pattern specificato nella configurazione"), logCore, msgDiag, null);
                        }
                        return;
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("identificazioneDinamicaServizioSPCoopNonRiuscita"), msgDiag.getLivello("identificazioneDinamicaServizioSPCoopNonRiuscita"));
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, null);
                        }
                        return;
                    }
                    msgDiag.setServizio(richiestaDelegata.getIdServizio());
                    msgDiag.addKeywords(richiestaDelegata.getIdServizio());
                    idEGovRequest = null;
                    msgDiag.mediumDebug("Inizializzazione connessione al database...");
                    try {
                        openspcoopstate = new OpenSPCoopStateful();
                        if ("abilitato".equals(propertiesReader.getNegoziamentoConnessioneDatasource())) {
                            openspcoopstate.initResource(identitaPdD, this.msgContext.getIdModulo());
                        } else {
                            openspcoopstate.initResourceFromConnectionPool(identitaPdD, this.msgContext.getIdModulo());
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "openspcoopstate.initResource()");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_505", "Sistema non disponibile"), logCore, msgDiag, null);
                        }
                        return;
                    }
                    msgDiag.mediumDebug("Gestione correlazione applicativa...");
                    correlazionePD = null;
                    try {
                        correlazionePD = configurazionePdDReader.getCorrelazioneApplicativa(pd);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "getCorrelazioneApplicativa(pd)");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, null);
                        }
                        return;
                    }
                    correlazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), logCore, richiestaDelegata.getSoggettoFruitore(), richiestaDelegata.getIdServizio(), servizioApplicativo);
                    correlazioneEsistente = false;
                    idCorrelazioneApplicativa = null;
                    if (correlazionePD != null) {
                        try {
                            soapEnvelopeRequest = requestMessage.getSOAPEnvelope();
                            correlazioneEsistente = correlazioneApplicativa.verificaCorrelazione(correlazionePD, parPD, soapEnvelopeRequest, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith("IntegrationManager"));
                            idCorrelazioneApplicativa = correlazioneApplicativa.getIdCorrelazione();
                            if (correlazioneEsistente) {
                                idEGovRequest = correlazioneApplicativa.getIdEGovCorrelato();
                                msgDiag.setIdEGovRichiesta(idEGovRequest);
                                msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
                                msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGovRequest);
                                msgDiag.logPersonalizzato(msgDiag.getMessaggio("correlazioneApplicativaEsistente"), msgDiag.getLivello("correlazioneApplicativaEsistente"));
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "CorrelazioneApplicativa");
                            logCore.error((Object)("Riscontrato errore durante il controllo di correlazione applicativa: " + e.getMessage()), (Throwable)e);
                            try {
                                if (configurazionePdDReader.dumpMessaggi()) {
                                    msgDiag.mediumDebug("Dump applicativo della richiesta...");
                                    dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), "NonDisponibile(ErroreCorrelazioneApplicativa)");
                                    dumpApplicativo.dumpRichiesta(requestMessage);
                                }
                            }
                            catch (Exception eDump) {
                                msgDiag.logErroreGenerico(eDump, "DumpDopoCorrelazioneApplicativaFallita");
                                logCore.error((Object)("Dump del messaggio applicativo che ha fatto fallire la creazione di una correlazione applicativa non riuscito: " + eDump), (Throwable)eDump);
                            }
                            codiceErrore = correlazioneApplicativa.getCodiceErrore();
                            if (codiceErrore == null) {
                                codiceErrore = "OPENSPCOOP_ORG_529";
                            }
                            if ((msgErrore = correlazioneApplicativa.getMsgErrore()) == null) {
                                msgErrore = "Sistema non disponibile";
                            }
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore), logCore, msgDiag, null);
                            }
                            return;
                        }
                    }
                    if (!correlazioneEsistente) {
                        msgDiag.mediumDebug("Costruzione identificativo eGov...");
                        try {
                            imbustatore = new org.openspcoop.egov.Imbustamento();
                            idEGovRequest = imbustatore.buildID_eGov(openspcoopstate.getStatoRichiesta(), identitaPdD.getCodicePorta(), identitaPdD.getNome());
                            if (idEGovRequest == null) {
                                throw new Exception("Identificativo eGov non costruito.");
                            }
                            msgDiag.setIdEGovRichiesta(idEGovRequest);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "imbustatore.buildID_eGov(idEGovRequest)");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_507", "Sistema non disponibile"), logCore, msgDiag, null);
                            }
                            return;
                        }
                        msgDiag.addKeyword("@ID_EGOV_RICHIESTA@", idEGovRequest);
                        if (correlazionePD != null && idCorrelazioneApplicativa != null) {
                            msgDiag.mediumDebug("Applicazione correlazione applicativa...");
                            try {
                                correlazioneApplicativa.applicaCorrelazione(correlazionePD, idCorrelazioneApplicativa, idEGovRequest);
                                msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
                                msgDiag.logPersonalizzato(msgDiag.getMessaggio("correlazioneApplicativaInstaurata"), msgDiag.getLivello("correlazioneApplicativaInstaurata"));
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "CreazioneCorrelazioneApplicativa");
                                try {
                                    if (configurazionePdDReader.dumpMessaggi()) {
                                        msgDiag.mediumDebug("Dump applicativo della richiesta...");
                                        dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), "NonDisponibile(ErroreCreazioneCorrelazioneApplicativa)");
                                        dumpApplicativo.dumpRichiesta(requestMessage);
                                    }
                                }
                                catch (Exception eDump) {
                                    msgDiag.logErroreGenerico(eDump, "DumpCreazioneCorrelazioneApplicativaFallita");
                                    logCore.error((Object)("Dump del messaggio applicativo che ha fatto fallire la creazione di una correlazione applicativa non riuscito: " + eDump), (Throwable)eDump);
                                }
                                codiceErrore = correlazioneApplicativa.getCodiceErrore();
                                if (codiceErrore == null) {
                                    codiceErrore = "OPENSPCOOP_ORG_529";
                                }
                                if ((msgErrore = correlazioneApplicativa.getMsgErrore()) == null) {
                                    msgErrore = "Sistema non disponibile";
                                }
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore), logCore, msgDiag, null);
                                }
                                return;
                            }
                        }
                    }
                    richiestaDelegata.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                    msgDiag.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                    msgDiag.mediumDebug("Gestione header integrazione della risposta...");
                    headerIntegrazioneRisposta.getEgov().setID(idEGovRequest);
                    if (RicezioneContenutiApplicativi.gestoriIntegrazionePD.containsKey("trasporto") || this.msgContext.getIdModulo().startsWith("RicezioneContenutiApplicativiIntegrationManager")) {
                        try {
                            propertiesIntegrazioneRisposta = new Properties();
                            gestore = RicezioneContenutiApplicativi.gestoriIntegrazionePD.get("trasporto");
                            if (gestore != null) {
                                gestore.setResponseHeader(headerIntegrazioneRisposta, null, propertiesIntegrazioneRisposta);
                                this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
                        }
                    }
                    msgDiag.logCorrelazione();
                    msgDiag.logCorrelazioneServizioApplicativo();
                    if (configurazionePdDReader.dumpMessaggi()) {
                        msgDiag.mediumDebug("Dump applicativo della richiesta...");
                        dumpApplicativo = new Dump(identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest);
                        dumpApplicativo.dumpRichiesta(requestMessage);
                    }
                    idServizio = richiestaDelegata.getIdServizio();
                    info = new InfoAttraversamentoPdD(TipoPdD.DELEGATA, soggettoFruitore, idServizio.getSoggettoErogatore(), idEGovRequest, idServizio.getTipoServizio(), idServizio.getServizio(), idServizio.getAzione());
                    info.setStato(false);
                    msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
                    tipoAutorizzazione = identificazione.getTipoAutorizzazione();
                    if (!"none".equalsIgnoreCase(tipoAutorizzazione)) {
                        msgErroreAutorizzazione = null;
                        codiceErroreAutorizzazione = null;
                        try {
                            if (!RicezioneContenutiApplicativi.gestoriAutorizzazione.containsKey(tipoAutorizzazione)) {
                                RicezioneContenutiApplicativi.aggiornaListaGestoreAutorizzazione(tipoAutorizzazione, className, propertiesReader, logCore);
                            }
                            if ((auth = RicezioneContenutiApplicativi.gestoriAutorizzazione.get(tipoAutorizzazione)) != null) {
                                esito = auth.process(servizioApplicativo, soggettoFruitore, parPD.getLocation(), richiestaDelegata.getIdServizio(), pd);
                                if (!esito.isServizioAutorizzato()) {
                                    msgErroreAutorizzazione = esito.getMsgErrore();
                                    codiceErroreAutorizzazione = esito.getCodiceErrore();
                                }
                            } else {
                                msgErroreAutorizzazione = "gestore [" + tipoAutorizzazione + "] non inizializzato";
                                codiceErroreAutorizzazione = "OPENSPCOOP_ORG_504";
                            }
                        }
                        catch (Exception e) {
                            msgErroreAutorizzazione = "processo di autorizzazione [" + tipoAutorizzazione + "] fallito, " + e.getMessage();
                            codiceErroreAutorizzazione = "OPENSPCOOP_ORG_504";
                        }
                        if (msgErroreAutorizzazione != null) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErroreAutorizzazione);
                            msgDiag.logPersonalizzato(msgDiag.getMessaggio("servizioApplicativoFruitore.nonAutorizzato"), msgDiag.getLivello("servizioApplicativoFruitore.nonAutorizzato"));
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErroreAutorizzazione, msgDiag.getMessaggio("servizioApplicativoFruitore.nonAutorizzato")), logCore, msgDiag, info);
                            }
                            return;
                        }
                    }
                    infoSearch = idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato dal Soggetto " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                    if (idServizio.getAzione() != null) {
                        infoSearch = infoSearch + " azione " + idServizio.getAzione();
                    }
                    riferimentoServizioCorrelato = null;
                    if (headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                        riferimentoServizioCorrelato = headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio();
                    }
                    infoSearch = riferimentoServizioCorrelato != null ? "Servizio correlato " + infoSearch : "Servizio " + infoSearch;
                    infoSearch = "Ricerca nel registro dei servizi di: " + infoSearch;
                    if (riferimentoServizioCorrelato != null) {
                        infoSearch = infoSearch + " (idServizioCorrelato: " + riferimentoServizioCorrelato + ")";
                    }
                    msgDiag.addKeyword("@INFO_SERVIZIO_SPCOOP@", infoSearch);
                    msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioInCorso"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioInCorso"));
                    msgDiag.mediumDebug("Ricerca nome registro...");
                    nomeRegistroForSearch = null;
                    try {
                        nomeRegistroForSearch = configurazionePdDReader.getRegistroForImbustamento(soggettoFruitore, idServizio);
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "connettore associato al servizio non trovato, " + e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_514", "Sistema non disponibile"), logCore, msgDiag, info);
                        }
                        return;
                    }
                    isServizioCorrelato = false;
                    invocazioneAzioneErrata = null;
                    portTypeErrato = null;
                    ricercaConErrore = false;
                    servizioNonTrovato = false;
                    infoServizio = null;
                    try {
                        if (riferimentoServizioCorrelato != null) {
                            erroreRicerca = null;
                            msgDiag.mediumDebug("Ricerca servizio correlato ...");
                            try {
                                infoServizio = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                isServizioCorrelato = true;
                            }
                            catch (DriverRegistroServiziAzioneNotFound e) {
                                invocazioneAzioneErrata = e.getMessage();
                                throw e;
                            }
                            catch (DriverRegistroServiziNotFound e) {
                                erroreRicerca = "\nRicerca come servizio correlato-> " + e.getMessage();
                            }
                            if (infoServizio == null && idServizio.getAzione() != null) {
                                msgDiag.mediumDebug("Ricerca servizio con azione correlata...");
                                try {
                                    infoServizio = registroServiziReader.getInfoServizioAzioneCorrelata(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                    isServizioCorrelato = true;
                                }
                                catch (DriverRegistroServiziAzioneNotFound e) {
                                    invocazioneAzioneErrata = e.getMessage();
                                    throw e;
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                    erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                                }
                            }
                            if (infoServizio == null && erroreRicerca == null) {
                                throw new DriverRegistroServiziNotFound("Servizio Correlato non trovato ne tramite la normale ricerca, ne tramite la ricerca per azione correlata (solo se profilo e' asincrono asimmetrico)");
                            }
                            if (infoServizio == null) {
                                throw new DriverRegistroServiziNotFound(erroreRicerca);
                            }
                            break block267;
                        }
                        erroreRicerca = null;
                        msgDiag.mediumDebug("Ricerca servizio ...");
                        try {
                            infoServizio = registroServiziReader.getInfoServizio(soggettoFruitore, idServizio, nomeRegistroForSearch);
                        }
                        catch (DriverRegistroServiziAzioneNotFound e) {
                            invocazioneAzioneErrata = e.getMessage();
                            throw e;
                        }
                        catch (DriverRegistroServiziNotFound e) {
                            erroreRicerca = "\nRicerca come servizio -> " + e.getMessage();
                        }
                        if (infoServizio == null) {
                            msgDiag.mediumDebug("Ricerca servizio correlato...");
                            try {
                                infoServizio = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                isServizioCorrelato = true;
                            }
                            catch (DriverRegistroServiziAzioneNotFound e) {
                                invocazioneAzioneErrata = e.getMessage();
                                throw e;
                            }
                            catch (DriverRegistroServiziNotFound e) {
                                erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                            }
                        }
                        if (infoServizio == null && erroreRicerca == null) {
                            throw new DriverRegistroServiziNotFound("Servizio non trovato ne tramite la normale ricerca, ne tramite la ricerca per servizio correlato");
                        }
                        if (infoServizio == null) {
                            throw new DriverRegistroServiziNotFound(erroreRicerca);
                        }
                    }
                    catch (DriverRegistroServiziNotFound e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                        servizioNonTrovato = true;
                    }
                    catch (DriverRegistroServiziAzioneNotFound e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                    }
                    catch (DriverRegistroServiziPortTypeNotFound e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "configurazione registro dei servizi errata, " + e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                        portTypeErrato = "Configurazione del registro dei Servizi errata: " + e.getMessage();
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "errore generale, " + e.getMessage());
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                        ricercaConErrore = true;
                    }
                }
                if (infoServizio == null) {
                    if (!servizioNonTrovato && !ricercaConErrore && invocazioneAzioneErrata == null) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio non esistente");
                        msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                        servizioNonTrovato = true;
                    }
                    codiceErrore = null;
                    msgErrore = null;
                    if (invocazioneAzioneErrata != null) {
                        codiceErrore = "OPENSPCOOP_ORG_423";
                        msgErrore = "Azione utilizzata con il Servizio SPCoop richiesto con la porta delegata non corretta:  (azione:" + idServizio.getAzione() + ") " + invocazioneAzioneErrata;
                    } else if (portTypeErrato != null) {
                        codiceErrore = "OPENSPCOOP_ORG_540";
                        msgErrore = portTypeErrato;
                    } else if (servizioNonTrovato) {
                        codiceErrore = "OPENSPCOOP_ORG_405";
                        msgErrore = "Servizio SPCoop richiesto con la porta delegata non trovato nel registro dei servizi di OpenSPCoop";
                    } else if (ricercaConErrore) {
                        codiceErrore = "OPENSPCOOP_ORG_534";
                        msgErrore = "Sistema non disponibile";
                    } else {
                        codiceErrore = "OPENSPCOOP_ORG_533";
                        msgErrore = "Sistema non disponibile";
                    }
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, codiceErrore, msgErrore), logCore, msgDiag, info);
                    }
                    return;
                }
                infoServizio.setCorrelato(isServizioCorrelato);
                info.setProfiloCollaborazione(infoServizio.getProfiloDiCollaborazione());
                msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", infoServizio.getProfiloDiCollaborazione());
                try {
                    profiloGestione = registroServiziReader.getProfiloGestioneFruizioneServizio(idServizio, nomeRegistroForSearch);
                    richiestaDelegata.setProfiloGestione(profiloGestione);
                    msgDiag.mediumDebug("Profilo di gestione [RicezioneContenutiApplicativi] della busta: " + profiloGestione);
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "analisi del profilo di gestione fallita, " + e.getMessage());
                    msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioFallita"));
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile"), logCore, msgDiag, info);
                    }
                    return;
                }
                msgDiag.logPersonalizzato(msgDiag.getMessaggio("imbustamentoBustaEGov.", "registroServizi.ricercaServizioEffettuata"), msgDiag.getLivello("imbustamentoBustaEGov.", "registroServizi.ricercaServizioEffettuata"));
                implementazionePdDMittente = null;
                implementazionePdDDestinatario = null;
                msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
                try {
                    implementazionePdDMittente = registroServiziReader.getImplementazionePdD(soggettoFruitore, null);
                    implementazionePdDDestinatario = registroServiziReader.getImplementazionePdD(idServizio.getSoggettoErogatore(), null);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ricercaImplementazioniPdD");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_534", "Sistema non disponibile"), logCore, msgDiag, info);
                    }
                    return;
                }
                msgDiag.mediumDebug("ImplementazionePdD soggetto (" + soggettoFruitore.toString() + ") e' [" + implementazionePdDMittente + "], soggetto (" + idServizio.getSoggettoErogatore().toString() + ") e' [" + implementazionePdDDestinatario + "]");
                msgDiag.mediumDebug("Controllo validazione xsd abilitata/disabilitata...");
                validazioneContenutoApplicativoApplicativo = null;
                try {
                    validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDDestinatario);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "getTipoValidazioneContenutoApplicativo(pd," + implementazionePdDDestinatario + ")");
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, info);
                    }
                    return;
                }
                if ("abilitato".equals(validazioneContenutoApplicativoApplicativo.getStato()) || "warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                    binXSD = null;
                    try {
                        block268: {
                            msgDiag.mediumDebug("Validatore contenuti applicativi della richiesta...");
                            readWSDL = "wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo());
                            validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(registroServiziReader, richiestaDelegata.getIdServizio(), requestMessage.getSOAPBody(), readWSDL);
                            checkStyle = false;
                            if (richiestaDelegata.getIdServizio().getAzione() != null && (readWSDL || "openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo()))) {
                                checkStyle = true;
                            }
                            msgDiag.mediumDebug("Validatore contenuti applicativi (raccolta url XSD Definitorio)...");
                            urlXSD = validatoreMessaggiApplicativi.getURLWsdlDefinitorio();
                            bytesXSD = validatoreMessaggiApplicativi.getBytesWsdlDefinitorio();
                            if (urlXSD == null && (bytesXSD == null || bytesXSD.length <= 0)) {
                                throw new Exception("Wsdl definitorio (xsd) non definito nell'accordo di servizio");
                            }
                            if (urlXSD != null) {
                                msgDiag.mediumDebug("Validazione xsd (url:" + urlXSD + ") della richiesta ...");
                            } else {
                                msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                            }
                            validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true, checkStyle);
                            if (richiestaDelegata.getIdServizio().getAzione() == null || !"wsdl".equals(validazioneContenutoApplicativoApplicativo.getTipo()) && !"openspcoop".equals(validazioneContenutoApplicativoApplicativo.getTipo())) break block268;
                            msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                            validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true, this.msgContext.getSoapAction());
                        }
                        var57_113 = null;
                        ** if (binXSD == null) goto lbl-1000
                    }
                    catch (Throwable var56_123) {
                        var57_116 = null;
                        if (binXSD != null) {
                            try {
                                binXSD.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var56_123;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            binXSD.close();
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block269;
                        catch (ValidatoreMessaggiApplicativiException ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato(msgDiag.getMessaggio("validazioneContenutiApplicativiNonRiuscita"), msgDiag.getLivello("validazioneContenutiApplicativiNonRiuscita"));
                            if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, ex.getCodiceErrore(), ex.getMsgErrore()), logCore, msgDiag, info);
                                }
                                var57_114 = null;
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            var57_113 = null;
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                            break block269;
                        }
                        catch (Exception ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato(msgDiag.getMessaggio("validazioneContenutiApplicativiNonRiuscita"), msgDiag.getLivello("validazioneContenutiApplicativiNonRiuscita"));
                            logCore.error((Object)"Riscontrato errore durante la validazione xsd della richiesta applicativa", (Throwable)ex);
                            if (!"warningOnly".equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_531", "Sistema non disponibile"), logCore, msgDiag, info);
                                }
                                var57_115 = null;
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            var57_113 = null;
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
            }
            msgDiag.mediumDebug("Controllo tipo di invocazione (riferimento/normale)...");
            invocazionePDPerRiferimento = false;
            try {
                invocazionePDPerRiferimento = configurazionePdDReader.invocazionePortaDelegataPerRiferimento(sa);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "invocazionePortaDelegataPerRiferimento(sa)");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, info);
                }
                return;
            }
            if (invocazionePDPerRiferimento) {
                if (!this.msgContext.isInvocazionePDPerRiferimento()) {
                    msgDiag.logPersonalizzato(msgDiag.getMessaggio("portaDelegataInvocabilePerRiferimento.riferimentoNonPresente"), msgDiag.getLivello("portaDelegataInvocabilePerRiferimento.riferimentoNonPresente"));
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_412", msgDiag.getMessaggio("portaDelegataInvocabilePerRiferimento.riferimentoNonPresente")), logCore, msgDiag, info);
                    }
                    return;
                }
            } else if (this.msgContext.isInvocazionePDPerRiferimento()) {
                msgDiag.logPersonalizzato(msgDiag.getMessaggio("portaDelegataInvocabileNormalmente.riferimentoPresente"), msgDiag.getLivello("portaDelegataInvocabileNormalmente.riferimentoPresente"));
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_413", msgDiag.getMessaggio("portaDelegataInvocabileNormalmente.riferimentoPresente")), logCore, msgDiag, info);
                }
                return;
            }
            msgDiag.logPersonalizzato(msgDiag.getMessaggio("ricevutaRichiestaApplicativa"), msgDiag.getLivello("ricevutaRichiestaApplicativa"));
            if (!propertiesReader.deleteHeaderIntegrazionePD()) {
                for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                    try {
                        gestore = RicezioneContenutiApplicativi.gestoriIntegrazionePD.get(tipiIntegrazionePD[i]);
                        if (gestore == null || !(gestore instanceof IGestoreIntegrazionePDSoap)) continue;
                        servizioApplicativoDaInserireHeader = null;
                        if (!"Anonimo".equals(servizioApplicativo)) {
                            servizioApplicativoDaInserireHeader = servizioApplicativo;
                        }
                        ((IGestoreIntegrazionePDSoap)gestore).updateHeader(requestMessage, soggettoFruitore, idServizio, idEGovRequest, servizioApplicativoDaInserireHeader, idCorrelazioneApplicativa);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "updateHeaderIntegrazione(" + tipiIntegrazionePD[i] + ")");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_541", "Sistema non disponibile"), logCore, msgDiag, info);
                        }
                        return;
                    }
                }
            }
            allegaBody = false;
            scartaBody = false;
            try {
                allegaBody = configurazionePdDReader.isAllegaBody(pd);
                scartaBody = configurazionePdDReader.isScartaBody(pd);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "configurazionePdDReader.isAllega/ScartaBody(pd)");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, info);
                }
                return;
            }
            if (scartaBody) {
                try {
                    if (requestMessage.countAttachments() <= 0) {
                        throw new Exception("La funzionalita' e' permessa solo per messaggi SOAP With Attachments");
                    }
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato(msgDiag.getMessaggio("funzionalitaScartaBodyNonEffettuabile"), msgDiag.getLivello("funzionalitaScartaBodyNonEffettuabile"));
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_425", "Funzionalita' 'scarta body' non e' riuscito ad utilizzare il messaggio inviato dal client: " + e.getMessage()), logCore, msgDiag, info);
                    }
                    return;
                }
            }
            if (allegaBody) {
                try {
                    if (requestMessage.countAttachments() > 0) {
                        throw new Exception("La funzionalita' non e' permessa per messaggi SOAP With Attachments");
                    }
                    body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)requestMessage.getSOAPEnvelope());
                    ap = (org.apache.axis.attachments.AttachmentPart)requestMessage.createAttachmentPart();
                    isContent = new ByteArrayInputStream(body);
                    ap.setContent((Object)isContent, "text/xml");
                    requestMessage.addAttachmentPart((AttachmentPart)ap);
                    requestMessage.getSOAPBody().removeContents();
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato(msgDiag.getMessaggio("funzionalitaAllegaBodyNonEffettuabile"), msgDiag.getLivello("funzionalitaAllegaBodyNonEffettuabile"));
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_424", "Funzionalita' 'allega body' non e' riuscito ad utilizzare il messaggio inviato dal client: " + e.getMessage()), logCore, msgDiag, info);
                    }
                    return;
                }
            }
            oneWayStateless = false;
            oneWayVersione11 = false;
            sincronoStateless = false;
            asincronoStateless = false;
            portaStateless = false;
            try {
                if (propertiesReader.isPdDLight()) {
                    oneWayStateless = true;
                    sincronoStateless = true;
                    asincronoStateless = true;
                }
                if ("EGOV_IT_MessaggioSingoloOneWay".equals(infoServizio.getProfiloDiCollaborazione())) {
                    oneWayStateless = configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione());
                } else if ("EGOV_IT_ServizioSincrono".equals(infoServizio.getProfiloDiCollaborazione())) {
                    sincronoStateless = configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione());
                } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(infoServizio.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoAsimmetrico".equals(infoServizio.getProfiloDiCollaborazione())) {
                    asincronoStateless = configurazionePdDReader.isModalitaStatelessByProfiloServizio(pd, infoServizio.getProfiloDiCollaborazione());
                }
                v0 = oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && "EGOV_IT_MessaggioSingoloOneWay".equals(infoServizio.getProfiloDiCollaborazione()) != false && oneWayStateless == false;
                if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11) {
                    openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)openspcoopstate, true);
                    portaStateless = true;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneStatelessStateful");
                logCore.error((Object)("Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + e));
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_536", "Sistema non disponibile"), logCore, msgDiag, info);
                }
                return;
            }
            msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
            msgRequest = new GestoreMessaggi(openspcoopstate, true, idEGovRequest, "OUTBOX", msgDiag);
            msgRequest.setOneWayVersione11(oneWayVersione11);
            try {
                if (!msgRequest.existsMessage_noCache()) break block272;
                proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                    msgDiag.lowDebug("Altra copia della Busta eGov con id[" + idEGovRequest + "] gia' elaborata, forzo eliminazione prima di continuare il processamento");
                    msgRequest.deleteMessage();
                    break block272;
                }
                msgDiag.errorOpenSPCoop("Altra copia della Busta eGov con id[" + idEGovRequest + "] gia' in elaborazione dal modulo [" + proprietarioMessaggio + "]");
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_537", "La richiesta assegnata alla busta SPCoop con ID=XXX e' gia' stata ricevuta e risulta ancora in processamento".replace("XXX", idEGovRequest)), logCore, msgDiag, info);
                }
                return;
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                logCore.error((Object)"Controllo/gestione presenza messaggio gia in gestione non riuscito", (Throwable)e);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_537", "Sistema non disponibile"), logCore, msgDiag, info);
                }
                return;
            }
        }
        msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
        richiestaAsincronaSimmetricaStateless = false;
        try {
            if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(infoServizio.getProfiloDiCollaborazione()) && portaStateless) {
                richiestaAsincronaSimmetricaStateless = "eGov1.1-lineeGuida1.1".equalsIgnoreCase(richiestaDelegata.getProfiloGestione()) ? (headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null ? false : headerIntegrazioneRichiesta.getEgov().getIdCollaborazione() == null) : headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() == null;
            }
            msgRequest.registraMessaggio(requestMessage, dataIngressoMessaggio, oneWayStateless != false || sincronoStateless != false || asincronoStateless != false);
            msgRequest.aggiornaProprietarioMessaggio("Imbustamento");
            if (richiestaAsincronaSimmetricaStateless) {
                msgRequest.registraInformazioniMessaggio_statelessEngine(dataIngressoMessaggio, "Imbustamento", idCorrelazioneApplicativa);
            }
        }
        catch (GestoreMessaggiException e) {
            msgDiag.logErroreGenerico(e, "msgRequest.aggiornaProprietarioMessaggio");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_508", "Sistema non disponibile"), logCore, msgDiag, info);
            }
            return;
        }
        msgDiag.mediumDebug("Registrazione busta eGov di richiesta nel RepositoryEGov...");
        repositoryEGov = new RepositoryEGov(openspcoopstate.getStatoRichiesta(), true);
        try {
            if (!portaStateless || oneWayVersione11) {
                if (repositoryEGov.isRegistrataIntoOutBox(idEGovRequest)) {
                    repositoryEGov.aggiornaBustaIntoOutBox(idEGovRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                    repositoryEGov.impostaUtilizzoPdDIntoOutBox(idEGovRequest);
                } else {
                    repositoryEGov.registraBustaIntoOutBox(idEGovRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                }
                infoIntegrazione = new Integrazione();
                infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
                infoIntegrazione.setLocationPD(richiestaDelegata.getLocationPD());
                infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                repositoryEGov.aggiornaInfoIntegrazioneIntoOutBox(idEGovRequest, infoIntegrazione);
            }
        }
        catch (EGovException e) {
            msgDiag.logErroreGenerico((Exception)e, "registrazioneAggiornamentoBusta");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_525", "Sistema non disponibile"), logCore, msgDiag, info);
            }
            return;
        }
        msgDiag.mediumDebug("Invio messaggio al modulo di Imbustamento...");
        try {
            msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
            imbustamentoMSG.setRichiestaDelegata(richiestaDelegata);
            imbustamentoMSG.setInfoServizio(infoServizio);
            imbustamentoMSG.setOneWayVersione11(oneWayVersione11);
            if (headerIntegrazioneRichiesta.getEgov() != null) {
                if ("eGov1.1-lineeGuida1.1".equalsIgnoreCase(richiestaDelegata.getProfiloGestione())) {
                    if (headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                        imbustamentoMSG.setRiferimentoServizioCorrelato(headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio());
                    } else if (headerIntegrazioneRichiesta.getEgov().getIdCollaborazione() != null) {
                        imbustamentoMSG.setRiferimentoServizioCorrelato(headerIntegrazioneRichiesta.getEgov().getIdCollaborazione());
                    }
                } else {
                    imbustamentoMSG.setRiferimentoServizioCorrelato(headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio());
                }
                if (headerIntegrazioneRichiesta.getEgov().getIdCollaborazione() != null) {
                    imbustamentoMSG.setIdCollaborazione(headerIntegrazioneRichiesta.getEgov().getIdCollaborazione());
                }
                imbustamentoMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                imbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
            }
            if (!portaStateless) {
                logCore.debug((Object)"RicezioneContenutiApplicativi :eseguo send a imbustamento...");
                RicezioneContenutiApplicativi.nodeSender.send(imbustamentoMSG, "Imbustamento", msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, msgRequest);
                logCore.debug((Object)"RicezioneContenutiApplicativi :send a imbustamento effettuata");
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(Imbustamento)");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_512", "Sistema non disponibile"), logCore, msgDiag, info);
            }
            return;
        }
        msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            openspcoopstate.commit();
            logCore.debug((Object)"RicezioneContenutiApplicativi :RicezioneContenutiApplicativi commit eseguito");
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "openspcoopstate.commit");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_506", "Sistema non disponibile"), logCore, msgDiag, info);
            }
            return;
        }
        if (!portaStateless) {
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta", null, false);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
            openspcoopstate.setPool(false);
        }
        parametriGestioneRisposta = new RicezioneContenutiApplicativiGestioneRisposta();
        parametriGestioneRisposta.setOpenspcoopstate(openspcoopstate);
        parametriGestioneRisposta.setMsgDiag(msgDiag);
        parametriGestioneRisposta.setLogCore(logCore);
        parametriGestioneRisposta.setPropertiesReader(propertiesReader);
        parametriGestioneRisposta.setXmlBuilder(xmlBuilder);
        parametriGestioneRisposta.setIdentitaPdD(identitaPdD);
        parametriGestioneRisposta.setIdEGovRequest(idEGovRequest);
        parametriGestioneRisposta.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
        parametriGestioneRisposta.setHeaderIntegrazioneRisposta(headerIntegrazioneRisposta);
        parametriGestioneRisposta.setTipiIntegrazionePD(tipiIntegrazionePD);
        parametriGestioneRisposta.setProprietaErroreAppl(proprietaErroreAppl);
        parametriGestioneRisposta.setServizioApplicativo(servizioApplicativo);
        parametriGestioneRisposta.setInfo(info);
        parametriGestioneRisposta.setDataIngressoMessaggio(dataIngressoMessaggio);
        parametriGestioneRisposta.setMsgRequest(msgRequest);
        parametriGestioneRisposta.setRepositoryEGov(repositoryEGov);
        parametriGestioneRisposta.setPortaStateless(portaStateless);
        parametriGestioneRisposta.setOneWayVers11(oneWayVersione11);
        parametriGestioneRisposta.setRichiestaAsincronaSimmetricaStateless(richiestaAsincronaSimmetricaStateless);
        if (portaStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            result = this.comportamentoStateless(parametriGestioneRisposta, imbustamentoMSG);
            if (!result) {
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        msgDiag.mediumDebug("Gestione risposta...");
        if (!this.msgContext.isGestioneRisposta()) {
            if (portaStateless) {
                openspcoopstate.releaseResource();
            }
            return;
        }
        this.gestioneRisposta(parametriGestioneRisposta);
        msgDiag.mediumDebug("Lavoro Terminato.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean comportamentoStateless(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta, ImbustamentoMessage imbustamentoMSG) {
        EsitoLib esito;
        OpenSPCoopStateless openspcoopstate;
        block26: {
            openspcoopstate = (OpenSPCoopStateless)parametriGestioneRisposta.getOpenspcoopstate();
            MsgDiagnostico msgDiag = parametriGestioneRisposta.getMsgDiag();
            Logger logCore = parametriGestioneRisposta.getLogCore();
            XMLBuilder xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
            OpenSPCoopProperties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
            String idEGovRequest = parametriGestioneRisposta.getIdEGovRequest();
            ProprietaErroreApplicativo proprietaErroreAppl = parametriGestioneRisposta.getProprietaErroreAppl();
            GestoreMessaggi msgRequest = parametriGestioneRisposta.getMsgRequest();
            InfoAttraversamentoPdD info = parametriGestioneRisposta.getInfo();
            parametriGestioneRisposta.setPortaStateless(true);
            boolean rinegoziamentoConnessione = propertiesReader.isGestioneStateful_RinegoziamentoConnessione() && !parametriGestioneRisposta.isOneWayVers11();
            Imbustamento imbustamentoLib = new Imbustamento(logCore);
            openspcoopstate.setMessageLib(imbustamentoMSG);
            openspcoopstate.setIDEgovSessione(idEGovRequest);
            try {
                esito = imbustamentoLib.onMessage(openspcoopstate);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.Imbustamento");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile"), logCore, msgDiag, info);
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO) && propertiesReader.isGestioneOnewayStateful_1_1()) {
                return true;
            }
            if (rinegoziamentoConnessione) {
                openspcoopstate.setUseConnection(true);
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                openspcoopstate.releaseResource();
                openspcoopstate.setUseConnection(false);
            }
            InoltroBusteEGov inoltroBusteLib = new InoltroBusteEGov(logCore);
            try {
                esito = inoltroBusteLib.onMessage(openspcoopstate);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.InoltroBusteEGov");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile"), logCore, msgDiag, info);
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                return true;
            }
            SbustamentoRisposte sbustamentoRisposteLib = new SbustamentoRisposte(logCore);
            boolean erroreSbustamentoRisposta = false;
            if (rinegoziamentoConnessione && openspcoopstate.resourceReleased()) {
                openspcoopstate.setUseConnection(true);
                openspcoopstate.initResource(parametriGestioneRisposta.getIdentitaPdD(), "SbustamentoRisposte");
                openspcoopstate.setUseConnection(false);
            }
            esito = sbustamentoRisposteLib.onMessage(openspcoopstate);
            Object var21_21 = null;
            if (!rinegoziamentoConnessione || erroreSbustamentoRisposta) break block26;
            openspcoopstate.setUseConnection(true);
            try {
                openspcoopstate.commit();
            }
            catch (Exception e2) {
                // empty catch block
            }
            openspcoopstate.releaseResource();
            openspcoopstate.setUseConnection(false);
            {
                break block26;
                catch (Exception e) {
                    erroreSbustamentoRisposta = true;
                    msgDiag.logErroreGenerico(e, "Stateless.SbustamentoRisposte");
                    logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile"), logCore, msgDiag, info);
                    }
                    boolean bl = false;
                    Object var21_22 = null;
                    if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                        openspcoopstate.setUseConnection(true);
                        try {
                            openspcoopstate.commit();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        openspcoopstate.releaseResource();
                        openspcoopstate.setUseConnection(false);
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                    openspcoopstate.setUseConnection(true);
                    try {
                        openspcoopstate.commit();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    openspcoopstate.releaseResource();
                    openspcoopstate.setUseConnection(false);
                }
                throw throwable;
            }
        }
        if (esito.getStatoInvocazione() != 1) {
            openspcoopstate.setUseConnection(true);
            this.gestioneRisposta(parametriGestioneRisposta);
            return false;
        }
        return true;
    }

    private void gestioneRisposta(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta) {
        IGestoreIntegrazionePD gestore;
        Date[] dateGestioneMessaggi;
        Message responseMessage;
        String profiloCollaborazione;
        String idCollaborazioneResponse;
        String idEGovResponse;
        boolean richiestaAsincronaSimmetricaStateless;
        boolean oneWayVers11;
        boolean portaStateless;
        GestoreMessaggi msgRequest;
        Timestamp dataIngressoMessaggio;
        InfoAttraversamentoPdD info;
        String[] tipiIntegrazionePD;
        HeaderIntegrazione headerIntegrazioneRisposta;
        HeaderIntegrazione headerIntegrazioneRichiesta;
        String servizioApplicativo;
        ProprietaErroreApplicativo proprietaErroreAppl;
        String idEGovRequest;
        XMLBuilder xmlBuilder;
        Logger logCore;
        MsgDiagnostico msgDiag;
        IOpenSPCoopState openspcoopstate;
        block51: {
            openspcoopstate = parametriGestioneRisposta.getOpenspcoopstate();
            msgDiag = parametriGestioneRisposta.getMsgDiag();
            logCore = parametriGestioneRisposta.getLogCore();
            OpenSPCoopProperties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
            xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
            IDSoggetto identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
            idEGovRequest = parametriGestioneRisposta.getIdEGovRequest();
            proprietaErroreAppl = parametriGestioneRisposta.getProprietaErroreAppl();
            servizioApplicativo = parametriGestioneRisposta.getServizioApplicativo();
            headerIntegrazioneRichiesta = parametriGestioneRisposta.getHeaderIntegrazioneRichiesta();
            headerIntegrazioneRisposta = parametriGestioneRisposta.getHeaderIntegrazioneRisposta();
            tipiIntegrazionePD = parametriGestioneRisposta.getTipiIntegrazionePD();
            info = parametriGestioneRisposta.getInfo();
            dataIngressoMessaggio = parametriGestioneRisposta.getDataIngressoMessaggio();
            msgRequest = parametriGestioneRisposta.getMsgRequest();
            portaStateless = parametriGestioneRisposta.isPortaStateless();
            oneWayVers11 = parametriGestioneRisposta.isOneWayVers11();
            richiestaAsincronaSimmetricaStateless = parametriGestioneRisposta.isRichiestaAsincronaSimmetricaStateless();
            idEGovResponse = null;
            idCollaborazioneResponse = null;
            profiloCollaborazione = null;
            responseMessage = null;
            dateGestioneMessaggi = null;
            try {
                RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG;
                if (portaStateless || oneWayVers11) {
                    ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)((OpenSPCoopStateless)openspcoopstate).getMessageLib();
                    idEGovResponse = ricezioneContenutiApplicativiMSG.getIdEGovRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
                    info.setIdMessaggioRitorno(idEGovResponse);
                    info.setIdCorrelazione(idCollaborazioneResponse);
                    dateGestioneMessaggi = ((OpenSPCoopStateless)openspcoopstate).getTempiAttraversamentoPDD().getInfoAttraversamentoPdDMessaggioRisposta();
                    msgDiag.setIdEGovRisposta(idEGovResponse);
                    msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGovResponse);
                    break block51;
                }
                try {
                    responseMessage = SoapUtils.build_Soap_Empty();
                    msgDiag.mediumDebug("Attesa/lettura risposta...");
                    ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)nodeReceiver.receive(msgDiag, identitaPdD.getCodicePorta(), this.msgContext.getIdModulo(), idEGovRequest, propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi(), propertiesReader.getNodeReceiverCheckInterval());
                    idEGovResponse = ricezioneContenutiApplicativiMSG.getIdEGovRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    info.setIdMessaggioRitorno(idEGovResponse);
                    info.setIdCorrelazione(idCollaborazioneResponse);
                }
                catch (Exception e) {
                    logCore.error((Object)("Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore"), (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GestioneRispostaErroreGenerale");
                    if (e instanceof NodeTimeoutException) {
                        try {
                            openspcoopstate.updateResource();
                        }
                        catch (Exception eDB) {
                            msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                            this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_505", "Sistema non disponibile"), logCore, msgDiag, info);
                            return;
                        }
                        try {
                            msgDiag.logPersonalizzato(msgDiag.getMessaggio("timeoutRicezioneRisposta"), msgDiag.getLivello("timeoutRicezioneRisposta"));
                            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            openspcoopstate.commit();
                        }
                        catch (Exception eDel) {
                            msgDiag.logErroreGenerico(eDel, "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                        }
                        openspcoopstate.releaseResource();
                    }
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_513", "Sistema non disponibile"), logCore, msgDiag, info);
                    return;
                }
                msgDiag.setIdEGovRisposta(idEGovResponse);
                msgDiag.addKeyword("@ID_EGOV_RISPOSTA@", idEGovResponse);
                msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                try {
                    openspcoopstate.updateResource();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_505", "Sistema non disponibile"), logCore, msgDiag, info);
                    return;
                }
                msgRequest.updateOpenSPCoopState(openspcoopstate);
                msgDiag.mediumDebug("Lettura messaggio di risposta...");
                GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "INBOX", msgDiag);
                try {
                    Date[] dRichiesta;
                    responseMessage = msgResponse.getMessage();
                    dateGestioneMessaggi = msgResponse.getInfoAttraversamentoPdDMessaggioRisposta();
                    if (dateGestioneMessaggi != null && (dateGestioneMessaggi[0] == null || dateGestioneMessaggi[1] == null) && (dRichiesta = msgRequest.getInfoAttraversamentoPdDMessaggioRisposta()) != null) {
                        dateGestioneMessaggi[1] = dRichiesta[1];
                    }
                }
                catch (GestoreMessaggiException e) {
                    msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    openspcoopstate.releaseResource();
                    this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_511", "Sistema non disponibile"), logCore, msgDiag, info);
                    return;
                }
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                msgDiag.logErroreGenerico(e, "ErroreGenerale");
                openspcoopstate.releaseResource();
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile"), logCore, msgDiag, info);
            }
        }
        msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
        headerIntegrazioneRisposta.getEgov().setIdCollaborazione(idCollaborazioneResponse);
        headerIntegrazioneRisposta.getEgov().setProfiloDiCollaborazione(profiloCollaborazione);
        headerIntegrazioneRisposta.getEgov().setID(idEGovRequest);
        if (gestoriIntegrazionePD.containsKey("trasporto") || this.msgContext.getIdModulo().startsWith("RicezioneContenutiApplicativiIntegrationManager")) {
            try {
                Properties propertiesIntegrazioneRisposta = new Properties();
                gestore = gestoriIntegrazionePD.get("trasporto");
                if (gestore != null) {
                    gestore.setResponseHeader(headerIntegrazioneRisposta, null, propertiesIntegrazioneRisposta);
                    this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
            }
        }
        for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
            try {
                gestore = gestoriIntegrazionePD.get(tipiIntegrazionePD[i]);
                if (gestore != null) {
                    gestore.setResponseHeader(headerIntegrazioneRisposta, responseMessage, new Properties());
                    continue;
                }
                msgDiag.logErroreGenerico("Creazione header di integrazione [" + tipiIntegrazionePD[i] + "] non riuscito, gestore non inzializzato", "setHeaderIntegrazioneRisposta");
                continue;
            }
            catch (Exception e) {
                logCore.error((Object)("Errore durante la creazione dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage()), (Throwable)e);
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta(" + tipiIntegrazionePD[i] + ")");
            }
        }
        if (!portaStateless) {
            this.eliminaSIL((OpenSPCoopStateful)openspcoopstate, msgDiag, idEGovRequest, idEGovResponse, servizioApplicativo);
        }
        if (portaStateless && !oneWayVers11) {
            msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                if (richiestaAsincronaSimmetricaStateless) {
                    boolean resourceReleased = openspcoopstate.resourceReleased();
                    if (resourceReleased) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.updateResource();
                    }
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "INBOX", msgDiag);
                    msgResponse.setReadyForDrop(true);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgResponse.setReadyForDrop(false);
                    msgRequest.updateOpenSPCoopState(openspcoopstate);
                    msgRequest.setReadyForDrop(true);
                    msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgRequest.setReadyForDrop(false);
                }
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Errore durante l'aggiornamento del proprietario al GestoreMessaggi (Stateless)", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                openspcoopstate.releaseResource();
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile"), logCore, msgDiag, info);
            }
        }
        if (oneWayVers11) {
            msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless ibrido versione 1.2 ...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Riscontrato errore durante il commit della gestione oneWay stateful/stateless ibrido versione 1.2", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                openspcoopstate.releaseResource();
                this.setMessageResponseIntoContext(xmlBuilder.msgErroreApplicativo_Processamento(proprietaErroreAppl, "OPENSPCOOP_ORG_500", "Sistema non disponibile"), logCore, msgDiag, info);
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        if (profiloCollaborazione != null) {
            if (profiloCollaborazione.equals("EGOV_IT_ServizioSincrono")) {
                msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta applicativa sincrona");
                msgDiag.logPersonalizzato(msgDiag.getMessaggio("consegnaRispostaApplicativa"), msgDiag.getLivello("consegnaRispostaApplicativa"));
            } else if (profiloCollaborazione.equals("EGOV_IT_ServizioAsincronoSimmetrico")) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                }
                msgDiag.logPersonalizzato(msgDiag.getMessaggio("consegnaRispostaApplicativa"), msgDiag.getLivello("consegnaRispostaApplicativa"));
            } else if (profiloCollaborazione.equals("EGOV_IT_ServizioAsincronoAsimmetrico")) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getEgov() != null && headerIntegrazioneRichiesta.getEgov().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                }
                msgDiag.logPersonalizzato(msgDiag.getMessaggio("consegnaRispostaApplicativa"), msgDiag.getLivello("consegnaRispostaApplicativa"));
            }
        }
        boolean esito = true;
        try {
            SOAPBody body = responseMessage.getSOAPBody();
            if (proprietaErroreAppl.isFaultAsXML()) {
                if (body.hasChildNodes() && body.getChildNodes().getLength() == 1 && "http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/".equals(body.getFirstChild().getNamespaceURI())) {
                    esito = false;
                }
            } else if (body.hasFault()) {
                esito = false;
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ImpostazioneTempiAttraversamentoPdD");
            esito = false;
        }
        if (dateGestioneMessaggi != null) {
            Date ricezioneMessaggioIngresso = null;
            Date spedizioneMessaggioIngresso = null;
            Date ricezioneMessaggioRisposta = null;
            if (dateGestioneMessaggi[1] != null) {
                ricezioneMessaggioIngresso = new Date(dataIngressoMessaggio.getTime());
                spedizioneMessaggioIngresso = dateGestioneMessaggi[1];
            }
            if (dateGestioneMessaggi[2] != null) {
                ricezioneMessaggioRisposta = dateGestioneMessaggi[2];
            }
            info.setTimeStamp1(ricezioneMessaggioIngresso);
            info.setTimeStamp2(spedizioneMessaggioIngresso);
            info.setTimeStamp3(ricezioneMessaggioRisposta);
        }
        info.setStato(esito);
        msgDiag.mediumDebug("Imposto risposta nel context...");
        this.setMessageResponseIntoContext(responseMessage, logCore, msgDiag, info);
    }

    private void eliminaSIL(OpenSPCoopStateful openspcoopstate, MsgDiagnostico msgDiag, String idEGovRequest, String idEGovResponse, String servizioApplicativo) {
        msgDiag.mediumDebug("Eliminazione SIL destinatario del messaggio nella tabelle MSG_SERVIZI_APPLICATIVI...");
        if (openspcoopstate.getConnectionDB() != null) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, false, idEGovResponse, "INBOX", msgDiag);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, idEGovRequest);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
            }
        } else {
            msgDiag.logErroreGenerico("Connessione non disponibile", "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
        }
    }

    public void setMessageResponseIntoContext(Message message, Logger aLog, MsgDiagnostico msgDiag, InfoAttraversamentoPdD info) {
        if (this.responseAsByte) {
            try {
                this.msgContext.setMessageResponseAsByte(message);
            }
            catch (Exception e) {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    new Message((Object)new AxisFault("Errore durante la setMessageResponseAsByte: " + e.getMessage())).writeTo((OutputStream)out);
                }
                catch (Exception er) {
                    aLog.error((Object)("Riscontrato errore durante la costruzione del messaggio di errore [setMessageResponseAsByte: " + e.getMessage() + "]: " + er.getMessage()));
                }
            }
        } else {
            this.msgContext.setMessageResponse(message);
        }
        if (info != null) {
            if (info.getTimeStamp3() != null) {
                Date spedizioneMessaggioRisposta = DateManager.getDate();
                info.setTimeStamp4(spedizioneMessaggioRisposta);
            }
            NotificaTempiAttraversamentoPdDUtility.notifica(info, msgDiag);
        }
    }
}

