/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.egov.XMLBuilder;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.core.autenticazione.Credenziali;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneBusteEGov;
import org.openspcoop.pdd.services.RicezioneBusteEGovContext;
import org.openspcoop.pdd.services.ServletUtils;
import org.openspcoop.utils.SoapUtils;

public class RicezioneBusteEGovDirect
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ID_MODULO = "RicezioneBusteEGovDirect";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        Message responseAxisMessage = null;
        ServletOutputStream outputStreamResponseServlet = res.getOutputStream();
        OpenSPCoopProperties openSPCoopProperties = OpenSPCoopProperties.getInstance();
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        XMLBuilder xmlBuilder = new XMLBuilder();
        ProprietaErroreApplicativo proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD();
        proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault());
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        proprietaErroreAppl.setFaultAsXML(true);
        RicezioneBusteEGovContext context = new RicezioneBusteEGovContext();
        try {
            Message axisMsgRequest = new Message((Object)req.getInputStream(), false, req.getContentType(), req.getContextPath());
            axisMsgRequest.getMimeHeaders().addHeader(req.getHeader("SOAPAction"), req.getHeader("SOAPAction"));
            ServletUtils.checkAxisMessage(axisMsgRequest);
            String mustUnderstandError = ServletUtils.checkMustUnderstand(axisMsgRequest);
            Credenziali credenziali = ServletUtils.getCredenziali(req);
            ServletUtils.checkEmptyBody(axisMsgRequest);
            context.setFromLocation(ServletUtils.getLocation(req, credenziali));
            context.setSoapAction(ServletUtils.getSoapAction(req));
            context.setIdModulo(ID_MODULO);
            context.setGestioneRisposta(true);
            context.setMessageRequest(axisMsgRequest);
            context.setTracciamentoAbilitato(true);
            context.setCredenziali(credenziali);
            if (mustUnderstandError == null) {
                RicezioneBusteEGov gestoreRichiesta = new RicezioneBusteEGov(context);
                gestoreRichiesta.process();
                responseAxisMessage = context.getMessageResponse();
            } else {
                responseAxisMessage = new Message((Object)SoapUtils.build_Server_Error((String)ID_MODULO, (String)"MustUnderstandError", (String)("Did not understand \"MustUnderstand\" header(s) : " + mustUnderstandError), (String)"soapenv:MustUnderstand"));
            }
        }
        catch (Exception e) {
            try {
                responseAxisMessage = new Message((Object)SoapUtils.build_Server_Error((String)ID_MODULO, (String)"ServletError", (String)e.getMessage(), (String)"soap:Server.userException"));
            }
            catch (Exception ee) {
                responseAxisMessage = new Message((Object)new AxisFault("ErroreBuildErrore: " + ee.getMessage()));
            }
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale(richiesta)");
        }
        try {
            SOAPHeader header;
            SOAPBody body;
            boolean rispostaPresente = true;
            if (!(!openSPCoopProperties.isHttp202OneWay() || (body = responseAxisMessage.getSOAPBody()) != null && body.getChildNodes().getLength() != 0 || (header = responseAxisMessage.getSOAPHeader()) != null && header.getChildNodes().getLength() != 0)) {
                rispostaPresente = false;
            }
            if (rispostaPresente) {
                res.setContentType(responseAxisMessage.getContentType((SOAPConstants)new SOAP11Constants()));
                responseAxisMessage.writeTo((OutputStream)outputStreamResponseServlet);
                if (responseAxisMessage.getSOAPBody() != null && responseAxisMessage.getSOAPBody().hasFault()) {
                    res.setStatus(500);
                }
            }
        }
        catch (Exception e) {
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale(risposta)");
            try {
                outputStreamResponseServlet.write(xmlBuilder.buildBytes_Eccezione(openSPCoopProperties.getIdentificativoPortaDefault(), ID_MODULO, proprietaErroreAppl.transformFaultCode("OPENSPCOOP_ORG_500"), "Sistema non disponibile", "EccezioneProcessamento"));
            }
            catch (Exception error) {
                outputStreamResponseServlet.write(error.toString().getBytes());
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

