/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DBUtils;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.AccessoConfigurazionePdD;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.IGestoreRepositoryEGov;
import org.openspcoop.egov.ValidazioneConSchemaSPCoop;
import org.openspcoop.pdd.config.ClassNameProperties;
import org.openspcoop.pdd.config.ConfigurazionePdDReader;
import org.openspcoop.pdd.config.DBManager;
import org.openspcoop.pdd.config.MailcapActivationReader;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.config.PddProperties;
import org.openspcoop.pdd.config.QueueManager;
import org.openspcoop.pdd.core.GestoreMessaggi;
import org.openspcoop.pdd.core.jmx.GestoreRisorseJMX;
import org.openspcoop.pdd.core.state.OpenSPCoopStateConnectionPool;
import org.openspcoop.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop.pdd.logger.MsgDiagnostico;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;
import org.openspcoop.pdd.services.RicezioneBusteEGov;
import org.openspcoop.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop.pdd.services.ServicesUtils;
import org.openspcoop.pdd.timers.TimerGestoreBusteNonRiscontrate;
import org.openspcoop.pdd.timers.TimerGestoreMessaggi;
import org.openspcoop.pdd.timers.TimerGestoreMessaggiThread;
import org.openspcoop.pdd.timers.TimerGestorePuliziaMessaggiAnomali;
import org.openspcoop.pdd.timers.TimerGestorePuliziaMessaggiAnomaliThread;
import org.openspcoop.pdd.timers.TimerGestoreRepositoryEGov;
import org.openspcoop.pdd.timers.TimerGestoreRepositoryEGovThread;
import org.openspcoop.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop.pdd.timers.TimerThreshold;
import org.openspcoop.registry.RegistroServiziReader;
import org.openspcoop.utils.GestoreJNDI;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.date.DateManager;

public class OpenSPCoopStartup
implements ServletContextListener {
    private static Logger log = Logger.getLogger((String)"InizializzazioneOpenSPCoop");
    private static final String ID_MODULO = "Inizializzazione Risorse";
    ServletContext servletContext;
    public static boolean initialize = false;
    private TimerGestoreBusteNonRiscontrate timerRiscontri;
    private TimerGestoreMessaggi timerEliminazioneMsg;
    private TimerGestoreMessaggiThread threadEliminazioneMsg;
    private TimerGestorePuliziaMessaggiAnomali timerPuliziaMsgAnomali;
    private TimerGestorePuliziaMessaggiAnomaliThread threadPuliziaMsgAnomali;
    private TimerGestoreRepositoryEGov timerRepositoryEGov;
    private TimerGestoreRepositoryEGovThread threadRepositoryEGov;
    private TimerThreshold timerThreshold = null;
    private TimerMonitoraggioRisorse timerMonitoraggioRisorse = null;
    private GestoreRisorseJMX gestoreRisorseJMX = null;
    private static Boolean isPdDLight = null;

    public void contextInitialized(ServletContextEvent sce) {
        boolean isInitializeValidatoreEGovXSD;
        long startDate = System.currentTimeMillis();
        this.servletContext = sce.getServletContext();
        if (!ClassNameProperties.initialize()) {
            log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'className.properties'");
            return;
        }
        ClassNameProperties classNameReader = ClassNameProperties.getInstance();
        if (!OpenSPCoopProperties.initialize()) {
            log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'openspcoop.properties'");
            return;
        }
        OpenSPCoopProperties propertiesReader = OpenSPCoopProperties.getInstance();
        if (!propertiesReader.validaConfigurazione()) {
            return;
        }
        boolean isInitializeLogger = false;
        isInitializeLogger = OpenSPCoopLogger.initialize(propertiesReader.getRootDirectory());
        if (!isInitializeLogger) {
            return;
        }
        Logger logCore = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
        isPdDLight = propertiesReader.isPdDLight();
        String locationPddProperties = null;
        if (propertiesReader.getLocationPddProperties() != null) {
            locationPddProperties = propertiesReader.getLocationPddProperties();
        }
        if (!PddProperties.initialize(locationPddProperties)) {
            log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'pdd.properties'");
            return;
        }
        try {
            OpenSPCoopProperties.updatePddPropertiesReader(PddProperties.getInstance());
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante l'assegnamento del pddPropertiesReader a OpenSPCoopPropertiesReader: " + e.getMessage()));
            return;
        }
        if (!MsgDiagnosticiProperties.initialize()) {
            log.error((Object)"Riscontrato errore durante l'inizializzazione del reader di 'msgDiagnostici.properties'");
            return;
        }
        MsgDiagnosticiProperties msgDiagProperties = MsgDiagnosticiProperties.getInstance();
        if (!msgDiagProperties.initializeMsgDiagnosticiPersonalizzati()) {
            return;
        }
        try {
            String tipoClass = classNameReader.getDateManager(propertiesReader.getTipoDateManager());
            DateManager.initializeDataManager((String)propertiesReader.getTipoTempoEGov("standard"), (String)tipoClass, (Properties)propertiesReader.getDateManagerProperties(), (Logger)logCore);
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante l'inizializzazione del DataManager: " + e.getMessage()));
            return;
        }
        AccessoConfigurazionePdD accessoConfigurazione = null;
        try {
            accessoConfigurazione = propertiesReader.getAccessoConfigurazionePdD();
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante la lettura della modalita' di accesso alla configurazione di OpenSPCoop: " + e.getMessage()));
            return;
        }
        boolean isInitializeConfig = ConfigurazionePdDReader.initialize(accessoConfigurazione, logCore, log);
        if (!isInitializeConfig) {
            log.error((Object)"Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop.");
            return;
        }
        ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
        if (!msgDiagProperties.checkValoriFiltriMsgDiagnostici(log)) {
            return;
        }
        try {
            String tipoClass = classNameReader.getRepositoryEGov(propertiesReader.getGestoreRepositoryEGov());
            Class<?> c = Class.forName(tipoClass);
            IGestoreRepositoryEGov repository = (IGestoreRepositoryEGov)c.newInstance();
            Configurazione.init((long)propertiesReader.getGestioneSerializableDB_AttesaAttiva(), (int)propertiesReader.getGestioneSerializableDB_CheckInterval(), (String)propertiesReader.getTipoSeriale_IdentificativoEGov(), (int)propertiesReader.getPrefissoSeriale_IdentificativoEGov(), (IGestoreRepositoryEGov)repository, (String)propertiesReader.getDatabaseType(), (Logger)logCore, (IDSoggetto)propertiesReader.getIdentitaPortaDefault(), propertiesReader.getTipiSoggetti(), propertiesReader.getTipiServizi(), (boolean)propertiesReader.isIgnoraEccezioniNonGravi(), (long)propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), (boolean)propertiesReader.isGenerazioneSPCoopErrore_strutturaMalformataHeaderEGov());
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante l'inizializzazione della libreria egov: " + e.getMessage()));
            return;
        }
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO);
        boolean isInitializeAppender = false;
        isInitializeAppender = OpenSPCoopLogger.initializeMsgDiagnosticiOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_MsgDiagnostici());
        if (!isInitializeAppender) {
            return;
        }
        isInitializeAppender = OpenSPCoopLogger.initializeTracciamentoOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_Tracciamento());
        if (!isInitializeAppender) {
            return;
        }
        if (!DBManager.initialize(propertiesReader.getJNDIName_DataSource(), propertiesReader.getJNDIContext_DataSource())) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa (DataSource)");
            return;
        }
        if (DBManager.getTransactionIsolationLevel() == 0) {
            log.info((Object)"Database TransactionLevel is NONE");
        } else if (DBManager.getTransactionIsolationLevel() == 2) {
            log.info((Object)"Database TransactionLevel is READ_COMMITTED");
        } else if (DBManager.getTransactionIsolationLevel() == 1) {
            log.info((Object)"Database TransactionLevel is READ_UNCOMMITTED");
        } else if (DBManager.getTransactionIsolationLevel() == 4) {
            log.info((Object)"Database TransactionLevel is REPEATABLE_READ");
        } else if (DBManager.getTransactionIsolationLevel() == 8) {
            log.info((Object)"Database TransactionLevel is SERIALIZABLE");
        } else {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa (DataSource): TransactionLevel associato alla connessione non conosciuto");
            return;
        }
        if (propertiesReader.isGestioneStateful_RinegoziamentoConnessione()) {
            try {
                Configurazione.setDatasourcePdD((DataSource)DBManager.getInstance().getDataSource());
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Inizializzazione Libreria eGov (DataSource): " + e.getMessage());
                return;
            }
        }
        if (!isPdDLight.booleanValue()) {
            if (!"jms".equals(propertiesReader.getNodeReceiver())) {
                // empty if block
            }
            if (!QueueManager.initialize(propertiesReader.getJNDIName_ConnectionFactory(), propertiesReader.getJNDIContext_ConnectionFactory())) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa (QueueConnectionFactory)");
                return;
            }
            log.info((Object)("Inizializzazione connectionFactoryJMS [" + propertiesReader.getJNDIName_ConnectionFactory() + "] effettuata."));
            if ("jms".equals(propertiesReader.getNodeReceiver())) {
                if (!QueueManager.initializeQueueNodeReceiver(propertiesReader.getJNDIContext_CodeInterne())) {
                    msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della code di ricezione JMS");
                    return;
                }
                log.info((Object)"Inizializzazione code JMS per la ricezione di messaggi nell'infrastruttura di OpenSPCoop, effettuata.");
            }
            if (!QueueManager.initializeQueueNodeSender(propertiesReader.getJNDIContext_CodeInterne())) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della code di spedizione JMS");
                return;
            }
            log.info((Object)"Inizializzazione code JMS per la spedizione di messaggi nell'infrastruttura di OpenSPCoop, effettuata.");
        }
        if (!(isInitializeValidatoreEGovXSD = ValidazioneConSchemaSPCoop.initializeSchema((Logger)logCore))) {
            return;
        }
        if (configurazionePdDReader.getAccessoRegistroServizi() == null) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante la lettura dei valori associati al registro dei servizi di OpenSPCoop.");
            return;
        }
        AccessoRegistro accessoRegistro = configurazionePdDReader.getAccessoRegistroServizi();
        for (int i = 0; i < accessoRegistro.sizeRegistroList(); ++i) {
            AccessoRegistroRegistro registro = accessoRegistro.getRegistro(i);
            if (!"db".equalsIgnoreCase(registro.getTipo())) continue;
            if (registro.getLocation().indexOf("@") != -1) {
                try {
                    String tipoDatabase = DBUtils.estraiTipoDatabaseFromLocation((String)registro.getLocation());
                    String location = registro.getLocation().substring(registro.getLocation().indexOf("@") + 1);
                    accessoRegistro.getRegistro(i).setLocation(location);
                    accessoRegistro.getRegistro(i).setTipoDatabase(tipoDatabase);
                    continue;
                }
                catch (Exception e) {
                    msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del registro dei servizi di OpenSPCoop, inizializzazione del registro[" + registro.getNome() + "] non riuscita: analisi del tipo di database (tipoDatabase@datasource) non riuscita: " + e.getMessage());
                    return;
                }
            }
            if (propertiesReader.getDatabaseType() == null) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del registro dei servizi di OpenSPCoop, inizializzazione del registro[" + registro.getNome() + "] non riuscita:\n " + "Il Registro dei Servizi di tipo [" + "db" + "] richiede la definizione del tipo di database indicato o come prefisso della location (tipoDB@datasource) o attraverso la proprieta' 'org.openspcoop.pdd.repository.tipoDatabase' della porta di dominio");
                return;
            }
            accessoRegistro.getRegistro(i).setTipoDatabase(propertiesReader.getDatabaseType());
        }
        boolean isInitializeRegistro = RegistroServiziReader.initialize((AccessoRegistro)accessoRegistro, (Logger)logCore, (Logger)log, (boolean)propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale(), (boolean)propertiesReader.isReadObjectStatoBozza());
        if (!isInitializeRegistro) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del registro dei servizi di OpenSPCoop.");
            return;
        }
        try {
            configurazionePdDReader.initializeRegistroServiziReader();
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del reader del registro dei servizi di OpenSPCoop, utilizzato dalla configurazione: " + e.getMessage());
            return;
        }
        try {
            GestoreMessaggi.initialize();
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della cache del GestoreMessaggi: " + e.getMessage());
            return;
        }
        try {
            Utilities.initMessageContext();
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione delle risorsa MessageContext per la produzione di buste eGov: " + e.getMessage());
            return;
        }
        try {
            Utilities.initAxisServer();
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione delle risorsa AxisServer: " + e.getMessage());
            return;
        }
        try {
            Utilities.initAxisClient();
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione delle risorsa AxisClient: " + e.getMessage());
            return;
        }
        try {
            RicezioneContenutiApplicativi.initializeService(classNameReader, propertiesReader, logCore);
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del servizio RicezioneContenutiApplicativi: " + e.getMessage());
            return;
        }
        try {
            RicezioneBusteEGov.initializeService(classNameReader, propertiesReader, logCore);
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del servizio RicezioneBusteEGov: " + e.getMessage());
            return;
        }
        try {
            MailcapActivationReader.initDataContentHandler(log);
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione dei DataContentHandler definiti in MET-INF/mailcap: " + e.getMessage());
            return;
        }
        try {
            if (!"abilitato".equals(propertiesReader.getNegoziamentoConnessioneDatasource())) {
                OpenSPCoopStateConnectionPool.initConnections(propertiesReader.getConnectionNumberPoolStateless(), log);
            }
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del connection pool per lo stateless: " + e.getMessage());
            return;
        }
        try {
            if (propertiesReader.isRisorseJMXAbilitate()) {
                this.gestoreRisorseJMX = propertiesReader.getJNDIName_MBeanServer() != null ? new GestoreRisorseJMX(propertiesReader.getJNDIName_MBeanServer(), propertiesReader.getJNDIContext_MBeanServer()) : new GestoreRisorseJMX();
            }
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del Gestore di Risorse JMX: " + e.getMessage());
        }
        if (this.gestoreRisorseJMX != null) {
            String jmxCtxName = null;
            try {
                jmxCtxName = propertiesReader.getContextRisorseJMX();
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante la lettura del nome del contesto per Risorse JMX: " + e.getMessage());
            }
            try {
                this.gestoreRisorseJMX.registerMBeanConfigurazionePdD(jmxCtxName);
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa JMX che gestisce la configurazione della Porta di Dominio: " + e.getMessage());
            }
            try {
                this.gestoreRisorseJMX.registerMBeanAccessoRegistroServizi(jmxCtxName);
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa JMX che gestisce l'accesso al Registro dei Servizi: " + e.getMessage());
            }
            try {
                this.gestoreRisorseJMX.registerMBeanMonitoraggioRisorse(jmxCtxName);
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa JMX che gestisce il Monitoraggio delle Risorse: " + e.getMessage());
            }
            try {
                this.gestoreRisorseJMX.registerMBeanAutorizzazioneSPCoop(jmxCtxName);
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa JMX che gestisce il Monitoraggio delle Risorse: " + e.getMessage());
            }
            try {
                this.gestoreRisorseJMX.registerMBeanRepositoryMessaggi(jmxCtxName);
            }
            catch (Exception e) {
                msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione della risorsa JMX che gestisce il Repository dei Messaggi: " + e.getMessage());
            }
        }
        try {
            if (propertiesReader.isAbilitatoControlloRisorseConfigurazione() || propertiesReader.isAbilitatoControlloRisorseDB() || propertiesReader.isAbilitatoControlloRisorseJMS() || propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati() || propertiesReader.isAbilitatoControlloRisorseRegistriServizi() || propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
                this.timerMonitoraggioRisorse = new TimerMonitoraggioRisorse();
                this.timerMonitoraggioRisorse.start();
                log.info((Object)"Inizializzo Timer per il Monitoraggio delle Risorse");
            }
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del TimerMonitoraggioRisorse: " + e.getMessage());
            return;
        }
        try {
            String[] tipiThreshold = propertiesReader.getRepositoryThresholdTypes();
            if (tipiThreshold != null) {
                this.timerThreshold = new TimerThreshold();
                this.timerThreshold.start();
                log.info((Object)"Inizializzo Timer per il Controllo dei Threshold sulle risorse");
            }
        }
        catch (Exception e) {
            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'inizializzazione del TimerThreshold: " + e.getMessage());
            return;
        }
        initialize = true;
        boolean gestoreBusteNonRiscontrate = false;
        boolean gestoreMessaggi = false;
        boolean gestorePuliziaMessaggiAnomali = false;
        boolean gestoreRepository = false;
        if (!isPdDLight.booleanValue()) {
            long scadenzaWhile = System.currentTimeMillis() + propertiesReader.getTimerEJBDeployTimeout();
            GestoreJNDI jndi = null;
            jndi = propertiesReader.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(propertiesReader.getJNDIContext_TimerEJB());
            while (!(System.currentTimeMillis() >= scadenzaWhile || gestoreBusteNonRiscontrate && gestoreMessaggi && gestorePuliziaMessaggiAnomali && gestoreRepository)) {
                String nomeJNDI;
                block165: {
                    block164: {
                        block163: {
                            gestoreBusteNonRiscontrate = false;
                            gestoreMessaggi = false;
                            gestorePuliziaMessaggiAnomali = false;
                            gestoreRepository = false;
                            if (propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
                                try {
                                    nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreBusteNonRiscontrate");
                                    log.info((Object)("Inizializzo EJB gestore riscontri [" + nomeJNDI + "]"));
                                    jndi.lookup(nomeJNDI);
                                    gestoreBusteNonRiscontrate = true;
                                    break block163;
                                }
                                catch (Exception e) {
                                    log.error((Object)("Search EJB gestore riscontri non trovato: " + e.getMessage()));
                                    try {
                                        Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                    }
                                    catch (Exception eRandom) {}
                                    continue;
                                }
                            }
                            gestoreBusteNonRiscontrate = true;
                        }
                        if (propertiesReader.isTimerGestoreMessaggiAbilitato()) {
                            try {
                                nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreMessaggi");
                                log.info((Object)("Inizializzo EJB gestore messaggi [" + nomeJNDI + "]"));
                                jndi.lookup(nomeJNDI);
                                gestoreMessaggi = true;
                                break block164;
                            }
                            catch (Exception e) {
                                log.error((Object)("Search EJB gestore messaggi non trovato: " + e.getMessage()));
                                try {
                                    Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                }
                                catch (Exception eRandom) {}
                                continue;
                            }
                        }
                        gestoreMessaggi = true;
                    }
                    if (propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                        try {
                            nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreConsistenzaDatabase");
                            log.info((Object)("Inizializzo EJB gestore pulizia messaggi anomali [" + nomeJNDI + "]"));
                            jndi.lookup(nomeJNDI);
                            gestorePuliziaMessaggiAnomali = true;
                            break block165;
                        }
                        catch (Exception e) {
                            log.error((Object)("Search EJB pulizia messaggi anomali non trovato: " + e.getMessage()));
                            try {
                                Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                            }
                            catch (Exception eRandom) {}
                            continue;
                        }
                    }
                    gestorePuliziaMessaggiAnomali = true;
                }
                if (propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
                    try {
                        nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreRepositoryEGov");
                        log.info((Object)("Inizializzo EJB gestore repository [" + nomeJNDI + "]"));
                        jndi.lookup(nomeJNDI);
                        gestoreRepository = true;
                    }
                    catch (Exception e) {
                        log.error((Object)("Search EJB gestore repository non trovato: " + e.getMessage()));
                        try {
                            Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                        }
                        catch (Exception eRandom) {}
                    }
                    continue;
                }
                gestoreRepository = true;
            }
            if (propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
                if (gestoreBusteNonRiscontrate) {
                    try {
                        this.timerRiscontri = ServicesUtils.createTimerGestoreBusteNonRiscontrate();
                    }
                    catch (Exception e) {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante la creazione del timer 'GestoreBusteNonRiscontrate': " + e.getMessage());
                    }
                    if (this.timerRiscontri != null) {
                        try {
                            this.timerRiscontri.start();
                        }
                        catch (RemoteException e) {
                            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreBusteNonRiscontrate': " + e.getMessage());
                        }
                    } else {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreBusteNonRiscontrate': timer is null");
                    }
                } else {
                    msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreBusteNonRiscontrate': timer non esiste nell'application server");
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreRiscontriRicevute.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreBusteNonRiscontrate");
                msgDiag.logPersonalizzato(msgDiag.getMessaggio("disabilitato"), msgDiag.getLivello("disabilitato"));
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
        }
        if (propertiesReader.isTimerGestoreMessaggiAbilitato()) {
            if (!isPdDLight.booleanValue()) {
                if (gestoreMessaggi) {
                    try {
                        this.timerEliminazioneMsg = ServicesUtils.createTimerGestoreMessaggi();
                    }
                    catch (Exception e) {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante la creazione del timer 'GestoreMessaggi': " + e.getMessage());
                    }
                    if (this.timerEliminazioneMsg != null) {
                        try {
                            this.timerEliminazioneMsg.start();
                        }
                        catch (RemoteException e) {
                            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreMessaggi': " + e.getMessage());
                        }
                    } else {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreMessaggi': timer is null");
                    }
                } else {
                    msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreMessaggi': timer non esiste nell'application server");
                }
            } else {
                try {
                    this.threadEliminazioneMsg = new TimerGestoreMessaggiThread();
                    this.threadEliminazioneMsg.start();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Avvio timer (thread) 'GestoreMessaggi'");
                }
            }
        } else {
            msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
            msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
            msgDiag.logPersonalizzato(msgDiag.getMessaggio("disabilitato"), msgDiag.getLivello("disabilitato"));
            msgDiag.setPrefixMsgPersonalizzati(null);
        }
        if (propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
            if (!isPdDLight.booleanValue()) {
                if (gestorePuliziaMessaggiAnomali) {
                    try {
                        this.timerPuliziaMsgAnomali = ServicesUtils.createTimerGestorePuliziaMessaggiAnomali();
                    }
                    catch (Exception e) {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante la creazione del timer 'GestoreConsistenzaDatabase': " + e.getMessage());
                    }
                    if (this.timerPuliziaMsgAnomali != null) {
                        try {
                            this.timerPuliziaMsgAnomali.start();
                        }
                        catch (RemoteException e) {
                            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreConsistenzaDatabase': " + e.getMessage());
                        }
                    } else {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreConsistenzaDatabase': timer is null");
                    }
                } else {
                    msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreConsistenzaDatabase': timer non esiste nell'application server");
                }
            } else {
                try {
                    this.threadPuliziaMsgAnomali = new TimerGestorePuliziaMessaggiAnomaliThread();
                    this.threadPuliziaMsgAnomali.start();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Avvio timer (thread) 'GestoreConsistenzaDatabase'");
                }
            }
        } else {
            msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
            msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
            msgDiag.logPersonalizzato(msgDiag.getMessaggio("disabilitato"), msgDiag.getLivello("disabilitato"));
            msgDiag.setPrefixMsgPersonalizzati(null);
        }
        if (propertiesReader.isTimerGestoreRepositoryEGovAbilitato()) {
            if (!isPdDLight.booleanValue()) {
                if (gestoreRepository) {
                    try {
                        this.timerRepositoryEGov = ServicesUtils.createTimerGestoreRepositoryEGov();
                    }
                    catch (Exception e) {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante la creazione del timer 'GestoreRepositoryEGov': " + e.getMessage());
                    }
                    if (this.timerRepositoryEGov != null) {
                        try {
                            this.timerRepositoryEGov.start();
                        }
                        catch (RemoteException e) {
                            msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreRepositoryEGov': " + e.getMessage());
                        }
                    } else {
                        msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreRepositoryEGov': timer is null");
                    }
                } else {
                    msgDiag.fatalOpenSPCoop("Riscontrato errore durante l'avvio del timer 'GestoreRepositoryEGov': timer non esiste nell'application server");
                }
            } else {
                try {
                    this.threadRepositoryEGov = new TimerGestoreRepositoryEGovThread();
                    this.threadRepositoryEGov.start();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Avvio timer (thread) 'GestoreRepositoryEGov'");
                }
            }
        } else {
            msgDiag.setPrefixMsgPersonalizzati("timerGestoreRepositoryEGov.");
            msgDiag.addKeyword("@ID_TIMER_GESTORE_REPOSITORY_EGOV@", "GestoreRepositoryEGov");
            msgDiag.logPersonalizzato(msgDiag.getMessaggio("disabilitato"), msgDiag.getLivello("disabilitato"));
            msgDiag.setPrefixMsgPersonalizzati(null);
        }
        long endDate = System.currentTimeMillis();
        long secondStarter = (endDate - startDate) / 1000L;
        msgDiag.setPrefixMsgPersonalizzati("openspcoopStartup.");
        msgDiag.addKeyword("@VERSIONE@", "OpenSPCoop v1.2");
        msgDiag.addKeyword("@TEMPO_DI_AVVIO@", secondStarter + " secondi");
        log.info((Object)("Porta di Dominio OpenSPCoop v1.2 avviata correttamente in " + secondStarter + " secondi."));
        msgDiag.logPersonalizzato(msgDiag.getMessaggio("pdd"), msgDiag.getLivello("pdd"));
        MsgDiagnostico msgIM = new MsgDiagnostico("IntegrationManager");
        msgIM.setPrefixMsgPersonalizzati("openspcoopStartup.");
        msgIM.addKeyword("@VERSIONE@", "OpenSPCoop v1.2");
        msgIM.addKeyword("@TEMPO_DI_AVVIO@", secondStarter + " secondi");
        msgIM.logPersonalizzato(msgDiag.getMessaggio("IntegrationManager"), msgDiag.getLivello("IntegrationManager"));
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            OpenSPCoopStateConnectionPool.closeResources();
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante la chiusura del connection pool per lo stateless: " + e.getMessage()));
        }
        try {
            if (this.timerRiscontri != null) {
                this.timerRiscontri.stop();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        try {
            if (this.timerEliminazioneMsg != null) {
                this.timerEliminazioneMsg.stop();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        try {
            if (this.timerPuliziaMsgAnomali != null) {
                this.timerPuliziaMsgAnomali.stop();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        try {
            if (this.timerRepositoryEGov != null) {
                this.timerRepositoryEGov.stop();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        try {
            if (this.timerMonitoraggioRisorse != null) {
                this.timerMonitoraggioRisorse.setStop(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.timerThreshold != null) {
                this.timerThreshold.setStop(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.gestoreRisorseJMX != null) {
            this.gestoreRisorseJMX.unregisterMBeans();
        }
        DateManager.close();
    }
}

