/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.pdd.services;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.openspcoop.pdd.config.OpenSPCoopProperties;
import org.openspcoop.pdd.logger.OpenSPCoopLogger;

public class EsitoInvocazioneHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static Logger log = OpenSPCoopLogger.getLoggerOpenSPCoopCore();
    private static OpenSPCoopProperties openspcoopProperties = OpenSPCoopProperties.getInstance();

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            int icarHttpResponseCode = 200;
            HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
            if (msgContext.getProperty("HEADER_INTEGRAZIONE") != null) {
                Properties headerIntegrazioneRisposta = (Properties)msgContext.getProperty("HEADER_INTEGRAZIONE");
                Enumeration<Object> en = headerIntegrazioneRisposta.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    response.setHeader(key, headerIntegrazioneRisposta.getProperty(key));
                }
            }
            if (msgContext.getResponseMessage() != null) {
                javax.xml.soap.SOAPBody o = msgContext.getResponseMessage().getSOAPBody();
                SOAPBody body = null;
                if (o != null) {
                    body = (SOAPBody)o;
                }
                if (body != null && body.hasFault()) {
                    response.setStatus(500);
                    icarHttpResponseCode = 500;
                }
                if (openspcoopProperties.isHttp202OneWay() && (body == null || body.getChildNodes().getLength() == 0)) {
                    o = msgContext.getResponseMessage().getSOAPHeader();
                    SOAPHeader header = null;
                    if (o != null) {
                        header = (SOAPHeader)o;
                    }
                    if (header == null || header.getChildNodes().getLength() == 0) {
                        msgContext.setResponseMessage(null);
                    } else {
                        String idModuloFunzionale = (String)msgContext.getProperty("GESTIONE_ESITO_MODULO_FUNZIONALE");
                        if ("RicezioneContenutiApplicativi".equals(idModuloFunzionale) && !openspcoopProperties.isHttp202OneWay_PD_HTTPEmptyResponse()) {
                            msgContext.setResponseMessage(null);
                        }
                    }
                }
                if (openspcoopProperties.isICARHttp200ResponseCodeEnabled() && icarHttpResponseCode == 200) {
                    response.setIntHeader("icar.http.response.code", 200);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore duranta l'impostazione dell'esito dell'invocazione di una PD nel trasporto [" + e.toString() + "]"), (Throwable)e);
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        this.invoke(msgContext);
    }
}

